/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle;

import com.android.ide.gradle.model.sources.SourcesAndJavadocArtifact;
import com.android.ide.gradle.model.sources.SourcesAndJavadocArtifacts;
import com.android.tools.idea.gradle.project.sync.idea.SourcesAndJavadocCollectorKt;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.LibraryDependency;
import com.intellij.jarFinder.InternetAttachSourceProvider;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryFilePaths {
    @NotNull
    private final Map<String, ArtifactPaths> myPathsMap = new HashMap<String, ArtifactPaths>();
    private static final Pattern gradleCachePattern = Pattern.compile("^[a-f0-9]{30,48}$");

    public void populate(@NotNull SourcesAndJavadocArtifacts artifacts) {
        if (artifacts == null) {
            LibraryFilePaths.$$$reportNull$$$0(0);
        }
        for (SourcesAndJavadocArtifact artifact : artifacts.getArtifacts()) {
            this.myPathsMap.computeIfAbsent(SourcesAndJavadocCollectorKt.idToString(artifact.getId()), k -> new ArtifactPaths(artifact.getJavadoc(), artifact.getSources(), artifact.getMavenPom()));
        }
    }

    public Collection<String> retrieveCachedLibs() {
        return new HashSet<String>(this.myPathsMap.keySet());
    }

    @NotNull
    public static LibraryFilePaths getInstance(@NotNull Project project) {
        if (project == null) {
            LibraryFilePaths.$$$reportNull$$$0(1);
        }
        LibraryFilePaths libraryFilePaths = (LibraryFilePaths)ServiceManager.getService((Project)project, LibraryFilePaths.class);
        if (libraryFilePaths == null) {
            LibraryFilePaths.$$$reportNull$$$0(2);
        }
        return libraryFilePaths;
    }

    @Nullable
    public File findSourceJarPath(@NotNull String libraryName, @NotNull File libraryPath) {
        String libraryId;
        if (libraryName == null) {
            LibraryFilePaths.$$$reportNull$$$0(3);
        }
        if (libraryPath == null) {
            LibraryFilePaths.$$$reportNull$$$0(4);
        }
        if (this.myPathsMap.containsKey(libraryId = LibraryFilePaths.getLibraryId(libraryName))) {
            return this.myPathsMap.get((Object)libraryId).mySources;
        }
        return LibraryFilePaths.findArtifactFilePathInRepository(libraryPath, "-sources.jar", true);
    }

    @NotNull
    static String getLibraryId(@NotNull String libraryName) {
        if (libraryName == null) {
            LibraryFilePaths.$$$reportNull$$$0(5);
        }
        if (libraryName.startsWith(LibraryDependency.NAME_PREFIX)) {
            libraryName = libraryName.substring(LibraryDependency.NAME_PREFIX.length());
        }
        if (libraryName.contains("@")) {
            libraryName = libraryName.substring(0, libraryName.indexOf(64));
        }
        String string = libraryName.trim();
        if (string == null) {
            LibraryFilePaths.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public File findJavadocJarPath(@NotNull String libraryName, @NotNull File libraryPath) {
        String libraryId;
        if (libraryName == null) {
            LibraryFilePaths.$$$reportNull$$$0(7);
        }
        if (libraryPath == null) {
            LibraryFilePaths.$$$reportNull$$$0(8);
        }
        if (this.myPathsMap.containsKey(libraryId = LibraryFilePaths.getLibraryId(libraryName))) {
            return this.myPathsMap.get((Object)libraryId).myJavaDoc;
        }
        return LibraryFilePaths.findArtifactFilePathInRepository(libraryPath, "-javadoc.jar", true);
    }

    @Nullable
    public File findPomPathForLibrary(@NotNull String libraryName, @NotNull File libraryPath) {
        String libraryId;
        if (libraryName == null) {
            LibraryFilePaths.$$$reportNull$$$0(9);
        }
        if (libraryPath == null) {
            LibraryFilePaths.$$$reportNull$$$0(10);
        }
        if (this.myPathsMap.containsKey(libraryId = LibraryFilePaths.getLibraryId(libraryName))) {
            return this.myPathsMap.get((Object)libraryId).myPom;
        }
        return LibraryFilePaths.findArtifactFilePathInRepository(libraryPath, ".pom", false);
    }

    @Nullable
    private static File findArtifactFilePathInRepository(@NotNull File libraryPath, @NotNull String fileNameSuffix, boolean searchInIdeCache) {
        File librarySourceDirPath;
        File sourceJarPath;
        if (libraryPath == null) {
            LibraryFilePaths.$$$reportNull$$$0(11);
        }
        if (fileNameSuffix == null) {
            LibraryFilePaths.$$$reportNull$$$0(12);
        }
        if (!libraryPath.isFile()) {
            return null;
        }
        File parentPath = libraryPath.getParentFile();
        String name = FileUtil.getNameWithoutExtension((File)libraryPath);
        String sourceFileName = name + fileNameSuffix;
        if (parentPath != null) {
            File sourceJar = LibraryFilePaths.findChildPath(parentPath, sourceFileName);
            if (sourceJar != null) {
                return sourceJar;
            }
            if ((parentPath = parentPath.getParentFile()) != null) {
                for (File child : FileUtil.notNullize((File[])parentPath.listFiles())) {
                    if (!child.isDirectory() || (sourceJar = LibraryFilePaths.findChildPath(child, sourceFileName)) == null) continue;
                    return sourceJar;
                }
            }
            if ((parentPath = libraryPath.getParentFile()) != null && gradleCachePattern.matcher(parentPath.getName()).matches() && (parentPath = parentPath.getParentFile()) != null && parentPath.getParentFile() != null && libraryPath.getName().startsWith(parentPath.getParentFile().getName())) {
                for (File child : FileUtil.notNullize((File[])parentPath.listFiles())) {
                    if (!child.isDirectory() || !gradleCachePattern.matcher(child.getName()).matches() || (sourceJar = LibraryFilePaths.findChildPath(child, sourceFileName)) == null) continue;
                    return sourceJar;
                }
            }
        }
        if (searchInIdeCache && (sourceJarPath = new File(librarySourceDirPath = InternetAttachSourceProvider.getLibrarySourceDir(), sourceFileName)).isFile()) {
            return sourceJarPath;
        }
        return null;
    }

    @Nullable
    private static File findChildPath(@NotNull File parentPath, @NotNull String childName) {
        if (parentPath == null) {
            LibraryFilePaths.$$$reportNull$$$0(13);
        }
        if (childName == null) {
            LibraryFilePaths.$$$reportNull$$$0(14);
        }
        for (File child : FileUtil.notNullize((File[])parentPath.listFiles())) {
            if (!childName.equals(child.getName())) continue;
            return child.isFile() ? child : null;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifacts";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/LibraryFilePaths";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryPath";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNameSuffix";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentPath";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/LibraryFilePaths";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "populate";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findSourceJarPath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryId";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findJavadocJarPath";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findPomPathForLibrary";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findArtifactFilePathInRepository";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findChildPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ArtifactPaths {
        @Nullable
        final File myJavaDoc;
        @Nullable
        final File mySources;
        @Nullable
        final File myPom;

        private ArtifactPaths(@Nullable File javadoc, @Nullable File sources, @Nullable File pom) {
            this.myJavaDoc = javadoc;
            this.mySources = sources;
            this.myPom = pom;
        }
    }
}

