/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fonts;

import com.google.common.util.concurrent.AtomicDouble;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.io.HttpRequests;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FontFileDownloader {
    private static final Logger LOG = Logger.getInstance(FontFileDownloader.class);
    private static final String LIB_SCHEMA = "lib://";
    private final List<? extends DownloadableFileDescription> myFileDescriptions;

    public FontFileDownloader(@NotNull List<? extends DownloadableFileDescription> fileDescriptions) {
        if (fileDescriptions == null) {
            FontFileDownloader.$$$reportNull$$$0(0);
        }
        this.myFileDescriptions = fileDescriptions;
    }

    @NotNull
    public List<Pair<File, DownloadableFileDescription>> download(@NotNull File targetDir) throws IOException {
        ArrayList<Pair<File, DownloadableFileDescription>> arrayList;
        if (targetDir == null) {
            FontFileDownloader.$$$reportNull$$$0(1);
        }
        List<Pair<File, DownloadableFileDescription>> downloadedFiles = Collections.synchronizedList(new ArrayList());
        List existingFiles = Collections.synchronizedList(new ArrayList());
        ProgressIndicator parentIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (parentIndicator == null) {
            parentIndicator = new EmptyProgressIndicator();
        }
        try {
            ConcurrentTasksProgressManager progressManager = new ConcurrentTasksProgressManager(parentIndicator, this.myFileDescriptions.size());
            parentIndicator.setText(IdeBundle.message((String)"progress.downloading.0.files.text", (Object[])new Object[]{this.myFileDescriptions.size()}));
            int maxParallelDownloads = Runtime.getRuntime().availableProcessors();
            LOG.debug("Downloading " + this.myFileDescriptions.size() + " files using " + maxParallelDownloads + " threads");
            long start = System.currentTimeMillis();
            ExecutorService executor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"FileDownloaderImpl pool", (int)maxParallelDownloads);
            ArrayList<Future<Void>> results = new ArrayList<Future<Void>>();
            AtomicLong totalSize = new AtomicLong();
            for (DownloadableFileDescription downloadableFileDescription : this.myFileDescriptions) {
                results.add(executor.submit(() -> {
                    SubTaskProgressIndicator indicator = progressManager.createSubTaskIndicator();
                    indicator.checkCanceled();
                    File existing2 = new File(targetDir, description.getDefaultFileName());
                    String url = description.getDownloadUrl();
                    if (url.startsWith(LIB_SCHEMA)) {
                        String path2 = FileUtil.toSystemDependentName((String)StringUtil.trimStart((String)url, (String)LIB_SCHEMA));
                        File file = PathManager.findFileInLibDirectory((String)path2);
                        existingFiles.add(Pair.create((Object)file, (Object)description));
                    } else if (url.startsWith("file://")) {
                        String path3 = FileUtil.toSystemDependentName((String)StringUtil.trimStart((String)url, (String)"file://"));
                        File file = new File(path3);
                        if (file.exists()) {
                            existingFiles.add(Pair.create((Object)file, (Object)description));
                        }
                    } else {
                        File downloaded;
                        try {
                            downloaded = FontFileDownloader.downloadFile(description, existing2, (ProgressIndicator)indicator);
                        }
                        catch (IOException e) {
                            throw new IOException(IdeBundle.message((String)"error.file.download.failed", (Object[])new Object[]{description.getDownloadUrl(), e.getMessage()}), e);
                        }
                        if (FileUtil.filesEqual((File)downloaded, (File)existing2)) {
                            existingFiles.add(Pair.create((Object)existing2, (Object)description));
                        } else {
                            totalSize.addAndGet(downloaded.length());
                            downloadedFiles.add(Pair.create((Object)downloaded, (Object)description));
                        }
                    }
                    indicator.finished();
                    return null;
                }));
            }
            for (Future future2 : results) {
                try {
                    future2.get();
                }
                catch (InterruptedException e) {
                    throw new ProcessCanceledException();
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof IOException) {
                        throw (IOException)e.getCause();
                    }
                    if (e.getCause() instanceof ProcessCanceledException) {
                        throw (ProcessCanceledException)e.getCause();
                    }
                    LOG.error((Throwable)e);
                }
            }
            long duration = System.currentTimeMillis() - start;
            LOG.debug("Downloaded " + StringUtil.formatFileSize((long)totalSize.get()) + " in " + StringUtil.formatDuration((long)duration) + "(" + duration + "ms)");
            ArrayList<Pair<File, DownloadableFileDescription>> localFiles = new ArrayList<Pair<File, DownloadableFileDescription>>();
            localFiles.addAll(FontFileDownloader.moveToDir(downloadedFiles, targetDir));
            localFiles.addAll(existingFiles);
            arrayList = localFiles;
        }
        catch (ProcessCanceledException | IOException e) {
            FontFileDownloader.deleteFiles(downloadedFiles);
            throw e;
        }
        if (arrayList == null) {
            FontFileDownloader.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static List<Pair<File, DownloadableFileDescription>> moveToDir(List<Pair<File, DownloadableFileDescription>> downloadedFiles, File targetDir) throws IOException {
        FileUtil.createDirectory((File)targetDir);
        ArrayList<Pair<File, DownloadableFileDescription>> result2 = new ArrayList<Pair<File, DownloadableFileDescription>>();
        for (Pair<File, DownloadableFileDescription> pair : downloadedFiles) {
            DownloadableFileDescription description = (DownloadableFileDescription)pair.getSecond();
            String fileName = description.generateFileName(s -> !new File(targetDir, (String)s).exists());
            File toFile = new File(targetDir, fileName);
            FileUtil.rename((File)((File)pair.getFirst()), (File)toFile);
            result2.add((Pair<File, DownloadableFileDescription>)Pair.create((Object)toFile, (Object)description));
        }
        return result2;
    }

    private static void deleteFiles(List<Pair<File, DownloadableFileDescription>> pairs) {
        for (Pair<File, DownloadableFileDescription> pair : pairs) {
            FileUtil.delete((File)((File)pair.getFirst()));
        }
    }

    @NotNull
    private static File downloadFile(@NotNull DownloadableFileDescription description, @NotNull File existingFile, @NotNull ProgressIndicator indicator) throws IOException {
        if (description == null) {
            FontFileDownloader.$$$reportNull$$$0(3);
        }
        if (existingFile == null) {
            FontFileDownloader.$$$reportNull$$$0(4);
        }
        if (indicator == null) {
            FontFileDownloader.$$$reportNull$$$0(5);
        }
        try {
            return FontFileDownloader.downloadFile(description, existingFile, indicator, true);
        }
        catch (IOException ex) {
            return FontFileDownloader.downloadFile(description, existingFile, indicator, false);
        }
    }

    @NotNull
    private static File downloadFile(final @NotNull DownloadableFileDescription description, final @NotNull File existingFile, final @NotNull ProgressIndicator indicator, boolean compressed) throws IOException {
        if (description == null) {
            FontFileDownloader.$$$reportNull$$$0(6);
        }
        if (existingFile == null) {
            FontFileDownloader.$$$reportNull$$$0(7);
        }
        if (indicator == null) {
            FontFileDownloader.$$$reportNull$$$0(8);
        }
        final String presentableUrl = description.getPresentableDownloadUrl();
        indicator.setText2(IdeBundle.message((String)"progress.connecting.to.download.file.text", (Object[])new Object[]{presentableUrl}));
        indicator.setIndeterminate(true);
        File file = (File)HttpRequests.request((String)description.getDownloadUrl()).gzip(compressed).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<File>(){

            public File process(@NotNull HttpRequests.Request request) throws IOException {
                if (request == null) {
                    1.$$$reportNull$$$0(0);
                }
                int size = request.getConnection().getContentLength();
                if (existingFile.exists() && (long)size == existingFile.length()) {
                    return existingFile;
                }
                indicator.setText2(IdeBundle.message((String)"progress.download.file.text", (Object[])new Object[]{description.getPresentableFileName(), presentableUrl}));
                return request.saveToFile(FileUtil.createTempFile((String)"download.", (String)".tmp"), indicator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/android/tools/idea/fonts/FontFileDownloader$1", "process"));
            }
        });
        if (file == null) {
            FontFileDownloader.$$$reportNull$$$0(9);
        }
        return file;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileDescriptions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDir";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/fonts/FontFileDownloader";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingFile";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/fonts/FontFileDownloader";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "download";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "downloadFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "download";
                break;
            }
            case 2: 
            case 9: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "downloadFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class SubTaskProgressIndicator
    extends SensitiveProgressWrapper {
        private final AtomicDouble myFraction;
        private final ConcurrentTasksProgressManager myProgressManager;

        private SubTaskProgressIndicator(ConcurrentTasksProgressManager progressManager) {
            super(progressManager.myParent);
            this.myProgressManager = progressManager;
            this.myFraction = new AtomicDouble();
        }

        public void setFraction(double newValue) {
            double oldValue = this.myFraction.getAndSet(newValue);
            this.myProgressManager.updateFraction(newValue - oldValue);
        }

        public void setIndeterminate(boolean indeterminate) {
            if (this.myProgressManager.myTasksCount > 1) {
                return;
            }
            super.setIndeterminate(indeterminate);
        }

        public void setText2(String text) {
            this.myProgressManager.setText2(this, text);
        }

        public double getFraction() {
            return this.myFraction.get();
        }

        public void finished() {
            this.setFraction(1.0);
            this.myProgressManager.setText2(this, null);
        }
    }

    private static final class ConcurrentTasksProgressManager {
        private final ProgressIndicator myParent;
        private final int myTasksCount;
        private final AtomicDouble myTotalFraction;
        private final Object myLock = new Object();
        private final LinkedHashMap<SubTaskProgressIndicator, String> myText2Stack = new LinkedHashMap();

        private ConcurrentTasksProgressManager(ProgressIndicator parent, int tasksCount) {
            this.myParent = parent;
            this.myTasksCount = tasksCount;
            this.myTotalFraction = new AtomicDouble();
        }

        public void updateFraction(double delta) {
            this.myTotalFraction.addAndGet(delta / (double)this.myTasksCount);
            this.myParent.setFraction(this.myTotalFraction.get());
        }

        public SubTaskProgressIndicator createSubTaskIndicator() {
            return new SubTaskProgressIndicator(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setText2(@NotNull SubTaskProgressIndicator subTask, @Nullable String text) {
            if (subTask == null) {
                ConcurrentTasksProgressManager.$$$reportNull$$$0(0);
            }
            if (text != null) {
                Object object = this.myLock;
                synchronized (object) {
                    this.myText2Stack.put((Object)subTask, (Object)text);
                }
                this.myParent.setText2(text);
            } else {
                String prev;
                Object object = this.myLock;
                synchronized (object) {
                    this.myText2Stack.remove((Object)subTask);
                    prev = (String)this.myText2Stack.getLastValue();
                }
                if (prev != null) {
                    this.myParent.setText2(prev);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subTask", "com/android/tools/idea/fonts/FontFileDownloader$ConcurrentTasksProgressManager", "setText2"));
        }
    }
}

