/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.flags;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.GradleExperimentalSettings;
import com.android.tools.idea.rendering.RenderSettings;
import com.android.tools.idea.ui.LayoutInspectorSettingsKt;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.LayoutEditorEvent;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Hashtable;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ExperimentalSettingsConfigurable
implements SearchableConfigurable {
    @NotNull
    private final GradleExperimentalSettings mySettings;
    @NotNull
    private final RenderSettings myRenderSettings;
    private JPanel myPanel;
    private JCheckBox myUseL2DependenciesCheckBox;
    private JCheckBox myUseSingleVariantSyncCheckbox;
    private JSlider myLayoutEditorQualitySlider;
    private JCheckBox myLayoutInspectorCheckbox;
    private TitledSeparator myLayoutInspectorSeparator;
    private JCheckBox mySkipGradleTasksList;
    private JCheckBox myUseLayoutlibNative;
    private Runnable myRestartCallback;

    public ExperimentalSettingsConfigurable(@NotNull Project project) {
        if (project == null) {
            ExperimentalSettingsConfigurable.$$$reportNull$$$0(0);
        }
        this(GradleExperimentalSettings.getInstance(), RenderSettings.getProjectSettings(project));
    }

    @VisibleForTesting
    ExperimentalSettingsConfigurable(@NotNull GradleExperimentalSettings settings, @NotNull RenderSettings renderSettings) {
        if (settings == null) {
            ExperimentalSettingsConfigurable.$$$reportNull$$$0(1);
        }
        if (renderSettings == null) {
            ExperimentalSettingsConfigurable.$$$reportNull$$$0(2);
        }
        this.mySettings = settings;
        this.myRenderSettings = renderSettings;
        this.$$$setupUI$$$();
        this.myUseL2DependenciesCheckBox.setVisible(false);
        Hashtable<Integer, JLabel> qualityLabels = new Hashtable<Integer, JLabel>();
        qualityLabels.put(new Integer(0), new JLabel("Fastest"));
        qualityLabels.put(new Integer(100), new JLabel("Slowest"));
        this.myLayoutEditorQualitySlider.setLabelTable(qualityLabels);
        this.myLayoutEditorQualitySlider.setPaintLabels(true);
        this.myLayoutEditorQualitySlider.setPaintTicks(true);
        this.myLayoutEditorQualitySlider.setMajorTickSpacing(25);
        boolean showLayoutInspectorSettings = (Boolean)StudioFlags.DYNAMIC_LAYOUT_INSPECTOR_ENABLED.get();
        this.myLayoutInspectorSeparator.setVisible(showLayoutInspectorSettings);
        this.myLayoutInspectorCheckbox.setVisible(showLayoutInspectorSettings);
        this.reset();
    }

    @NotNull
    public String getId() {
        return "gradle.experimental";
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    @Nls
    public String getDisplayName() {
        return AndroidBundle.message("configurable.ExperimentalSettingsConfigurable.display.name", new Object[0]);
    }

    @Nullable
    public String getHelpTopic() {
        return null;
    }

    @NotNull
    public JComponent createComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            ExperimentalSettingsConfigurable.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    public boolean isModified() {
        return this.mySettings.USE_L2_DEPENDENCIES_ON_SYNC != this.isUseL2DependenciesInSync() || this.mySettings.USE_SINGLE_VARIANT_SYNC != this.isUseSingleVariantSync() || this.mySettings.SKIP_GRADLE_TASKS_LIST != this.skipGradleTasksList() || (int)(this.myRenderSettings.getQuality() * 100.0f) != this.getQualitySetting() || this.myLayoutInspectorCheckbox.isSelected() != LayoutInspectorSettingsKt.getEnableLiveLayoutInspector() || this.myUseLayoutlibNative.isSelected() == PluginManagerCore.isDisabled((String)"com.android.layoutlib.native");
    }

    private int getQualitySetting() {
        return this.myLayoutEditorQualitySlider.getValue();
    }

    public void apply() throws ConfigurationException {
        this.mySettings.USE_L2_DEPENDENCIES_ON_SYNC = this.isUseL2DependenciesInSync();
        this.mySettings.USE_SINGLE_VARIANT_SYNC = this.isUseSingleVariantSync();
        this.mySettings.SKIP_GRADLE_TASKS_LIST = this.skipGradleTasksList();
        this.myRenderSettings.setQuality((float)this.getQualitySetting() / 100.0f);
        LayoutInspectorSettingsKt.setEnableLiveLayoutInspector(this.myLayoutInspectorCheckbox.isSelected());
        if (this.myUseLayoutlibNative.isSelected() == PluginManagerCore.isDisabled((String)"com.android.layoutlib.native")) {
            this.myRestartCallback = () -> ApplicationManager.getApplication().invokeLater(() -> PluginManagerConfigurable.shutdownOrRestartApp());
            LayoutEditorEvent.Builder eventBuilder = LayoutEditorEvent.newBuilder();
            if (this.myUseLayoutlibNative.isSelected()) {
                eventBuilder.setType(LayoutEditorEvent.LayoutEditorEventType.ENABLE_LAYOUTLIB_NATIVE);
                PluginManagerCore.enablePlugin((String)"com.android.layoutlib.native");
            } else {
                eventBuilder.setType(LayoutEditorEvent.LayoutEditorEventType.DISABLE_LAYOUTLIB_NATIVE);
                PluginManagerCore.disablePlugin((String)"com.android.layoutlib.native");
                PluginManagerCore.enablePlugin((String)"com.android.layoutlib.standard");
            }
            AndroidStudioEvent.Builder studioEvent = AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.LAYOUT_EDITOR).setKind(AndroidStudioEvent.EventKind.LAYOUT_EDITOR_EVENT).setLayoutEditorEvent(eventBuilder.build());
            UsageTracker.log((AndroidStudioEvent.Builder)studioEvent);
        }
    }

    public void disposeUIResources() {
        if (this.myRestartCallback != null) {
            this.myRestartCallback.run();
            this.myRestartCallback = null;
        }
    }

    @VisibleForTesting
    boolean isUseL2DependenciesInSync() {
        return this.myUseL2DependenciesCheckBox.isSelected();
    }

    @TestOnly
    void setUseL2DependenciesInSync(boolean value2) {
        this.myUseL2DependenciesCheckBox.setSelected(value2);
    }

    boolean isUseSingleVariantSync() {
        return this.myUseSingleVariantSyncCheckbox.isSelected();
    }

    @TestOnly
    void setUseSingleVariantSync(boolean value2) {
        this.myUseSingleVariantSyncCheckbox.setSelected(value2);
    }

    boolean skipGradleTasksList() {
        return this.mySkipGradleTasksList.isSelected();
    }

    @TestOnly
    void setSkipGradleTasksList(boolean value2) {
        this.mySkipGradleTasksList.setSelected(value2);
    }

    public void reset() {
        this.myUseL2DependenciesCheckBox.setSelected(this.mySettings.USE_L2_DEPENDENCIES_ON_SYNC);
        this.myUseSingleVariantSyncCheckbox.setSelected(this.mySettings.USE_SINGLE_VARIANT_SYNC);
        this.mySkipGradleTasksList.setSelected(this.mySettings.SKIP_GRADLE_TASKS_LIST);
        this.myLayoutEditorQualitySlider.setValue((int)(this.myRenderSettings.getQuality() * 100.0f));
        this.myLayoutInspectorCheckbox.setSelected(LayoutInspectorSettingsKt.getEnableLiveLayoutInspector());
        this.myUseLayoutlibNative.setSelected(!PluginManagerCore.isDisabled((String)"com.android.layoutlib.native"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/flags/ExperimentalSettingsConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/flags/ExperimentalSettingsConfigurable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        TitledSeparator titledSeparator;
        JSlider jSlider;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(12, 8, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("<html><b>Note:</b> These settings are for features that are considered <b>experimental</b>.</html>");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 8, 0, 1, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(11, 4, 1, 4, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("<html><br></html>");
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 6, 0, 0, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("<html><br></html>");
        jPanel.add((Component)jBLabel3, new GridConstraints(3, 7, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myUseL2DependenciesCheckBox = jCheckBox5 = new JCheckBox();
        jCheckBox5.setText("Use new dependency mechanism during Gradle sync");
        jPanel.add((Component)jCheckBox5, new GridConstraints(4, 0, 1, 6, 8, 0, 3, 0, null, null, null));
        TitledSeparator titledSeparator2 = new TitledSeparator();
        titledSeparator2.setText("Gradle");
        jPanel.add((Component)titledSeparator2, new GridConstraints(2, 0, 1, 8, 0, 1, 3, 0, null, null, null));
        this.myUseSingleVariantSyncCheckbox = jCheckBox4 = new JCheckBox();
        jCheckBox4.setText("Only sync the active variant");
        jPanel.add((Component)jCheckBox4, new GridConstraints(3, 0, 1, 6, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Layout Editor quality setting");
        jPanel.add((Component)jBLabel4, new GridConstraints(7, 0, 1, 5, 8, 0, 0, 0, null, null, null));
        this.myLayoutEditorQualitySlider = jSlider = new JSlider();
        jPanel.add((Component)jSlider, new GridConstraints(7, 6, 1, 1, 0, 1, 0, 0, new Dimension(150, -1), new Dimension(90, -1), null));
        TitledSeparator titledSeparator3 = new TitledSeparator();
        titledSeparator3.setText("Editor");
        jPanel.add((Component)titledSeparator3, new GridConstraints(6, 0, 1, 8, 0, 1, 3, 0, null, null, null));
        this.myLayoutInspectorSeparator = titledSeparator = new TitledSeparator();
        titledSeparator.setText("Layout Inspector");
        jPanel.add((Component)titledSeparator, new GridConstraints(9, 0, 1, 8, 0, 1, 3, 0, null, null, null));
        this.myLayoutInspectorCheckbox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Enable Live Layout Inspector");
        jPanel.add((Component)jCheckBox3, new GridConstraints(10, 0, 1, 6, 8, 0, 3, 0, null, null, null));
        this.mySkipGradleTasksList = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Do not build Gradle task list during Gradle sync");
        jPanel.add((Component)jCheckBox2, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myUseLayoutlibNative = jCheckBox = new JCheckBox();
        jCheckBox.setText("Use new Layout Rendering Engine");
        jPanel.add((Component)jCheckBox, new GridConstraints(8, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

