/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fileTypes.profiler;

import com.android.tools.idea.fileTypes.profiler.AndroidProfilerCaptureFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.io.ByteSequence;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryCaptureFileType
extends AndroidProfilerCaptureFileType {
    public static final String EXTENSION = "hprof";
    private static final MemoryCaptureFileType myInstance = new MemoryCaptureFileType();

    private MemoryCaptureFileType() {
    }

    @NotNull
    public String getName() {
        return "AndroidProfilerMemoryCapture";
    }

    @NotNull
    public String getDescription() {
        return "Android Profiler Memory capture file";
    }

    @NotNull
    public String getDefaultExtension() {
        return EXTENSION;
    }

    public static FileType getInstance() {
        return myInstance;
    }

    public static final class Detector
    implements FileTypeRegistry.FileTypeDetector {
        private static final byte[] magic = "JAVA PROFILE 1.0.3".getBytes(StandardCharsets.US_ASCII);

        @Nullable
        public FileType detect(@NotNull VirtualFile file, @NotNull ByteSequence firstBytes, @Nullable CharSequence firstCharsIfText) {
            if (file == null) {
                Detector.$$$reportNull$$$0(0);
            }
            if (firstBytes == null) {
                Detector.$$$reportNull$$$0(1);
            }
            if (!MemoryCaptureFileType.EXTENSION.equalsIgnoreCase(file.getExtension())) {
                return null;
            }
            if (firstBytes.length() < magic.length) {
                return null;
            }
            if (Arrays.equals(firstBytes.subSequence(0, magic.length).toBytes(), magic)) {
                return myInstance;
            }
            return null;
        }

        public int getDesiredContentPrefixLength() {
            return magic.length;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "firstBytes";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/fileTypes/profiler/MemoryCaptureFileType$Detector";
            objectArray[2] = "detect";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

