/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer.adbimpl;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.SyncService;
import com.android.tools.idea.concurrency.FutureCallbackExecutor;
import com.android.tools.idea.explorer.adbimpl.AdbFileListingEntry;
import com.android.tools.idea.explorer.adbimpl.AdbFileOperations;
import com.android.tools.idea.explorer.fs.FileTransferProgress;
import com.android.tools.idea.explorer.fs.ThrottledProgress;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Locale;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdbFileTransfer {
    @NotNull
    private static Logger LOGGER = Logger.getInstance(AdbFileTransfer.class);
    @NotNull
    private final IDevice myDevice;
    @NotNull
    private final AdbFileOperations myFileOperations;
    @NotNull
    private final FutureCallbackExecutor myProgressExecutor;
    @NotNull
    private final FutureCallbackExecutor myTaskExecutor;

    public AdbFileTransfer(@NotNull IDevice device, @NotNull AdbFileOperations fileOperations, @NotNull Executor progressExecutor, @NotNull Executor taskExecutor) {
        if (device == null) {
            AdbFileTransfer.$$$reportNull$$$0(0);
        }
        if (fileOperations == null) {
            AdbFileTransfer.$$$reportNull$$$0(1);
        }
        if (progressExecutor == null) {
            AdbFileTransfer.$$$reportNull$$$0(2);
        }
        if (taskExecutor == null) {
            AdbFileTransfer.$$$reportNull$$$0(3);
        }
        this.myDevice = device;
        this.myFileOperations = fileOperations;
        this.myProgressExecutor = FutureCallbackExecutor.wrap((Executor)progressExecutor);
        this.myTaskExecutor = FutureCallbackExecutor.wrap((Executor)taskExecutor);
    }

    @NotNull
    public ListenableFuture<Void> downloadFile(@NotNull AdbFileListingEntry remoteFileEntry, @NotNull Path localPath, @NotNull FileTransferProgress progress) {
        if (remoteFileEntry == null) {
            AdbFileTransfer.$$$reportNull$$$0(4);
        }
        if (localPath == null) {
            AdbFileTransfer.$$$reportNull$$$0(5);
        }
        if (progress == null) {
            AdbFileTransfer.$$$reportNull$$$0(6);
        }
        return this.downloadFileWorker(remoteFileEntry.getFullPath(), remoteFileEntry.getSize(), localPath, progress);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ListenableFuture<Void> downloadFile(@NotNull String remotePath, long remotePathSize, @NotNull Path localPath, @NotNull FileTransferProgress fileTransferProgress) {
        void progress;
        if (remotePath == null) {
            AdbFileTransfer.$$$reportNull$$$0(7);
        }
        if (localPath == null) {
            AdbFileTransfer.$$$reportNull$$$0(8);
        }
        if (fileTransferProgress == null) {
            AdbFileTransfer.$$$reportNull$$$0(9);
        }
        return this.downloadFileWorker(remotePath, remotePathSize, localPath, (FileTransferProgress)progress);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ListenableFuture<Void> downloadFileViaTempLocation(@NotNull String remotePath, long remotePathSize, @NotNull Path localPath, @NotNull FileTransferProgress progress, @Nullable String string) {
        void runAs;
        if (remotePath == null) {
            AdbFileTransfer.$$$reportNull$$$0(10);
        }
        if (localPath == null) {
            AdbFileTransfer.$$$reportNull$$$0(11);
        }
        if (progress == null) {
            AdbFileTransfer.$$$reportNull$$$0(12);
        }
        ListenableFuture<String> futureTempFile = this.myFileOperations.createTempFile("/data/local/tmp");
        ListenableFuture listenableFuture = this.myTaskExecutor.transformAsync(futureTempFile, arg_0 -> this.lambda$downloadFileViaTempLocation$2(remotePath, (String)runAs, remotePathSize, localPath, progress, arg_0));
        if (listenableFuture == null) {
            AdbFileTransfer.$$$reportNull$$$0(13);
        }
        return listenableFuture;
    }

    @NotNull
    public ListenableFuture<Void> uploadFile(@NotNull Path localPath, @NotNull String remotePath, @NotNull FileTransferProgress progress) {
        if (localPath == null) {
            AdbFileTransfer.$$$reportNull$$$0(14);
        }
        if (remotePath == null) {
            AdbFileTransfer.$$$reportNull$$$0(15);
        }
        if (progress == null) {
            AdbFileTransfer.$$$reportNull$$$0(16);
        }
        return this.uploadFileWorker(localPath, remotePath, progress);
    }

    public ListenableFuture<Void> uploadFileViaTempLocation(@NotNull Path localPath, @NotNull String remotePath, @NotNull FileTransferProgress progress, @Nullable String runAs) {
        if (localPath == null) {
            AdbFileTransfer.$$$reportNull$$$0(17);
        }
        if (remotePath == null) {
            AdbFileTransfer.$$$reportNull$$$0(18);
        }
        if (progress == null) {
            AdbFileTransfer.$$$reportNull$$$0(19);
        }
        ListenableFuture<String> futureTempFile = this.myFileOperations.createTempFile("/data/local/tmp");
        return this.myTaskExecutor.transformAsync(futureTempFile, tempFile -> {
            assert (tempFile != null);
            ListenableFuture<Void> futureUpload = this.uploadFile(localPath, (String)tempFile, progress);
            ListenableFuture futureCopy = this.myTaskExecutor.transformAsync(futureUpload, aVoid -> this.myFileOperations.copyFileRunAs((String)tempFile, remotePath, runAs));
            return this.myTaskExecutor.finallyAsync(futureCopy, () -> this.myFileOperations.deleteFile((String)tempFile));
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private ListenableFuture<Void> downloadFileWorker(@NotNull String remotePath, long remotePathSize, @NotNull Path localPath, @NotNull FileTransferProgress fileTransferProgress) {
        void progress;
        if (remotePath == null) {
            AdbFileTransfer.$$$reportNull$$$0(20);
        }
        if (localPath == null) {
            AdbFileTransfer.$$$reportNull$$$0(21);
        }
        if (fileTransferProgress == null) {
            AdbFileTransfer.$$$reportNull$$$0(22);
        }
        ListenableFuture<SyncService> futureSyncService = this.getSyncService();
        ListenableFuture futurePull = this.myTaskExecutor.transform(futureSyncService, arg_0 -> this.lambda$downloadFileWorker$6(remotePath, localPath, (FileTransferProgress)progress, remotePathSize, arg_0));
        ListenableFuture listenableFuture = this.myTaskExecutor.catchingAsync(futurePull, SyncException.class, syncError -> {
            assert (syncError != null);
            if (syncError.wasCanceled()) {
                return Futures.immediateCancelledFuture();
            }
            LOGGER.info(String.format("Error pulling file from \"%s\" to \"%s\"", remotePath, localPath), (Throwable)syncError);
            return Futures.immediateFailedFuture((Throwable)syncError);
        });
        if (listenableFuture == null) {
            AdbFileTransfer.$$$reportNull$$$0(23);
        }
        return listenableFuture;
    }

    @NotNull
    private ListenableFuture<Void> uploadFileWorker(@NotNull Path localPath, @NotNull String remotePath, @NotNull FileTransferProgress progress) {
        if (localPath == null) {
            AdbFileTransfer.$$$reportNull$$$0(24);
        }
        if (remotePath == null) {
            AdbFileTransfer.$$$reportNull$$$0(25);
        }
        if (progress == null) {
            AdbFileTransfer.$$$reportNull$$$0(26);
        }
        ListenableFuture<SyncService> futureSyncService = this.getSyncService();
        ListenableFuture futurePush = this.myTaskExecutor.transform(futureSyncService, syncService -> {
            assert (syncService != null);
            try {
                long fileLength = localPath.toFile().length();
                long startTime = System.nanoTime();
                syncService.pushFile(localPath.toString(), remotePath, (SyncService.ISyncProgressMonitor)new SingleFileProgressMonitor((Executor)this.myProgressExecutor, progress, fileLength));
                long endTime = System.nanoTime();
                LOGGER.info(String.format(Locale.US, "Push file took %,d ms to execute: \"%s\" -> \"%s\"", (endTime - startTime) / 1000000L, localPath, remotePath));
                Void void_ = null;
                return void_;
            }
            finally {
                syncService.close();
            }
        });
        ListenableFuture listenableFuture = this.myTaskExecutor.catchingAsync(futurePush, SyncException.class, syncError -> {
            assert (syncError != null);
            if (syncError.wasCanceled()) {
                return Futures.immediateCancelledFuture();
            }
            LOGGER.info(String.format("Error pushing file from \"%s\" to \"%s\"", localPath, remotePath), (Throwable)syncError);
            return Futures.immediateFailedFuture((Throwable)syncError);
        });
        if (listenableFuture == null) {
            AdbFileTransfer.$$$reportNull$$$0(27);
        }
        return listenableFuture;
    }

    @NotNull
    private ListenableFuture<SyncService> getSyncService() {
        ListenableFuture listenableFuture = this.myTaskExecutor.executeAsync(() -> {
            SyncService sync = this.myDevice.getSyncService();
            if (sync == null) {
                throw new IOException("Unable to open synchronization service to device");
            }
            return sync;
        });
        if (listenableFuture == null) {
            AdbFileTransfer.$$$reportNull$$$0(28);
        }
        return listenableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Void lambda$downloadFileWorker$6(String remotePath, Path localPath, FileTransferProgress progress, long remotePathSize, SyncService syncService) throws Exception {
        assert (syncService != null);
        try {
            long startTime = System.nanoTime();
            syncService.pullFile(remotePath, localPath.toString(), (SyncService.ISyncProgressMonitor)new SingleFileProgressMonitor((Executor)this.myProgressExecutor, progress, remotePathSize));
            long endTime = System.nanoTime();
            LOGGER.info(String.format(Locale.US, "Pull file took %,d ms to execute: \"%s\" -> \"%s\"", (endTime - startTime) / 1000000L, remotePath, localPath));
            Void void_ = null;
            return void_;
        }
        finally {
            syncService.close();
        }
    }

    private /* synthetic */ ListenableFuture lambda$downloadFileViaTempLocation$2(String remotePath, String runAs, long remotePathSize, Path localPath, FileTransferProgress progress, String tempFile) throws Exception {
        assert (tempFile != null);
        ListenableFuture<Void> futureCopy = this.myFileOperations.copyFileRunAs(remotePath, tempFile, runAs);
        ListenableFuture futureDownload = this.myTaskExecutor.transformAsync(futureCopy, aVoid -> this.downloadFile(tempFile, remotePathSize, localPath, progress));
        return this.myTaskExecutor.finallyAsync(futureDownload, () -> this.myFileOperations.deleteFile(tempFile));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 23: 
            case 27: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 23: 
            case 27: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOperations";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressExecutor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskExecutor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteFileEntry";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 16: 
            case 19: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 7: 
            case 10: 
            case 15: 
            case 18: 
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePath";
                break;
            }
            case 13: 
            case 23: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/explorer/adbimpl/AdbFileTransfer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/explorer/adbimpl/AdbFileTransfer";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "downloadFileViaTempLocation";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "downloadFileWorker";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "uploadFileWorker";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getSyncService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "downloadFile";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "downloadFileViaTempLocation";
                break;
            }
            case 13: 
            case 23: 
            case 27: 
            case 28: {
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "uploadFile";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "uploadFileViaTempLocation";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "downloadFileWorker";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "uploadFileWorker";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 23: 
            case 27: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SingleFileProgressMonitor
    implements SyncService.ISyncProgressMonitor {
        private static final int PROGRESS_REPORT_INTERVAL_MILLIS = 50;
        @NotNull
        private final Executor myCallbackExecutor;
        @NotNull
        private final FileTransferProgress myProgress;
        @NotNull
        private final ThrottledProgress myThrottledProgress;
        private final long myTotalBytes;
        private long myCurrentBytes;

        public SingleFileProgressMonitor(@NotNull Executor callbackExecutor, @NotNull FileTransferProgress progress, long totalBytes) {
            if (callbackExecutor == null) {
                SingleFileProgressMonitor.$$$reportNull$$$0(0);
            }
            if (progress == null) {
                SingleFileProgressMonitor.$$$reportNull$$$0(1);
            }
            this.myCallbackExecutor = callbackExecutor;
            this.myProgress = progress;
            this.myTotalBytes = totalBytes;
            this.myThrottledProgress = new ThrottledProgress(50L);
        }

        public void start(int totalWork) {
            this.myCallbackExecutor.execute(() -> this.myProgress.progress(0L, this.myTotalBytes));
        }

        public void stop() {
            this.myCallbackExecutor.execute(() -> this.myProgress.progress(this.myTotalBytes, this.myTotalBytes));
        }

        public boolean isCanceled() {
            return this.myProgress.isCancelled();
        }

        public void startSubTask(String name) {
            assert (false) : "A single file sync should not have multiple tasks";
        }

        public void advance(int work) {
            this.myCurrentBytes += (long)work;
            if (this.myThrottledProgress.check()) {
                long currentBytes = this.myCurrentBytes;
                this.myCallbackExecutor.execute(() -> this.myProgress.progress(currentBytes, this.myTotalBytes));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "callbackExecutor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "progress";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/explorer/adbimpl/AdbFileTransfer$SingleFileProgressMonitor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

