/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer.adbimpl;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.FileListingService;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.tools.idea.concurrency.FutureCallbackExecutor;
import com.android.tools.idea.explorer.adbimpl.AdbDeviceCapabilities;
import com.android.tools.idea.explorer.adbimpl.AdbFileListingEntry;
import com.android.tools.idea.explorer.adbimpl.AdbFileListingEntryBuilder;
import com.android.tools.idea.explorer.adbimpl.AdbPathUtil;
import com.android.tools.idea.explorer.adbimpl.AdbShellCommandBuilder;
import com.android.tools.idea.explorer.adbimpl.AdbShellCommandResult;
import com.android.tools.idea.explorer.adbimpl.AdbShellCommandsUtil;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdbFileListing {
    @NotNull
    public static final Logger LOGGER = Logger.getInstance(AdbFileListing.class);
    @NotNull
    private static final Pattern BACKSLASH = Pattern.compile("\\", 16);
    @NotNull
    private final IDevice myDevice;
    @NotNull
    private AdbDeviceCapabilities myDeviceCapabilities;
    @NotNull
    private final FutureCallbackExecutor myExecutor;
    @NotNull
    private final AdbFileListingEntry myRoot;

    public AdbFileListing(@NotNull IDevice device, @NotNull AdbDeviceCapabilities deviceCapabilities, @NotNull Executor taskExecutor) {
        if (device == null) {
            AdbFileListing.$$$reportNull$$$0(0);
        }
        if (deviceCapabilities == null) {
            AdbFileListing.$$$reportNull$$$0(1);
        }
        if (taskExecutor == null) {
            AdbFileListing.$$$reportNull$$$0(2);
        }
        this.myDevice = device;
        this.myDeviceCapabilities = deviceCapabilities;
        this.myExecutor = FutureCallbackExecutor.wrap((Executor)taskExecutor);
        this.myRoot = new AdbFileListingEntryBuilder().setPath("/").setKind(AdbFileListingEntry.EntryKind.DIRECTORY).build();
    }

    @NotNull
    public ListenableFuture<AdbFileListingEntry> getRoot() {
        ListenableFuture listenableFuture = Futures.immediateFuture((Object)this.myRoot);
        if (listenableFuture == null) {
            AdbFileListing.$$$reportNull$$$0(3);
        }
        return listenableFuture;
    }

    @NotNull
    public ListenableFuture<List<AdbFileListingEntry>> getChildren(@NotNull AdbFileListingEntry parentEntry) {
        if (parentEntry == null) {
            AdbFileListing.$$$reportNull$$$0(4);
        }
        ListenableFuture<List<AdbFileListingEntry>> listenableFuture = this.getChildrenRunAs(parentEntry, null);
        if (listenableFuture == null) {
            AdbFileListing.$$$reportNull$$$0(5);
        }
        return listenableFuture;
    }

    @NotNull
    public ListenableFuture<List<AdbFileListingEntry>> getChildrenRunAs(@NotNull AdbFileListingEntry parentEntry, @Nullable String runAs) {
        if (parentEntry == null) {
            AdbFileListing.$$$reportNull$$$0(6);
        }
        ListenableFuture listenableFuture = this.myExecutor.executeAsync(() -> {
            String command = this.getCommand(runAs, "ls -l ").withDirectoryEscapedPath(parentEntry.getFullPath()).build();
            AdbShellCommandResult commandResult = AdbShellCommandsUtil.executeCommand(this.myDevice, command);
            boolean escaping = this.myDeviceCapabilities.hasEscapingLs();
            List entries = commandResult.getOutput().stream().map(line -> AdbFileListing.processLsOutputLine(line, escaping, parentEntry)).filter(Objects::nonNull).collect(Collectors.toList());
            if (entries.isEmpty() && commandResult.isError()) {
                commandResult.throwIfError();
            }
            return entries;
        });
        if (listenableFuture == null) {
            AdbFileListing.$$$reportNull$$$0(7);
        }
        return listenableFuture;
    }

    @NotNull
    public ListenableFuture<Boolean> isDirectoryLink(@NotNull AdbFileListingEntry entry) {
        if (entry == null) {
            AdbFileListing.$$$reportNull$$$0(8);
        }
        ListenableFuture<Boolean> listenableFuture = this.isDirectoryLinkRunAs(entry, null);
        if (listenableFuture == null) {
            AdbFileListing.$$$reportNull$$$0(9);
        }
        return listenableFuture;
    }

    @NotNull
    public ListenableFuture<Boolean> isDirectoryLinkRunAs(@NotNull AdbFileListingEntry entry, @Nullable String runAs) {
        if (entry == null) {
            AdbFileListing.$$$reportNull$$$0(10);
        }
        if (!entry.isSymbolicLink()) {
            ListenableFuture listenableFuture = Futures.immediateFuture((Object)false);
            if (listenableFuture == null) {
                AdbFileListing.$$$reportNull$$$0(11);
            }
            return listenableFuture;
        }
        ListenableFuture listenableFuture = this.myExecutor.executeAsync(() -> {
            String command = this.getCommand(runAs, "ls -l -d ").withDirectoryEscapedPath(entry.getFullPath()).build();
            AdbShellCommandResult commandResult = AdbShellCommandsUtil.executeCommandNoErrorCheck(this.myDevice, command);
            int lineCount = 0;
            for (String line : commandResult.getOutput()) {
                Matcher m = FileListingService.LS_LD_PATTERN.matcher(line);
                if (!m.matches()) continue;
                if (lineCount > 0) {
                    LOGGER.warn(String.format("Unexpected additional output line matching result of ld -l -d: %s", line));
                }
                ++lineCount;
            }
            return lineCount > 0;
        });
        if (listenableFuture == null) {
            AdbFileListing.$$$reportNull$$$0(12);
        }
        return listenableFuture;
    }

    @Nullable
    private static AdbFileListingEntry processLsOutputLine(@NotNull String line, boolean escaping, @NotNull AdbFileListingEntry parentEntry) {
        if (line == null) {
            AdbFileListing.$$$reportNull$$$0(13);
        }
        if (parentEntry == null) {
            AdbFileListing.$$$reportNull$$$0(14);
        }
        if (line.isEmpty()) {
            return null;
        }
        Matcher m = FileListingService.LS_L_PATTERN.matcher(line);
        if (!m.matches()) {
            return null;
        }
        String name = AdbFileListing.getName(m, escaping);
        String permissions = m.group(1);
        String owner = m.group(2);
        String group2 = m.group(3);
        String size = m.group(4);
        String date = m.group(5);
        String time2 = m.group(6);
        Object info = null;
        AdbFileListingEntry.EntryKind objectType = AdbFileListingEntry.EntryKind.OTHER;
        switch (permissions.charAt(0)) {
            case '-': {
                objectType = AdbFileListingEntry.EntryKind.FILE;
                break;
            }
            case 'b': {
                objectType = AdbFileListingEntry.EntryKind.BLOCK;
                break;
            }
            case 'c': {
                objectType = AdbFileListingEntry.EntryKind.CHARACTER;
                break;
            }
            case 'd': {
                objectType = AdbFileListingEntry.EntryKind.DIRECTORY;
                break;
            }
            case 'l': {
                objectType = AdbFileListingEntry.EntryKind.SYMBOLIC_LINK;
                break;
            }
            case 's': {
                objectType = AdbFileListingEntry.EntryKind.SOCKET;
                break;
            }
            case 'p': {
                objectType = AdbFileListingEntry.EntryKind.FIFO;
            }
        }
        if (objectType == AdbFileListingEntry.EntryKind.SYMBOLIC_LINK) {
            String[] segments = name.split("\\s->\\s");
            if (segments.length == 2) {
                name = segments[0];
                info = segments[1];
            }
            info = "-> " + info;
        }
        String path2 = AdbPathUtil.resolve(parentEntry.getFullPath(), name);
        return new AdbFileListingEntry(path2, objectType, permissions, owner, group2, date, time2, size, (String)info);
    }

    @NotNull
    private static String getName(@NotNull MatchResult result2, boolean escaping) {
        if (result2 == null) {
            AdbFileListing.$$$reportNull$$$0(15);
        }
        String name = result2.group(7);
        String string = escaping ? BACKSLASH.matcher(name).replaceAll("") : name;
        if (string == null) {
            AdbFileListing.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    private AdbShellCommandBuilder getCommand(@Nullable String runAs, @NotNull String text) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        if (text == null) {
            AdbFileListing.$$$reportNull$$$0(17);
        }
        AdbShellCommandBuilder command = new AdbShellCommandBuilder();
        if (runAs != null) {
            command.withRunAs(runAs);
        } else if (this.myDeviceCapabilities.supportsSuRootCommand()) {
            command.withSuRootPrefix();
        }
        AdbShellCommandBuilder adbShellCommandBuilder = command.withText(text);
        if (adbShellCommandBuilder == null) {
            AdbFileListing.$$$reportNull$$$0(18);
        }
        return adbShellCommandBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 16: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 16: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceCapabilities";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskExecutor";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/explorer/adbimpl/AdbFileListing";
                break;
            }
            case 4: 
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentEntry";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/explorer/adbimpl/AdbFileListing";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenRunAs";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "isDirectoryLink";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "isDirectoryLinkRunAs";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 16: 
            case 18: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenRunAs";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isDirectoryLink";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isDirectoryLinkRunAs";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processLsOutputLine";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getCommand";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 16: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

