/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer;

import com.android.tools.idea.concurrency.FutureCallbackExecutor;
import com.android.tools.idea.explorer.FileTransferWorkEstimate;
import com.android.tools.idea.explorer.FileTransferWorkEstimatorProgress;
import com.android.tools.idea.explorer.fs.DeviceFileEntry;
import com.android.tools.idea.explorer.fs.ThrottledProgress;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;

public class FileTransferWorkEstimator {
    private static final int DIRECTORY_TRANSFER_WORK_UNITS = 64000;
    private static final int FILE_TRANSFER_WORK_UNITS = 64000;
    private static final int PROGRESS_REPORT_INTERVAL_MILLIS = 50;
    @NotNull
    private final FutureCallbackExecutor myEdtExecutor;
    @NotNull
    private final FutureCallbackExecutor myTaskExecutor;
    @NotNull
    private final ThrottledProgress myThrottledProgress;

    FileTransferWorkEstimator(@NotNull Executor edtExecutor, @NotNull Executor taskExecutor) {
        if (edtExecutor == null) {
            FileTransferWorkEstimator.$$$reportNull$$$0(0);
        }
        if (taskExecutor == null) {
            FileTransferWorkEstimator.$$$reportNull$$$0(1);
        }
        this.myEdtExecutor = FutureCallbackExecutor.wrap((Executor)edtExecutor);
        this.myTaskExecutor = FutureCallbackExecutor.wrap((Executor)taskExecutor);
        this.myThrottledProgress = new ThrottledProgress(50L);
    }

    public static long getDirectoryWorkUnits() {
        return 64000L;
    }

    public static long getFileWorkUnits() {
        return 64000L;
    }

    public static long getFileContentsWorkUnits(long byteCount) {
        return byteCount;
    }

    public ListenableFuture<FileTransferWorkEstimate> estimateDownloadWork(@NotNull DeviceFileEntry entry, boolean isLinkToDirectory, @NotNull FileTransferWorkEstimatorProgress progress) {
        if (entry == null) {
            FileTransferWorkEstimator.$$$reportNull$$$0(2);
        }
        if (progress == null) {
            FileTransferWorkEstimator.$$$reportNull$$$0(3);
        }
        FileTransferWorkEstimate workEstimate = new FileTransferWorkEstimate();
        ListenableFuture<Void> future2 = this.estimateDownloadWorkWorker(entry, isLinkToDirectory, workEstimate, progress);
        return this.myEdtExecutor.transform(future2, aVoid -> workEstimate);
    }

    public ListenableFuture<Void> estimateDownloadWorkWorker(@NotNull DeviceFileEntry entry, boolean isLinkToDirectory, @NotNull FileTransferWorkEstimate estimate, @NotNull FileTransferWorkEstimatorProgress progress) {
        if (entry == null) {
            FileTransferWorkEstimator.$$$reportNull$$$0(4);
        }
        if (estimate == null) {
            FileTransferWorkEstimator.$$$reportNull$$$0(5);
        }
        if (progress == null) {
            FileTransferWorkEstimator.$$$reportNull$$$0(6);
        }
        if (progress.isCancelled()) {
            return Futures.immediateCancelledFuture();
        }
        this.reportProgress(estimate, progress);
        if (entry.isDirectory() || isLinkToDirectory) {
            ListenableFuture<List<DeviceFileEntry>> futureEntries = entry.getEntries();
            return this.myEdtExecutor.transformAsync(futureEntries, entries -> {
                assert (entries != null);
                estimate.addDirectoryCount(1);
                estimate.addWorkUnits(FileTransferWorkEstimator.getDirectoryWorkUnits());
                return this.myEdtExecutor.executeFuturesInSequence(entries.iterator(), childEntry -> this.estimateDownloadWorkWorker((DeviceFileEntry)childEntry, false, estimate, progress));
            });
        }
        estimate.addFileCount(1);
        estimate.addWorkUnits(FileTransferWorkEstimator.getFileWorkUnits() + FileTransferWorkEstimator.getFileContentsWorkUnits(entry.getSize()));
        return Futures.immediateFuture(null);
    }

    public ListenableFuture<FileTransferWorkEstimate> estimateUploadWork(@NotNull Path path2, @NotNull FileTransferWorkEstimatorProgress progress) {
        if (path2 == null) {
            FileTransferWorkEstimator.$$$reportNull$$$0(7);
        }
        if (progress == null) {
            FileTransferWorkEstimator.$$$reportNull$$$0(8);
        }
        ListenableFuture futureEstimate = this.myTaskExecutor.executeAsync(() -> {
            FileTransferWorkEstimate workEstimate = new FileTransferWorkEstimate();
            if (!this.estimateUploadWorkWorker(path2.toFile(), workEstimate, progress)) {
                return null;
            }
            return workEstimate;
        });
        return this.myTaskExecutor.transformAsync(futureEstimate, estimate -> {
            if (estimate == null) {
                return Futures.immediateCancelledFuture();
            }
            return Futures.immediateFuture((Object)estimate);
        });
    }

    private boolean estimateUploadWorkWorker(@NotNull File file, @NotNull FileTransferWorkEstimate estimate, @NotNull FileTransferWorkEstimatorProgress progress) {
        if (file == null) {
            FileTransferWorkEstimator.$$$reportNull$$$0(9);
        }
        if (estimate == null) {
            FileTransferWorkEstimator.$$$reportNull$$$0(10);
        }
        if (progress == null) {
            FileTransferWorkEstimator.$$$reportNull$$$0(11);
        }
        if (progress.isCancelled()) {
            return false;
        }
        this.reportProgress(estimate, progress);
        if (file.isDirectory()) {
            estimate.addWorkUnits(FileTransferWorkEstimator.getDirectoryWorkUnits());
            estimate.addDirectoryCount(1);
            File[] children = file.listFiles();
            if (children != null) {
                for (File child : children) {
                    if (this.estimateUploadWorkWorker(child, estimate, progress)) continue;
                    return false;
                }
            }
        } else {
            estimate.addWorkUnits(FileTransferWorkEstimator.getFileWorkUnits() + FileTransferWorkEstimator.getFileContentsWorkUnits(file.length()));
            estimate.addFileCount(1);
        }
        return true;
    }

    private void reportProgress(@NotNull FileTransferWorkEstimate estimate, @NotNull FileTransferWorkEstimatorProgress progress) {
        if (estimate == null) {
            FileTransferWorkEstimator.$$$reportNull$$$0(12);
        }
        if (progress == null) {
            FileTransferWorkEstimator.$$$reportNull$$$0(13);
        }
        if (this.myThrottledProgress.check()) {
            int fileCount2 = estimate.getFileCount();
            int directoryCount = estimate.getDirectoryCount();
            this.myEdtExecutor.execute(() -> progress.progress(fileCount2, directoryCount));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edtExecutor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskExecutor";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 5: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "estimate";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/explorer/FileTransferWorkEstimator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "estimateDownloadWork";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "estimateDownloadWorkWorker";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "estimateUploadWork";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "estimateUploadWorkWorker";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "reportProgress";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

