/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer;

import com.android.tools.idea.apk.viewer.ApkViewPanel;
import com.android.tools.idea.explorer.DeviceExplorerView;
import com.android.tools.idea.explorer.FileTransferSummary;
import com.android.tools.idea.explorer.FileTransferWorkEstimate;
import com.android.tools.idea.explorer.FileTransferWorkEstimator;
import com.android.tools.idea.explorer.LongRunningOperationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import java.util.Locale;
import java.util.concurrent.CancellationException;
import org.jetbrains.annotations.NotNull;

public class FileTransferOperationTracker
extends LongRunningOperationTracker {
    private static final int MAX_PATH_DISPLAY_LENGTH = 50;
    @NotNull
    private final FileTransferSummary mySummary;
    private long myFinishedWorkUnits;
    private long myTotalWorkUnits;
    private int myCurrentFileCount;
    private int myTotalFileCount;
    private int myCurrentDirectoryCount;
    private int myTotalDirectoryCount;

    public FileTransferOperationTracker(@NotNull DeviceExplorerView view) {
        if (view == null) {
            FileTransferOperationTracker.$$$reportNull$$$0(0);
        }
        super(view);
        this.mySummary = new FileTransferSummary();
    }

    @NotNull
    public FileTransferSummary getSummary() {
        FileTransferSummary fileTransferSummary = this.mySummary;
        if (fileTransferSummary == null) {
            FileTransferOperationTracker.$$$reportNull$$$0(1);
        }
        return fileTransferSummary;
    }

    @Override
    public void stop() {
        super.stop();
        this.mySummary.setDurationMillis(this.getDurationMillis());
    }

    public void addProblem(@NotNull Throwable error) {
        if (error == null) {
            FileTransferOperationTracker.$$$reportNull$$$0(2);
        }
        if (ExceptionUtil.getRootCause((Throwable)error) instanceof CancellationException) {
            return;
        }
        this.mySummary.getProblems().add(error);
        this.setWarningColor();
    }

    public void showProgress() {
        if (this.myTotalWorkUnits == 0L) {
            return;
        }
        this.setProgress((double)this.myFinishedWorkUnits / (double)this.myTotalWorkUnits);
    }

    public void processDirectory() {
        this.myFinishedWorkUnits += FileTransferWorkEstimator.getDirectoryWorkUnits();
        ++this.myCurrentDirectoryCount;
        this.showProgress();
    }

    public void processFile() {
        this.myFinishedWorkUnits += FileTransferWorkEstimator.getFileWorkUnits();
        ++this.myCurrentFileCount;
        this.showProgress();
    }

    public void processFileBytes(long byteCount) {
        this.myFinishedWorkUnits += FileTransferWorkEstimator.getFileContentsWorkUnits(byteCount);
        this.showProgress();
    }

    /*
     * WARNING - void declaration
     */
    public void setUploadFileText(@NotNull VirtualFile file, long currentBytes, long l) {
        void totalBytes;
        if (file == null) {
            FileTransferOperationTracker.$$$reportNull$$$0(3);
        }
        Object text = this.myTotalFileCount > 1 ? String.format(Locale.US, "Uploading file %,d of %,d: \"%s\"", this.myCurrentFileCount, this.myTotalFileCount, StringUtil.shortenPathWithEllipsis((String)file.getPresentableUrl(), (int)50)) : String.format("Uploading file \"%s\"", StringUtil.shortenPathWithEllipsis((String)file.getPresentableUrl(), (int)50));
        if (totalBytes > 0L) {
            text = (String)text + String.format(" (%s / %s)", ApkViewPanel.getHumanizedSize(currentBytes), ApkViewPanel.getHumanizedSize((long)totalBytes));
        }
        this.setStatusText((String)text);
    }

    /*
     * WARNING - void declaration
     */
    public void setDownloadFileText(@NotNull String entryFullPath, long currentBytes, long l) {
        void totalBytes;
        if (entryFullPath == null) {
            FileTransferOperationTracker.$$$reportNull$$$0(4);
        }
        Object text = this.myTotalFileCount > 1 ? String.format(Locale.US, "Downloading file %,d of %,d: \"%s\"", this.myCurrentFileCount, this.myTotalFileCount, StringUtil.shortenPathWithEllipsis((String)entryFullPath.toString(), (int)50)) : String.format("Downloading file \"%s\"", StringUtil.shortenPathWithEllipsis((String)entryFullPath.toString(), (int)50));
        if (totalBytes > 0L) {
            text = (String)text + String.format(" (%s / %s)", ApkViewPanel.getHumanizedSize(currentBytes), ApkViewPanel.getHumanizedSize((long)totalBytes));
        }
        this.setStatusText((String)text);
    }

    public void addWorkEstimate(FileTransferWorkEstimate estimate) {
        this.myTotalFileCount += estimate.getFileCount();
        this.myTotalDirectoryCount += estimate.getDirectoryCount();
        this.myTotalWorkUnits += estimate.getWorkUnits();
    }

    public void setCalculatingText(int fileCount2, int directoryCount) {
        Object text = "Calculating...";
        if ((fileCount2 += this.myTotalFileCount) > 0 || (directoryCount += this.myTotalDirectoryCount) > 0) {
            text = (String)text + String.format(Locale.US, " %,d %s, %,d %s", fileCount2, StringUtil.pluralize((String)"file", (int)fileCount2), directoryCount, StringUtil.pluralize((String)"directory", (int)directoryCount));
        }
        this.setStatusText((String)text);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/explorer/FileTransferOperationTracker";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryFullPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/explorer/FileTransferOperationTracker";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSummary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addProblem";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setUploadFileText";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setDownloadFileText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

