/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer;

import com.android.tools.idea.explorer.DeviceExplorer;
import com.android.tools.idea.explorer.DeviceExplorerController;
import com.android.tools.idea.explorer.DeviceExplorerFileManager;
import com.android.tools.idea.explorer.DeviceExplorerModel;
import com.android.tools.idea.explorer.adbimpl.AdbDeviceFileSystemRendererFactory;
import com.android.tools.idea.explorer.adbimpl.AdbDeviceFileSystemService;
import com.android.tools.idea.explorer.ui.DeviceExplorerViewImpl;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.concurrency.EdtExecutorService;
import icons.StudioIcons;
import java.nio.file.Path;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.PooledThreadExecutor;

public final class DeviceExplorerToolWindowFactory
implements DumbAware,
ToolWindowFactory {
    public static final String TOOL_WINDOW_ID = "Device File Explorer";

    public boolean isApplicable(@NotNull Project project) {
        if (project == null) {
            DeviceExplorerToolWindowFactory.$$$reportNull$$$0(0);
        }
        return DeviceExplorer.isFeatureEnabled();
    }

    public void createToolWindowContent(final @NotNull Project project, @NotNull ToolWindow toolWindow) {
        if (project == null) {
            DeviceExplorerToolWindowFactory.$$$reportNull$$$0(1);
        }
        if (toolWindow == null) {
            DeviceExplorerToolWindowFactory.$$$reportNull$$$0(2);
        }
        toolWindow.setIcon(StudioIcons.Shell.ToolWindows.DEVICE_EXPLORER);
        toolWindow.setAvailable(true);
        toolWindow.setToHideOnEmptyContent(true);
        toolWindow.setTitle(TOOL_WINDOW_ID);
        EdtExecutorService edtExecutor = EdtExecutorService.getInstance();
        ExecutorService taskExecutor = PooledThreadExecutor.INSTANCE;
        AdbDeviceFileSystemService adbService = AdbDeviceFileSystemService.getInstance(project);
        DeviceExplorerFileManager fileManager = DeviceExplorerFileManager.getInstance(project);
        AdbDeviceFileSystemRendererFactory deviceFileSystemRendererFactory = new AdbDeviceFileSystemRendererFactory(adbService);
        DeviceExplorerModel model2 = new DeviceExplorerModel();
        DeviceExplorerViewImpl view = new DeviceExplorerViewImpl(project, deviceFileSystemRendererFactory, model2);
        DeviceExplorerController.FileOpener fileOpener = new DeviceExplorerController.FileOpener(){

            @Override
            public void openFile(@NotNull Path localPath) {
                if (localPath == null) {
                    1.$$$reportNull$$$0(0);
                }
                TransactionGuard.submitTransaction((Disposable)project, () -> {
                    ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
                    OpenFileAction.openFile((String)localPath.toString(), (Project)project);
                });
            }

            @Override
            public void openFile(@NotNull VirtualFile virtualFile) {
                if (virtualFile == null) {
                    1.$$$reportNull$$$0(1);
                }
                TransactionGuard.submitTransaction((Disposable)project, () -> {
                    ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
                    OpenFileAction.openFile((VirtualFile)virtualFile, (Project)project);
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "localPath";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "virtualFile";
                        break;
                    }
                }
                objectArray[1] = "com/android/tools/idea/explorer/DeviceExplorerToolWindowFactory$1";
                objectArray[2] = "openFile";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        DeviceExplorerController controller2 = new DeviceExplorerController(project, model2, view, adbService, fileManager, fileOpener, (Executor)edtExecutor, taskExecutor);
        controller2.setup();
        ContentManager contentManager = toolWindow.getContentManager();
        Content toolWindowContent = contentManager.getFactory().createContent(view.getComponent(), "", true);
        contentManager.addContent(toolWindowContent);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/explorer/DeviceExplorerToolWindowFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createToolWindowContent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

