/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer;

import com.android.tools.idea.concurrency.FutureCallbackExecutor;
import com.android.tools.idea.device.fs.DeviceFileId;
import com.android.tools.idea.device.fs.DownloadProgress;
import com.android.tools.idea.device.fs.DownloadedFileData;
import com.android.tools.idea.deviceExplorer.FileHandler;
import com.android.tools.idea.explorer.DeviceExplorerFileManager;
import com.android.tools.idea.explorer.DeviceExplorerFilesUtils;
import com.android.tools.idea.explorer.adbimpl.AdbPathUtil;
import com.android.tools.idea.explorer.fs.DeviceFileEntry;
import com.android.tools.idea.explorer.fs.DeviceFileSystem;
import com.android.tools.idea.explorer.fs.FileTransferProgress;
import com.android.tools.idea.explorer.options.DeviceFileExplorerSettings;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.PathUtilRt;
import com.intellij.util.concurrency.EdtExecutorService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class DeviceExplorerFileManagerImpl
implements DeviceExplorerFileManager {
    private static final Logger LOGGER = Logger.getInstance(DeviceExplorerFileManagerImpl.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final FutureCallbackExecutor myEdtExecutor;
    @NotNull
    private final FutureCallbackExecutor myTaskExecutor;
    @NotNull
    private Supplier<Path> myDefaultDownloadPath;

    private DeviceExplorerFileManagerImpl(@NotNull Project project) {
        if (project == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(0);
        }
        this(project, (Executor)new FutureCallbackExecutor((Executor)EdtExecutorService.getInstance()), (Executor)new FutureCallbackExecutor((Executor)PooledThreadExecutor.INSTANCE), () -> Paths.get(DeviceFileExplorerSettings.getInstance().getDownloadLocation(), new String[0]));
    }

    @NonInjectable
    @VisibleForTesting
    public DeviceExplorerFileManagerImpl(@NotNull Project project, @NotNull Executor edtExecutor, @NotNull Executor taskExecutor, @NotNull Supplier<Path> downloadPathSupplier) {
        if (project == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(1);
        }
        if (edtExecutor == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(2);
        }
        if (taskExecutor == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(3);
        }
        if (downloadPathSupplier == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(4);
        }
        this.myProject = project;
        this.myProject.getMessageBus().connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                if (source == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (VfsUtilCore.isAncestor((File)DeviceExplorerFileManagerImpl.this.getDefaultDownloadPath().toFile(), (File)VfsUtilCore.virtualToIoFile((VirtualFile)file), (boolean)true)) {
                    Path localPath = Paths.get(file.getPath(), new String[0]);
                    DeviceExplorerFileManagerImpl.deleteTemporaryFile(localPath);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "source";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                }
                objectArray[1] = "com/android/tools/idea/explorer/DeviceExplorerFileManagerImpl$1";
                objectArray[2] = "fileClosed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myEdtExecutor = new FutureCallbackExecutor(edtExecutor);
        this.myTaskExecutor = new FutureCallbackExecutor(taskExecutor);
        this.myDefaultDownloadPath = downloadPathSupplier;
    }

    @NotNull
    public Path getDefaultLocalPathForDevice(@NotNull DeviceFileSystem device) {
        if (device == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(5);
        }
        Path rootPath = this.getDefaultDownloadPath();
        Path path2 = rootPath.resolve(DeviceExplorerFileManagerImpl.mapName(device.getName()));
        if (path2 == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(6);
        }
        return path2;
    }

    @Override
    @NotNull
    public Path getDefaultLocalPathForEntry(@NotNull DeviceFileEntry entry) {
        if (entry == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(7);
        }
        Path devicePath = this.getDefaultLocalPathForDevice(entry.getFileSystem());
        Path relativePath = DeviceExplorerFileManagerImpl.getEntryPath(entry);
        Path path2 = devicePath.resolve(relativePath);
        if (path2 == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(8);
        }
        return path2;
    }

    @Override
    @NotNull
    public ListenableFuture<DownloadedFileData> downloadFileEntry(@NotNull DeviceFileEntry entry, @NotNull Path localPath, @NotNull DownloadProgress progress) {
        if (entry == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(9);
        }
        if (localPath == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(10);
        }
        if (progress == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(11);
        }
        SettableFuture futureResult = SettableFuture.create();
        FileUtils.mkdirs((File)localPath.getParent().toFile());
        TransactionGuard.submitTransaction((Disposable)this.myProject, () -> ApplicationManager.getApplication().runWriteAction(() -> {
            VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)localPath.toFile(), (boolean)true);
            if (virtualFile != null) {
                try {
                    this.deleteVirtualFile(virtualFile);
                }
                catch (IOException exception) {
                    futureResult.setException((Throwable)exception);
                    return;
                }
            }
            this.downloadFileAndAdditionalFiles((SettableFuture<DownloadedFileData>)futureResult, entry, localPath, progress);
        }));
        SettableFuture settableFuture = futureResult;
        if (settableFuture == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(12);
        }
        return settableFuture;
    }

    public void deleteVirtualFile(@NotNull VirtualFile virtualFile) throws IOException {
        if (virtualFile == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(13);
        }
        ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
        virtualFile.delete((Object)this);
    }

    private void downloadFileAndAdditionalFiles(final @NotNull SettableFuture<DownloadedFileData> futureResult, final @NotNull DeviceFileEntry entry, @NotNull Path localPath, final @NotNull DownloadProgress progress) {
        if (futureResult == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(14);
        }
        if (entry == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(15);
        }
        if (localPath == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(16);
        }
        if (progress == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(17);
        }
        this.downloadFile(entry, localPath, progress, new FutureCallback<VirtualFile>(){

            public void onSuccess(final VirtualFile virtualFile) {
                ListenableFuture<List<VirtualFile>> downloadAdditionalFiles = DeviceExplorerFileManagerImpl.this.downloadAdditionalFiles(virtualFile, entry, progress);
                DeviceExplorerFileManagerImpl.this.myTaskExecutor.addCallback(downloadAdditionalFiles, (FutureCallback)new FutureCallback<List<VirtualFile>>(){

                    public void onSuccess(List<VirtualFile> additionalVirtualFiles) {
                        futureResult.set((Object)new DownloadedFileData(new DeviceFileId(entry.getFileSystem().getName(), entry.getFullPath()), virtualFile, additionalVirtualFiles));
                    }

                    public void onFailure(@NotNull Throwable throwable) {
                        if (throwable == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        futureResult.setException(throwable);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "throwable", "com/android/tools/idea/explorer/DeviceExplorerFileManagerImpl$2$1", "onFailure"));
                    }
                });
            }

            public void onFailure(@NotNull Throwable t) {
                if (t == null) {
                    2.$$$reportNull$$$0(0);
                }
                futureResult.setException(t);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/android/tools/idea/explorer/DeviceExplorerFileManagerImpl$2", "onFailure"));
            }
        });
    }

    @NotNull
    private ListenableFuture<VirtualFile> downloadFile(final @NotNull DeviceFileEntry entry, final @NotNull Path localPath, final @NotNull DownloadProgress progress, final @Nullable FutureCallback<VirtualFile> callback2) {
        if (entry == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(18);
        }
        if (localPath == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(19);
        }
        if (progress == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(20);
        }
        FileTransferProgress fileTransferProgress = this.createFileTransferProgress(entry, progress);
        progress.onStarting(entry.getFullPath());
        ListenableFuture<Void> downloadFileFuture = entry.downloadFile(localPath, fileTransferProgress);
        ListenableFuture getVirtualFile = this.myTaskExecutor.transformAsync(downloadFileFuture, aVoid -> DeviceExplorerFilesUtils.findFile(localPath));
        this.myEdtExecutor.addCallback(getVirtualFile, (FutureCallback)new FutureCallback<VirtualFile>(){

            public void onSuccess(VirtualFile virtualFile) {
                DeviceFileId fileInfo = new DeviceFileId(entry.getFileSystem().getName(), entry.getFullPath());
                fileInfo.storeInVirtualFile(virtualFile);
                progress.onCompleted(entry.getFullPath());
                if (callback2 != null) {
                    callback2.onSuccess((Object)virtualFile);
                }
            }

            public void onFailure(@NotNull Throwable t) {
                if (t == null) {
                    3.$$$reportNull$$$0(0);
                }
                progress.onCompleted(entry.getFullPath());
                DeviceExplorerFileManagerImpl.deleteTemporaryFile(localPath);
                if (callback2 != null) {
                    callback2.onFailure(t);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/android/tools/idea/explorer/DeviceExplorerFileManagerImpl$3", "onFailure"));
            }
        });
        ListenableFuture listenableFuture = getVirtualFile;
        if (listenableFuture == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(21);
        }
        return listenableFuture;
    }

    @NotNull
    private ListenableFuture<List<VirtualFile>> downloadAdditionalFiles(@NotNull VirtualFile originalFile, @NotNull DeviceFileEntry originalEntry, @NotNull DownloadProgress progress) {
        ListenableFuture<List<DeviceFileEntry>> additionalEntriesFuture;
        List<String> additionalPaths;
        if (originalFile == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(22);
        }
        if (originalEntry == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(23);
        }
        if (progress == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(24);
        }
        if (this.haveSameParent(originalEntry, additionalPaths = this.getAdditionalDevicePaths(originalEntry, originalFile))) {
            DeviceFileEntry parent = originalEntry.getParent();
            assert (parent != null);
            additionalEntriesFuture = this.getEntriesFromCommonParent(parent, additionalPaths);
        } else {
            additionalEntriesFuture = this.mapPathsToEntries(originalEntry.getFileSystem(), additionalPaths);
        }
        ArrayList virtualFiles = new ArrayList();
        ListenableFuture fileDownloaded = this.myTaskExecutor.transformAsync(additionalEntriesFuture, additionalEntries -> {
            assert (additionalEntries != null);
            return this.myEdtExecutor.executeFuturesInSequence(additionalEntries.iterator(), additionalEntry -> {
                Path localPath = this.getDefaultLocalPathForEntry((DeviceFileEntry)additionalEntry);
                FileUtils.mkdirs((File)localPath.getParent().toFile());
                ListenableFuture<VirtualFile> downloadCompleted = this.downloadFile((DeviceFileEntry)additionalEntry, localPath, progress, null);
                return this.myTaskExecutor.transform(downloadCompleted, virtualFile -> {
                    virtualFiles.add(virtualFile);
                    return null;
                });
            });
        });
        ListenableFuture listenableFuture = this.myTaskExecutor.transform(fileDownloaded, aVoid -> virtualFiles);
        if (listenableFuture == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(25);
        }
        return listenableFuture;
    }

    @NotNull
    private ListenableFuture<List<DeviceFileEntry>> getEntriesFromCommonParent(@NotNull DeviceFileEntry parent, @NotNull List<String> paths) {
        if (parent == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(26);
        }
        if (paths == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(27);
        }
        ListenableFuture<List<DeviceFileEntry>> getEntries = parent.getEntries();
        ListenableFuture listenableFuture = this.myTaskExecutor.transform(getEntries, entries -> {
            assert (entries != null);
            return paths.stream().map(path2 -> {
                Optional<DeviceFileEntry> additionalEntryOptional = entries.stream().filter(e -> e.getFullPath().equals(path2)).findFirst();
                return additionalEntryOptional.get();
            }).collect(Collectors.toList());
        });
        if (listenableFuture == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(28);
        }
        return listenableFuture;
    }

    private boolean haveSameParent(@NotNull DeviceFileEntry originalEntry, @NotNull List<String> additionalPaths) {
        DeviceFileEntry parent;
        if (originalEntry == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(29);
        }
        if (additionalPaths == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(30);
        }
        String parentPath = (parent = originalEntry.getParent()) != null ? parent.getFullPath() : "";
        for (String currentPath : additionalPaths) {
            if (parentPath.equals(AdbPathUtil.getParentPath(currentPath))) continue;
            return false;
        }
        return true;
    }

    private FileTransferProgress createFileTransferProgress(final @NotNull DeviceFileEntry entry, final @NotNull DownloadProgress progress) {
        if (entry == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(31);
        }
        if (progress == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(32);
        }
        return new FileTransferProgress(){

            @Override
            public void progress(long currentBytes, long totalBytes) {
                progress.onProgress(entry.getFullPath(), currentBytes, totalBytes);
            }

            @Override
            public boolean isCancelled() {
                return progress.isCancelled();
            }
        };
    }

    @NotNull
    private ListenableFuture<List<DeviceFileEntry>> mapPathsToEntries(@NotNull DeviceFileSystem fileSystem, @NotNull List<String> paths) {
        if (fileSystem == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(33);
        }
        if (paths == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(34);
        }
        ArrayList entries = new ArrayList();
        ListenableFuture allDone = this.myTaskExecutor.executeFuturesInSequence(paths.iterator(), path2 -> {
            ListenableFuture<DeviceFileEntry> futureEntry = fileSystem.getEntry((String)path2);
            return this.myTaskExecutor.transform(futureEntry, entry -> {
                entries.add(entry);
                return null;
            });
        });
        ListenableFuture listenableFuture = this.myTaskExecutor.transform(allDone, aVoid -> entries);
        if (listenableFuture == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(35);
        }
        return listenableFuture;
    }

    @NotNull
    private List<String> getAdditionalDevicePaths(@NotNull DeviceFileEntry entry, @NotNull VirtualFile virtualFile) {
        if (entry == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(36);
        }
        if (virtualFile == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(37);
        }
        ArrayList<String> additionalPaths = new ArrayList<String>();
        for (FileHandler fileHandler : (FileHandler[])FileHandler.EP_NAME.getExtensions()) {
            additionalPaths.addAll(fileHandler.getAdditionalDevicePaths(entry.getFullPath(), virtualFile));
        }
        ArrayList<String> arrayList = additionalPaths;
        if (arrayList == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(38);
        }
        return arrayList;
    }

    @NotNull
    private Path getDefaultDownloadPath() {
        Path path2 = this.myDefaultDownloadPath.get();
        if (path2 == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(39);
        }
        return path2;
    }

    @NotNull
    private static Path mapName(String name) {
        Path path2 = Paths.get(PathUtilRt.suggestFileName((String)name, (boolean)true, (boolean)true), new String[0]);
        if (path2 == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(40);
        }
        return path2;
    }

    @NotNull
    private static Path getEntryPath(@NotNull DeviceFileEntry file) {
        if (file == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(41);
        }
        ArrayList<Path> names = new ArrayList<Path>();
        for (DeviceFileEntry entry = file; entry != null; entry = entry.getParent()) {
            names.add(DeviceExplorerFileManagerImpl.mapName(entry.getName()));
        }
        Collections.reverse(names);
        Optional path2 = names.stream().reduce(Path::resolve);
        assert (path2.isPresent());
        Path path3 = (Path)path2.get();
        if (path3 == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(42);
        }
        return path3;
    }

    private static void deleteTemporaryFile(@NotNull Path localPath) {
        if (localPath == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(43);
        }
        try {
            Files.deleteIfExists(localPath);
        }
        catch (IOException e) {
            LOGGER.warn(String.format("Error deleting device file from local file system \"%s\"", localPath), (Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 12: 
            case 21: 
            case 25: 
            case 28: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 42: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 12: 
            case 21: 
            case 25: 
            case 28: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 42: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edtExecutor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskExecutor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloadPathSupplier";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 6: 
            case 8: 
            case 12: 
            case 21: 
            case 25: 
            case 28: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/explorer/DeviceExplorerFileManagerImpl";
                break;
            }
            case 7: 
            case 9: 
            case 15: 
            case 18: 
            case 31: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 10: 
            case 16: 
            case 19: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 11: 
            case 17: 
            case 20: 
            case 24: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 13: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "futureResult";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFile";
                break;
            }
            case 23: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalEntry";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 27: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalPaths";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSystem";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/explorer/DeviceExplorerFileManagerImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLocalPathForDevice";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLocalPathForEntry";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "downloadFileEntry";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "downloadFile";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "downloadAdditionalFiles";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntriesFromCommonParent";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "mapPathsToEntries";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalDevicePaths";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultDownloadPath";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "mapName";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntryPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultLocalPathForDevice";
                break;
            }
            case 6: 
            case 8: 
            case 12: 
            case 21: 
            case 25: 
            case 28: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 42: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultLocalPathForEntry";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "downloadFileEntry";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "deleteVirtualFile";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "downloadFileAndAdditionalFiles";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "downloadFile";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "downloadAdditionalFiles";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getEntriesFromCommonParent";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "haveSameParent";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createFileTransferProgress";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "mapPathsToEntries";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalDevicePaths";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getEntryPath";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "deleteTemporaryFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 12: 
            case 21: 
            case 25: 
            case 28: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 42: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

