/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.experimental.codeanalysis.utils;

import com.android.tools.idea.experimental.codeanalysis.PsiCFGScene;
import com.android.tools.idea.experimental.codeanalysis.callgraph.Callgraph;
import com.android.tools.idea.experimental.codeanalysis.datastructs.PsiCFGClass;
import com.android.tools.idea.experimental.codeanalysis.datastructs.PsiCFGMethod;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.BlockGraph;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.MethodGraph;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.impl.MethodGraphImpl;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.node.BlockGraphEntryNode;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.node.BlockGraphExitNode;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.node.ConditionCheckNode;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.node.GraphNode;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.node.IfBranchingNode;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.node.LoopBranchingNode;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.node.impl.ConditionFalseNode;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.node.impl.ConditionTrueNode;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.node.impl.DummyNodeImpl;
import com.android.tools.idea.experimental.codeanalysis.datastructs.value.impl.ParamImpl;
import com.android.tools.idea.experimental.codeanalysis.utils.CFGBuilder;
import com.android.tools.idea.experimental.codeanalysis.utils.PsiCFGDebugUtil;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.intellij.openapi.application.PathManager;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CFGUtil {
    public static final String NODE_TYPE_GRAPHNODE = "GraphNode";
    public static final String NODE_TYPE_BLOCKENTRY = "BlockGraphEntryNode";
    public static final String NODE_TYPE_BLOCKEXIT = "BlockGraphExitNode";
    public static final String NODE_TYPE_CONDITION_CHECK_NODE = "ConditionCheckNode";
    public static final String NODE_TYPE_CONDITION_TRUE_NODE = "ConditionTrueNode";
    public static final String NODE_TYPE_CONDITION_FALSE_NODE = "ConditionFalseNode";
    public static final String NODE_TYPE_UNREACHABLE_ENTRY_NODE = "UnreachableEntryNode";
    public static final String NODE_TYPE_IF_BRANCHING_NODE = "IfBranchingNode";
    public static final String NODE_TYPE_LOOP_BRANCHING_NODE = "LoopBranchingNode";
    private static int nodeCounter = 0;

    public static MethodGraph constructControlFlowGraphFromCodeBlock(@NotNull PsiCodeBlock cb) {
        if (cb == null) {
            CFGUtil.$$$reportNull$$$0(0);
        }
        MethodGraph cfg = null;
        return cfg;
    }

    public static MethodGraph constructMethodGraph(@NotNull PsiCFGScene scene, @NotNull PsiCodeBlock psiCodeBlock, @NotNull PsiCFGMethod cfgMethod) {
        if (scene == null) {
            CFGUtil.$$$reportNull$$$0(1);
        }
        if (psiCodeBlock == null) {
            CFGUtil.$$$reportNull$$$0(2);
        }
        if (cfgMethod == null) {
            CFGUtil.$$$reportNull$$$0(3);
        }
        PsiMethod psiMethodRef = cfgMethod.getMethodRef();
        PsiParameterList pl = psiMethodRef.getParameterList();
        MethodGraphImpl retGraph = new MethodGraphImpl(cfgMethod);
        CFGUtil.processParameters(scene, pl, retGraph);
        CFGBuilder builder2 = new CFGBuilder(scene, (BlockGraph)retGraph, cfgMethod.getDeclaringClass(), psiCodeBlock);
        builder2.build();
        return retGraph;
    }

    public static MethodGraph constructMethodGraphForLambda(@NotNull PsiCFGScene scene, @NotNull PsiCFGMethod lambdaMethod) {
        if (scene == null) {
            CFGUtil.$$$reportNull$$$0(4);
        }
        if (lambdaMethod == null) {
            CFGUtil.$$$reportNull$$$0(5);
        }
        PsiElement lambdaBody = lambdaMethod.getBody();
        MethodGraphImpl lambdaGraph = new MethodGraphImpl(lambdaMethod);
        PsiLambdaExpression lambdaPsiRef = lambdaMethod.getLambdaRef();
        if (lambdaPsiRef == null) {
            PsiCFGDebugUtil.LOG.warning("Method: " + lambdaMethod + " is not recognized as a lambda");
            return null;
        }
        CFGUtil.processLambdaParameters(scene, lambdaPsiRef.getParameterList(), lambdaGraph);
        CFGBuilder builder2 = null;
        if (lambdaBody instanceof PsiCodeBlock) {
            builder2 = new CFGBuilder(scene, (BlockGraph)lambdaGraph, lambdaMethod.getDeclaringClass(), (PsiCodeBlock)lambdaBody);
            builder2.setLambdaFlag();
        } else if (lambdaBody instanceof PsiExpression) {
            builder2 = new CFGBuilder(scene, (BlockGraph)lambdaGraph, lambdaMethod.getDeclaringClass(), (PsiExpression)lambdaBody);
            builder2.setLambdaFlag();
        } else {
            PsiCFGDebugUtil.LOG.warning("Method: " + lambdaPsiRef.getText() + " has unknown body of type " + (lambdaBody == null ? "null" : lambdaBody.getClass().getName()));
            return null;
        }
        builder2.build();
        lambdaMethod.setControlFlowGraph(lambdaGraph);
        return lambdaGraph;
    }

    private static void processLambdaParameters(@NotNull PsiCFGScene scene, @NotNull PsiParameterList pl, @NotNull MethodGraphImpl lambdaGraph) {
        if (scene == null) {
            CFGUtil.$$$reportNull$$$0(6);
        }
        if (pl == null) {
            CFGUtil.$$$reportNull$$$0(7);
        }
        if (lambdaGraph == null) {
            CFGUtil.$$$reportNull$$$0(8);
        }
        if (pl.getParametersCount() != 0) {
            PsiParameter[] allParams;
            for (PsiParameter curPsiParam : allParams = pl.getParameters()) {
                if (curPsiParam == null) {
                    PsiCFGDebugUtil.LOG.warning("null found in param in " + lambdaGraph.getPsiCFGMethod().getLambdaRef().getText());
                    continue;
                }
                ParamImpl curParamImpl = new ParamImpl(curPsiParam);
                lambdaGraph.addParam(curPsiParam, curParamImpl);
            }
        }
    }

    private static void processParameters(@NotNull PsiCFGScene scene, @NotNull PsiParameterList pl, @NotNull MethodGraphImpl retGraph) {
        if (scene == null) {
            CFGUtil.$$$reportNull$$$0(9);
        }
        if (pl == null) {
            CFGUtil.$$$reportNull$$$0(10);
        }
        if (retGraph == null) {
            CFGUtil.$$$reportNull$$$0(11);
        }
        PsiMethod psiMethodRef = retGraph.getPsiCFGMethod().getMethodRef();
        if (pl == null) {
            PsiCFGDebugUtil.LOG.info("ParamList is null in this method " + psiMethodRef.getName());
        }
        if (pl.getParametersCount() != 0) {
            PsiParameter[] allParams;
            for (PsiParameter curPsiParam : allParams = pl.getParameters()) {
                if (curPsiParam == null) {
                    PsiCFGDebugUtil.LOG.warning("PsiParam in method " + psiMethodRef.getName() + " is null");
                    continue;
                }
                ParamImpl curParamImpl = new ParamImpl(curPsiParam);
                retGraph.addParam(curPsiParam, curParamImpl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void outputCallGraphDotFile(Callgraph cg) {
        String path2 = PathManager.getLogPath();
        String fileName = "CallGraph.dot";
        BufferedWriter bw = null;
        try {
            File dotFile = new File(path2, fileName);
            if (dotFile.exists()) {
                dotFile.delete();
            }
            dotFile.createNewFile();
            PsiCFGDebugUtil.LOG.info("Log Callgraph to file: " + dotFile.getAbsolutePath());
            FileWriter fw = new FileWriter(dotFile);
            bw = new BufferedWriter(fw);
            Map<PsiCFGMethod, Integer> allNodes = CFGUtil.getAllMethodNodesFromCallGraph(cg);
            bw.write("digraph G{\n");
            for (PsiCFGMethod method : allNodes.keySet()) {
                String label = method.getName();
                String line = String.format(Locale.US, "n%d[label=\"%s\"];\n", allNodes.get(method), label);
                bw.write(line);
            }
            bw.write("\n");
            for (PsiCFGMethod curMethod : cg.callerMethodToCalleeMethodMap.keySet()) {
                Integer sId = allNodes.get(curMethod);
                for (PsiCFGMethod tgtMethod : cg.callerMethodToCalleeMethodMap.get((Object)curMethod)) {
                    Integer tId = allNodes.get(tgtMethod);
                    String line = String.format(Locale.US, "n%d -> n%d;\n", sId, tId);
                    bw.write(line);
                }
            }
            bw.write("\n");
            bw.write("}");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static Map<PsiCFGMethod, Integer> getAllMethodNodesFromCallGraph(Callgraph cg) {
        HashMap retMap = Maps.newHashMap();
        Set<PsiCFGMethod> allMethods = cg.allMethodsInGraph;
        int i2 = 0;
        for (PsiCFGMethod curMethod : allMethods) {
            retMap.put(curMethod, i2);
            ++i2;
        }
        return retMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void outputCFGDotFile(MethodGraph graph) {
        String path2 = PathManager.getLogPath();
        String methodName = graph.getPsiCFGMethod().getName();
        String className = "dummyClass";
        PsiCFGClass cfgClass = graph.getPsiCFGMethod().getDeclaringClass();
        className = cfgClass.getQualifiedClassName().replace(".", "-");
        String fileName = className + "-" + methodName + ".dot";
        BufferedWriter bw = null;
        try {
            File dotFile = new File(path2, fileName);
            if (dotFile.exists()) {
                dotFile.delete();
            }
            dotFile.createNewFile();
            PsiCFGDebugUtil.LOG.info("Log CFG to file: " + dotFile.getAbsolutePath());
            FileWriter fw = new FileWriter(dotFile);
            bw = new BufferedWriter(fw);
            Map<GraphNode, Integer> allNodes = CFGUtil.getAllNodeFromGraph(graph);
            bw.write("digraph G {\n");
            for (GraphNode node : allNodes.keySet()) {
                String label = CFGUtil.getLabelFromGraphNode(node);
                String line = String.format(Locale.US, "n%d[label=\"%s\"];\n", allNodes.get(node), label);
                bw.write(line);
            }
            bw.write("\n");
            CFGUtil.bfsOutputEdges(bw, graph.getEntryNode(), allNodes);
            bw.write("}");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static Map<GraphNode, Integer> getAllNodeFromGraph(MethodGraph graph) {
        HashMap retMap = Maps.newHashMap();
        retMap.put(graph.getEntryNode(), 0);
        retMap.put(graph.getExitNode(), 1);
        nodeCounter = 2;
        for (GraphNode initNode : graph.getEntryNode().getOut()) {
            CFGUtil.dfsGetAllNodes(retMap, initNode);
        }
        return retMap;
    }

    private static void dfsGetAllNodes(Map<GraphNode, Integer> retMap, GraphNode curNode) {
        if (retMap.containsKey(curNode)) {
            return;
        }
        retMap.put(curNode, nodeCounter);
        ++nodeCounter;
        for (GraphNode nextNode : curNode.getOut()) {
            CFGUtil.dfsGetAllNodes(retMap, nextNode);
        }
    }

    private static void bfsOutputEdges(BufferedWriter bw, GraphNode entry, Map<GraphNode, Integer> NodeMap) throws IOException {
        HashSet<GraphNode> vistedNode = new HashSet<GraphNode>();
        ArrayDeque workList = Queues.newArrayDeque();
        workList.add(entry);
        while (!workList.isEmpty()) {
            GraphNode[] outEdges;
            GraphNode node = (GraphNode)workList.removeFirst();
            if (vistedNode.contains(node)) continue;
            vistedNode.add(node);
            Integer srcID = NodeMap.get(node);
            for (GraphNode outNode : outEdges = node.getOut()) {
                Integer tgtID = NodeMap.get(outNode);
                String line = String.format(Locale.US, "n%d -> n%d;\n", srcID, tgtID);
                bw.write(line);
                if (vistedNode.contains(outNode)) continue;
                workList.addLast(outNode);
            }
        }
    }

    public static String getLabelFromGraphNode(GraphNode node) {
        String nodeType = NODE_TYPE_GRAPHNODE;
        if (node instanceof BlockGraphEntryNode) {
            nodeType = NODE_TYPE_BLOCKENTRY;
        } else if (node instanceof BlockGraphExitNode) {
            nodeType = NODE_TYPE_BLOCKEXIT;
        } else if (node instanceof IfBranchingNode) {
            nodeType = NODE_TYPE_IF_BRANCHING_NODE;
        } else if (node instanceof ConditionCheckNode) {
            nodeType = NODE_TYPE_CONDITION_CHECK_NODE;
        } else if (node instanceof ConditionTrueNode) {
            nodeType = NODE_TYPE_CONDITION_TRUE_NODE;
        } else if (node instanceof ConditionFalseNode) {
            nodeType = NODE_TYPE_CONDITION_FALSE_NODE;
        } else if (node instanceof DummyNodeImpl) {
            nodeType = NODE_TYPE_UNREACHABLE_ENTRY_NODE;
        } else if (node instanceof LoopBranchingNode) {
            nodeType = NODE_TYPE_LOOP_BRANCHING_NODE;
        }
        String stmtString = node.getSimpleName();
        return nodeType + "\\n" + stmtString;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cb";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scene";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiCodeBlock";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cfgMethod";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lambdaMethod";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lambdaGraph";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "retGraph";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/experimental/codeanalysis/utils/CFGUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "constructControlFlowGraphFromCodeBlock";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "constructMethodGraph";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "constructMethodGraphForLambda";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "processLambdaParameters";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "processParameters";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

