/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.datamodels;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.resources.ResourceType;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.annotations.NotNull;

public class ThemeEditorStyle {
    private static final Logger LOG = Logger.getInstance(ThemeEditorStyle.class);
    @NotNull
    private final ConfigurationManager myManager;
    @NotNull
    private final ResourceReference myStyleReference;

    public ThemeEditorStyle(@NotNull ConfigurationManager manager, @NotNull ResourceReference styleReference) {
        if (manager == null) {
            ThemeEditorStyle.$$$reportNull$$$0(0);
        }
        if (styleReference == null) {
            ThemeEditorStyle.$$$reportNull$$$0(1);
        }
        this.myManager = manager;
        this.myStyleReference = styleReference;
    }

    @NotNull
    public final ResourceReference getStyleReference() {
        ResourceReference resourceReference = this.myStyleReference;
        if (resourceReference == null) {
            ThemeEditorStyle.$$$reportNull$$$0(2);
        }
        return resourceReference;
    }

    @NotNull
    public String getQualifiedName() {
        ResourceRepositoryManager repositoryManager = ResourceRepositoryManager.getInstance(this.myManager.getModule());
        if (repositoryManager == null || repositoryManager.getNamespace().equals((Object)this.myStyleReference.getNamespace())) {
            String string = this.myStyleReference.getName();
            if (string == null) {
                ThemeEditorStyle.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = this.myStyleReference.getQualifiedName();
        if (string == null) {
            ThemeEditorStyle.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.myStyleReference.getName();
        if (string == null) {
            ThemeEditorStyle.$$$reportNull$$$0(5);
        }
        return string;
    }

    public boolean isFramework() {
        return this.myStyleReference.getNamespace().equals((Object)ResourceNamespace.ANDROID);
    }

    public boolean isProjectStyle() {
        if (this.isFramework()) {
            return false;
        }
        ResourceRepositoryManager repositoryManager = ResourceRepositoryManager.getInstance(this.myManager.getModule());
        assert (repositoryManager != null);
        LocalResourceRepository repository = repositoryManager.getProjectResources();
        return repository.hasResources(this.myStyleReference.getNamespace(), this.myStyleReference.getResourceType(), this.myStyleReference.getName());
    }

    public boolean isPublic() {
        if (!this.isFramework()) {
            return true;
        }
        IAndroidTarget target = this.myManager.getTarget();
        if (target == null) {
            LOG.error("Unable to get IAndroidTarget.");
            return false;
        }
        AndroidTargetData androidTargetData = AndroidTargetData.getTargetData(target, this.myManager.getModule());
        if (androidTargetData == null) {
            LOG.error("Unable to get AndroidTargetData.");
            return false;
        }
        return androidTargetData.isResourcePublic(ResourceType.STYLE.getName(), this.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styleReference";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyleReference";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

