/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.SdkConstants;
import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.Configurable;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredThemeEditorStyle;
import com.android.tools.idea.lint.common.LintIdeClient;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.lint.checks.ApiLookup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ResolutionUtils {
    private static final Logger LOG = Logger.getInstance(ResolutionUtils.class);

    private ResolutionUtils() {
    }

    @NotNull
    public static String getStyleResourceUrl(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            ResolutionUtils.$$$reportNull$$$0(0);
        }
        String string = ResolutionUtils.getResourceUrlFromQualifiedName(qualifiedName, "style");
        if (string == null) {
            ResolutionUtils.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static String getResourceUrlFromQualifiedName(@NotNull String qualifiedName, @NotNull String type) {
        if (qualifiedName == null) {
            ResolutionUtils.$$$reportNull$$$0(2);
        }
        if (type == null) {
            ResolutionUtils.$$$reportNull$$$0(3);
        }
        String startChar = "attr".equals(type) ? "?" : "@";
        int colonIndex = qualifiedName.indexOf(58);
        if (colonIndex != -1) {
            String namespace = qualifiedName.substring(0, colonIndex + 1);
            String themeNameWithoutNamespace = StringUtil.trimStart((String)qualifiedName, (String)namespace);
            return startChar + namespace + type + "/" + themeNameWithoutNamespace;
        }
        return startChar + type + "/" + qualifiedName;
    }

    @Deprecated
    @NotNull
    public static ResourceReference getStyleReference(@NotNull String themeName) {
        if (themeName == null) {
            ResolutionUtils.$$$reportNull$$$0(4);
        }
        if (themeName.startsWith("android:")) {
            ResourceReference resourceReference = ResourceReference.style((ResourceNamespace)ResourceNamespace.ANDROID, (String)themeName.substring("android:".length()));
            if (resourceReference == null) {
                ResolutionUtils.$$$reportNull$$$0(5);
            }
            return resourceReference;
        }
        assert (themeName.indexOf(58) < 0);
        ResourceReference resourceReference = ResourceReference.style((ResourceNamespace)ResourceNamespace.TODO(), (String)themeName);
        if (resourceReference == null) {
            ResolutionUtils.$$$reportNull$$$0(6);
        }
        return resourceReference;
    }

    @NotNull
    public static String getQualifiedNameFromResourceUrl(@NotNull String styleResourceUrl) {
        if (styleResourceUrl == null) {
            ResolutionUtils.$$$reportNull$$$0(7);
        }
        ResourceUrl url = ResourceUrl.parse((String)styleResourceUrl);
        assert (url != null) : styleResourceUrl;
        Object object = url.namespace != null ? url.namespace + ":" + url.name : url.name;
        if (object == null) {
            ResolutionUtils.$$$reportNull$$$0(8);
        }
        return object;
    }

    @NotNull
    public static String getNameFromQualifiedName(@NotNull String qualifiedName) {
        int colonIndex;
        if (qualifiedName == null) {
            ResolutionUtils.$$$reportNull$$$0(9);
        }
        String string = (colonIndex = qualifiedName.indexOf(58)) != -1 ? qualifiedName.substring(colonIndex + 1) : qualifiedName;
        if (string == null) {
            ResolutionUtils.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public static String getQualifiedStyleName(@NotNull StyleResourceValue style) {
        if (style == null) {
            ResolutionUtils.$$$reportNull$$$0(11);
        }
        String name = style.getName();
        Object object = style.isFramework() ? "android:" + name : name;
        if (object == null) {
            ResolutionUtils.$$$reportNull$$$0(12);
        }
        return object;
    }

    @NotNull
    public static String getQualifiedItemAttrName(@NotNull StyleItemResourceValue item) {
        ResourceReference attr;
        if (item == null) {
            ResolutionUtils.$$$reportNull$$$0(13);
        }
        String string = (attr = item.getAttr()) != null ? attr.getRelativeResourceUrl(ResourceNamespace.TODO()).getQualifiedName() : item.getAttrName();
        if (string == null) {
            ResolutionUtils.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Nullable
    public static ConfiguredThemeEditorStyle getThemeEditorStyle(@NotNull Configuration configuration, @NotNull ResourceReference styleReference) {
        if (configuration == null) {
            ResolutionUtils.$$$reportNull$$$0(15);
        }
        if (styleReference == null) {
            ResolutionUtils.$$$reportNull$$$0(16);
        }
        ResourceResolver resolver = configuration.getResourceResolver();
        assert (resolver != null);
        StyleResourceValue style = resolver.getStyle(styleReference);
        return style == null ? null : new ConfiguredThemeEditorStyle(configuration, style);
    }

    @Nullable
    public static AttributeDefinition getAttributeDefinition(@NotNull Configuration configuration, @NotNull StyleItemResourceValue itemResValue) {
        ResourceReference attr;
        if (configuration == null) {
            ResolutionUtils.$$$reportNull$$$0(17);
        }
        if (itemResValue == null) {
            ResolutionUtils.$$$reportNull$$$0(18);
        }
        return (attr = itemResValue.getAttr()) == null ? null : ResolutionUtils.getAttributeDefinition(configuration.getModule(), attr);
    }

    @Nullable
    public static AttributeDefinition getAttributeDefinition(@NotNull Module module, @NotNull ResourceReference attr) {
        if (module == null) {
            ResolutionUtils.$$$reportNull$$$0(19);
        }
        if (attr == null) {
            ResolutionUtils.$$$reportNull$$$0(20);
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module);
        assert (facet2 != null) : String.format("Module %s is not an Android module", module.getName());
        AttributeDefinitions definitions = ModuleResourceManagers.getInstance(facet2).getLocalResourceManager().getAttributeDefinitions();
        return definitions.getAttrDefinition(attr);
    }

    @Deprecated
    @Nullable
    public static AttributeDefinition getAttributeDefinition(@NotNull Module module, @Nullable Configuration configuration, @NotNull String name) {
        AttributeDefinitions definitions;
        if (module == null) {
            ResolutionUtils.$$$reportNull$$$0(21);
        }
        if (name == null) {
            ResolutionUtils.$$$reportNull$$$0(22);
        }
        if (name.startsWith("android:")) {
            IAndroidTarget target;
            if (configuration == null) {
                AndroidFacet facet2 = AndroidFacet.getInstance((Module)module);
                assert (facet2 != null);
                target = ConfigurationManager.getOrCreateInstance(module).getDefaultTarget();
            } else {
                target = configuration.getRealTarget();
            }
            assert (target != null);
            AndroidTargetData androidTargetData = AndroidTargetData.getTargetData(target, module);
            assert (androidTargetData != null);
            definitions = androidTargetData.getAllAttrDefs(module.getProject());
        } else {
            AndroidFacet facet3 = AndroidFacet.getInstance((Module)module);
            assert (facet3 != null) : String.format("Module %s is not an Android module", module.getName());
            definitions = ModuleResourceManagers.getInstance(facet3).getLocalResourceManager().getAttributeDefinitions();
        }
        if (definitions == null) {
            return null;
        }
        return definitions.getAttrDefByName(ResolutionUtils.getNameFromQualifiedName(name));
    }

    public static int getOriginalApiLevel(@Nullable String name, @NotNull Project project) {
        if (project == null) {
            ResolutionUtils.$$$reportNull$$$0(23);
        }
        if (name == null) {
            return -1;
        }
        ApiLookup apiLookup = LintIdeClient.getApiLookup((Project)project);
        if (apiLookup == null) {
            LOG.warn("Could not find Lint client for project " + project.getName());
            return -1;
        }
        ResourceUrl resUrl = ResourceUrl.parse((String)name);
        if (resUrl == null) {
            if (!name.startsWith("android:")) {
                return -1;
            }
            return apiLookup.getFieldVersion("android/R$attr", name.substring(SdkConstants.ANDROID_NS_NAME_PREFIX_LEN));
        }
        if (!resUrl.isFramework()) {
            return -1;
        }
        return apiLookup.getFieldVersion("android/R$" + resUrl.type, AndroidResourceUtil.getFieldNameByResourceName(resUrl.name));
    }

    @Nullable
    public static String getParentQualifiedName(@NotNull StyleResourceValue style) {
        ResourceReference parent;
        if (style == null) {
            ResolutionUtils.$$$reportNull$$$0(24);
        }
        if ((parent = style.getParentStyle()) == null) {
            return null;
        }
        return parent.getRelativeResourceUrl(ResourceNamespace.TODO()).getQualifiedName();
    }

    @NotNull
    public static Collection<StyleItemResourceValue> getThemeAttributes(@NotNull ResourceResolver resolver, @NotNull String themeUrl) {
        StyleResourceValue theme;
        if (resolver == null) {
            ResolutionUtils.$$$reportNull$$$0(25);
        }
        if (themeUrl == null) {
            ResolutionUtils.$$$reportNull$$$0(26);
        }
        HashMap<String, StyleItemResourceValue> allItems = new HashMap<String, StyleItemResourceValue>();
        String themeName = ResolutionUtils.getQualifiedNameFromResourceUrl(themeUrl);
        while ((theme = resolver.getStyle(ResolutionUtils.getNameFromQualifiedName(themeName), themeName.startsWith("android:"))) != null) {
            Collection themeItems = theme.getDefinedItems();
            for (StyleItemResourceValue item : themeItems) {
                String itemName = ResolutionUtils.getQualifiedItemAttrName(item);
                if (allItems.containsKey(itemName)) continue;
                allItems.put(itemName, item);
            }
            themeName = ResolutionUtils.getParentQualifiedName(theme);
            if (themeName != null) continue;
        }
        Collection<StyleItemResourceValue> collection2 = allItems.values();
        if (collection2 == null) {
            ResolutionUtils.$$$reportNull$$$0(27);
        }
        return collection2;
    }

    @Nullable
    public static ResourceType getAttrType(@NotNull StyleItemResourceValue item, @NotNull Configuration configuration) {
        if (item == null) {
            ResolutionUtils.$$$reportNull$$$0(28);
        }
        if (configuration == null) {
            ResolutionUtils.$$$reportNull$$$0(29);
        }
        ResourceResolver resolver = configuration.getResourceResolver();
        assert (resolver != null);
        ResourceValue resolvedValue = resolver.resolveResValue((ResourceValue)item);
        ResourceType attrType = resolvedValue.getResourceType();
        if (attrType != null) {
            return attrType;
        }
        AttributeDefinition def = ResolutionUtils.getAttributeDefinition(configuration, item);
        if (def != null) {
            for (AttributeFormat attrFormat : def.getFormats()) {
                attrType = AndroidDomUtil.getResourceType(attrFormat);
                if (attrType == null) continue;
                return attrType;
            }
        }
        return null;
    }

    @NotNull
    public static FolderConfiguration getFolderConfiguration(@NotNull AndroidFacet facet2, @NotNull ResourceValue resolvedValue, @NotNull FolderConfiguration configuration) {
        List configurables2;
        if (facet2 == null) {
            ResolutionUtils.$$$reportNull$$$0(30);
        }
        if (resolvedValue == null) {
            ResolutionUtils.$$$reportNull$$$0(31);
        }
        if (configuration == null) {
            ResolutionUtils.$$$reportNull$$$0(32);
        }
        if (resolvedValue.isFramework()) {
            ConfigurationManager configurationManager = ConfigurationManager.getOrCreateInstance(facet2.getModule());
            IAndroidTarget target = configurationManager.getDefaultTarget();
            assert (target != null);
            ResourceRepository resourceRepository = configurationManager.getResolverCache().getFrameworkResources(configuration, target);
            assert (resourceRepository != null);
            configurables2 = resourceRepository.getResources(ResourceNamespace.ANDROID, resolvedValue.getResourceType(), resolvedValue.getName());
        } else {
            LocalResourceRepository LocalResourceRepository2 = ResourceRepositoryManager.getAppResources(facet2);
            configurables2 = LocalResourceRepository2.getResources(ResourceNamespace.TODO(), resolvedValue.getResourceType(), resolvedValue.getName());
        }
        Configurable configurable = configuration.findMatchingConfigurable(configurables2);
        assert (configurable != null);
        FolderConfiguration folderConfiguration = configurable.getConfiguration();
        if (folderConfiguration == null) {
            ResolutionUtils.$$$reportNull$$$0(33);
        }
        return folderConfiguration;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 27: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 27: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 27: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/theme/ResolutionUtils";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "themeName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styleResourceUrl";
                break;
            }
            case 11: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "style";
                break;
            }
            case 13: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 15: 
            case 17: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styleReference";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemResValue";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attr";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "themeUrl";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/theme/ResolutionUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyleResourceUrl";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyleReference";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedNameFromResourceUrl";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameFromQualifiedName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedStyleName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedItemAttrName";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getThemeAttributes";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getFolderConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStyleResourceUrl";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 27: 
            case 33: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getResourceUrlFromQualifiedName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getStyleReference";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedNameFromResourceUrl";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getNameFromQualifiedName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedStyleName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedItemAttrName";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getThemeEditorStyle";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeDefinition";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalApiLevel";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getParentQualifiedName";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getThemeAttributes";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getAttrType";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getFolderConfiguration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 27: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

