/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.tools.idea.editors.strings.StringResourceRepository;
import com.android.tools.idea.editors.strings.StringResourceViewPanel;
import com.android.tools.idea.editors.strings.table.StringResourceTableModel;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ResourceLoadingTask
extends Task.Backgroundable {
    @NotNull
    private final StringResourceViewPanel myPanel;
    @NotNull
    private final Supplier<? extends LocalResourceRepository> myGetModuleResources;
    @Nullable
    private StringResourceRepository myRepository;

    ResourceLoadingTask(@NotNull StringResourceViewPanel panel2) {
        if (panel2 == null) {
            ResourceLoadingTask.$$$reportNull$$$0(0);
        }
        this(panel2, () -> ResourceRepositoryManager.getModuleResources(panel2.getFacet()));
    }

    @VisibleForTesting
    ResourceLoadingTask(@NotNull StringResourceViewPanel panel2, @NotNull Supplier<? extends LocalResourceRepository> getModuleResources) {
        if (panel2 == null) {
            ResourceLoadingTask.$$$reportNull$$$0(1);
        }
        if (getModuleResources == null) {
            ResourceLoadingTask.$$$reportNull$$$0(2);
        }
        super(panel2.getFacet().getModule().getProject(), "Loading String Resources...");
        this.myPanel = panel2;
        this.myGetModuleResources = getModuleResources;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            ResourceLoadingTask.$$$reportNull$$$0(3);
        }
        indicator.setIndeterminate(true);
        this.myRepository = StringResourceRepository.create(this.myGetModuleResources.get());
    }

    public void onSuccess() {
        assert (this.myRepository != null);
        this.myPanel.getTable().setModel(new StringResourceTableModel(this.myRepository, this.myPanel.getFacet().getModule().getProject()));
        this.myPanel.getLoadingPanel().stopLoading();
    }

    public void onCancel() {
        this.myPanel.getLoadingPanel().stopLoading();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getModuleResources";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/editors/strings/ResourceLoadingTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

