/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.tools.idea.editors.strings.StringResourceKey;
import com.android.tools.idea.editors.strings.StringResourceRepository;
import com.android.tools.idea.editors.strings.StringResourceViewPanel;
import com.android.tools.idea.editors.strings.table.StringResourceTable;
import com.android.tools.idea.editors.strings.table.StringResourceTableModel;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.DeleteHandler;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.safeDelete.SafeDeleteDialog;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.Arrays;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;

final class RemoveKeysAction
extends AnAction {
    private final StringResourceViewPanel myPanel;

    RemoveKeysAction(@NotNull StringResourceViewPanel panel2) {
        if (panel2 == null) {
            RemoveKeysAction.$$$reportNull$$$0(0);
        }
        super("Remove Keys", null, AllIcons.General.Remove);
        this.myPanel = panel2;
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            RemoveKeysAction.$$$reportNull$$$0(1);
        }
        event.getPresentation().setEnabled(this.myPanel.getTable().getSelectedRowCount() != 0);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            RemoveKeysAction.$$$reportNull$$$0(2);
        }
        this.perform();
    }

    void perform() {
        StringResourceTable table2 = this.myPanel.getTable();
        StringResourceTableModel model2 = (StringResourceTableModel)table2.getModel();
        StringResourceRepository repository = model2.getRepository();
        Project project = this.myPanel.getFacet().getModule().getProject();
        PsiElement[] keys = (PsiElement[])Arrays.stream(table2.getSelectedModelRowIndices()).mapToObj(index -> model2.getStringResourceAt(index).getKey()).flatMap(key -> repository.getItems((StringResourceKey)key).stream()).map(item -> AndroidResourceUtil.getItemTag(project, item)).toArray(PsiElement[]::new);
        if (keys.length == 0) {
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)project, Arrays.asList(keys), (boolean)true)) {
            return;
        }
        if (DumbService.getInstance((Project)project).isDumb()) {
            DeleteHandler.deletePsiElement((PsiElement[])keys, (Project)project);
            this.myPanel.reloadData();
            return;
        }
        SafeDeleteDialogCallback callback2 = new SafeDeleteDialogCallback();
        MySafeDeleteDialog dialog2 = new MySafeDeleteDialog(project, keys, callback2);
        if (!dialog2.showAndGet()) {
            return;
        }
        if (callback2.mySafeDeleteCheckBoxSelected) {
            SafeDeleteProcessor.createInstance((Project)project, () -> this.myPanel.reloadData(), (PsiElement[])keys, (boolean)dialog2.isSearchInComments(), (boolean)dialog2.isSearchForTextOccurences(), (boolean)true).run();
        } else {
            DeleteHandler.deletePsiElement((PsiElement[])keys, (Project)project, (boolean)false);
            this.myPanel.reloadData();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/editors/strings/RemoveKeysAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class SafeDeleteDialogCallback
    implements SafeDeleteDialog.Callback {
        private boolean mySafeDeleteCheckBoxSelected;

        private SafeDeleteDialogCallback() {
        }

        public void run(@NotNull SafeDeleteDialog dialog2) {
            if (dialog2 == null) {
                SafeDeleteDialogCallback.$$$reportNull$$$0(0);
            }
            this.mySafeDeleteCheckBoxSelected = true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialog", "com/android/tools/idea/editors/strings/RemoveKeysAction$SafeDeleteDialogCallback", "run"));
        }
    }

    private static final class MySafeDeleteDialog
    extends SafeDeleteDialog {
        private MySafeDeleteDialog(@NotNull Project project, @NotNull PsiElement[] keys, @NotNull SafeDeleteDialog.Callback callback2) {
            if (project == null) {
                MySafeDeleteDialog.$$$reportNull$$$0(0);
            }
            if (keys == null) {
                MySafeDeleteDialog.$$$reportNull$$$0(1);
            }
            if (callback2 == null) {
                MySafeDeleteDialog.$$$reportNull$$$0(2);
            }
            super(project, keys, callback2);
            this.setTitle(RefactoringBundle.message((String)"delete.title"));
        }

        protected boolean isDelete() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "keys";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "callback";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/editors/strings/RemoveKeysAction$MySafeDeleteDialog";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

