/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.manifest;

import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.manifmerger.Actions;
import com.android.manifmerger.IntentFilterNodeKeyResolver;
import com.android.manifmerger.XmlNode;
import com.android.tools.idea.editors.manifest.ManifestPanel;
import com.android.tools.idea.model.MergedManifestManager;
import com.android.tools.idea.model.MergedManifestSnapshot;
import com.android.tools.idea.projectsystem.NamedIdeaSourceProvider;
import com.android.tools.lint.detector.api.Lint;
import com.android.utils.PositionXmlParser;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.facet.IdeaSourceProviderUtil;
import org.jetbrains.android.facet.SourceProviderManager;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class ManifestUtils {
    private ManifestUtils() {
    }

    @Nullable
    public static SourceFilePosition getSourceFilePosition(@NotNull Module module, @NotNull String activityName) {
        MergedManifestSnapshot mergedManifestManager;
        Element item;
        if (module == null) {
            ManifestUtils.$$$reportNull$$$0(0);
        }
        if (activityName == null) {
            ManifestUtils.$$$reportNull$$$0(1);
        }
        if ((item = (mergedManifestManager = MergedManifestManager.getSnapshot(module)).findActivity(activityName)) == null) {
            return null;
        }
        List<? extends Actions.Record> records = ManifestUtils.getRecords(mergedManifestManager, item);
        if (records.isEmpty()) {
            return null;
        }
        return ManifestUtils.getActionLocation(module, records.get(0));
    }

    @NotNull
    public static List<? extends Actions.Record> getRecords(@NotNull MergedManifestSnapshot manifest, @NotNull Node node) {
        Actions actions2;
        if (manifest == null) {
            ManifestUtils.$$$reportNull$$$0(2);
        }
        if (node == null) {
            ManifestUtils.$$$reportNull$$$0(3);
        }
        if ((actions2 = manifest.getActions()) != null) {
            Attr attribute;
            XmlNode.NodeName nodeName;
            ImmutableList attributeRecords;
            XmlNode.NodeKey parentKey;
            Element parentElement;
            Element element;
            if (node instanceof Element) {
                element = (Element)node;
            } else if (node instanceof Attr) {
                Attr attribute2 = (Attr)node;
                element = attribute2.getOwnerElement();
            } else {
                List list = Collections.emptyList();
                if (list == null) {
                    ManifestUtils.$$$reportNull$$$0(4);
                }
                return list;
            }
            Node parentNode = element.getParentNode();
            if (parentNode instanceof Element && "intent-filter".equals((parentElement = (Element)parentNode).getTagName()) && (parentKey = ManifestUtils.getNodeKey(manifest, parentElement)) != null) {
                ImmutableList immutableList = actions2.getNodeRecords(parentKey);
                if (immutableList == null) {
                    ManifestUtils.$$$reportNull$$$0(5);
                }
                return immutableList;
            }
            XmlNode.NodeKey key = ManifestUtils.getNodeKey(manifest, element);
            if (key == null) {
                List list = Collections.emptyList();
                if (list == null) {
                    ManifestUtils.$$$reportNull$$$0(6);
                }
                return list;
            }
            if (node instanceof Attr && !(attributeRecords = actions2.getAttributeRecords(key, nodeName = XmlNode.fromXmlName((String)(attribute = (Attr)node).getName()))).isEmpty()) {
                ImmutableList immutableList = attributeRecords;
                if (immutableList == null) {
                    ManifestUtils.$$$reportNull$$$0(7);
                }
                return immutableList;
            }
            ImmutableList immutableList = actions2.getNodeRecords(key);
            if (immutableList == null) {
                ManifestUtils.$$$reportNull$$$0(8);
            }
            return immutableList;
        }
        List list = Collections.emptyList();
        if (list == null) {
            ManifestUtils.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Nullable
    static XmlNode.NodeKey getNodeKey(@NotNull MergedManifestSnapshot manifest, @NotNull Element element) {
        Object key;
        if (manifest == null) {
            ManifestUtils.$$$reportNull$$$0(10);
        }
        if (element == null) {
            ManifestUtils.$$$reportNull$$$0(11);
        }
        if ((key = manifest.getNodeKey(element.getNodeName())) == null) {
            Attr glEsVersionAttribute;
            Attr nameAttribute = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
            key = nameAttribute != null ? manifest.getNodeKey(element.getTagName() + "#" + nameAttribute.getValue()) : ((glEsVersionAttribute = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "glEsVersion")) != null ? manifest.getNodeKey(element.getTagName() + "#" + glEsVersionAttribute.getValue()) : ("intent-filter".equals(element.getTagName()) ? manifest.getNodeKey(element.getTagName() + "#" + IntentFilterNodeKeyResolver.INSTANCE.getKey(element)) : null));
        }
        return key;
    }

    @Nullable
    public static Node getSourceNode(@NotNull Module module, @NotNull Actions.Record record) {
        if (module == null) {
            ManifestUtils.$$$reportNull$$$0(12);
        }
        if (record == null) {
            ManifestUtils.$$$reportNull$$$0(13);
        }
        SourceFilePosition sourceFilePosition = record.getActionLocation();
        SourceFile sourceFile = sourceFilePosition.getFile();
        File file = sourceFile.getSourceFile();
        SourcePosition sourcePosition = sourceFilePosition.getPosition();
        if (file != null && !SourcePosition.UNKNOWN.equals((Object)sourcePosition)) {
            VirtualFile vFile = VfsUtil.findFileByIoFile((File)file, (boolean)false);
            assert (vFile != null);
            Module fileModule = ModuleUtilCore.findModuleForFile((VirtualFile)vFile, (Project)module.getProject());
            if (fileModule != null && !fileModule.equals(module)) {
                MergedManifestSnapshot manifest = MergedManifestManager.getSnapshot(fileModule);
                Document document = manifest.getDocument();
                assert (document != null);
                Element root2 = document.getDocumentElement();
                assert (root2 != null);
                int startLine = sourcePosition.getStartLine();
                int startColumn = sourcePosition.getStartColumn();
                return PositionXmlParser.findNodeAtLineAndCol((Document)document, (int)startLine, (int)startColumn);
            }
            int startLine = sourcePosition.getStartLine();
            int startColumn = sourcePosition.getStartColumn();
            try {
                byte[] bytes = Files.toByteArray((File)file);
                Document document = PositionXmlParser.parse((byte[])bytes);
                return PositionXmlParser.findNodeAtLineAndCol((Document)document, (int)startLine, (int)startColumn);
            }
            catch (IOException | ParserConfigurationException | SAXException exception) {
                // empty catch block
            }
        }
        return null;
    }

    @NotNull
    static SourceFilePosition getActionLocation(@NotNull Module module, @NotNull Actions.Record record) {
        int startColumn;
        AndroidFacet facet2;
        Module fileModule;
        if (module == null) {
            ManifestUtils.$$$reportNull$$$0(14);
        }
        if (record == null) {
            ManifestUtils.$$$reportNull$$$0(15);
        }
        SourceFilePosition sourceFilePosition = record.getActionLocation();
        SourceFile sourceFile = sourceFilePosition.getFile();
        File file = sourceFile.getSourceFile();
        SourcePosition sourcePosition = sourceFilePosition.getPosition();
        if (file == null || SourcePosition.UNKNOWN.equals((Object)sourcePosition)) {
            SourceFilePosition sourceFilePosition2 = sourceFilePosition;
            if (sourceFilePosition2 == null) {
                ManifestUtils.$$$reportNull$$$0(16);
            }
            return sourceFilePosition2;
        }
        VirtualFile vFile = VfsUtil.findFileByIoFile((File)file, (boolean)false);
        Module module2 = fileModule = vFile == null ? null : ModuleUtilCore.findModuleForFile((VirtualFile)vFile, (Project)module.getProject());
        if (module.equals(fileModule)) {
            SourceFilePosition sourceFilePosition3 = sourceFilePosition;
            if (sourceFilePosition3 == null) {
                ManifestUtils.$$$reportNull$$$0(17);
            }
            return sourceFilePosition3;
        }
        AndroidFacet androidFacet = facet2 = fileModule == null ? null : AndroidFacet.getInstance((Module)fileModule);
        if (facet2 == null || !IdeaSourceProviderUtil.isManifestFile(facet2, vFile)) {
            SourceFilePosition sourceFilePosition4 = sourceFilePosition;
            if (sourceFilePosition4 == null) {
                ManifestUtils.$$$reportNull$$$0(18);
            }
            return sourceFilePosition4;
        }
        MergedManifestSnapshot manifest = MergedManifestManager.getSnapshot(fileModule);
        Document document = manifest.getDocument();
        assert (document != null);
        Element root2 = document.getDocumentElement();
        assert (root2 != null);
        int startLine = sourcePosition.getStartLine();
        Node node = PositionXmlParser.findNodeAtLineAndCol((Document)document, (int)startLine, (int)(startColumn = sourcePosition.getStartColumn()));
        if (node == null) {
            Logger.getInstance(ManifestPanel.class).warn("Can not find node in " + fileModule + " for " + sourceFilePosition);
            SourceFilePosition sourceFilePosition5 = sourceFilePosition;
            if (sourceFilePosition5 == null) {
                ManifestUtils.$$$reportNull$$$0(19);
            }
            return sourceFilePosition5;
        }
        List<? extends Actions.Record> records = ManifestUtils.getRecords(manifest, node);
        if (!records.isEmpty()) {
            return ManifestUtils.getActionLocation(fileModule, records.get(0));
        }
        SourceFilePosition sourceFilePosition6 = sourceFilePosition;
        if (sourceFilePosition6 == null) {
            ManifestUtils.$$$reportNull$$$0(20);
        }
        return sourceFilePosition6;
    }

    @Nullable
    public static NamedIdeaSourceProvider findManifestSourceProvider(@NotNull AndroidFacet facet2, @NotNull VirtualFile manifestFile) {
        if (facet2 == null) {
            ManifestUtils.$$$reportNull$$$0(21);
        }
        if (manifestFile == null) {
            ManifestUtils.$$$reportNull$$$0(22);
        }
        return IdeaSourceProviderUtil.findByFile(SourceProviderManager.getInstance(facet2).getCurrentSourceProviders(), manifestFile);
    }

    @NotNull
    public static XmlFile getMainManifest(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            ManifestUtils.$$$reportNull$$$0(23);
        }
        VirtualFile manifestFile = AndroidRootUtil.getPrimaryManifestFile(facet2);
        assert (manifestFile != null);
        PsiFile psiFile2 = PsiManager.getInstance((Project)facet2.getModule().getProject()).findFile(manifestFile);
        assert (psiFile2 != null);
        XmlFile xmlFile = (XmlFile)psiFile2;
        if (xmlFile == null) {
            ManifestUtils.$$$reportNull$$$0(24);
        }
        return xmlFile;
    }

    static void toolsRemove(@NotNull XmlFile manifest, @NotNull Node item) {
        if (manifest == null) {
            ManifestUtils.$$$reportNull$$$0(25);
        }
        if (item == null) {
            ManifestUtils.$$$reportNull$$$0(26);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (item instanceof Element) {
            ManifestUtils.toolsRemove(manifest, (Element)item);
        } else if (item instanceof Attr) {
            Attr attribute = (Attr)item;
            Element element = attribute.getOwnerElement();
            if ("name".equals(attribute.getLocalName()) && "http://schemas.android.com/apk/res/android".equals(attribute.getNamespaceURI()) || Lint.getChildCount((Node)element) == 0 && element.getAttributes().getLength() == 1) {
                ManifestUtils.toolsRemove(manifest, element);
            } else {
                ManifestUtils.toolsRemove(manifest, attribute);
            }
        }
    }

    static void toolsRemove(@NotNull XmlFile manifest, @NotNull Element item) {
        if (manifest == null) {
            ManifestUtils.$$$reportNull$$$0(27);
        }
        if (item == null) {
            ManifestUtils.$$$reportNull$$$0(28);
        }
        ManifestUtils.addToolsAttribute(manifest, item, "node", "remove");
    }

    static void toolsRemove(@NotNull XmlFile manifest, @NotNull Attr item) {
        if (manifest == null) {
            ManifestUtils.$$$reportNull$$$0(29);
        }
        if (item == null) {
            ManifestUtils.$$$reportNull$$$0(30);
        }
        ManifestUtils.addToolsAttribute(manifest, item.getOwnerElement(), "remove", item.getName());
    }

    static void addToolsAttribute(@NotNull XmlFile manifest, @NotNull Element item, @NotNull String attributeName, @NotNull String attributeValue) {
        if (manifest == null) {
            ManifestUtils.$$$reportNull$$$0(31);
        }
        if (item == null) {
            ManifestUtils.$$$reportNull$$$0(32);
        }
        if (attributeName == null) {
            ManifestUtils.$$$reportNull$$$0(33);
        }
        if (attributeValue == null) {
            ManifestUtils.$$$reportNull$$$0(34);
        }
        if (attributeName.contains(":")) {
            throw new IllegalArgumentException("should not have namespace as it's always tools");
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        AndroidResourceUtil.ensureNamespaceImported(manifest, "http://schemas.android.com/tools", null);
        XmlTag parent = null;
        XmlTag[] manifestTags = new XmlTag[]{manifest.getRootTag()};
        for (Element tag : ManifestUtils.getPath(item)) {
            XmlTag found = ManifestUtils.findTag(manifestTags, tag);
            if (found == null) {
                if (parent == null) {
                    Logger.getInstance(ManifestUtils.class).warn("can not root tag " + tag + " in xml file " + manifest);
                    return;
                }
                found = parent.createChildTag(tag.getLocalName(), null, null, false);
                found = parent.addSubTag(found, true);
                Attr nameAttribute = tag.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
                if (nameAttribute != null) {
                    found.setAttribute(nameAttribute.getLocalName(), nameAttribute.getNamespaceURI(), nameAttribute.getValue());
                }
                if (tag == item) {
                    found.setAttribute(attributeName, "http://schemas.android.com/tools", attributeValue);
                }
            } else if (tag == item) {
                XmlAttribute attribute = found.getAttribute(attributeName, "http://schemas.android.com/tools");
                if (attribute == null) {
                    found.setAttribute(attributeName, "http://schemas.android.com/tools", attributeValue);
                } else {
                    found.setAttribute(attributeName, "http://schemas.android.com/tools", attribute.getValue() + "," + attributeValue);
                }
            }
            parent = found;
            manifestTags = found.getSubTags();
        }
    }

    @Nullable
    private static XmlTag findTag(@NotNull XmlTag[] manifestTags, @NotNull Element tag) {
        Attr nameAttribute;
        if (manifestTags == null) {
            ManifestUtils.$$$reportNull$$$0(35);
        }
        if (tag == null) {
            ManifestUtils.$$$reportNull$$$0(36);
        }
        String name = (nameAttribute = tag.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name")) == null ? null : nameAttribute.getValue();
        for (XmlTag xmlTag : manifestTags) {
            if (!tag.getTagName().equals(xmlTag.getName())) continue;
            if (name != null) {
                XmlAttribute xmlAttribute = xmlTag.getAttribute("name", "http://schemas.android.com/apk/res/android");
                if (xmlAttribute == null || !name.equals(xmlAttribute.getValue())) continue;
                return xmlTag;
            }
            return xmlTag;
        }
        return null;
    }

    @NotNull
    private static List<Element> getPath(@NotNull Element element) {
        if (element == null) {
            ManifestUtils.$$$reportNull$$$0(37);
        }
        Element tag = element;
        ArrayList<Element> path2 = new ArrayList<Element>();
        while (true) {
            path2.add(tag);
            Node parentNode = tag.getParentNode();
            if (!(parentNode instanceof Element)) break;
            tag = (Element)parentNode;
        }
        Collections.reverse(path2);
        ArrayList<Element> arrayList = path2;
        if (arrayList == null) {
            ManifestUtils.$$$reportNull$$$0(38);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activityName";
                break;
            }
            case 2: 
            case 10: 
            case 25: 
            case 27: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manifest";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/manifest/ManifestUtils";
                break;
            }
            case 11: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "record";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manifestFile";
                break;
            }
            case 26: 
            case 28: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeValue";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manifestTags";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/manifest/ManifestUtils";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecords";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionLocation";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainManifest";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSourceFilePosition";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRecords";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 38: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getNodeKey";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSourceNode";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getActionLocation";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findManifestSourceProvider";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getMainManifest";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "toolsRemove";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addToolsAttribute";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "findTag";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

