/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.layoutInspector.actions;

import com.android.ddmlib.Client;
import com.android.layoutinspector.model.ClientWindow;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.actions.AbstractClientAction;
import com.android.tools.idea.editors.layoutInspector.LayoutInspectorCaptureTask;
import com.android.tools.idea.editors.layoutInspector.WindowPickerDialog;
import com.android.tools.idea.ui.LayoutInspectorSettingsKt;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import icons.StudioIcons;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayoutInspectorAction
extends AbstractClientAction {
    private final Project myProject;

    public LayoutInspectorAction(@NotNull Project project, @NotNull DeviceContext deviceContext) {
        if (project == null) {
            LayoutInspectorAction.$$$reportNull$$$0(0);
        }
        if (deviceContext == null) {
            LayoutInspectorAction.$$$reportNull$$$0(1);
        }
        super(deviceContext, AndroidBundle.message("android.ddms.actions.layoutinspector.title", new Object[0]), AndroidBundle.message("android.ddms.actions.layoutinspector.description", new Object[0]), StudioIcons.Shell.Menu.LAYOUT_INSPECTOR);
        this.myProject = project;
    }

    @Override
    protected void performAction(@NotNull Client client) {
        if (client == null) {
            LayoutInspectorAction.$$$reportNull$$$0(2);
        }
        new GetClientWindowsTask(this.myProject, client).queue();
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            LayoutInspectorAction.$$$reportNull$$$0(3);
        }
        e.getPresentation().setVisible(!LayoutInspectorSettingsKt.getEnableLiveLayoutInspector());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/editors/layoutInspector/actions/LayoutInspectorAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "performAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @VisibleForTesting
    static interface ClientWindowRetriever {
        /*
         * WARNING - void declaration
         */
        default public List<ClientWindow> getAllWindows(@NotNull Client client, long timeout, @NotNull TimeUnit timeUnit) throws IOException {
            void timeoutUnits;
            if (client == null) {
                ClientWindowRetriever.$$$reportNull$$$0(0);
            }
            if (timeUnit == null) {
                ClientWindowRetriever.$$$reportNull$$$0(1);
            }
            return ClientWindow.getAll((Client)client, (long)timeout, (TimeUnit)timeoutUnits);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "client";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "timeoutUnits";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/editors/layoutInspector/actions/LayoutInspectorAction$ClientWindowRetriever";
            objectArray[2] = "getAllWindows";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class GetClientWindowsTask
    extends Task.Backgroundable {
        private final Client myClient;
        private List<ClientWindow> myWindows;
        private String myError;
        @NotNull
        private final ClientWindowRetriever myClientWindowRetriever;

        @VisibleForTesting
        GetClientWindowsTask(@Nullable Project project, @NotNull Client client, @NotNull ClientWindowRetriever windowRetriever) {
            if (client == null) {
                GetClientWindowsTask.$$$reportNull$$$0(0);
            }
            if (windowRetriever == null) {
                GetClientWindowsTask.$$$reportNull$$$0(1);
            }
            super(project, "Obtaining Windows");
            this.myClient = client;
            this.myError = null;
            this.myClientWindowRetriever = windowRetriever;
        }

        public GetClientWindowsTask(@Nullable Project project, @NotNull Client client) {
            if (client == null) {
                GetClientWindowsTask.$$$reportNull$$$0(2);
            }
            this(project, client, new ClientWindowRetriever(){});
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                GetClientWindowsTask.$$$reportNull$$$0(3);
            }
            indicator.setIndeterminate(true);
            try {
                this.myWindows = this.myClientWindowRetriever.getAllWindows(this.myClient, 5L, TimeUnit.SECONDS);
                if (this.myWindows == null) {
                    this.myError = "Unable to obtain list of windows used by " + this.myClient.getClientData().getPackageName() + "\nLayout Inspector requires device API version to be 18 or greater.";
                } else if (this.myWindows.isEmpty()) {
                    this.myError = "No active windows displayed by " + this.myClient.getClientData().getPackageName();
                }
            }
            catch (IOException e) {
                this.myError = "Unable to obtain list of windows used by " + this.myClient.getClientData().getPackageName() + "\nError: " + e.getMessage();
            }
        }

        public void onSuccess() {
            ClientWindow window;
            if (this.myError != null) {
                Messages.showErrorDialog((String)this.myError, (String)"Capture View Hierarchy");
                return;
            }
            if (this.myWindows.size() == 1) {
                window = this.myWindows.get(0);
            } else {
                WindowPickerDialog pickerDialog = new WindowPickerDialog(this.myProject, this.myClient, this.myWindows);
                if (!pickerDialog.showAndGet()) {
                    return;
                }
                window = pickerDialog.getSelectedWindow();
                if (window == null) {
                    return;
                }
            }
            LayoutInspectorCaptureTask captureTask = new LayoutInspectorCaptureTask(this.myProject, this.myClient, window);
            captureTask.queue();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "client";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "windowRetriever";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/editors/layoutInspector/actions/LayoutInspectorAction$GetClientWindowsTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

