/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.layoutInspector;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.HandleViewDebug;
import com.android.ddmlib.IDevice;
import com.android.layoutinspector.model.ClientWindow;
import com.android.layoutinspector.model.LayoutFileData;
import com.android.layoutinspector.model.ViewNode;
import com.android.layoutinspector.model.ViewProperty;
import com.android.tools.adtui.workbench.ToolWindowDefinition;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.editors.layoutInspector.EditHandler;
import com.android.tools.idea.editors.layoutInspector.LayoutInspectorEditHandler;
import com.android.tools.idea.editors.layoutInspector.LayoutInspectorModel;
import com.android.tools.idea.editors.layoutInspector.ptable.LITTableCellEditorProvider;
import com.android.tools.idea.editors.layoutInspector.ptable.LITableGroupItem;
import com.android.tools.idea.editors.layoutInspector.ptable.LITableRendererProvider;
import com.android.tools.idea.editors.layoutInspector.ui.RollOverTree;
import com.android.tools.idea.editors.layoutInspector.ui.ViewNodeActiveDisplay;
import com.android.tools.idea.editors.layoutInspector.ui.ViewNodeTreeRenderer;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.observable.collections.ObservableList;
import com.android.tools.property.ptable.PTable;
import com.android.tools.property.ptable.PTableItem;
import com.android.tools.property.ptable.PTableModel;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.LayoutInspectorEvent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.JBCheckboxMenuItem;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TableSpeedSearch;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayoutInspectorContext
implements Disposable,
DataProvider,
ViewNodeActiveDisplay.ViewNodeActiveDisplayListener,
TreeSelectionListener,
RollOverTree.TreeHoverListener,
AndroidDebugBridge.IDeviceChangeListener {
    private static final Key<ViewNode> KEY_VIEW_NODE = Key.create((String)ViewNode.class.getName());
    private static final boolean DUMP_DISPLAYLIST_ENABLED = Boolean.getBoolean("dump.displaylist.enabled");
    @NotNull
    private LayoutInspectorModel myModel;
    @Nullable
    private ViewNodeActiveDisplay myPreview;
    @NotNull
    private RollOverTree myNodeTree;
    @NotNull
    private final ObservableList<ViewNode> mySubviewList;
    @NotNull
    private final PTableModel myTableModel;
    @NotNull
    private final PTable myPropertiesTable;
    @NotNull
    private final JBPopupMenu myNodePopup;
    @NotNull
    private final JBCheckboxMenuItem myNodeVisibleMenuItem;
    @NotNull
    private final JMenuItem myDumpDisplayListMenuItem;
    @NotNull
    private final JMenuItem mySubtreePreviewMenuItem;

    @NotNull
    private static Logger getLogger() {
        Logger logger2 = Logger.getInstance(LayoutInspectorContext.class);
        if (logger2 == null) {
            LayoutInspectorContext.$$$reportNull$$$0(0);
        }
        return logger2;
    }

    public LayoutInspectorContext(@NotNull LayoutFileData layoutParser, @NotNull Disposable parentDisposable) {
        if (layoutParser == null) {
            LayoutInspectorContext.$$$reportNull$$$0(1);
        }
        if (parentDisposable == null) {
            LayoutInspectorContext.$$$reportNull$$$0(2);
        }
        ViewNode root2 = layoutParser.getNode();
        BufferedImage image = layoutParser.getBufferedImage();
        assert (root2 != null && image != null);
        this.myModel = new LayoutInspectorModel(root2, image);
        this.myNodeTree = this.createNodeTree(this.myModel.getRoot());
        this.mySubviewList = new ObservableList();
        this.myTableModel = new PTableModel();
        this.myPropertiesTable = new PTable(this.myTableModel);
        this.myPropertiesTable.getColumnModel().getColumn(0).setMinWidth((int)((double)ToolWindowDefinition.DEFAULT_SIDE_WIDTH * 0.6));
        this.myPropertiesTable.setRendererProvider(LITableRendererProvider.getInstance());
        if (((Boolean)StudioFlags.LAYOUT_INSPECTOR_EDITING_ENABLED.get()).booleanValue()) {
            this.myPropertiesTable.setEditorProvider(LITTableCellEditorProvider.INSTANCE);
        }
        this.myPropertiesTable.setFillsViewportHeight(true);
        this.myPropertiesTable.getTableHeader().setReorderingAllowed(false);
        TableSpeedSearch propertiesSpeedSearch = new TableSpeedSearch((JTable)((Object)this.myPropertiesTable), (object, cell) -> {
            if (object == null) {
                return null;
            }
            assert (object instanceof PTableItem) : "Items in inspector properties table expected to be a PTableItem";
            return ((PTableItem)object).getName();
        });
        propertiesSpeedSearch.setComparator(new SpeedSearchComparator(false, false));
        this.myNodePopup = new JBPopupMenu();
        this.myNodeVisibleMenuItem = new JBCheckboxMenuItem(AndroidBundle.message("android.ddms.actions.layoutinspector.menu.show.bound", new Object[0]));
        this.myNodeVisibleMenuItem.addActionListener((ActionListener)new ShowHidePreviewActionListener());
        this.myNodePopup.add((JMenuItem)this.myNodeVisibleMenuItem);
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        this.myDumpDisplayListMenuItem = new JMenuItem(AndroidBundle.message("android.ddms.actions.layoutinspector.menu.dump.display", new Object[0]));
        this.myDumpDisplayListMenuItem.setVisible(false);
        if (LayoutInspectorContext.isDumpDisplayListEnabled()) {
            this.myDumpDisplayListMenuItem.setVisible(true);
            this.myDumpDisplayListMenuItem.addActionListener(new DumpDisplayListActionListener());
            this.myDumpDisplayListMenuItem.setEnabled(this.myModel.isConnected());
            this.myNodePopup.add(this.myDumpDisplayListMenuItem);
        }
        this.mySubtreePreviewMenuItem = new JMenuItem("Render subtree preview");
        this.mySubtreePreviewMenuItem.setVisible(false);
        if (((Boolean)StudioFlags.LAYOUT_INSPECTOR_SUB_VIEW_ENABLED.get()).booleanValue()) {
            this.mySubtreePreviewMenuItem.setVisible(true);
            this.mySubtreePreviewMenuItem.addActionListener(new RenderSubtreePreviewActionListener());
            this.mySubtreePreviewMenuItem.setEnabled(this.myModel.isConnected());
            this.myNodePopup.add(this.mySubtreePreviewMenuItem);
        }
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    @NotNull
    private RollOverTree createNodeTree(@Nullable ViewNode root2) {
        RollOverTree tree = new RollOverTree((TreeNode)root2);
        tree.setSelectionRow(0);
        tree.setCellRenderer((TreeCellRenderer)((Object)new ViewNodeTreeRenderer()));
        tree.addTreeSelectionListener(this);
        tree.addTreeHoverListener(this);
        for (int i2 = 0; i2 < tree.getRowCount(); ++i2) {
            TreePath path2 = tree.getPathForRow(i2);
            ViewNode n = (ViewNode)path2.getLastPathComponent();
            if (!n.isDrawn()) continue;
            tree.expandPath(path2);
        }
        tree.addMouseListener(new NodeRightClickAdapter());
        RollOverTree rollOverTree = tree;
        if (rollOverTree == null) {
            LayoutInspectorContext.$$$reportNull$$$0(3);
        }
        return rollOverTree;
    }

    @NotNull
    public RollOverTree getNodeTree() {
        RollOverTree rollOverTree = this.myNodeTree;
        if (rollOverTree == null) {
            LayoutInspectorContext.$$$reportNull$$$0(4);
        }
        return rollOverTree;
    }

    @NotNull
    public PTable getPropertiesTable() {
        PTable pTable = this.myPropertiesTable;
        if (pTable == null) {
            LayoutInspectorContext.$$$reportNull$$$0(5);
        }
        return pTable;
    }

    @NotNull
    public PTableModel getTableModel() {
        PTableModel pTableModel = this.myTableModel;
        if (pTableModel == null) {
            LayoutInspectorContext.$$$reportNull$$$0(6);
        }
        return pTableModel;
    }

    @Override
    public void onViewNodeOver(@Nullable ViewNode node) {
        if (node == null) {
            this.myNodeTree.updateHoverPath(null);
        } else {
            TreePath path2 = ViewNode.getPathFromParent((ViewNode)node, (ViewNode)this.myModel.getRoot());
            this.myNodeTree.updateHoverPath(path2);
        }
    }

    @Override
    public void onNodeSelected(@NotNull ViewNode node) {
        if (node == null) {
            LayoutInspectorContext.$$$reportNull$$$0(7);
        }
        TreePath path2 = ViewNode.getPathFromParent((ViewNode)node, (ViewNode)this.myModel.getRoot());
        this.myNodeTree.scrollPathToVisible(path2);
        this.myNodeTree.setSelectionPath(path2);
    }

    @Override
    public void onNodeDoubleClicked(@NotNull ViewNode node) {
        if (node == null) {
            LayoutInspectorContext.$$$reportNull$$$0(8);
        }
        if (this.myModel.isConnected() && ((Boolean)StudioFlags.LAYOUT_INSPECTOR_SUB_VIEW_ENABLED.get()).booleanValue()) {
            this.showSubView(node);
        }
    }

    @Override
    public void valueChanged(@NotNull TreeSelectionEvent event) {
        ViewNode selection;
        if (event == null) {
            LayoutInspectorContext.$$$reportNull$$$0(9);
        }
        if ((selection = (ViewNode)this.myNodeTree.getLastSelectedPathComponent()) != null) {
            this.myTableModel.setItems(LayoutInspectorContext.convertToItems(selection.getGroupedProperties(), new LayoutInspectorEditHandler()));
            if (this.myPreview != null) {
                this.myPreview.setSelectedNode(selection);
            }
        }
    }

    @NotNull
    public static List<PTableItem> convertToItems(@NotNull Map<String, List<ViewProperty>> properties, @NotNull EditHandler editHandler) {
        if (properties == null) {
            LayoutInspectorContext.$$$reportNull$$$0(10);
        }
        if (editHandler == null) {
            LayoutInspectorContext.$$$reportNull$$$0(11);
        }
        ArrayList<PTableItem> items2 = new ArrayList<PTableItem>();
        ArrayList<String> sortedKeys = new ArrayList<String>(properties.keySet());
        sortedKeys.sort(String::compareToIgnoreCase);
        for (String key : sortedKeys) {
            items2.add(new LITableGroupItem(key, properties.get(key), editHandler));
        }
        ArrayList<PTableItem> arrayList = items2;
        if (arrayList == null) {
            LayoutInspectorContext.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @Override
    public void onTreeCellHover(@Nullable TreePath path2) {
        if (this.myPreview != null) {
            this.myPreview.setHoverNode(path2 == null ? null : (ViewNode)path2.getLastPathComponent());
        }
    }

    public void dispose() {
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        return null;
    }

    @NotNull
    public ViewNode getRoot() {
        ViewNode viewNode = this.myModel.getRoot();
        if (viewNode == null) {
            LayoutInspectorContext.$$$reportNull$$$0(13);
        }
        return viewNode;
    }

    @NotNull
    public BufferedImage getBufferedImage() {
        BufferedImage bufferedImage = this.myModel.getBufferedImage();
        if (bufferedImage == null) {
            LayoutInspectorContext.$$$reportNull$$$0(14);
        }
        return bufferedImage;
    }

    public void setPreview(@NotNull ViewNodeActiveDisplay preview) {
        if (preview == null) {
            LayoutInspectorContext.$$$reportNull$$$0(15);
        }
        this.myPreview = preview;
    }

    public void setSources(@Nullable Client newClient, @Nullable ClientWindow newWindow) {
        this.myModel = this.myModel.copy(this.myModel.getRoot(), this.myModel.getBufferedImage(), newClient, newWindow);
        this.myDumpDisplayListMenuItem.setEnabled(this.myModel.isConnected());
        this.mySubtreePreviewMenuItem.setEnabled(this.myModel.isConnected());
    }

    public static boolean isDumpDisplayListEnabled() {
        return DUMP_DISPLAYLIST_ENABLED;
    }

    public void deviceConnected(IDevice device) {
    }

    public void deviceDisconnected(IDevice device) {
        if (this.myModel.getClient() == null) {
            return;
        }
        IDevice currentDevice = this.myModel.getClient().getDevice();
        if (device.equals(currentDevice)) {
            this.setSources(null, null);
        }
    }

    public void deviceChanged(IDevice device, int changeMask) {
    }

    private static void createNotification(@NotNull String message2, @NotNull NotificationType type) {
        if (message2 == null) {
            LayoutInspectorContext.$$$reportNull$$$0(16);
        }
        if (type == null) {
            LayoutInspectorContext.$$$reportNull$$$0(17);
        }
        Notifications.Bus.notify((Notification)new Notification(NotificationGroup.createIdWithTitle((String)"Layout Inspector", (String)AndroidBundle.message("android.ddms.actions.layoutinspector.notification.group", new Object[0])), AndroidBundle.message("android.ddms.actions.layoutinspector.notification.title", new Object[0]), message2, type, null));
    }

    public void goBackSubView() {
        assert (!this.mySubviewList.isEmpty());
        ViewNode lastNode = this.mySubviewList.get(this.mySubviewList.size() - 1);
        if (lastNode == null) {
            return;
        }
        this.updatePreview(lastNode);
        this.mySubviewList.remove(lastNode);
    }

    @NotNull
    public ObservableList<ViewNode> getSubviewList() {
        ObservableList<ViewNode> observableList = this.mySubviewList;
        if (observableList == null) {
            LayoutInspectorContext.$$$reportNull$$$0(18);
        }
        return observableList;
    }

    @VisibleForTesting
    public void showSubView(@NotNull ViewNode node) {
        if (node == null) {
            LayoutInspectorContext.$$$reportNull$$$0(19);
        }
        UsageTracker.log((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.LAYOUT_INSPECTOR_EVENT).setLayoutInspectorEvent(LayoutInspectorEvent.newBuilder().setType(LayoutInspectorEvent.LayoutInspectorEventType.RENDER_SUB_VIEW)));
        ViewNode root2 = this.getRoot();
        this.updatePreview(node);
        this.mySubviewList.add(root2);
    }

    private void updatePreview(@NotNull ViewNode node) {
        if (node == null) {
            LayoutInspectorContext.$$$reportNull$$$0(20);
        }
        if (!this.myModel.isConnected()) {
            return;
        }
        byte[] bytes = this.myModel.getWindow().loadViewImage(node, 10L, TimeUnit.SECONDS);
        if (bytes == null) {
            return;
        }
        BufferedImage newImage = null;
        try {
            newImage = ImageIO.read(new ByteArrayInputStream(bytes));
        }
        catch (IOException e) {
            LayoutInspectorContext.getLogger().warn((Throwable)e);
        }
        if (newImage == null) {
            LayoutInspectorContext.createNotification(AndroidBundle.message("android.ddms.actions.layoutinspector.update.notification.failure", new Object[0]), NotificationType.ERROR);
            return;
        }
        this.myModel = this.myModel.copy(this.myModel.getRoot(), newImage, this.myModel.getClient(), this.myModel.getWindow());
        this.myPreview.setPreview(this.myModel.getBufferedImage(), node);
        this.myNodeTree = this.createNodeTree(node);
        this.myPreview.repaint();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/layoutInspector/LayoutInspectorContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutParser";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 7: 
            case 8: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editHandler";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preview";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/layoutInspector/LayoutInspectorContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createNodeTree";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeTree";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertiesTable";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableModel";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToItems";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getBufferedImage";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubviewList";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "onNodeSelected";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "onNodeDoubleClicked";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "valueChanged";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "convertToItems";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setPreview";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createNotification";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "showSubView";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "updatePreview";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class RenderSubtreePreviewActionListener
    implements ActionListener {
        private RenderSubtreePreviewActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (LayoutInspectorContext.this.myModel.isConnected()) {
                LayoutInspectorContext.this.showSubView((ViewNode)LayoutInspectorContext.this.myNodePopup.getClientProperty(KEY_VIEW_NODE));
            }
        }
    }

    private class DumpDisplayListActionListener
    implements ActionListener {
        private DumpDisplayListActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!LayoutInspectorContext.this.myModel.isConnected()) {
                return;
            }
            ViewNode node = (ViewNode)LayoutInspectorContext.this.myNodePopup.getClientProperty(KEY_VIEW_NODE);
            if (node == null) {
                LayoutInspectorContext.createNotification(AndroidBundle.message("android.ddms.actions.layoutinspector.dumpdisplay.notification.nonode", new Object[0]), NotificationType.ERROR);
                return;
            }
            try {
                HandleViewDebug.dumpDisplayList((Client)LayoutInspectorContext.this.myModel.getClient(), (String)LayoutInspectorContext.this.myModel.getWindow().getTitle(), (String)node.toString());
            }
            catch (IOException e1) {
                LayoutInspectorContext.createNotification(AndroidBundle.message("android.ddms.actions.layoutinspector.dumpdisplay.notification.failure", e1.getMessage()), NotificationType.ERROR);
                return;
            }
            LayoutInspectorContext.createNotification(AndroidBundle.message("android.ddms.actions.layoutinspector.dumpdisplay.notification.success", new Object[0]), NotificationType.INFORMATION);
            UsageTracker.log((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.LAYOUT_INSPECTOR_EVENT).setLayoutInspectorEvent(LayoutInspectorEvent.newBuilder().setType(LayoutInspectorEvent.LayoutInspectorEventType.DUMP_DISPLAYLIST)));
        }
    }

    private class ShowHidePreviewActionListener
    implements ActionListener {
        private ShowHidePreviewActionListener() {
        }

        @Override
        public void actionPerformed(@NotNull ActionEvent event) {
            ViewNode node;
            if (event == null) {
                ShowHidePreviewActionListener.$$$reportNull$$$0(0);
            }
            if ((node = (ViewNode)LayoutInspectorContext.this.myNodePopup.getClientProperty(KEY_VIEW_NODE)) == null) {
                return;
            }
            node.setForcedState(LayoutInspectorContext.this.myNodeVisibleMenuItem.getState() ? ViewNode.ForcedState.VISIBLE : ViewNode.ForcedState.INVISIBLE);
            LayoutInspectorContext.this.getRoot().updateNodeDrawn();
            if (LayoutInspectorContext.this.myPreview != null) {
                LayoutInspectorContext.this.myPreview.repaint();
            }
            LayoutInspectorContext.this.myNodeTree.repaint();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/editors/layoutInspector/LayoutInspectorContext$ShowHidePreviewActionListener", "actionPerformed"));
        }
    }

    private class NodeRightClickAdapter
    extends MouseAdapter {
        private NodeRightClickAdapter() {
        }

        @Override
        public void mousePressed(@NotNull MouseEvent event) {
            if (event == null) {
                NodeRightClickAdapter.$$$reportNull$$$0(0);
            }
            if (event.isPopupTrigger()) {
                TreePath path2 = LayoutInspectorContext.this.myNodeTree.getPathForEvent(event);
                if (path2 == null) {
                    return;
                }
                ViewNode node = (ViewNode)path2.getLastPathComponent();
                if (node.isParentVisible()) {
                    LayoutInspectorContext.this.myNodeVisibleMenuItem.setEnabled(true);
                    if (node.getForcedState() == ViewNode.ForcedState.NONE) {
                        LayoutInspectorContext.this.myNodeVisibleMenuItem.setState(node.isDrawn());
                    } else {
                        LayoutInspectorContext.this.myNodeVisibleMenuItem.setState(node.getForcedState() == ViewNode.ForcedState.VISIBLE);
                    }
                } else {
                    LayoutInspectorContext.this.myNodeVisibleMenuItem.setEnabled(false);
                    LayoutInspectorContext.this.myNodeVisibleMenuItem.setState(false);
                }
                LayoutInspectorContext.this.mySubtreePreviewMenuItem.setVisible(!node.equals((Object)LayoutInspectorContext.this.myModel.getRoot()));
                LayoutInspectorContext.this.myNodePopup.putClientProperty(KEY_VIEW_NODE, (Object)node);
                LayoutInspectorContext.this.myNodePopup.show((Component)((Object)LayoutInspectorContext.this.myNodeTree), event.getX(), event.getY());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/editors/layoutInspector/LayoutInspectorContext$NodeRightClickAdapter", "mousePressed"));
        }
    }
}

