/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.fonts;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.codeInsight.template.emmet.generators.LoremGenerator;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.event.MouseWheelEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FontEditor
implements FileEditor {
    private static final Logger LOG = Logger.getInstance(FontEditor.class);
    private static final String NAME = "Font";
    private static final String LOREM_TEXT = new LoremGenerator().generate(50, true);
    private static final float MAX_FONT_SIZE = UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.NORMAL) + JBUI.scale((float)30.0f);
    private static final float MIN_FONT_SIZE = UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.MINI);
    private static final Border BORDER = JBUI.Borders.empty((int)50);
    private static final Font DEFAULT_FONT = UIUtil.getLabelFont();
    private final UserDataHolderBase myUserDataHolder;
    private final JTextArea myTextArea;
    private final VirtualFile myFile;
    private final JPanel myRootPanel;
    private float myCurrentFontSize;
    private final JTextArea myFontNameArea;

    @NotNull
    private static JTextArea createTextArea() {
        JTextArea area = new JTextArea();
        area.setLineWrap(true);
        area.setWrapStyleWord(true);
        JTextArea jTextArea = area;
        if (jTextArea == null) {
            FontEditor.$$$reportNull$$$0(0);
        }
        return jTextArea;
    }

    @NotNull
    private static String findDisplayableText(@NotNull Font font) {
        if (font == null) {
            FontEditor.$$$reportNull$$$0(1);
        }
        if (font.canDisplayUpTo(LOREM_TEXT) == -1) {
            String string = LOREM_TEXT;
            if (string == null) {
                FontEditor.$$$reportNull$$$0(2);
            }
            return string;
        }
        StringBuilder displayableString = new StringBuilder(50);
        int numGlyphs = Math.min(font.getNumGlyphs(), 250);
        int displayedGlyphs = 0;
        for (int i2 = 0; i2 < 0x10FFFF; ++i2) {
            if (!Character.isValidCodePoint(i2)) continue;
            if (displayedGlyphs >= numGlyphs) {
                String string = displayableString.toString();
                if (string == null) {
                    FontEditor.$$$reportNull$$$0(3);
                }
                return string;
            }
            if (!font.canDisplay(i2)) continue;
            ++displayedGlyphs;
            displayableString.appendCodePoint(i2);
        }
        return "";
    }

    public FontEditor(@NotNull VirtualFile file) {
        if (file == null) {
            FontEditor.$$$reportNull$$$0(4);
        }
        this.myUserDataHolder = new UserDataHolderBase();
        this.myFile = file;
        this.myRootPanel = new JPanel(new BorderLayout());
        this.myRootPanel.setBackground(UIUtil.getTextFieldBackground());
        this.myRootPanel.setBorder(BORDER);
        this.myFontNameArea = FontEditor.createTextArea();
        this.myTextArea = FontEditor.createTextArea();
        this.myCurrentFontSize = UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.NORMAL) + JBUI.scale((float)15.0f);
        try {
            Font font = Font.createFont(0, file.getInputStream()).deriveFont(this.myCurrentFontSize);
            this.myFontNameArea.setText(font.getFontName());
            if (font.canDisplayUpTo(font.getFontName()) == -1) {
                this.myFontNameArea.setFont(font);
            } else {
                this.myFontNameArea.setFont(DEFAULT_FONT.deriveFont(this.myCurrentFontSize));
            }
            String displayableText = FontEditor.findDisplayableText(font);
            if (!displayableText.isEmpty()) {
                this.myTextArea.setFont(font);
                this.myTextArea.setText(displayableText);
            } else {
                this.myTextArea.setFont(DEFAULT_FONT);
                this.myTextArea.setEditable(false);
                this.myTextArea.setText("This font does not contain any glyphs that can be previewed");
            }
            this.myRootPanel.addMouseWheelListener(this::onMouseWheelEvent);
        }
        catch (FontFormatException | IOException e) {
            String message2 = "Unable to open font " + file.getName();
            this.myTextArea.setFont(UIUtil.getLabelFont());
            this.myTextArea.setEditable(false);
            this.myTextArea.setText(message2);
            LOG.warn(message2, (Throwable)e);
        }
        this.myRootPanel.add((Component)this.myFontNameArea, "North");
        this.myRootPanel.add((Component)this.myTextArea, "Center");
    }

    private void onMouseWheelEvent(MouseWheelEvent e) {
        float increment = e.getWheelRotation() < 0 ? -1.0f : 1.0f;
        float newFontSize = Math.min(Math.max(MIN_FONT_SIZE, this.myCurrentFontSize + increment), MAX_FONT_SIZE);
        if (newFontSize != this.myCurrentFontSize) {
            this.myCurrentFontSize = newFontSize;
            this.myTextArea.setFont(this.myTextArea.getFont().deriveFont(this.myCurrentFontSize));
            this.myFontNameArea.setFont(this.myFontNameArea.getFont().deriveFont(this.myCurrentFontSize));
        }
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myRootPanel;
        if (jPanel == null) {
            FontEditor.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myTextArea;
    }

    @NotNull
    public String getName() {
        return NAME;
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            FontEditor.$$$reportNull$$$0(6);
        }
        FileEditorState fileEditorState = FileEditorState.INSTANCE;
        if (fileEditorState == null) {
            FontEditor.$$$reportNull$$$0(7);
        }
        return fileEditorState;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            FontEditor.$$$reportNull$$$0(8);
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return this.myFile.isValid();
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            FontEditor.$$$reportNull$$$0(9);
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            FontEditor.$$$reportNull$$$0(10);
        }
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            FontEditor.$$$reportNull$$$0(11);
        }
        return (T)this.myUserDataHolder.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
        if (key == null) {
            FontEditor.$$$reportNull$$$0(12);
        }
        this.myUserDataHolder.putUserData(key, value2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/fonts/FontEditor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "font";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextArea";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/fonts/FontEditor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findDisplayableText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findDisplayableText";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

