/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.windows;

import com.android.tools.idea.diagnostics.windows.VirusCheckerStatusProvider;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class WindowsDefenderRegistryStatusProvider
implements VirusCheckerStatusProvider {
    @Override
    @NotNull
    public List<String> getExcludedPaths() throws IOException {
        try {
            HashSet localPaths = new HashSet(Advapi32Util.registryGetValues((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)"SOFTWARE\\Microsoft\\Windows Defender\\Exclusions\\Paths").keySet());
            HashSet policyPaths = new HashSet(Advapi32Util.registryGetValues((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)"SOFTWARE\\Policies\\Microsoft\\Windows Defender\\exclusions\\paths").keySet());
            localPaths.addAll(policyPaths);
            return new ArrayList<String>(localPaths);
        }
        catch (Win32Exception exception) {
            throw new IOException("Error code " + exception.getErrorCode() + ": " + exception.getMessage(), exception);
        }
    }

    @Override
    @NotNull
    public VirusCheckerStatusProvider.RealtimeScanningStatus getRealtimeScanningStatus() throws IOException {
        block5: {
            VirusCheckerStatusProvider.RealtimeScanningStatus realtimeScanningStatus;
            try {
                boolean policyExists = Advapi32Util.registryKeyExists((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)"SOFTWARE\\Policies\\Microsoft\\Windows Defender\\Real-Time Protection");
                if (!policyExists) break block5;
                int policyDisableRealtimeValue = Advapi32Util.registryGetIntValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)"SOFTWARE\\Policies\\Microsoft\\Windows Defender\\Real-Time Protection", (String)"DisableRealtimeMonitoring");
                realtimeScanningStatus = policyDisableRealtimeValue == 0 ? VirusCheckerStatusProvider.RealtimeScanningStatus.SCANNING_ENABLED : VirusCheckerStatusProvider.RealtimeScanningStatus.SCANNING_DISABLED;
            }
            catch (Win32Exception exception) {
                throw new IOException("Error code " + exception.getErrorCode() + ": " + exception.getMessage(), exception);
            }
            if (realtimeScanningStatus == null) {
                WindowsDefenderRegistryStatusProvider.$$$reportNull$$$0(0);
            }
            return realtimeScanningStatus;
        }
        int localDisableRealtimeValue = Advapi32Util.registryGetIntValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)"SOFTWARE\\Microsoft\\Windows Defender\\Real-Time Protection", (String)"DisableRealtimeMonitoring");
        VirusCheckerStatusProvider.RealtimeScanningStatus realtimeScanningStatus = localDisableRealtimeValue == 0 ? VirusCheckerStatusProvider.RealtimeScanningStatus.SCANNING_ENABLED : VirusCheckerStatusProvider.RealtimeScanningStatus.SCANNING_DISABLED;
        if (realtimeScanningStatus == null) {
            WindowsDefenderRegistryStatusProvider.$$$reportNull$$$0(1);
        }
        return realtimeScanningStatus;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/diagnostics/windows/WindowsDefenderRegistryStatusProvider", "getRealtimeScanningStatus"));
    }
}

