/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.hprof;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;

class AnalyzerProgressIndicator
extends EmptyProgressIndicator {
    private long myStartMillis = System.currentTimeMillis();
    private DateFormat myFormat = new SimpleDateFormat("HH:mm:ss.SSS", Locale.US);

    AnalyzerProgressIndicator() {
        super(ModalityState.NON_MODAL);
        this.myFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public void setText(String text) {
        super.setText(text);
        this.print(text);
    }

    public void setText2(String text) {
        super.setText2(text);
        this.print("  " + text);
    }

    private void print(String text) {
        long elapsedMs = System.currentTimeMillis() - this.myStartMillis;
        if (elapsedMs < 0L) {
            elapsedMs = 0L;
        }
        System.out.printf("[%s] %s...%n", this.myFormat.format(elapsedMs), text);
    }
}

