/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.crash;

import com.android.tools.idea.diagnostics.crash.BaseStudioReport;
import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import java.nio.charset.Charset;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;

public class StudioPsiInvalidationTraceReport
extends BaseStudioReport {
    private final String invalidationReason;
    private final Throwable currentStack;
    private final String threadDump;

    public StudioPsiInvalidationTraceReport(PsiFile psiFile2, String threadDump) {
        super(null, null, "PsiInvalidationTrace");
        this.invalidationReason = StudioPsiInvalidationTraceReport.getInvalidationReason(psiFile2);
        this.currentStack = new Throwable();
        this.threadDump = threadDump;
    }

    @Override
    protected void serializeTo(MultipartEntityBuilder builder2) {
        super.serializeTo(builder2);
        builder2.addTextBody("exception_info", Throwables.getStackTraceAsString((Throwable)this.currentStack));
        builder2.addTextBody("invalidationReason", this.invalidationReason, ContentType.create((String)"text/plain", (Charset)Charsets.UTF_8));
        builder2.addTextBody("threadDump", this.threadDump, ContentType.create((String)"text/plain", (Charset)Charsets.UTF_8));
    }

    private static String getInvalidationReason(PsiFile psiFile2) {
        StringBuilder sb = new StringBuilder();
        sb.append(PsiInvalidElementAccessException.getInvalidationTrace((UserDataHolder)psiFile2));
        sb.append("\n");
        FileViewProvider provider2 = psiFile2.getViewProvider();
        VirtualFile vFile = provider2.getVirtualFile();
        if (!vFile.isValid()) {
            sb.append("Virtual file is invalid. ");
        }
        sb.append("\n");
        return sb.toString();
    }
}

