/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.crash;

import com.android.tools.analytics.crash.CrashReport;
import com.android.tools.idea.diagnostics.crash.BaseStudioReport;
import com.android.tools.idea.diagnostics.crash.exception.JvmCrashException;
import com.android.tools.idea.diagnostics.crash.exception.NonGracefulExitException;
import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.entity.mime.MultipartEntityBuilder;

public final class StudioCrashReport
extends BaseStudioReport {
    private final List<String> descriptions;
    private final boolean isJvmCrash;
    private final long uptimeInMs;
    private final String errorSignal;
    private final String errorFrame;
    private final String errorThread;
    private final String nativeStack;

    private StudioCrashReport(String version2, List<String> descriptions, Map<String, String> productData, boolean isJvmCrash, long uptimeInMs, String errorSignal, String errorFrame, String errorThread, String nativeStack) {
        super(version2, productData, "Crash");
        this.descriptions = descriptions;
        this.isJvmCrash = isJvmCrash;
        this.uptimeInMs = uptimeInMs;
        this.errorSignal = errorSignal;
        this.errorFrame = errorFrame;
        this.errorThread = errorThread;
        this.nativeStack = nativeStack;
    }

    @Override
    protected void serializeTo(MultipartEntityBuilder builder2) {
        super.serializeTo(builder2);
        builder2.addTextBody("numCrashes", Integer.toString(this.descriptions.size()));
        builder2.addTextBody("crashDesc", Joiner.on((String)"\n\n").join(this.descriptions));
        Exception exception = this.isJvmCrash ? new JvmCrashException() : new NonGracefulExitException();
        String[] exceptionInfoAllLines = Throwables.getStackTraceAsString((Throwable)exception).split("[\\r\\n]+");
        String exceptionInfo = Arrays.stream(exceptionInfoAllLines).limit(2L).collect(Collectors.joining("\n"));
        builder2.addTextBody("exception_info", exceptionInfo);
        if (this.isJvmCrash) {
            builder2.addTextBody("errorSignal", this.errorSignal);
            builder2.addTextBody("errorFrame", this.errorFrame);
            builder2.addTextBody("errorThread", this.errorThread);
            builder2.addTextBody("nativeStack", this.nativeStack);
        }
    }

    protected void overrideDefaultParameters(Map<String, String> parameters2) {
        if (this.uptimeInMs >= 0L) {
            parameters2.put("ptime", Long.toString(this.uptimeInMs));
        }
    }

    public static class Builder
    extends CrashReport.BaseBuilder<StudioCrashReport, Builder> {
        private List<String> descriptions;
        private boolean isJvmCrash = false;
        private long uptimeInMs = -1L;
        private String errorSignal = "";
        private String errorFrame = "";
        private String errorThread = "";
        private String nativeStack = "";

        protected Builder getThis() {
            return this;
        }

        public Builder setDescriptions(List<String> descriptions) {
            this.descriptions = descriptions;
            return this;
        }

        public Builder setIsJvmCrash(boolean isJvmCrash) {
            this.isJvmCrash = isJvmCrash;
            return this;
        }

        public Builder setUptimeInMs(long uptimeInMs) {
            this.uptimeInMs = uptimeInMs;
            return this;
        }

        public Builder setErrorSignal(String errorSignal) {
            this.errorSignal = errorSignal;
            return this;
        }

        public Builder setErrorFrame(String errorFrame) {
            this.errorFrame = errorFrame;
            return this;
        }

        public Builder setErrorThread(String errorThread) {
            this.errorThread = errorThread;
            return this;
        }

        public Builder setNativeStack(String nativeStack) {
            this.nativeStack = nativeStack;
            return this;
        }

        public StudioCrashReport build() {
            return new StudioCrashReport(this.getVersion(), this.descriptions, this.getProductData(), this.isJvmCrash, this.uptimeInMs, this.errorSignal, this.errorFrame, this.errorThread, this.nativeStack);
        }
    }
}

