/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics;

import com.android.tools.idea.diagnostics.DiagnosticReportConfiguration;
import com.android.tools.idea.diagnostics.DiagnosticReportContributor;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThreadSamplingReportContributor
implements DiagnosticReportContributor {
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private final ThreadMXBean myThreadMXBean = ManagementFactory.getThreadMXBean();
    private final Object LOCK = new Object();
    @GuardedBy(value="mySampledStacks")
    private final List<ThreadInfo[]> mySampledStacks = new ArrayList<ThreadInfo[]>();
    @GuardedBy(value="LOCK")
    private ScheduledFuture<?> myFutureSampling;
    @GuardedBy(value="LOCK")
    private ScheduledFuture<?> myFutureFinishSampling;
    private String myAwtStack = "";
    private String myReport = "";
    private DiagnosticReportConfiguration myConfiguration;

    @Override
    public void setup(DiagnosticReportConfiguration configuration) {
        this.myConfiguration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startCollection(long timeElapsedSoFarMs) {
        DiagnosticReportConfiguration configuration = this.myConfiguration;
        Object object = this.LOCK;
        synchronized (object) {
            this.myFutureSampling = this.scheduler.scheduleWithFixedDelay(this::sampleThreads, 0L, configuration.getIntervalMs(), TimeUnit.MILLISECONDS);
            long samplingTimeMs = configuration.getMaxSamplingTimeMs();
            if (samplingTimeMs > 0L) {
                this.myFutureFinishSampling = this.scheduler.schedule(this::stop, samplingTimeMs, TimeUnit.MILLISECONDS);
            }
        }
    }

    @Override
    public void stopCollection(long totalDurationMs) {
        this.stop();
        this.prepareReport(totalDurationMs);
    }

    @Override
    public String getReport() {
        return this.myReport;
    }

    @Override
    public void generateReport(BiConsumer<String, String> saveReportCallback) {
        saveReportCallback.accept("hotPathStackTrace", this.getAWTStack());
        saveReportCallback.accept("profileDiagnostics", this.getReport());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myFutureFinishSampling != null) {
                this.myFutureFinishSampling.cancel(false);
                this.myFutureFinishSampling = null;
            }
            if (this.myFutureSampling != null) {
                this.myFutureSampling.cancel(false);
                this.myFutureSampling = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sampleThreads() {
        try {
            ThreadInfo[] allThreads = this.myThreadMXBean.dumpAllThreads(false, false);
            List<ThreadInfo[]> list = this.mySampledStacks;
            synchronized (list) {
                this.mySampledStacks.add(allThreads);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getAWTStack() {
        return this.myAwtStack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareReport(long totalFreezeDurationMs) {
        StringBuilder sb = new StringBuilder();
        HashMap<Long, ThreadCallTree> threadMap = new HashMap<Long, ThreadCallTree>();
        long intervalMs = this.myConfiguration.getIntervalMs();
        List<ThreadInfo[]> list = this.mySampledStacks;
        synchronized (list) {
            for (ThreadInfo[] sampledThreads : this.mySampledStacks) {
                for (ThreadInfo ti : sampledThreads) {
                    ThreadCallTree callTree = (ThreadCallTree)threadMap.get(ti.getThreadId());
                    if (callTree == null) {
                        callTree = new ThreadCallTree(ti.getThreadId(), ti.getThreadName());
                        threadMap.put(ti.getThreadId(), callTree);
                    }
                    callTree.addThreadInfo(ti, intervalMs);
                }
            }
        }
        for (ThreadCallTree callTree : threadMap.values()) {
            callTree.computeTimeSpent();
        }
        ThreadCallTree awtThread = ThreadSamplingReportContributor.getAwtThread(threadMap.values());
        this.myAwtStack = this.createHotPathStackTrace(awtThread, totalFreezeDurationMs);
        if (awtThread != null) {
            sb.append(awtThread.getReportString(this.myConfiguration.getFrameTimeIgnoreThresholdMs()));
            sb.append('\n');
        }
        for (ThreadCallTree callTree : threadMap.values()) {
            if (callTree == awtThread) continue;
            sb.append(callTree.getReportString(this.myConfiguration.getFrameTimeIgnoreThresholdMs()));
            sb.append('\n');
        }
        this.myReport = sb.toString();
    }

    @NotNull
    private String createHotPathStackTrace(@Nullable ThreadCallTree thread, long totalFreezeDurationMs) {
        FrameInfo frame;
        StringBuilder sb = new StringBuilder();
        String threadName = thread != null ? thread.myThreadName : "MissingAWTThread";
        sb.append("\"").append(threadName).append("\" tid=0x0 runnable\n").append("     java.lang.Thread.State: RUNNABLE\n").append("     Frozen for ").append(TimeUnit.MILLISECONDS.toSeconds(totalFreezeDurationMs)).append("secs\n");
        FrameInfo frameInfo = frame = thread != null ? thread.myRootFrame : null;
        if (frame == null) {
            sb.append("\tat ").append(ThreadSamplingReportContributor.class.getName()).append(".missingEdtStack(Unknown source)\n");
        }
        ArrayList<FrameInfo> frames = new ArrayList<FrameInfo>();
        while (frame != null) {
            if (frame.myStackTraceElement != null) {
                frames.add(frame);
            }
            if ((frame = frame.getHottestSubframe()) == null || frame.myTimeSpent >= this.myConfiguration.getFrameTimeIgnoreThresholdMs()) continue;
        }
        Collections.reverse(frames);
        for (FrameInfo f : frames) {
            sb.append("\tat ");
            f.appendStackTraceForCurrentFrame(sb);
            sb.append('\n');
        }
        String string = sb.toString();
        if (string == null) {
            ThreadSamplingReportContributor.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    private static ThreadCallTree getAwtThread(@NotNull Collection<ThreadCallTree> threadMap) {
        if (threadMap == null) {
            ThreadSamplingReportContributor.$$$reportNull$$$0(1);
        }
        return threadMap.stream().filter(t -> t.myThreadName.startsWith("AWT-EventQueue-")).findFirst().orElse(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/diagnostics/ThreadSamplingReportContributor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createHotPathStackTrace";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/diagnostics/ThreadSamplingReportContributor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAwtThread";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class FrameInfo {
        public static final FrameInfo[] EMPTY_FRAME_INFOS = new FrameInfo[0];
        private static final String INDENT_STRING = "  ";
        private static final String INDENT_MARK_STRING = "+ ";
        private static final String[][] ourIdleApplicationImplThread = new String[][]{{"java.lang.Thread.run", "java.util.concurrent.ThreadPoolExecutor$Worker.run", "java.util.concurrent.ThreadPoolExecutor.runWorker", "java.util.concurrent.ThreadPoolExecutor.getTask", "java.util.concurrent.SynchronousQueue.poll", "java.util.concurrent.SynchronousQueue$TransferStack.transfer", "java.util.concurrent.SynchronousQueue$TransferStack.awaitFulfill", "java.util.concurrent.locks.LockSupport.parkNanos", "sun.misc.Unsafe.park"}, {"java.util.concurrent.ForkJoinWorkerThread.run", "java.util.concurrent.ForkJoinPool.runWorker", "java.util.concurrent.ForkJoinPool.awaitWork", "sun.misc.Unsafe.park"}, {"java.lang.Thread.run", "java.util.concurrent.ThreadPoolExecutor$Worker.run", "java.util.concurrent.ThreadPoolExecutor.runWorker", "java.util.concurrent.ThreadPoolExecutor.getTask", "java.util.concurrent.ScheduledThreadPoolExecutor$DelayedWorkQueue.take", "java.util.concurrent.ScheduledThreadPoolExecutor$DelayedWorkQueue.take", "java.util.concurrent.locks.AbstractQueuedSynchronizer$ConditionObject.await", "java.util.concurrent.locks.LockSupport.park", "sun.misc.Unsafe.park"}};
        private static final boolean INCLUDE_SOURCE_INFO_IN_REPORT = true;
        private static final Comparator<StackTraceElement> STACK_TRACE_ELEMENT_COMPARATOR_NO_SOURCE = (a, b) -> ComparisonChain.start().compare((Object)a.getClassName(), (Object)b.getClassName(), (Comparator)Ordering.natural().nullsFirst()).compare((Object)a.getMethodName(), (Object)b.getMethodName(), (Comparator)Ordering.natural().nullsFirst()).result();
        private static final Comparator<StackTraceElement> STACK_TRACE_ELEMENT_COMPARATOR_WITH_SOURCE = (a, b) -> ComparisonChain.start().compare((Object)a.getClassName(), (Object)b.getClassName(), (Comparator)Ordering.natural().nullsFirst()).compare((Object)a.getMethodName(), (Object)b.getMethodName(), (Comparator)Ordering.natural().nullsFirst()).compare((Object)a.getFileName(), (Object)b.getFileName(), (Comparator)Ordering.natural().nullsFirst()).compare((Object)a.getLineNumber(), (Object)b.getLineNumber(), (Comparator)Ordering.natural().nullsFirst()).result();
        private static final Comparator<StackTraceElement> STACK_TRACE_ELEMENT_COMPARATOR = STACK_TRACE_ELEMENT_COMPARATOR_WITH_SOURCE;
        private static final Comparator<FrameInfo> FRAME_INFO_COMPARATOR = (a, b) -> ComparisonChain.start().compare(b.myTimeSpent, a.myTimeSpent).compare((Object)a.myStackTraceElement, (Object)b.myStackTraceElement, STACK_TRACE_ELEMENT_COMPARATOR).result();
        private final StackTraceElement myStackTraceElement;
        private final SortedMap<StackTraceElement, FrameInfo> myChildren = new TreeMap<StackTraceElement, FrameInfo>(STACK_TRACE_ELEMENT_COMPARATOR);
        private long myTimeSpent;

        private FrameInfo(@Nullable StackTraceElement element) {
            this.myStackTraceElement = element;
        }

        @Nullable
        public FrameInfo getHottestSubframe() {
            FrameInfo result2 = null;
            for (FrameInfo fi : this.myChildren.values()) {
                if (result2 != null && fi.myTimeSpent <= result2.myTimeSpent) continue;
                result2 = fi;
            }
            return result2;
        }

        public void addThreadInfo(@NotNull ThreadInfo ti, long timeSpent) {
            if (ti == null) {
                FrameInfo.$$$reportNull$$$0(0);
            }
            if (FrameInfo.isIdleThread(ti)) {
                return;
            }
            this.addStack(ti.getStackTrace(), timeSpent);
        }

        private void addStack(@NotNull StackTraceElement[] stackTrace, long timeSpent) {
            if (stackTrace == null) {
                FrameInfo.$$$reportNull$$$0(1);
            }
            FrameInfo currentFrameInfo = this;
            for (int index = stackTrace.length - 1; index >= 0; --index) {
                StackTraceElement element = stackTrace[index];
                FrameInfo fi = (FrameInfo)currentFrameInfo.myChildren.get(element);
                if (fi == null) {
                    fi = new FrameInfo(element);
                    currentFrameInfo.myChildren.put(element, fi);
                }
                currentFrameInfo = fi;
            }
            currentFrameInfo.myTimeSpent += timeSpent;
        }

        public long computeTimeSpent() {
            if (this.myChildren.isEmpty()) {
                return this.myTimeSpent;
            }
            long sum = 0L;
            for (FrameInfo fi : this.myChildren.values()) {
                sum += fi.computeTimeSpent();
            }
            this.myTimeSpent = sum;
            return sum;
        }

        public String getReportString(long frameTimeIgnoreThreshold) {
            StringBuilder indentString = new StringBuilder();
            return this.getReportStringWithIndent(frameTimeIgnoreThreshold, indentString, false);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        private String getReportStringWithIndent(long frameTimeIgnoreThreshold, @NotNull StringBuilder indentString, boolean bl) {
            boolean shouldIndent;
            void addMark;
            if (indentString == null) {
                FrameInfo.$$$reportNull$$$0(2);
            }
            StringBuilder sb = new StringBuilder();
            if (addMark != false) {
                sb.append(indentString.subSequence(0, indentString.length() - INDENT_MARK_STRING.length()));
                sb.append(INDENT_MARK_STRING);
            } else {
                sb.append((CharSequence)indentString);
            }
            this.appendStackTraceForCurrentFrame(sb);
            sb.append(" [").append(this.myTimeSpent).append("ms]");
            sb.append('\n');
            FrameInfo[] childFrames = this.myChildren.values().toArray(EMPTY_FRAME_INFOS);
            Arrays.sort(childFrames, FRAME_INFO_COMPARATOR);
            boolean bl2 = shouldIndent = Arrays.stream(childFrames).filter(fi -> fi.myTimeSpent > frameTimeIgnoreThreshold).count() > 1L;
            if (shouldIndent) {
                indentString.append(INDENT_STRING);
            }
            for (FrameInfo fi2 : childFrames) {
                if (fi2.myTimeSpent <= frameTimeIgnoreThreshold) continue;
                sb.append(fi2.getReportStringWithIndent(frameTimeIgnoreThreshold, indentString, shouldIndent));
            }
            if (shouldIndent) {
                indentString.delete(indentString.length() - INDENT_STRING.length(), indentString.length());
            }
            String string = sb.toString();
            if (string == null) {
                FrameInfo.$$$reportNull$$$0(3);
            }
            return string;
        }

        private void appendStackTraceForCurrentFrame(@NotNull StringBuilder sb) {
            if (sb == null) {
                FrameInfo.$$$reportNull$$$0(4);
            }
            if (this.myStackTraceElement != null) {
                sb.append(this.myStackTraceElement.toString());
            }
        }

        private static boolean isIdleThread(ThreadInfo ti) {
            StackTraceElement[] stackTraceElements = ti.getStackTrace();
            for (String[] templateIdleStack : ourIdleApplicationImplThread) {
                StackTraceElement stackTraceElement;
                int i2;
                if (stackTraceElements.length != templateIdleStack.length) continue;
                for (i2 = 0; i2 < templateIdleStack.length && templateIdleStack[i2].equals((stackTraceElement = stackTraceElements[stackTraceElements.length - i2 - 1]).getClassName() + "." + stackTraceElement.getMethodName()); ++i2) {
                }
                if (i2 != templateIdleStack.length) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ti";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stackTrace";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indentString";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/diagnostics/ThreadSamplingReportContributor$FrameInfo";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/diagnostics/ThreadSamplingReportContributor$FrameInfo";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReportStringWithIndent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addThreadInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "addStack";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getReportStringWithIndent";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "appendStackTraceForCurrentFrame";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ThreadCallTree {
        private long myThreadId;
        private final String myThreadName;
        private final FrameInfo myRootFrame;

        public ThreadCallTree(long threadId, String threadName) {
            this.myThreadId = threadId;
            this.myThreadName = threadName;
            this.myRootFrame = new FrameInfo(null);
        }

        public void addThreadInfo(ThreadInfo ti, long timeSpent) {
            this.myRootFrame.addThreadInfo(ti, timeSpent);
        }

        public void computeTimeSpent() {
            this.myRootFrame.computeTimeSpent();
        }

        public String getReportString(long frameTimeIgnoreThresholdMs) {
            return this.myThreadName + ", TID: " + this.myThreadId + this.myRootFrame.getReportString(frameTimeIgnoreThresholdMs);
        }
    }
}

