/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics;

import com.android.tools.idea.diagnostics.DiagnosticReportConfiguration;
import com.android.tools.idea.diagnostics.DiagnosticReportContributor;
import com.intellij.openapi.util.LowMemoryWatcher;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;

public class MemoryUseReportContributor
implements DiagnosticReportContributor {
    private static final int MEGABYTE = 0x100000;
    private String myReport;
    private AtomicInteger myLowMemorySignalsCount;
    private LowMemoryWatcher myLowMemoryWatcher;

    @Override
    public void setup(DiagnosticReportConfiguration configuration) {
    }

    @Override
    public void startCollection(long timeElapsedSoFarMs) {
        this.myLowMemorySignalsCount = new AtomicInteger(0);
        this.myLowMemoryWatcher = LowMemoryWatcher.register(this.myLowMemorySignalsCount::incrementAndGet);
    }

    @Override
    public void stopCollection(long totalDurationMs) {
        this.myLowMemoryWatcher.stop();
        this.myLowMemoryWatcher = null;
        long totalMemory = Runtime.getRuntime().totalMemory() / 0x100000L;
        long usedMemory = totalMemory - Runtime.getRuntime().freeMemory() / 0x100000L;
        this.myReport = "Low memory events count: " + this.myLowMemorySignalsCount.get() + "\nTotal heap: " + totalMemory + "MB\nCurrent heap used: " + usedMemory + "MB\n";
    }

    @Override
    public String getReport() {
        return this.myReport;
    }

    @Override
    public void generateReport(BiConsumer<String, String> saveReportCallback) {
        saveReportCallback.accept("memoryUseDiagnostics", this.getReport());
    }
}

