/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics;

import com.android.tools.idea.diagnostics.ActionsReportContributor;
import com.android.tools.idea.diagnostics.DiagnosticReportConfiguration;
import com.android.tools.idea.diagnostics.DiagnosticReportContributor;
import com.android.tools.idea.diagnostics.DiagnosticReportIdePerformanceListener;
import com.android.tools.idea.diagnostics.LastActionTracker;
import com.android.tools.idea.diagnostics.MemoryUseReportContributor;
import com.android.tools.idea.diagnostics.ThreadSamplingReportContributor;
import com.android.tools.idea.diagnostics.report.DiagnosticReport;
import com.android.tools.idea.diagnostics.report.FreezeReport;
import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiagnosticReportBuilder {
    private static final Logger LOG = Logger.getInstance((String)"#com.android.tools.idea.diagnostics.DiagnosticReportBuilder");
    public static final long MAX_DURATION_MS = Long.getLong("studio.diagnostic.uiFreezeSampling.maxDurationMs", TimeUnit.SECONDS.toMillis(60L));
    public static final long INTERVAL_MS = Long.getLong("studio.diagnostic.uiFreezeSampling.intervalMs", 100L);
    public static final long FRAME_IGNORE_THRESHOLD_MS = Long.getLong("studio.diagnostic.uiFreezeSampling.frameIgnoreThresholdMs", 200L);
    public static final int MAX_REPORTS = Integer.getInteger("studio.diagnostic.uiFreezeSampling.maxReports", ApplicationManager.getApplication().isEAP() ? 10 : 3);
    @NotNull
    private final Object LOCK;
    private final long myStartTime;
    private final long myFreezeTimeBeforeCreated;
    @NotNull
    private final DiagnosticReportIdePerformanceListener.Controller myController;
    @NotNull
    private final ScheduledFuture<?> myFutureStop;
    @GuardedBy(value="LOCK")
    private boolean myIsStopped;
    @NotNull
    private List<DiagnosticReportContributor> myReportContributors;
    @GuardedBy(value="LOCK")
    private boolean myIsTimedOut;

    /*
     * WARNING - void declaration
     */
    public DiagnosticReportBuilder(long intervalMs, long maxSamplingTimeMs, long frameTimeIgnoreThresholdMs, long l, @NotNull LastActionTracker lastActionTracker, @NotNull DiagnosticReportIdePerformanceListener.Controller controller2) {
        void freezeTimeBeforeCreatedMs;
        void lastActionTracker2;
        void controller3;
        if (lastActionTracker == null) {
            DiagnosticReportBuilder.$$$reportNull$$$0(0);
        }
        if (controller2 == null) {
            DiagnosticReportBuilder.$$$reportNull$$$0(1);
        }
        this.LOCK = new Object();
        if (intervalMs <= 0L) {
            throw new IllegalArgumentException("intervalMs must be > 0");
        }
        if (maxSamplingTimeMs < 0L) {
            throw new IllegalArgumentException("maxSamplingTimeMs must be >= 0");
        }
        this.myController = controller3;
        this.myReportContributors = Arrays.asList(new ThreadSamplingReportContributor(), new MemoryUseReportContributor(), new ActionsReportContributor((LastActionTracker)lastActionTracker2));
        this.myFreezeTimeBeforeCreated = freezeTimeBeforeCreatedMs;
        DiagnosticReportConfiguration configuration = new DiagnosticReportConfiguration(intervalMs, maxSamplingTimeMs, frameTimeIgnoreThresholdMs);
        for (DiagnosticReportContributor contributor : this.myReportContributors) {
            try {
                contributor.setup(configuration);
            }
            catch (Throwable t) {
                LOG.error(t);
            }
        }
        this.myStartTime = System.currentTimeMillis();
        for (DiagnosticReportContributor contributor : this.myReportContributors) {
            try {
                contributor.startCollection((long)freezeTimeBeforeCreatedMs);
            }
            catch (Throwable t) {
                LOG.error(t);
            }
        }
        this.myFutureStop = JobScheduler.getScheduler().schedule(this::stopAfterTimeout, maxSamplingTimeMs, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopAfterTimeout() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myIsStopped) {
                return;
            }
            this.myIsTimedOut = true;
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private DiagnosticReport generateReport(long totalDurationMs) {
        Object object = this.LOCK;
        synchronized (object) {
            HashMap reportPaths = new HashMap();
            for (DiagnosticReportContributor contributor : this.myReportContributors) {
                contributor.generateReport((name, contents) -> {
                    Path path2 = this.myController.saveReportFile((String)name, (String)contents);
                    assert (!reportPaths.containsKey(name));
                    reportPaths.put(name, path2);
                });
            }
            if (!reportPaths.containsKey("hotPathStackTrace")) {
                return null;
            }
            Path hotPathStackTrace = (Path)reportPaths.remove("hotPathStackTrace");
            return new FreezeReport(hotPathStackTrace, reportPaths, this.myIsTimedOut, totalDurationMs, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myIsStopped) {
                return;
            }
            long stopTime = System.currentTimeMillis();
            long totalDurationMs = stopTime - this.myStartTime + this.myFreezeTimeBeforeCreated;
            for (DiagnosticReportContributor contributor : this.myReportContributors) {
                try {
                    contributor.stopCollection(totalDurationMs);
                }
                catch (Throwable t) {
                    LOG.error(t);
                }
            }
            this.myIsStopped = true;
            this.myFutureStop.cancel(false);
            DiagnosticReport report2 = this.generateReport(totalDurationMs);
            this.myController.reportReady(report2);
        }
    }

    public static void registerPerformanceListener(Consumer<DiagnosticReport> reportCallback) {
        new DiagnosticReportIdePerformanceListener(reportCallback).registerOn(ApplicationManager.getApplication());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "lastActionTracker";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "controller";
                break;
            }
        }
        objectArray[1] = "com/android/tools/idea/diagnostics/DiagnosticReportBuilder";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

