/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.deploy;

import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.DeploymentService;
import com.android.tools.idea.run.deployable.DeployableProvider;
import com.android.tools.idea.run.deployment.DeviceAndSnapshotComboBoxDeployableProvider;
import com.android.tools.idea.run.deployment.DeviceAndSnapshotComboBoxTargetProvider;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManagerAdapter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeployActionsInitializer
implements StartupActivity {
    public void runActivity(@NotNull Project project) {
        if (project == null) {
            DeployActionsInitializer.$$$reportNull$$$0(0);
        }
        DeployActionsInitializer.updateDeployableProvider(project, RunManager.getInstance((Project)project).getSelectedConfiguration());
    }

    @Contract(value="null -> null")
    @Nullable
    private static AndroidRunConfigurationBase getAndroidRunConfigurationbase(@Nullable RunnerAndConfigurationSettings configSettings) {
        if (configSettings == null) {
            return null;
        }
        RunConfiguration config = configSettings.getConfiguration();
        if (!(config instanceof AndroidRunConfigurationBase)) {
            return null;
        }
        return (AndroidRunConfigurationBase)config;
    }

    @Contract(value="null -> null")
    @Nullable
    private static Module getModule(@Nullable AndroidRunConfigurationBase androidRunConfigurationBase) {
        return androidRunConfigurationBase == null ? null : ((JavaRunConfigurationModule)androidRunConfigurationBase.getConfigurationModule()).getModule();
    }

    @Contract(value="null -> null")
    @Nullable
    private static DeployableProvider getDeployTargetProvider(@Nullable RunnerAndConfigurationSettings configSettings) {
        AndroidRunConfigurationBase androidRunConfig = DeployActionsInitializer.getAndroidRunConfigurationbase(configSettings);
        Module module = DeployActionsInitializer.getModule(androidRunConfig);
        if (module == null) {
            return null;
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module);
        if (facet2 == null) {
            return null;
        }
        if (facet2.isDisposed()) {
            Logger.getInstance(DeployActionsInitializer.class).warn("Facet is disposed for the selected configuration.");
            return null;
        }
        if (androidRunConfig.getDeployTargetContext().getCurrentDeployTargetProvider() instanceof DeviceAndSnapshotComboBoxTargetProvider) {
            ApplicationIdProvider applicationIdProvider = androidRunConfig.getApplicationIdProvider(facet2);
            return new DeviceAndSnapshotComboBoxDeployableProvider(module.getProject(), applicationIdProvider);
        }
        return null;
    }

    private static boolean canOverrideDeployableProvider(@Nullable DeployableProvider provider2) {
        return provider2 == null || provider2 instanceof DeviceAndSnapshotComboBoxDeployableProvider;
    }

    private static void updateDeployableProvider(@NotNull Project project, @Nullable RunnerAndConfigurationSettings configSettings) {
        DeploymentService deploymentService;
        if (project == null) {
            DeployActionsInitializer.$$$reportNull$$$0(1);
        }
        if (DeployActionsInitializer.canOverrideDeployableProvider((deploymentService = DeploymentService.getInstance(project)).getDeployableProvider())) {
            deploymentService.setDeployableProvider(DeployActionsInitializer.getDeployTargetProvider(configSettings));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/android/tools/idea/deploy/DeployActionsInitializer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runActivity";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "updateDeployableProvider";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class MyFacetManagerAdapter
    extends FacetManagerAdapter {
        @NotNull
        private final Project myProject;

        public MyFacetManagerAdapter(@NotNull Project project) {
            if (project == null) {
                MyFacetManagerAdapter.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        public void beforeFacetRemoved(@NotNull Facet facet2) {
            if (facet2 == null) {
                MyFacetManagerAdapter.$$$reportNull$$$0(1);
            }
            RunnerAndConfigurationSettings selectedConfiguration = RunManager.getInstance((Project)this.myProject).getSelectedConfiguration();
            if (facet2 instanceof AndroidFacet && facet2.getModule() == DeployActionsInitializer.getModule(DeployActionsInitializer.getAndroidRunConfigurationbase(selectedConfiguration))) {
                DeployActionsInitializer.updateDeployableProvider(this.myProject, null);
            }
        }

        public void facetAdded(@NotNull Facet facet2) {
            if (facet2 == null) {
                MyFacetManagerAdapter.$$$reportNull$$$0(2);
            }
            RunnerAndConfigurationSettings selectedConfiguration = RunManager.getInstance((Project)this.myProject).getSelectedConfiguration();
            if (facet2 instanceof AndroidFacet && facet2.getModule() == DeployActionsInitializer.getModule(DeployActionsInitializer.getAndroidRunConfigurationbase(selectedConfiguration))) {
                DeployActionsInitializer.updateDeployableProvider(this.myProject, selectedConfiguration);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "facet";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/deploy/DeployActionsInitializer$MyFacetManagerAdapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeFacetRemoved";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "facetAdded";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class MyRunManagerListener
    implements RunManagerListener {
        @NotNull
        private final Project myProject;

        public MyRunManagerListener(@NotNull Project project) {
            if (project == null) {
                MyRunManagerListener.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        public void runConfigurationSelected(@Nullable RunnerAndConfigurationSettings settings) {
            DeployActionsInitializer.updateDeployableProvider(this.myProject, settings);
        }

        public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings, @Nullable String existingId) {
            if (settings == null) {
                MyRunManagerListener.$$$reportNull$$$0(1);
            }
            this.runConfigurationChanged(settings);
        }

        public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings) {
            if (settings == null) {
                MyRunManagerListener.$$$reportNull$$$0(2);
            }
            if (settings.getConfiguration() == RunManager.getInstance((Project)this.myProject).getSelectedConfiguration()) {
                DeployActionsInitializer.updateDeployableProvider(this.myProject, settings);
            }
        }

        public void runConfigurationRemoved(@NotNull RunnerAndConfigurationSettings settings) {
            if (settings == null) {
                MyRunManagerListener.$$$reportNull$$$0(3);
            }
            if (settings.getConfiguration() == RunManager.getInstance((Project)this.myProject).getSelectedConfiguration()) {
                DeployActionsInitializer.updateDeployableProvider(this.myProject, null);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/deploy/DeployActionsInitializer$MyRunManagerListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "runConfigurationChanged";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "runConfigurationRemoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

