/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.debug;

import com.android.tools.idea.debug.ResolveTypedIntegerCommand;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.BatchEvaluator;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRendererImpl;
import com.intellij.debugger.ui.tree.render.ToStringCommand;
import com.sun.jdi.IntegerType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;

public class AndroidTypedIntegerRenderer
extends NodeRendererImpl {
    private static final String ID = "android.resource.renderer";

    public AndroidTypedIntegerRenderer() {
        super("Android Typed Integer", true);
    }

    public String getUniqueId() {
        return ID;
    }

    public boolean isApplicable(Type type) {
        if (!(type instanceof IntegerType)) {
            return false;
        }
        return type.virtualMachine().name().startsWith("Dalvik");
    }

    public String calcLabel(ValueDescriptor descriptor2, EvaluationContext evaluationContext, DescriptorLabelListener listener2) throws EvaluateException {
        Value value2 = descriptor2.getValue();
        BatchEvaluator.getBatchEvaluator((DebugProcess)evaluationContext.getDebugProcess()).invoke((ToStringCommand)new ResolveTypedIntegerCommand(descriptor2, evaluationContext, value2, listener2));
        return value2.toString();
    }
}

