/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.actions;

import com.android.ddmlib.IDevice;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.avdmanager.EmulatorAdvFeatures;
import com.android.tools.idea.ddms.actions.Features;
import com.android.tools.idea.log.LogWrapper;
import com.android.tools.idea.run.DeviceStateCache;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.utils.ILogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;

final class CachedFeatures
implements Features {
    private final DeviceStateCache<CompletableFuture<DeviceFeatures>> myCache;

    CachedFeatures(@NotNull Disposable parent) {
        if (parent == null) {
            CachedFeatures.$$$reportNull$$$0(0);
        }
        this.myCache = new DeviceStateCache(parent);
    }

    @Override
    public boolean watch(@NotNull IDevice device) {
        if (device == null) {
            CachedFeatures.$$$reportNull$$$0(1);
        }
        return this.getFeatures((IDevice)device).myWatch;
    }

    @Override
    public boolean screenRecord(@NotNull IDevice device) {
        if (device == null) {
            CachedFeatures.$$$reportNull$$$0(2);
        }
        if (device.isEmulator()) {
            AndroidSdkHandler handler = AndroidSdks.getInstance().tryToChooseSdkHandler();
            StudioLoggerProgressIndicator indicator = new StudioLoggerProgressIndicator(CachedFeatures.class);
            LogWrapper logger2 = new LogWrapper(Logger.getInstance(CachedFeatures.class));
            return EmulatorAdvFeatures.emulatorSupportsScreenRecording(handler, (ProgressIndicator)indicator, (ILogger)logger2);
        }
        return this.getFeatures((IDevice)device).myScreenRecord;
    }

    @NotNull
    private DeviceFeatures getFeatures(@NotNull IDevice device) {
        CompletableFuture<DeviceFeatures> features;
        if (device == null) {
            CachedFeatures.$$$reportNull$$$0(3);
        }
        if ((features = this.myCache.get(device, "")) == null) {
            features = CompletableFuture.supplyAsync(() -> new DeviceFeatures(device));
            this.myCache.put(device, "", features);
        }
        DeviceFeatures deviceFeatures = features.getNow(new DeviceFeatures());
        if (deviceFeatures == null) {
            CachedFeatures.$$$reportNull$$$0(4);
        }
        return deviceFeatures;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/ddms/actions/CachedFeatures";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/ddms/actions/CachedFeatures";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFeatures";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "watch";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "screenRecord";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFeatures";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class DeviceFeatures {
        private final boolean myWatch;
        private final boolean myScreenRecord;

        private DeviceFeatures() {
            this(false, false);
        }

        private DeviceFeatures(@NotNull IDevice device) {
            if (device == null) {
                DeviceFeatures.$$$reportNull$$$0(0);
            }
            this(device.supportsFeature(IDevice.HardwareFeature.WATCH), device.supportsFeature(IDevice.Feature.SCREEN_RECORD));
        }

        private DeviceFeatures(boolean watch, boolean screenRecord) {
            this.myWatch = watch;
            this.myScreenRecord = screenRecord;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/ddms/actions/CachedFeatures$DeviceFeatures", "<init>"));
        }
    }
}

