/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding.util;

import com.android.tools.idea.databinding.util.DataBindingUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BrUtil {
    @NotNull
    private static Logger getLog() {
        Logger logger2 = Logger.getInstance(BrUtil.class);
        if (logger2 == null) {
            BrUtil.$$$reportNull$$$0(0);
        }
        return logger2;
    }

    @NotNull
    public static Set<String> collectIds(@NotNull Collection<? extends PsiModifierListOwner> psiElements) {
        if (psiElements == null) {
            BrUtil.$$$reportNull$$$0(1);
        }
        HashSet<String> properties = new HashSet<String>();
        for (PsiModifierListOwner psiModifierListOwner : psiElements) {
            String key = null;
            if (psiModifierListOwner instanceof PsiField) {
                key = DataBindingUtil.stripPrefixFromField((PsiField)psiModifierListOwner);
            } else if (psiModifierListOwner instanceof PsiMethod) {
                key = BrUtil.stripPrefixFromMethod((PsiMethod)psiModifierListOwner);
            }
            if (key == null) continue;
            properties.add(key);
        }
        HashSet<String> hashSet = properties;
        if (hashSet == null) {
            BrUtil.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    @Nullable
    private static String stripPrefixFromMethod(@NotNull PsiMethod psiMethod) {
        CharSequence propertyName;
        if (psiMethod == null) {
            BrUtil.$$$reportNull$$$0(3);
        }
        String name = psiMethod.getName();
        if (DataBindingUtil.isGetter(psiMethod) || DataBindingUtil.isSetter(psiMethod)) {
            propertyName = name.subSequence(3, name.length());
        } else if (DataBindingUtil.isBooleanGetter(psiMethod)) {
            propertyName = name.subSequence(2, name.length());
        } else {
            BrUtil.getLog().warn("@Bindable associated with a method must follow JavaBeans convention: " + psiMethod.getName());
            return null;
        }
        char firstChar = propertyName.charAt(0);
        return String.valueOf(Character.toLowerCase(firstChar)) + propertyName.subSequence(1, propertyName.length());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/databinding/util/BrUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElements";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/databinding/util/BrUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "collectIds";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "collectIds";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "stripPrefixFromMethod";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

