/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding.cache;

import com.android.tools.idea.databinding.LayoutBindingProjectComponent;
import com.android.tools.idea.databinding.cache.ResourceCacheValueProvider;
import com.google.common.collect.Maps;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectResourceCachedValueProvider<T, V>
implements CachedValueProvider<T>,
ModificationTracker {
    private Map<AndroidFacet, CachedValue<V>> myCachedValues = Maps.newHashMap();
    private final ModificationTracker[] myAdditionalTrackers;
    private List<ModificationTracker> myDependencies = new ArrayList<ModificationTracker>();
    private LayoutBindingProjectComponent myComponent;
    private long myDependencyModificationCountOnCompute;
    private long myModificationCount = 0L;

    public long getModificationCount() {
        long newCount = ProjectResourceCachedValueProvider.calculateModificationCountFrom(this.myDependencies);
        if (newCount != this.myDependencyModificationCountOnCompute) {
            ++this.myModificationCount;
        }
        return this.myModificationCount;
    }

    public ProjectResourceCachedValueProvider(LayoutBindingProjectComponent component3, ModificationTracker ... additionalTrackers) {
        this.myComponent = component3;
        this.myAdditionalTrackers = additionalTrackers;
    }

    @Nullable
    public final CachedValueProvider.Result<T> compute() {
        List<AndroidFacet> facets = this.getFacets();
        ArrayList<Object> values = new ArrayList<Object>();
        ArrayList<ModificationTracker> newDependencies = new ArrayList<ModificationTracker>();
        newDependencies.add(this.myComponent);
        Collections.addAll(newDependencies, this.myAdditionalTrackers);
        for (AndroidFacet facet2 : facets) {
            Object result2;
            CachedValue<V> cachedValue2 = this.getCachedValue(facet2);
            if (cachedValue2.getValueProvider() instanceof ModificationTracker) {
                newDependencies.add((ModificationTracker)cachedValue2.getValueProvider());
            }
            if ((result2 = cachedValue2.getValue()) == null) continue;
            values.add(result2);
        }
        this.myDependencies = Collections.unmodifiableList(newDependencies);
        this.myDependencyModificationCountOnCompute = ProjectResourceCachedValueProvider.calculateModificationCountFrom(this.myDependencies);
        return CachedValueProvider.Result.create(this.merge(values), (Object[])new Object[]{this});
    }

    @NotNull
    private List<AndroidFacet> getFacets() {
        List<AndroidFacet> viewBindingEnabledFacets = this.myComponent.getViewBindingEnabledFacets();
        if (viewBindingEnabledFacets.isEmpty()) {
            List<AndroidFacet> list = this.myComponent.getDataBindingEnabledFacets();
            if (list == null) {
                ProjectResourceCachedValueProvider.$$$reportNull$$$0(0);
            }
            return list;
        }
        List<AndroidFacet> list = viewBindingEnabledFacets;
        if (list == null) {
            ProjectResourceCachedValueProvider.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static long calculateModificationCountFrom(List<ModificationTracker> dependencies2) {
        long total = 0L;
        for (ModificationTracker tracker : dependencies2) {
            total += tracker.getModificationCount();
        }
        return total;
    }

    @NotNull
    protected abstract T merge(List<V> var1);

    private CachedValue<V> getCachedValue(AndroidFacet facet2) {
        CachedValue cachedValue2 = this.myCachedValues.get(facet2);
        if (cachedValue2 == null) {
            ResourceCacheValueProvider<V> cacheProvider = this.createCacheProvider(facet2);
            cachedValue2 = CachedValuesManager.getManager((Project)facet2.getModule().getProject()).createCachedValue(cacheProvider, false);
            this.myCachedValues.put(facet2, cachedValue2);
        }
        return cachedValue2;
    }

    protected abstract ResourceCacheValueProvider<V> createCacheProvider(AndroidFacet var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/cache/ProjectResourceCachedValueProvider", "getFacets"));
    }

    public static abstract class MergedMapValueProvider<A, B>
    extends ProjectResourceCachedValueProvider<Map<A, List<B>>, Map<A, List<B>>> {
        public MergedMapValueProvider(LayoutBindingProjectComponent component3, ModificationTracker ... additionalTrackers) {
            super(component3, additionalTrackers);
        }

        @Override
        @NotNull
        protected Map<A, List<B>> merge(List<Map<A, List<B>>> results) {
            HashMap merged = Maps.newHashMap();
            for (Map<A, List<B>> result2 : results) {
                for (Map.Entry<A, List<B>> entry : result2.entrySet()) {
                    ArrayList bList = (ArrayList)merged.get(entry.getKey());
                    if (bList == null) {
                        bList = new ArrayList();
                        merged.put(entry.getKey(), bList);
                    }
                    bList.addAll(entry.getValue());
                }
            }
            HashMap hashMap = merged;
            if (hashMap == null) {
                MergedMapValueProvider.$$$reportNull$$$0(0);
            }
            return hashMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/cache/ProjectResourceCachedValueProvider$MergedMapValueProvider", "merge"));
        }
    }
}

