/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.tools.adtui.actions.DropDownAction;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationAction;
import com.android.tools.idea.configurations.ConfigurationHolder;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.ThemeSelectionDialog;
import com.android.tools.idea.configurations.ThemeUtils;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.editors.theme.ThemeResolver;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredThemeEditorStyle;
import com.android.tools.idea.res.ResourceHelper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import icons.StudioIcons;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemeMenuAction
extends DropDownAction {
    private final ConfigurationHolder myRenderContext;

    public ThemeMenuAction(@NotNull ConfigurationHolder renderContext) {
        if (renderContext == null) {
            ThemeMenuAction.$$$reportNull$$$0(0);
        }
        super("Theme for Preview", "Theme for Preview", StudioIcons.LayoutEditor.Toolbar.THEME_BUTTON);
        this.myRenderContext = renderContext;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ThemeMenuAction.$$$reportNull$$$0(1);
        }
        super.update(e);
        this.updatePresentation(e.getPresentation());
    }

    public boolean displayTextInToolbar() {
        return true;
    }

    private void updatePresentation(Presentation presentation) {
        boolean visible;
        Configuration configuration = this.myRenderContext.getConfiguration();
        boolean bl = visible = configuration != null;
        if (visible) {
            String brief = ThemeMenuAction.getThemeLabel(configuration.getTheme(), true);
            this.getTemplatePresentation().setText(brief, false);
            presentation.setText(brief, false);
        }
        if (visible != presentation.isVisible()) {
            presentation.setVisible(visible);
        }
    }

    @NotNull
    public static String getThemeLabel(@Nullable String theme, boolean brief) {
        int index;
        if (theme == null) {
            return "";
        }
        theme = ResourceHelper.styleToTheme(theme);
        if (brief && (index = theme.lastIndexOf(46)) < theme.length() - 1) {
            String string = theme.substring(index + 1);
            if (string == null) {
                ThemeMenuAction.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = theme;
        if (string == null) {
            ThemeMenuAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    protected boolean updateActions(@NotNull DataContext context) {
        if (context == null) {
            ThemeMenuAction.$$$reportNull$$$0(4);
        }
        this.removeAll();
        this.addThemeActions();
        this.add((AnAction)new MoreThemesAction());
        return true;
    }

    private void addThemeActions() {
        Configuration conf = this.myRenderContext.getConfiguration();
        if (conf == null) {
            return;
        }
        ThemeResolver themeResolver = new ThemeResolver(this.myRenderContext.getConfiguration());
        StyleResourceValue[] baseThemes = themeResolver.requiredBaseThemes();
        String currentThemeName = this.getCurrentTheme();
        String defaultTheme = this.getDefaultTheme();
        if (defaultTheme != null) {
            String themeName = ThemeUtils.getPreferredThemeName(defaultTheme);
            this.add(new SetThemeAction(this.myRenderContext, themeName, themeName + " [default]", ThemeMenuAction.isSameTheme(defaultTheme, currentThemeName)));
            this.addSeparator();
        }
        ImmutableSet excludedThemes = defaultTheme != null ? ImmutableSet.of((Object)defaultTheme) : ImmutableSet.of();
        Function1<ConfiguredThemeEditorStyle, Boolean> filter2 = ThemeUtils.createFilter(themeResolver, (Set<String>)excludedThemes, baseThemes);
        List<String> projectThemeWithoutDefaultTheme = ThemeUtils.getProjectThemeNames(themeResolver, filter2);
        this.addThemes(projectThemeWithoutDefaultTheme, currentThemeName, false);
        List<String> recommendedThemes = ThemeUtils.getRecommendedThemeNames(themeResolver, filter2);
        this.addThemes(recommendedThemes, currentThemeName, true);
        Configuration config = this.myRenderContext.getConfiguration();
        if (config != null) {
            Project project = config.getModule().getProject();
            HashSet<String> existingThemes = new HashSet<String>();
            existingThemes.addAll((Collection<String>)excludedThemes);
            existingThemes.addAll(projectThemeWithoutDefaultTheme);
            existingThemes.addAll(recommendedThemes);
            List<String> recentUsedThemes = ThemeUtils.getRecentlyUsedThemes(project, existingThemes);
            this.addThemes(recentUsedThemes, currentThemeName, true);
        }
    }

    @Nullable
    private String getCurrentTheme() {
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration == null) {
            return null;
        }
        String theme = configuration.getTheme();
        theme = ThemeMenuAction.convertToNonResourcePrefixName(theme);
        return theme;
    }

    @Nullable
    private String getDefaultTheme() {
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration == null) {
            return null;
        }
        ConfigurationManager configurationManager = configuration.getConfigurationManager();
        String theme = configurationManager.computePreferredTheme(configuration);
        return ThemeMenuAction.convertToNonResourcePrefixName(theme);
    }

    private void addThemes(List<String> themes, @Nullable String currentSelectedTheme, boolean builtInTheme) {
        if (themes.isEmpty()) {
            return;
        }
        for (String theme : themes) {
            String displayName = ThemeMenuAction.getThemeLabel(theme);
            if (builtInTheme) {
                displayName = ThemeUtils.getPreferredThemeName(displayName);
            }
            this.add(new SetThemeAction(this.myRenderContext, theme, displayName, ThemeMenuAction.isSameTheme(theme, currentSelectedTheme)));
        }
        this.addSeparator();
    }

    @NotNull
    private static String getThemeLabel(@NotNull String theme) {
        if (theme == null) {
            ThemeMenuAction.$$$reportNull$$$0(5);
        }
        String string = ResolutionUtils.getNameFromQualifiedName(theme.substring(theme.indexOf(47) + 1));
        if (string == null) {
            ThemeMenuAction.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static boolean isSameTheme(@Nullable String left2, @Nullable String right2) {
        if (left2 == null) {
            return right2 == null;
        }
        return right2 != null && ThemeMenuAction.convertToNonResourcePrefixName(left2).equals(ThemeMenuAction.convertToNonResourcePrefixName(right2));
    }

    @NotNull
    private static String convertToNonResourcePrefixName(@NotNull String theme) {
        if (theme == null) {
            ThemeMenuAction.$$$reportNull$$$0(7);
        }
        if (theme.startsWith("@android:style/")) {
            theme = theme.replace("@android:style/", "android:");
        }
        if (theme.startsWith("@style/")) {
            theme = theme.replace("@style/", "");
        }
        String string = theme;
        if (string == null) {
            ThemeMenuAction.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/configurations/ThemeMenuAction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "theme";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/configurations/ThemeMenuAction";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getThemeLabel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToNonResourcePrefixName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateActions";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getThemeLabel";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "convertToNonResourcePrefixName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    public class MoreThemesAction
    extends DumbAwareAction {
        public MoreThemesAction() {
            super("More Themes...");
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            String theme;
            ThemeSelectionDialog dialog2;
            Configuration configuration;
            if (e == null) {
                MoreThemesAction.$$$reportNull$$$0(0);
            }
            if ((configuration = ThemeMenuAction.this.myRenderContext.getConfiguration()) != null && (dialog2 = new ThemeSelectionDialog(configuration)).showAndGet() && (theme = dialog2.getTheme()) != null) {
                configuration.setTheme(theme);
                ThemeUtils.addRecentlyUsedTheme(configuration.getModule().getProject(), theme);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/configurations/ThemeMenuAction$MoreThemesAction", "actionPerformed"));
        }
    }

    private class SetThemeAction
    extends ConfigurationAction {
        private final String myTheme;

        public SetThemeAction(@NotNull ConfigurationHolder configurationHolder, @NotNull String theme, String themeDisplayName, boolean selected) {
            if (configurationHolder == null) {
                SetThemeAction.$$$reportNull$$$0(0);
            }
            if (theme == null) {
                SetThemeAction.$$$reportNull$$$0(1);
            }
            if (themeDisplayName == null) {
                SetThemeAction.$$$reportNull$$$0(2);
            }
            super(configurationHolder, themeDisplayName);
            this.myTheme = theme;
            if (selected) {
                this.getTemplatePresentation().putClientProperty("selected", (Object)true);
            }
        }

        @Override
        protected void updatePresentation(@NotNull Presentation presentation) {
            if (presentation == null) {
                SetThemeAction.$$$reportNull$$$0(3);
            }
            ThemeMenuAction.this.updatePresentation(presentation);
        }

        @Override
        protected void updateConfiguration(@NotNull Configuration configuration, boolean commit) {
            if (configuration == null) {
                SetThemeAction.$$$reportNull$$$0(4);
            }
            configuration.setTheme(this.myTheme);
            if (ThemeUtils.getRecentlyUsedThemes(configuration.getModule().getProject()).contains(this.myTheme)) {
                ThemeUtils.addRecentlyUsedTheme(configuration.getModule().getProject(), this.myTheme);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurationHolder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "theme";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "themeDisplayName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/configurations/ThemeMenuAction$SetThemeAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updatePresentation";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateConfiguration";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

