/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceRepositoryUtil;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.ResourceValueMap;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.ide.common.util.DisjointUnionMap;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.rendering.multi.CompatibilityRenderTarget;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.utils.SparseArray;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Table;
import com.intellij.openapi.application.ReadAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceResolverCache {
    private final ConfigurationManager myManager;
    @VisibleForTesting
    final Map<String, ResourceResolver> myResolverMap = new HashMap<String, ResourceResolver>();
    @VisibleForTesting
    final Map<String, Table<ResourceNamespace, ResourceType, ResourceValueMap>> myAppResourceMap = new HashMap<String, Table<ResourceNamespace, ResourceType, ResourceValueMap>>();
    @VisibleForTesting
    final Map<String, Map<ResourceType, ResourceValueMap>> myFrameworkResourceMap = new HashMap<String, Map<ResourceType, ResourceValueMap>>();
    private long myCachedGeneration;
    private SparseArray<AndroidTargetData> myFrameworkResources = new SparseArray();
    private String myCustomConfigurationKey;
    private String myCustomResolverKey;

    public ResourceResolverCache(ConfigurationManager manager) {
        this.myManager = manager;
    }

    @NotNull
    public ResourceResolver getResourceResolver(@Nullable IAndroidTarget target, @NotNull String themeStyle, @NotNull FolderConfiguration fullConfiguration) {
        ResourceRepositoryManager repositoryManager;
        if (themeStyle == null) {
            ResourceResolverCache.$$$reportNull$$$0(0);
        }
        if (fullConfiguration == null) {
            ResourceResolverCache.$$$reportNull$$$0(1);
        }
        if ((repositoryManager = ResourceRepositoryManager.getInstance(this.myManager.getModule())) == null) {
            ResourceResolver resourceResolver2 = ResourceResolver.create(Collections.emptyMap(), null);
            if (resourceResolver2 == null) {
                ResourceResolverCache.$$$reportNull$$$0(2);
            }
            return resourceResolver2;
        }
        LocalResourceRepository resources = repositoryManager.getAppResources();
        if (this.myCachedGeneration != resources.getModificationCount()) {
            this.myResolverMap.clear();
            this.myAppResourceMap.clear();
        }
        this.myCachedGeneration = resources.getModificationCount();
        String qualifierString = fullConfiguration.getQualifierString();
        String resolverKey = ResourceResolverCache.getResolverKey(themeStyle, qualifierString);
        ResourceResolver resolver = this.myResolverMap.get(resolverKey);
        if (resolver == null) {
            if (target == null) {
                target = this.myManager.getTarget();
            }
            Map frameworkResources = target == null ? Collections.emptyMap() : this.getConfiguredFrameworkResources(target, fullConfiguration);
            Table configuredAppRes = this.myAppResourceMap.get(qualifierString);
            if (configuredAppRes == null) {
                configuredAppRes = (Table)ReadAction.compute(() -> ResourceRepositoryUtil.getConfiguredResources((ResourceRepository)resources, (FolderConfiguration)fullConfiguration));
                this.myAppResourceMap.put(qualifierString, (Table<ResourceNamespace, ResourceType, ResourceValueMap>)configuredAppRes);
            }
            DisjointUnionMap allResources = new DisjointUnionMap(Collections.singletonMap(ResourceNamespace.ANDROID, frameworkResources), configuredAppRes.rowMap());
            assert (themeStyle.startsWith("@")) : themeStyle;
            ResourceReference theme = null;
            ResourceUrl themeUrl = ResourceUrl.parse((String)themeStyle);
            if (themeUrl != null) {
                ResourceNamespace contextNamespace = (ResourceNamespace)ReadAction.compute(() -> repositoryManager.getNamespace());
                theme = themeUrl.resolve(contextNamespace, ResourceNamespace.Resolver.EMPTY_RESOLVER);
            }
            resolver = ResourceResolver.create((Map)allResources, theme);
            if (target instanceof CompatibilityRenderTarget) {
                int apiLevel = target.getVersion().getFeatureLevel();
                if (apiLevel >= 21) {
                    resolver.setDeviceDefaults("Material");
                } else if (apiLevel >= 14) {
                    resolver.setDeviceDefaults("Holo");
                } else {
                    resolver.setDeviceDefaults("");
                }
            }
            this.myResolverMap.put(resolverKey, resolver);
        }
        ResourceResolver resourceResolver3 = resolver;
        if (resourceResolver3 == null) {
            ResourceResolverCache.$$$reportNull$$$0(3);
        }
        return resourceResolver3;
    }

    public Map<ResourceType, ResourceValueMap> getConfiguredFrameworkResources(@NotNull IAndroidTarget target, @NotNull FolderConfiguration fullConfiguration) {
        ResourceRepository resourceRepository;
        if (target == null) {
            ResourceResolverCache.$$$reportNull$$$0(4);
        }
        if (fullConfiguration == null) {
            ResourceResolverCache.$$$reportNull$$$0(5);
        }
        if ((resourceRepository = this.getFrameworkResources(fullConfiguration, target)) == null) {
            return Collections.emptyMap();
        }
        String qualifierString = fullConfiguration.getQualifierString();
        Map frameworkResources = this.myFrameworkResourceMap.get(qualifierString);
        if (frameworkResources == null) {
            frameworkResources = ResourceRepositoryUtil.getConfiguredResources((ResourceRepository)resourceRepository, (FolderConfiguration)fullConfiguration).row((Object)ResourceNamespace.ANDROID);
            this.myFrameworkResourceMap.put(qualifierString, frameworkResources);
        }
        return frameworkResources;
    }

    @NotNull
    private static String getResolverKey(@NotNull String themeStyle, @NotNull String qualifierString) {
        if (themeStyle == null) {
            ResourceResolverCache.$$$reportNull$$$0(6);
        }
        if (qualifierString == null) {
            ResourceResolverCache.$$$reportNull$$$0(7);
        }
        Object object = qualifierString.isEmpty() ? themeStyle : themeStyle + "-" + qualifierString;
        if (object == null) {
            ResourceResolverCache.$$$reportNull$$$0(8);
        }
        return object;
    }

    @Nullable
    public ResourceRepository getFrameworkResources(@NotNull FolderConfiguration configuration, @NotNull IAndroidTarget target) {
        String language;
        LocaleQualifier locale;
        int apiLevel;
        AndroidTargetData targetData;
        if (configuration == null) {
            ResourceResolverCache.$$$reportNull$$$0(9);
        }
        if (target == null) {
            ResourceResolverCache.$$$reportNull$$$0(10);
        }
        if ((targetData = (AndroidTargetData)this.myFrameworkResources.get(apiLevel = target.getVersion().getFeatureLevel())) == null) {
            AndroidPlatform platform = AndroidPlatform.getInstance(this.myManager.getModule());
            if (platform == null) {
                return null;
            }
            targetData = platform.getSdkData().getTargetData(target);
            this.myFrameworkResources.put(apiLevel, (Object)targetData);
        }
        if ((locale = configuration.getLocaleQualifier()) == null) {
            locale = this.myManager.getLocale().qualifier;
        }
        ImmutableSet languages = (language = locale.getLanguage()) == null ? ImmutableSet.of() : ImmutableSet.of((Object)language);
        return targetData.getFrameworkResources((Set<String>)languages);
    }

    public void reset() {
        this.myCachedGeneration = 0L;
        this.myAppResourceMap.clear();
        this.myResolverMap.clear();
    }

    public void replaceCustomConfig(@NotNull String themeStyle, @NotNull FolderConfiguration fullConfiguration) {
        String qualifierString;
        String newCustomResolverKey;
        if (themeStyle == null) {
            ResourceResolverCache.$$$reportNull$$$0(11);
        }
        if (fullConfiguration == null) {
            ResourceResolverCache.$$$reportNull$$$0(12);
        }
        if ((newCustomResolverKey = ResourceResolverCache.getResolverKey(themeStyle, qualifierString = fullConfiguration.getQualifierString())).equals(this.myCustomResolverKey)) {
            return;
        }
        if (this.myCustomConfigurationKey != null) {
            this.myFrameworkResourceMap.remove(this.myCustomConfigurationKey);
            this.myAppResourceMap.remove(this.myCustomConfigurationKey);
        }
        if (this.myCustomResolverKey != null) {
            this.myResolverMap.remove(this.myCustomResolverKey);
        }
        this.myCustomConfigurationKey = qualifierString;
        this.myCustomResolverKey = newCustomResolverKey;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "themeStyle";
                break;
            }
            case 1: 
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullConfiguration";
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/configurations/ResourceResolverCache";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierString";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/configurations/ResourceResolverCache";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceResolver";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolverKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getResourceResolver";
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguredFrameworkResources";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getResolverKey";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFrameworkResources";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "replaceCustomConfig";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

