/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.surface;

import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.common.surface.InteractionInformation;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.api.ScrollHandler;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewEditorImpl;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseWheelEvent;
import java.util.EventObject;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScrollInteraction
extends Interaction {
    private static final int MAX_SCROLL_MULTIPLIER = 5;
    private final ScrollHandler myHandler;
    private int myScrolledAmount;
    private short myLastScrollSign;
    private int myScrollMultiplier = 1;
    private SceneView mySceneView;

    public ScrollInteraction(SceneView sceneView, ScrollHandler scrollHandler) {
        this.mySceneView = sceneView;
        this.myHandler = scrollHandler;
    }

    @Nullable
    public static ScrollInteraction createScrollInteraction(SceneView sceneView, NlComponent component3) {
        ViewGroupHandler viewGroupHandler;
        ViewHandler viewHandler;
        ScrollHandler scrollHandler = null;
        ViewEditorImpl editor2 = new ViewEditorImpl(sceneView);
        for (NlComponent currentComponent = component3; !(currentComponent == null || (viewHandler = NlComponentHelperKt.getViewHandler(currentComponent)) instanceof ViewGroupHandler && (scrollHandler = (viewGroupHandler = (ViewGroupHandler)viewHandler).createScrollHandler(editor2, currentComponent)) != null); currentComponent = currentComponent.getParent()) {
        }
        if (scrollHandler == null) {
            return null;
        }
        return new ScrollInteraction(sceneView, scrollHandler);
    }

    @Override
    public void begin(@Nullable EventObject event, @NotNull InteractionInformation interactionInformation) {
        if (interactionInformation == null) {
            ScrollInteraction.$$$reportNull$$$0(0);
        }
        assert (event instanceof MouseWheelEvent);
        MouseWheelEvent mouseEvent = (MouseWheelEvent)event;
        this.begin(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiersEx());
    }

    @Override
    public void update(@NotNull EventObject event, @NotNull InteractionInformation interactionInformation) {
        if (event == null) {
            ScrollInteraction.$$$reportNull$$$0(1);
        }
        if (interactionInformation == null) {
            ScrollInteraction.$$$reportNull$$$0(2);
        }
        if (event instanceof MouseWheelEvent) {
            MouseWheelEvent mouseWheelEvent = (MouseWheelEvent)event;
            int x = mouseWheelEvent.getX();
            int y = mouseWheelEvent.getY();
            int scrollAmount = mouseWheelEvent.getScrollType() == 0 ? mouseWheelEvent.getUnitsToScroll() : (mouseWheelEvent.getWheelRotation() < 0 ? -1 : 1);
            DesignSurface surface2 = this.mySceneView.getSurface();
            SceneView sceneView = surface2.getSceneView(x, y);
            if (sceneView == null) {
                mouseWheelEvent.getComponent().getParent().dispatchEvent(mouseWheelEvent);
                return;
            }
            NlComponent component3 = Coordinates.findComponent(sceneView, x, y);
            if (component3 == null) {
                mouseWheelEvent.getComponent().getParent().dispatchEvent(mouseWheelEvent);
                return;
            }
            if (!this.canScroll(scrollAmount)) {
                JScrollPane scrollPane = surface2.getScrollPane();
                JViewport viewport = scrollPane.getViewport();
                Dimension extentSize = viewport.getExtentSize();
                Dimension viewSize = viewport.getViewSize();
                if (viewSize.width > extentSize.width || viewSize.height > extentSize.height) {
                    mouseWheelEvent.getComponent().getParent().dispatchEvent(mouseWheelEvent);
                    return;
                }
            }
            this.scroll(x, y, scrollAmount);
        }
    }

    @Override
    public void scroll(int x, int y, int scrollAmount) {
        short currentScrollSign = (short)(scrollAmount < 0 ? -1 : 0);
        if (this.myLastScrollSign != currentScrollSign) {
            this.myScrollMultiplier = 1;
            this.myLastScrollSign = currentScrollSign;
        } else if (this.myScrollMultiplier < 5) {
            ++this.myScrollMultiplier;
        }
        int newScrolledAmount = this.myScrolledAmount + scrollAmount * this.myScrollMultiplier;
        int scrolled = this.myHandler.update(newScrolledAmount);
        if (scrolled != 0) {
            this.myScrolledAmount += scrollAmount;
            this.mySceneView.getSceneManager().requestLayoutAndRender(false);
        }
    }

    @Override
    public void commit(@Nullable EventObject event, @NotNull InteractionInformation interactionInformation) {
        if (interactionInformation == null) {
            ScrollInteraction.$$$reportNull$$$0(3);
        }
        this.end(interactionInformation.getX(), interactionInformation.getY(), interactionInformation.getModifiersEx());
    }

    @Override
    public void end(int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
        this.myScrollMultiplier = 1;
        this.myHandler.commit(this.myScrolledAmount);
        this.myScrolledAmount = 0;
    }

    @Override
    public void cancel(@Nullable EventObject event, @NotNull InteractionInformation interactionInformation) {
        if (interactionInformation == null) {
            ScrollInteraction.$$$reportNull$$$0(4);
        }
        this.cancel(interactionInformation.getX(), interactionInformation.getY(), interactionInformation.getModifiersEx());
    }

    @Override
    public void cancel(int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
        this.myHandler.update(0);
        this.mySceneView.getSceneManager().requestLayoutAndRender(false);
    }

    @Override
    @Nullable
    public Cursor getCursor() {
        return null;
    }

    public boolean canScroll(int scrollAmount) {
        return this.myHandler.canScroll(scrollAmount);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interactionInformation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/common/surface/ScrollInteraction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "begin";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "commit";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "cancel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

