/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.surface;

import com.android.tools.adtui.Pannable;
import com.android.tools.adtui.PannableKt;
import com.android.tools.adtui.Zoomable;
import com.android.tools.adtui.ZoomableKt;
import com.android.tools.adtui.actions.ZoomType;
import com.android.tools.editor.PanZoomListener;
import com.android.tools.idea.common.analytics.DesignerAnalyticsManager;
import com.android.tools.idea.common.editor.ActionManager;
import com.android.tools.idea.common.error.IssueModel;
import com.android.tools.idea.common.error.IssuePanel;
import com.android.tools.idea.common.error.LintIssueProvider;
import com.android.tools.idea.common.lint.LintAnnotationsModel;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.ItemTransferable;
import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionListener;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.DesignSurfaceActionHandler;
import com.android.tools.idea.common.surface.DesignSurfaceListener;
import com.android.tools.idea.common.surface.InteractionHandler;
import com.android.tools.idea.common.surface.InteractionManager;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.common.surface.SceneLayer;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.common.type.DefaultDesignerFileType;
import com.android.tools.idea.common.type.DesignerEditorFileType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationListener;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.ui.designer.EditorDesignSurface;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.Magnificator;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.concurrent.GuardedBy;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import javax.swing.plaf.ScrollBarUI;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DesignSurface
extends EditorDesignSurface
implements Disposable,
DataProvider,
Zoomable,
Pannable {
    private static final Predicate<NlModel> FILTER_DISPOSED_MODELS = input -> input != null && !input.getModule().isDisposed();
    private static final Predicate<SceneManager> FILTER_DISPOSED_SCENE_MANAGERS = input -> input != null && FILTER_DISPOSED_MODELS.apply((Object)input.getModel());
    private static final Integer LAYER_PROGRESS = JLayeredPane.POPUP_LAYER + 100;
    private final Project myProject;
    protected double myScale;
    @NotNull
    protected final JScrollPane myScrollPane;
    private final MyLayeredPane myLayeredPane;
    @VisibleForTesting
    @NotNull
    public ImmutableList<Layer> myLayers;
    private final InteractionManager myInteractionManager;
    private final GlassPane myGlassPane;
    protected final List<DesignSurfaceListener> myListeners;
    private List<PanZoomListener> myZoomListeners;
    private final ActionManager myActionManager;
    @NotNull
    private WeakReference<FileEditor> myFileEditorDelegate;
    private final ReentrantReadWriteLock myModelToSceneManagersLock;
    @GuardedBy(value="myModelToSceneManagersLock")
    private final LinkedHashMap<NlModel, SceneManager> myModelToSceneManagers;
    protected final JPanel myVisibleSurfaceLayerPanel;
    private final SelectionModel mySelectionModel;
    private final ModelListener myModelListener;
    protected final IssueModel myIssueModel;
    private final IssuePanel myIssuePanel;
    private final Object myErrorQueueLock;
    private MergingUpdateQueue myErrorQueue;
    private boolean myIsActive;
    private LintIssueProvider myLintIssueProvider;
    private final boolean myIsEditable;
    private boolean mySkipResizeContent;
    private boolean mySkipResizeContentOnce;
    private final ConfigurationListener myConfigurationListener;
    private ZoomType myCurrentZoomType;
    @NotNull
    private final DesignerAnalyticsManager myAnalyticsManager;
    @NotNull
    private State myState;
    @Nullable
    private StateChangeListener myStateChangeListener;
    private float myMaxFitIntoScale;
    private final Timer myRepaintTimer;
    private final List<ProgressIndicator> myProgressIndicators;
    private final MyProgressPanel myProgressPanel;

    public DesignSurface(@NotNull Project project, @NotNull Disposable parentDisposable, @NotNull Function<DesignSurface, ActionManager<? extends DesignSurface>> actionManagerProvider, @NotNull Function<DesignSurface, InteractionHandler> interactionProviderCreator, @NotNull State defaultSurfaceState, boolean isEditable) {
        if (project == null) {
            DesignSurface.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            DesignSurface.$$$reportNull$$$0(1);
        }
        if (actionManagerProvider == null) {
            DesignSurface.$$$reportNull$$$0(2);
        }
        if (interactionProviderCreator == null) {
            DesignSurface.$$$reportNull$$$0(3);
        }
        if (defaultSurfaceState == null) {
            DesignSurface.$$$reportNull$$$0(4);
        }
        super(new BorderLayout());
        this.myScale = 1.0;
        this.myLayers = ImmutableList.of();
        this.myListeners = new ArrayList<DesignSurfaceListener>();
        this.myFileEditorDelegate = new WeakReference<Object>(null);
        this.myModelToSceneManagersLock = new ReentrantReadWriteLock();
        this.myModelToSceneManagers = new LinkedHashMap();
        this.mySelectionModel = new SelectionModel();
        this.myModelListener = new ModelListener(){

            @Override
            public void modelChangedOnLayout(@NotNull NlModel model2, boolean animate) {
                if (model2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                DesignSurface.this.repaint();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/common/surface/DesignSurface$1", "modelChangedOnLayout"));
            }
        };
        this.myIssueModel = new IssueModel();
        this.myErrorQueueLock = new Object();
        this.myIsActive = false;
        this.myConfigurationListener = flags -> {
            if ((flags & 6) != 0 && !this.isLayoutDisabled()) {
                this.zoom(ZoomType.FIT_INTO, -1, -1);
            }
            return true;
        };
        this.myMaxFitIntoScale = Float.MAX_VALUE;
        this.myRepaintTimer = new Timer(15, actionEvent -> this.repaint());
        this.myProgressIndicators = new ArrayList<ProgressIndicator>();
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.myProject = project;
        this.myIsEditable = isEditable;
        this.myState = defaultSurfaceState;
        this.setOpaque(true);
        this.setFocusable(false);
        this.myAnalyticsManager = new DesignerAnalyticsManager(this);
        SelectionListener selectionListener = (model2, selection) -> {
            if (this.getFocusedSceneView() != null) {
                this.notifySelectionListeners(selection);
            } else {
                this.notifySelectionListeners(Collections.emptyList());
            }
        };
        this.mySelectionModel.addListener(selectionListener);
        this.myInteractionManager = new InteractionManager(this, interactionProviderCreator.apply(this));
        this.myLayeredPane = new MyLayeredPane();
        this.myLayeredPane.setFocusable(true);
        this.myLayeredPane.setBounds(0, 0, 100, 100);
        this.myGlassPane = new GlassPane();
        this.myLayeredPane.add((Component)this.myGlassPane, JLayeredPane.DRAG_LAYER);
        this.myProgressPanel = new MyProgressPanel();
        this.myProgressPanel.setName("Layout Editor Progress Panel");
        this.myLayeredPane.add((Component)this.myProgressPanel, LAYER_PROGRESS);
        this.myVisibleSurfaceLayerPanel = new MyVisibleSurfaceLayerPane();
        this.myVisibleSurfaceLayerPanel.setLayout(new BorderLayout());
        this.myVisibleSurfaceLayerPanel.setBounds(0, 0, 100, 100);
        this.myLayeredPane.add((Component)this.myVisibleSurfaceLayerPanel, JLayeredPane.POPUP_LAYER);
        this.myScrollPane = new MyScrollPane();
        this.myScrollPane.setViewportView(this.myLayeredPane);
        this.myScrollPane.setBorder(null);
        this.myScrollPane.setVerticalScrollBarPolicy(22);
        this.myScrollPane.setHorizontalScrollBarPolicy(32);
        this.myScrollPane.getHorizontalScrollBar().addAdjustmentListener(this::notifyPanningChanged);
        this.myScrollPane.getVerticalScrollBar().addAdjustmentListener(this::notifyPanningChanged);
        this.myScrollPane.getViewport().setBackground(this.getBackground());
        this.myIssuePanel = new IssuePanel(this, this.myIssueModel);
        Disposer.register((Disposable)this, (Disposable)this.myIssuePanel);
        this.add(this.myScrollPane);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                boolean scaled = false;
                if (DesignSurface.this.isShowing() && DesignSurface.this.getWidth() > 0 && DesignSurface.this.getHeight() > 0 && !DesignSurface.this.contentResizeSkipped()) {
                    scaled = DesignSurface.this.zoomToFit();
                }
                if (!scaled) {
                    DesignSurface.this.layoutContent();
                    DesignSurface.this.updateScrolledAreaSize();
                }
                DesignSurface.this.getSceneManagers().forEach(it -> it.getScene().needsRebuildList());
            }
        });
        this.myInteractionManager.startListening();
        this.myActionManager = actionManagerProvider.apply(this);
        this.myActionManager.registerActionsShortcuts(this.myLayeredPane);
        this.myVisibleSurfaceLayerPanel.add((Component)this.myActionManager.createDesignSurfaceToolbar(), "East");
    }

    public float getScreenScalingFactor() {
        return 1.0f;
    }

    @NotNull
    protected abstract SceneManager createSceneManager(@NotNull NlModel var1);

    public abstract void layoutContent();

    public JPanel getAccessoryPanel() {
        return null;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            DesignSurface.$$$reportNull$$$0(5);
        }
        return project;
    }

    @NotNull
    public DesignerEditorFileType getLayoutType() {
        NlModel model2 = this.getModel();
        DesignerEditorFileType designerEditorFileType = model2 == null ? DefaultDesignerFileType.INSTANCE : model2.getType();
        if (designerEditorFileType == null) {
            DesignSurface.$$$reportNull$$$0(6);
        }
        return designerEditorFileType;
    }

    @NotNull
    public ActionManager getActionManager() {
        ActionManager actionManager = this.myActionManager;
        if (actionManager == null) {
            DesignSurface.$$$reportNull$$$0(7);
        }
        return actionManager;
    }

    public SelectionModel getSelectionModel() {
        return this.mySelectionModel;
    }

    @NotNull
    public abstract ItemTransferable getSelectionAsTransferable();

    @Deprecated
    @Nullable
    public NlModel getModel() {
        return (NlModel)Iterables.getFirst(this.getModels(), null);
    }

    @NotNull
    public ImmutableList<NlModel> getModels() {
        this.myModelToSceneManagersLock.readLock().lock();
        ImmutableList immutableList = ImmutableList.copyOf((Collection)Sets.filter(this.myModelToSceneManagers.keySet(), FILTER_DISPOSED_MODELS));
        ImmutableList immutableList2 = immutableList;
        if (immutableList2 == null) {
            DesignSurface.$$$reportNull$$$0(8);
        }
        return immutableList2;
        finally {
            this.myModelToSceneManagersLock.readLock().unlock();
        }
    }

    @NotNull
    protected ImmutableList<SceneManager> getSceneManagers() {
        this.myModelToSceneManagersLock.readLock().lock();
        ImmutableList immutableList = ImmutableList.copyOf((Collection)Collections2.filter(this.myModelToSceneManagers.values(), FILTER_DISPOSED_SCENE_MANAGERS));
        ImmutableList immutableList2 = immutableList;
        if (immutableList2 == null) {
            DesignSurface.$$$reportNull$$$0(9);
        }
        return immutableList2;
        finally {
            this.myModelToSceneManagersLock.readLock().unlock();
        }
    }

    @NotNull
    private SceneManager addModelImpl(@NotNull NlModel model2) {
        SceneManager manager;
        if (model2 == null) {
            DesignSurface.$$$reportNull$$$0(10);
        }
        if ((manager = this.getSceneManager(model2)) != null) {
            SceneManager sceneManager = manager;
            if (sceneManager == null) {
                DesignSurface.$$$reportNull$$$0(11);
            }
            return sceneManager;
        }
        model2.addListener(this.myModelListener);
        model2.getConfiguration().addListener(this.myConfigurationListener);
        manager = this.createSceneManager(model2);
        this.myModelToSceneManagersLock.writeLock().lock();
        try {
            this.myModelToSceneManagers.put(model2, manager);
        }
        finally {
            this.myModelToSceneManagersLock.writeLock().unlock();
        }
        if (this.myIsActive) {
            model2.activate((Object)this);
        }
        SceneManager sceneManager = manager;
        if (sceneManager == null) {
            DesignSurface.$$$reportNull$$$0(12);
        }
        return sceneManager;
    }

    @NotNull
    public CompletableFuture<Void> addModel(@NotNull NlModel model2) {
        if (model2 == null) {
            DesignSurface.$$$reportNull$$$0(13);
        }
        SceneManager modelSceneManager = this.addModelImpl(model2);
        CompletionStage completionStage = modelSceneManager.requestRender().whenCompleteAsync((result2, ex) -> {
            this.reactivateInteractionManager();
            for (DesignSurfaceListener listener2 : ImmutableList.copyOf(this.myListeners)) {
                listener2.modelChanged(this, model2);
            }
        }, (Executor)EdtExecutorService.getInstance());
        if (completionStage == null) {
            DesignSurface.$$$reportNull$$$0(14);
        }
        return completionStage;
    }

    private boolean removeModelImpl(@NotNull NlModel model2) {
        SceneManager manager;
        if (model2 == null) {
            DesignSurface.$$$reportNull$$$0(15);
        }
        this.myModelToSceneManagersLock.writeLock().lock();
        try {
            manager = (SceneManager)this.myModelToSceneManagers.remove(model2);
        }
        finally {
            this.myModelToSceneManagersLock.writeLock().unlock();
        }
        if (manager == null) {
            return false;
        }
        model2.deactivate((Object)this);
        model2.getConfiguration().removeListener(this.myConfigurationListener);
        model2.removeListener(this.myModelListener);
        this.removeLayers(manager.getLayers());
        Disposer.dispose((Disposable)manager);
        return true;
    }

    public void removeModel(@NotNull NlModel model2) {
        if (model2 == null) {
            DesignSurface.$$$reportNull$$$0(16);
        }
        if (!this.removeModelImpl(model2)) {
            return;
        }
        this.reactivateInteractionManager();
    }

    public CompletableFuture<Void> setModel(@Nullable NlModel model2) {
        NlModel oldModel = this.getModel();
        if (model2 == oldModel) {
            return CompletableFuture.completedFuture(null);
        }
        if (oldModel != null) {
            this.removeModelImpl(oldModel);
        }
        if (model2 == null) {
            return CompletableFuture.completedFuture(null);
        }
        this.addModelImpl(model2);
        this.zoomToFit();
        return this.requestRender().whenCompleteAsync((result2, ex) -> {
            this.reactivateInteractionManager();
            this.zoomToFit();
            for (DesignSurfaceListener listener2 : ImmutableList.copyOf(this.myListeners)) {
                listener2.modelChanged(this, model2);
            }
        }, (Executor)EdtExecutorService.getInstance());
    }

    private void reactivateInteractionManager() {
        if (this.isEditable()) {
            this.myInteractionManager.startListening();
        } else {
            this.myInteractionManager.stopListening();
        }
    }

    public void dispose() {
        this.myInteractionManager.stopListening();
        for (NlModel model2 : this.getModels()) {
            model2.getConfiguration().removeListener(this.myConfigurationListener);
            model2.removeListener(this.myModelListener);
        }
    }

    @Nullable
    protected abstract Dimension getScrolledAreaSize();

    public void updateScrolledAreaSize() {
        Dimension dimension2 = this.getScrolledAreaSize();
        if (dimension2 == null) {
            return;
        }
        this.myLayeredPane.setSize(dimension2.width, dimension2.height);
        this.myLayeredPane.setPreferredSize(dimension2);
        this.myScrollPane.revalidate();
        SceneView view = this.getFocusedSceneView();
        if (view != null) {
            this.myProgressPanel.setBounds(view.getX(), view.getY(), view.getSize().width, view.getSize().height);
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myGlassPane;
    }

    public final void setState(@NotNull State state) {
        if (state == null) {
            DesignSurface.$$$reportNull$$$0(17);
        }
        this.myState = state;
        if (this.myStateChangeListener != null) {
            this.myStateChangeListener.onStateChange(state);
        }
    }

    @NotNull
    public final State getState() {
        State state = this.myState;
        if (state == null) {
            DesignSurface.$$$reportNull$$$0(18);
        }
        return state;
    }

    public void setStateChangeListener(@Nullable StateChangeListener stateChangeListener) {
        this.myStateChangeListener = stateChangeListener;
    }

    public void needsRepaint() {
        if (!this.myRepaintTimer.isRunning()) {
            this.myRepaintTimer.setRepeats(false);
            this.myRepaintTimer.start();
        }
    }

    @Nullable
    public SceneView getFocusedSceneView() {
        NlComponent primary;
        SceneManager manager;
        ImmutableList<SceneManager> managers = this.getSceneManagers();
        if (managers.size() == 1) {
            SceneManager manager2 = this.getSceneManager();
            assert (manager2 != null);
            return manager2.getSceneView();
        }
        ImmutableList<NlComponent> selection = this.mySelectionModel.getSelection();
        if (!selection.isEmpty() && (manager = this.getSceneManager((primary = (NlComponent)selection.get(0)).getModel())) != null) {
            return manager.getSceneView();
        }
        return null;
    }

    public void startDragDropInteraction() {
        for (Layer layer : this.myLayers) {
            SceneLayer sceneLayer;
            if (!(layer instanceof SceneLayer) || (sceneLayer = (SceneLayer)layer).isShowOnHover()) continue;
            sceneLayer.setShowOnHover(true);
            this.repaint();
        }
    }

    public void stopDragDropInteraction() {
        for (Layer layer : this.myLayers) {
            SceneLayer sceneLayer;
            if (!(layer instanceof SceneLayer) || !(sceneLayer = (SceneLayer)layer).isShowOnHover()) continue;
            sceneLayer.setShowOnHover(false);
            this.repaint();
        }
    }

    public boolean zoom(@NotNull ZoomType type) {
        if (type == null) {
            DesignSurface.$$$reportNull$$$0(19);
        }
        this.myAnalyticsManager.trackZoom(type);
        return this.zoom(type, -1, -1);
    }

    public void setPanning(boolean isPanning) {
        this.myInteractionManager.setPanning(isPanning);
    }

    public boolean zoom(@NotNull ZoomType type, int x, int y) {
        boolean scaled;
        SceneComponent component3;
        Scene scene;
        if (type == null) {
            DesignSurface.$$$reportNull$$$0(20);
        }
        SceneView view = this.getFocusedSceneView();
        if (!(type != ZoomType.IN || x >= 0 && y >= 0 || view == null || this.getSelectionModel().isEmpty() || (scene = this.getScene()) == null || (component3 = scene.getSceneComponent(this.getSelectionModel().getPrimary())) == null)) {
            x = Coordinates.getSwingXDip(view, component3.getCenterX());
            y = Coordinates.getSwingYDip(view, component3.getCenterY());
        }
        switch (type) {
            case IN: {
                double currentScale = this.myScale * (double)this.getScreenScalingFactor();
                int current = (int)Math.round(currentScale * 100.0);
                double scale = (double)ZoomType.zoomIn((int)current) / 100.0 / (double)this.getScreenScalingFactor();
                scaled = this.setScale(scale, x, y);
                break;
            }
            case OUT: {
                double currentScale = this.myScale * (double)this.getScreenScalingFactor();
                int current = (int)(currentScale * 100.0);
                double scale = (double)ZoomType.zoomOut((int)current) / 100.0 / (double)this.getScreenScalingFactor();
                scaled = this.setScale(scale, x, y);
                break;
            }
            case ACTUAL: {
                scaled = this.setScale(1.0 / (double)this.getScreenScalingFactor());
                this.myCurrentZoomType = type;
                break;
            }
            case FIT: 
            case FIT_INTO: {
                scaled = this.setScale(this.getFitScale(type == ZoomType.FIT_INTO));
                this.myCurrentZoomType = type;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not yet implemented: " + type);
            }
        }
        if (scaled) {
            this.repaint();
        }
        return scaled;
    }

    protected double getFitScale(boolean fitInto) {
        int availableWidth = this.myScrollPane.getWidth() - this.myScrollPane.getVerticalScrollBar().getWidth();
        int availableHeight = this.myScrollPane.getHeight() - this.myScrollPane.getHorizontalScrollBar().getHeight();
        return this.getFitScale(this.getPreferredContentSize(availableWidth, availableHeight), fitInto);
    }

    @VisibleForTesting
    public double getFitScale(Dimension size, boolean fitInto) {
        int availableWidth = this.myScrollPane.getWidth() - this.myScrollPane.getVerticalScrollBar().getWidth();
        int availableHeight = this.myScrollPane.getHeight() - this.myScrollPane.getHorizontalScrollBar().getHeight();
        Dimension padding = this.getDefaultOffset();
        double scaleX = size.width == 0 ? 1.0 : (double)(availableWidth -= padding.width) / (double)size.width;
        double scaleY = size.height == 0 ? 1.0 : (double)(availableHeight -= padding.height) / (double)size.height;
        double scale = Math.min(scaleX, scaleY);
        if (fitInto) {
            double min2 = 1.0 / (double)this.getScreenScalingFactor();
            scale = Math.min(min2, scale);
        }
        scale = Math.min(scale, (double)this.myMaxFitIntoScale);
        return scale;
    }

    protected abstract Dimension getDefaultOffset();

    @NotNull
    protected abstract Dimension getPreferredContentSize(int var1, int var2);

    public boolean zoomToFit() {
        return this.zoom(ZoomType.FIT, -1, -1);
    }

    public double getScale() {
        return this.myScale;
    }

    public boolean isPanning() {
        return this.myInteractionManager.isPanning();
    }

    public boolean isPannable() {
        return true;
    }

    public boolean canZoomIn() {
        return this.getScale() < this.getMaxScale();
    }

    public boolean canZoomOut() {
        return this.getScale() > this.getMinScale();
    }

    public boolean canZoomToFit() {
        return true;
    }

    public boolean canZoomToActual() {
        return this.myScale > 1.0 && this.canZoomOut() || this.myScale < 1.0 && this.canZoomIn();
    }

    public abstract void scrollToCenter(@NotNull List<NlComponent> var1);

    public void setScrollPosition(int x, int y) {
        this.setScrollPosition(new Point(x, y));
    }

    public void setScrollPosition(Point p) {
        Dimension extent = this.myScrollPane.getViewport().getExtentSize();
        Dimension view = this.myScrollPane.getViewport().getViewSize();
        p.setLocation(Math.max(0, Math.min(view.width - extent.width, p.x)), Math.max(0, Math.min(view.height - extent.height, p.y)));
        this.myScrollPane.getViewport().setViewPosition(p);
    }

    public Point getScrollPosition() {
        return this.myScrollPane.getViewport().getViewPosition();
    }

    public boolean setScale(double scale) {
        return this.setScale(scale, -1, -1);
    }

    @VisibleForTesting
    public boolean setScale(double scale, int x, int y) {
        double newScale = Math.min(Math.max(scale, this.getMinScale()), this.getMaxScale());
        if (Math.abs(newScale - this.myScale) < 0.005 / (double)this.getScreenScalingFactor()) {
            return false;
        }
        this.myCurrentZoomType = null;
        Point oldViewPosition = this.getScrollPosition();
        if (x < 0 || y < 0) {
            x = oldViewPosition.x + this.myScrollPane.getWidth() / 2;
            y = oldViewPosition.y + this.myScrollPane.getHeight() / 2;
        }
        SceneView view = this.getFocusedSceneView();
        int androidX = 0;
        int androidY = 0;
        if (view != null) {
            androidX = Coordinates.getAndroidXDip(view, x);
            androidY = Coordinates.getAndroidYDip(view, y);
        }
        this.myScale = newScale;
        this.layoutContent();
        this.updateScrolledAreaSize();
        if (view != null) {
            int shiftedX = Coordinates.getSwingXDip(view, androidX);
            int shiftedY = Coordinates.getSwingYDip(view, androidY);
            this.myScrollPane.getViewport().setViewPosition(new Point(oldViewPosition.x + shiftedX - x, oldViewPosition.y + shiftedY - y));
        }
        this.notifyScaleChanged();
        return true;
    }

    protected double getMinScale() {
        return 0.0;
    }

    protected double getMaxScale() {
        return 1.0;
    }

    private void notifyScaleChanged() {
        if (this.myZoomListeners != null) {
            for (PanZoomListener myZoomListener : this.myZoomListeners) {
                myZoomListener.zoomChanged();
            }
        }
    }

    private void notifyPanningChanged(AdjustmentEvent adjustmentEvent) {
        if (this.myZoomListeners != null) {
            for (PanZoomListener myZoomListener : this.myZoomListeners) {
                myZoomListener.panningChanged(adjustmentEvent);
            }
        }
    }

    @NotNull
    public JComponent getLayeredPane() {
        MyLayeredPane myLayeredPane = this.myLayeredPane;
        if (myLayeredPane == null) {
            DesignSurface.$$$reportNull$$$0(21);
        }
        return myLayeredPane;
    }

    @NotNull
    public DesignerAnalyticsManager getAnalyticsManager() {
        DesignerAnalyticsManager designerAnalyticsManager = this.myAnalyticsManager;
        if (designerAnalyticsManager == null) {
            DesignSurface.$$$reportNull$$$0(22);
        }
        return designerAnalyticsManager;
    }

    protected void notifySelectionListeners(@NotNull List<NlComponent> newSelection) {
        if (newSelection == null) {
            DesignSurface.$$$reportNull$$$0(23);
        }
        ArrayList listeners = Lists.newArrayList(this.myListeners);
        for (DesignSurfaceListener listener2 : listeners) {
            listener2.componentSelectionChanged(this, newSelection);
        }
    }

    public void notifyComponentActivate(@NotNull NlComponent component3, int x, int y) {
        if (component3 == null) {
            DesignSurface.$$$reportNull$$$0(24);
        }
        this.notifyComponentActivate(component3);
    }

    public void notifyComponentActivate(@NotNull NlComponent component3) {
        if (component3 == null) {
            DesignSurface.$$$reportNull$$$0(25);
        }
        this.activatePreferredEditor(component3);
    }

    @NotNull
    public abstract Consumer<NlComponent> getComponentRegistrar();

    protected void activatePreferredEditor(@NotNull NlComponent component3) {
        if (component3 == null) {
            DesignSurface.$$$reportNull$$$0(26);
        }
        for (DesignSurfaceListener listener2 : new ArrayList<DesignSurfaceListener>(this.myListeners)) {
            if (listener2.activatePreferredEditor(this, component3)) break;
        }
    }

    public void addListener(@NotNull DesignSurfaceListener listener2) {
        if (listener2 == null) {
            DesignSurface.$$$reportNull$$$0(27);
        }
        this.myListeners.remove(listener2);
        this.myListeners.add(listener2);
    }

    public void removeListener(@NotNull DesignSurfaceListener listener2) {
        if (listener2 == null) {
            DesignSurface.$$$reportNull$$$0(28);
        }
        this.myListeners.remove(listener2);
    }

    public void addPanZoomListener(PanZoomListener listener2) {
        if (this.myZoomListeners == null) {
            this.myZoomListeners = new ArrayList<PanZoomListener>();
        } else {
            this.myZoomListeners.remove(listener2);
        }
        this.myZoomListeners.add(listener2);
    }

    public void removePanZoomListener(PanZoomListener listener2) {
        if (this.myZoomListeners != null) {
            this.myZoomListeners.remove(listener2);
        }
    }

    public void activate() {
        if (Disposer.isDisposed((Disposable)this)) {
            return;
        }
        if (!this.myIsActive) {
            for (NlModel model2 : this.getModels()) {
                model2.activate((Object)this);
            }
        }
        this.myIsActive = true;
    }

    public void deactivate() {
        if (this.myIsActive) {
            for (NlModel model2 : this.getModels()) {
                model2.deactivate((Object)this);
            }
        }
        this.myIsActive = false;
        this.myInteractionManager.cancelInteraction();
    }

    public void setFileEditorDelegate(@Nullable FileEditor fileEditor) {
        this.myFileEditorDelegate = new WeakReference<FileEditor>(fileEditor);
    }

    @Nullable
    public SceneView getSceneView(int x, int y) {
        return this.getFocusedSceneView();
    }

    @NotNull
    public abstract Rectangle getRenderableBoundsForInvisibleComponents(@NotNull SceneView var1, @Nullable Rectangle var2);

    @Nullable
    public SceneView getHoverSceneView(int x, int y) {
        return this.getFocusedSceneView();
    }

    @Nullable
    public Scene getScene() {
        SceneManager sceneManager = this.getSceneManager();
        return sceneManager != null ? sceneManager.getScene() : null;
    }

    @Nullable
    public SceneManager getSceneManager() {
        NlModel model2 = this.getModel();
        return model2 != null ? this.getSceneManager(model2) : null;
    }

    @Nullable
    public SceneManager getSceneManager(@NotNull NlModel model2) {
        if (model2 == null) {
            DesignSurface.$$$reportNull$$$0(29);
        }
        if (model2.getModule().isDisposed()) {
            return null;
        }
        this.myModelToSceneManagersLock.readLock().lock();
        try {
            SceneManager sceneManager = this.myModelToSceneManagers.get(model2);
            return sceneManager;
        }
        finally {
            this.myModelToSceneManagersLock.readLock().unlock();
        }
    }

    public void setSkipResizeContent(boolean skipLayout) {
        this.mySkipResizeContent = skipLayout;
    }

    public void skipContentResizeOnce() {
        this.mySkipResizeContentOnce = true;
    }

    public boolean isSkipContentResize() {
        return this.mySkipResizeContent || this.mySkipResizeContentOnce || this.myCurrentZoomType != ZoomType.FIT;
    }

    protected boolean contentResizeSkipped() {
        boolean skip = this.isSkipContentResize();
        this.mySkipResizeContentOnce = false;
        return skip;
    }

    public CompletableFuture<?> goingToSetModel(NlModel model2) {
        return CompletableFuture.completedFuture(null);
    }

    @NotNull
    public InteractionManager getInteractionManager() {
        InteractionManager interactionManager = this.myInteractionManager;
        if (interactionManager == null) {
            DesignSurface.$$$reportNull$$$0(30);
        }
        return interactionManager;
    }

    protected boolean getSupportPinchAndZoom() {
        return true;
    }

    public boolean isEditable() {
        return this.getLayoutType().isEditable() && this.myIsEditable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerIndicator(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            DesignSurface.$$$reportNull$$$0(31);
        }
        if (this.myProject.isDisposed() || Disposer.isDisposed((Disposable)this)) {
            return;
        }
        List<ProgressIndicator> list = this.myProgressIndicators;
        synchronized (list) {
            this.myProgressIndicators.add(indicator);
            this.myProgressPanel.showProgressIcon();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterIndicator(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            DesignSurface.$$$reportNull$$$0(32);
        }
        List<ProgressIndicator> list = this.myProgressIndicators;
        synchronized (list) {
            this.myProgressIndicators.remove(indicator);
            if (this.myProgressIndicators.isEmpty()) {
                this.myProgressPanel.hideProgressIcon();
            }
        }
    }

    protected boolean useSmallProgressIcon() {
        return true;
    }

    @NotNull
    public CompletableFuture<Void> requestRender() {
        ImmutableList<SceneManager> managers = this.getSceneManagers();
        if (managers.isEmpty()) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                DesignSurface.$$$reportNull$$$0(33);
            }
            return completableFuture;
        }
        CompletableFuture<Void> completableFuture = CompletableFuture.allOf((CompletableFuture[])managers.stream().map(manager -> manager.requestRender()).toArray(CompletableFuture[]::new));
        if (completableFuture == null) {
            DesignSurface.$$$reportNull$$$0(34);
        }
        return completableFuture;
    }

    @NotNull
    public JScrollPane getScrollPane() {
        JScrollPane jScrollPane = this.myScrollPane;
        if (jScrollPane == null) {
            DesignSurface.$$$reportNull$$$0(35);
        }
        return jScrollPane;
    }

    public void setDesignToolTip(@Nullable String text) {
        this.myLayeredPane.setToolTipText(text);
    }

    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            DesignSurface.$$$reportNull$$$0(36);
        }
        if (ZoomableKt.ZOOMABLE_KEY.is(dataId) || PannableKt.PANNABLE_KEY.is(dataId)) {
            return this;
        }
        if (PlatformDataKeys.FILE_EDITOR.is(dataId)) {
            return this.myFileEditorDelegate.get();
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId) || PlatformDataKeys.CUT_PROVIDER.is(dataId) || PlatformDataKeys.COPY_PROVIDER.is(dataId) || PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return this.createActionHandler();
        }
        if (PlatformDataKeys.CONTEXT_MENU_POINT.is(dataId)) {
            SceneView view = this.getFocusedSceneView();
            NlComponent selection = this.getSelectionModel().getPrimary();
            Scene scene = this.getScene();
            if (view == null || scene == null || selection == null) {
                return null;
            }
            SceneComponent sceneComponent = scene.getSceneComponent(selection);
            if (sceneComponent == null) {
                return null;
            }
            return new Point(Coordinates.getSwingXDip(view, sceneComponent.getCenterX()), Coordinates.getSwingYDip(view, sceneComponent.getCenterY()));
        }
        return this.myLayeredPane.getData(dataId);
    }

    @NotNull
    protected abstract DesignSurfaceActionHandler createActionHandler();

    public abstract boolean isLayoutDisabled();

    @Override
    @NotNull
    public ImmutableCollection<Configuration> getConfigurations() {
        ImmutableCollection immutableCollection = (ImmutableCollection)this.getModels().stream().map(NlModel::getConfiguration).collect(ImmutableList.toImmutableList());
        if (immutableCollection == null) {
            DesignSurface.$$$reportNull$$$0(37);
        }
        return immutableCollection;
    }

    @NotNull
    public IssueModel getIssueModel() {
        IssueModel issueModel = this.myIssueModel;
        if (issueModel == null) {
            DesignSurface.$$$reportNull$$$0(38);
        }
        return issueModel;
    }

    public void setLintAnnotationsModel(@NotNull LintAnnotationsModel model2) {
        if (model2 == null) {
            DesignSurface.$$$reportNull$$$0(39);
        }
        if (this.myLintIssueProvider != null) {
            this.myLintIssueProvider.setLintAnnotationsModel(model2);
        } else {
            this.myLintIssueProvider = new LintIssueProvider(model2);
            this.getIssueModel().addIssueProvider(this.myLintIssueProvider);
        }
    }

    @NotNull
    public IssuePanel getIssuePanel() {
        IssuePanel issuePanel = this.myIssuePanel;
        if (issuePanel == null) {
            DesignSurface.$$$reportNull$$$0(40);
        }
        return issuePanel;
    }

    public void setShowIssuePanel(boolean show) {
        UIUtil.invokeLaterIfNeeded(() -> {
            this.myIssuePanel.setMinimized(!show);
            this.revalidate();
            this.repaint();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    protected MergingUpdateQueue getErrorQueue() {
        Object object = this.myErrorQueueLock;
        // MONITORENTER : object
        if (this.myErrorQueue == null) {
            this.myErrorQueue = new MergingUpdateQueue("android.error.computation", 200, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
        }
        MergingUpdateQueue mergingUpdateQueue = this.myErrorQueue;
        // MONITOREXIT : object
        if (mergingUpdateQueue != null) return mergingUpdateQueue;
        DesignSurface.$$$reportNull$$$0(41);
        return mergingUpdateQueue;
    }

    public void addLayers(@NotNull ImmutableList<Layer> layers) {
        if (layers == null) {
            DesignSurface.$$$reportNull$$$0(42);
        }
        this.myLayers = ImmutableList.copyOf((Iterable)Iterables.concat(this.myLayers, layers));
    }

    public void removeLayers(@NotNull ImmutableList<Layer> layers) {
        if (layers == null) {
            DesignSurface.$$$reportNull$$$0(43);
        }
        this.myLayers = ImmutableList.copyOf((Iterable)Iterables.filter(this.myLayers, l -> !layers.contains(l)));
    }

    @NotNull
    protected List<Layer> getLayers() {
        ImmutableList<Layer> immutableList = this.myLayers;
        if (immutableList == null) {
            DesignSurface.$$$reportNull$$$0(44);
        }
        return immutableList;
    }

    @NotNull
    public ConfigurationManager getConfigurationManager(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            DesignSurface.$$$reportNull$$$0(45);
        }
        ConfigurationManager configurationManager = ConfigurationManager.getOrCreateInstance(facet2);
        if (configurationManager == null) {
            DesignSurface.$$$reportNull$$$0(46);
        }
        return configurationManager;
    }

    public void updateUI() {
        super.updateUI();
        if (this.myModelToSceneManagers != null) {
            for (SceneManager manager : this.getSceneManagers()) {
                manager.getSceneView().updateUI();
            }
        }
    }

    @NotNull
    public abstract List<NlComponent> getSelectableComponents();

    public void setMaxFitIntoScale(float maxFitIntoScale) {
        this.myMaxFitIntoScale = maxFitIntoScale;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 21: 
            case 22: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 44: 
            case 46: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 21: 
            case 22: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 44: 
            case 46: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionManagerProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interactionProviderCreator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultSurfaceState";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 21: 
            case 22: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/surface/DesignSurface";
                break;
            }
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 29: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSelection";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layers";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/surface/DesignSurface";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayoutType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionManager";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getModels";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSceneManagers";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "addModelImpl";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "addModel";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayeredPane";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnalyticsManager";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getInteractionManager";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "requestRender";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getScrollPane";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurations";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getIssueModel";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getIssuePanel";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorQueue";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayers";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 21: 
            case 22: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 44: 
            case 46: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addModelImpl";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addModel";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "removeModelImpl";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeModel";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "zoom";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "notifySelectionListeners";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "notifyComponentActivate";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "activatePreferredEditor";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getSceneManager";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "registerIndicator";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "unregisterIndicator";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "setLintAnnotationsModel";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "addLayers";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "removeLayers";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationManager";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 21: 
            case 22: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 44: 
            case 46: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class MyProgressPanel
    extends JPanel {
        private AsyncProcessIcon mySmallProgressIcon;
        private AsyncProcessIcon myLargeProgressIcon;
        private boolean mySmall;
        private boolean myProgressVisible;

        private MyProgressPanel() {
            super(new BorderLayout());
            this.setOpaque(false);
            this.setVisible(false);
        }

        private void setSmallIcon(boolean small) {
            if (small != this.mySmall) {
                if (this.myProgressVisible && this.getComponentCount() != 0) {
                    AsyncProcessIcon oldIcon = this.getProgressIcon();
                    oldIcon.suspend();
                }
                this.mySmall = true;
                this.removeAll();
                AsyncProcessIcon icon2 = this.getProgressIcon();
                this.add((Component)icon2, "Center");
                if (this.myProgressVisible) {
                    icon2.setVisible(true);
                    icon2.resume();
                }
            }
        }

        public void showProgressIcon() {
            if (!this.myProgressVisible) {
                this.setSmallIcon(DesignSurface.this.useSmallProgressIcon());
                this.myProgressVisible = true;
                this.setVisible(true);
                AsyncProcessIcon icon2 = this.getProgressIcon();
                if (this.getComponentCount() == 0) {
                    this.add((Component)this.getProgressIcon(), "Center");
                } else {
                    icon2.setVisible(true);
                }
                icon2.resume();
            }
        }

        public void hideProgressIcon() {
            if (this.myProgressVisible) {
                this.myProgressVisible = false;
                this.setVisible(false);
                AsyncProcessIcon icon2 = this.getProgressIcon();
                icon2.setVisible(false);
                icon2.suspend();
            }
        }

        @Override
        public void doLayout() {
            super.doLayout();
            this.setBackground((Color)JBColor.RED);
            if (!this.myProgressVisible) {
                return;
            }
            AsyncProcessIcon icon2 = this.getProgressIcon();
            Dimension size = icon2.getPreferredSize();
            if (this.mySmall) {
                icon2.setBounds(this.getWidth() - size.width - 1, 1, size.width, size.height);
            } else {
                icon2.setBounds(this.getWidth() / 2 - size.width / 2, this.getHeight() / 2 - size.height / 2, size.width, size.height);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getProgressIcon().getPreferredSize();
        }

        @NotNull
        private AsyncProcessIcon getProgressIcon() {
            return this.getProgressIcon(this.mySmall);
        }

        @NotNull
        private AsyncProcessIcon getProgressIcon(boolean small) {
            if (small) {
                if (this.mySmallProgressIcon == null) {
                    this.mySmallProgressIcon = new AsyncProcessIcon("Android layout rendering");
                    Disposer.register((Disposable)DesignSurface.this, (Disposable)this.mySmallProgressIcon);
                }
                AsyncProcessIcon asyncProcessIcon = this.mySmallProgressIcon;
                if (asyncProcessIcon == null) {
                    MyProgressPanel.$$$reportNull$$$0(0);
                }
                return asyncProcessIcon;
            }
            if (this.myLargeProgressIcon == null) {
                this.myLargeProgressIcon = new AsyncProcessIcon.Big("Android layout rendering");
                Disposer.register((Disposable)DesignSurface.this, (Disposable)this.myLargeProgressIcon);
            }
            AsyncProcessIcon asyncProcessIcon = this.myLargeProgressIcon;
            if (asyncProcessIcon == null) {
                MyProgressPanel.$$$reportNull$$$0(1);
            }
            return asyncProcessIcon;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/common/surface/DesignSurface$MyProgressPanel", "getProgressIcon"));
        }
    }

    private static class GlassPane
    extends JComponent {
        private static final long EVENT_FLAGS = 56L;

        public GlassPane() {
            this.enableEvents(56L);
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            if (enabled) {
                this.enableEvents(56L);
            } else {
                this.disableEvents(56L);
            }
        }

        @Override
        protected void processKeyEvent(KeyEvent event) {
            if (!event.isConsumed()) {
                super.processKeyEvent(event);
            }
        }

        @Override
        protected void processMouseEvent(MouseEvent event) {
            if (event.getID() == 501) {
                this.requestFocusInWindow();
            }
            super.processMouseEvent(event);
        }
    }

    private class MyVisibleSurfaceLayerPane
    extends JBPanel {
        MyVisibleSurfaceLayerPane() {
            this.setOpaque(false);
        }

        public Rectangle getBounds(@Nullable Rectangle rv) {
            if (DesignSurface.this.myScrollPane != null && DesignSurface.this.myScrollPane.getViewport() != null) {
                if (rv == null) {
                    rv = new Rectangle();
                }
                Rectangle viewportBorderBounds = DesignSurface.this.myScrollPane.getViewportBorderBounds();
                rv.height = viewportBorderBounds.height;
                rv.width = viewportBorderBounds.width;
                Point point = DesignSurface.this.myScrollPane.getViewport().getViewPosition();
                rv.x = point.x;
                rv.y = point.y;
                this.setBounds(rv);
                return rv;
            }
            return super.getBounds(rv);
        }
    }

    private class MyLayeredPane
    extends JLayeredPane
    implements Magnificator,
    DataProvider {
        public MyLayeredPane() {
            if (DesignSurface.this.getSupportPinchAndZoom()) {
                this.putClientProperty(Magnificator.CLIENT_PROPERTY_KEY, this);
            }
        }

        public Point magnify(double scale, Point at) {
            DesignSurface.this.setScale(scale * DesignSurface.this.myScale);
            DesignSurface.this.repaint();
            return new Point((int)((double)at.x * scale), (int)((double)at.y * scale));
        }

        @Override
        protected void paintComponent(@NotNull Graphics graphics) {
            if (graphics == null) {
                MyLayeredPane.$$$reportNull$$$0(0);
            }
            super.paintComponent(graphics);
            Graphics2D g2d = (Graphics2D)graphics;
            int tlx = DesignSurface.this.myScrollPane.getHorizontalScrollBar().getValue();
            int tly = DesignSurface.this.myScrollPane.getVerticalScrollBar().getValue();
            this.paintBackground(g2d, tlx, tly);
            Rectangle bounds = DesignSurface.this.myScrollPane.getViewport().getViewRect();
            for (Layer layer : DesignSurface.this.myLayers) {
                if (!layer.isVisible()) continue;
                g2d.setClip(bounds);
                layer.paint(g2d);
            }
            if (!DesignSurface.this.isEditable()) {
                return;
            }
            List<Layer> interactionLayers = DesignSurface.this.myInteractionManager.getLayers();
            if (interactionLayers != null) {
                for (Layer layer : interactionLayers) {
                    if (!layer.isVisible()) continue;
                    layer.paint(g2d);
                }
            }
        }

        private void paintBackground(@NotNull Graphics2D graphics, int lx, int ly) {
            if (graphics == null) {
                MyLayeredPane.$$$reportNull$$$0(1);
            }
            int width = DesignSurface.this.myScrollPane.getWidth();
            int height = DesignSurface.this.myScrollPane.getHeight();
            graphics.setColor(this.getBackground());
            graphics.fillRect(lx, ly, width, height);
        }

        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            SelectionModel selectionModel;
            NlComponent primary;
            if (dataId == null) {
                MyLayeredPane.$$$reportNull$$$0(2);
            }
            if (CommonDataKeys.PSI_ELEMENT.is(dataId) && DesignSurface.this.getFocusedSceneView() != null && (primary = (selectionModel = DesignSurface.this.getFocusedSceneView().getSelectionModel()).getPrimary()) != null) {
                return primary.getTagDeprecated();
            }
            if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId) && DesignSurface.this.getFocusedSceneView() != null) {
                selectionModel = DesignSurface.this.getFocusedSceneView().getSelectionModel();
                ImmutableList<NlComponent> selection = selectionModel.getSelection();
                ArrayList list = Lists.newArrayListWithCapacity((int)selection.size());
                for (NlComponent component3 : selection) {
                    list.add(component3.getTagDeprecated());
                }
                return list.toArray(XmlTag.EMPTY);
            }
            NlModel model2 = DesignSurface.this.getModel();
            if (LangDataKeys.MODULE.is(dataId) && model2 != null) {
                return model2.getModule();
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "graphics";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/common/surface/DesignSurface$MyLayeredPane";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paintComponent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paintBackground";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyScrollBar
    extends JBScrollBar
    implements IdeGlassPane.TopComponent {
        private ScrollBarUI myPersistentUI;

        private MyScrollBar(@JdkConstants.AdjustableOrientation int orientation) {
            super(orientation);
            this.setOpaque(false);
        }

        public boolean canBePreprocessed(@NotNull MouseEvent e) {
            if (e == null) {
                MyScrollBar.$$$reportNull$$$0(0);
            }
            return JBScrollPane.canBePreprocessed((MouseEvent)e, (JScrollBar)((Object)this));
        }

        public void setUI(ScrollBarUI ui) {
            if (this.myPersistentUI == null) {
                this.myPersistentUI = ui;
            }
            super.setUI(this.myPersistentUI);
            this.setOpaque(false);
        }

        public int getUnitIncrement(int direction) {
            return 5;
        }

        public int getBlockIncrement(int direction) {
            return 1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/common/surface/DesignSurface$MyScrollBar", "canBePreprocessed"));
        }
    }

    private static final class MyScrollPane
    extends JBScrollPane {
        private MyScrollPane() {
            super(0);
            this.setupCorners();
        }

        @NotNull
        public JScrollBar createVerticalScrollBar() {
            return new MyScrollBar(1);
        }

        @NotNull
        public JScrollBar createHorizontalScrollBar() {
            return new MyScrollBar(0);
        }
    }

    public static interface StateChangeListener {
        public void onStateChange(@NotNull State var1);
    }

    public static enum State {
        FULL,
        SPLIT,
        DEACTIVATED;

    }
}

