/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene.target;

import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.NonPlaceholderDragTarget;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.BaseTarget;
import com.android.tools.idea.common.scene.target.MultiComponentTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.handlers.constraint.ComponentModification;
import com.android.tools.idea.uibuilder.scene.target.TargetSnapper;
import com.google.common.collect.ImmutableList;
import java.awt.Cursor;
import java.util.List;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DragBaseTarget
extends BaseTarget
implements MultiComponentTarget,
NonPlaceholderDragTarget {
    private static final boolean DEBUG_RENDERER = false;
    protected int myOffsetX;
    protected int myOffsetY;
    protected int myFirstMouseX;
    protected int myFirstMouseY;
    protected boolean myChangedComponent;
    @NotNull
    private final TargetSnapper myTargetSnapper;

    private DragBaseTarget(@NotNull TargetSnapper targetSnapper) {
        if (targetSnapper == null) {
            DragBaseTarget.$$$reportNull$$$0(0);
        }
        this.myTargetSnapper = targetSnapper;
    }

    public DragBaseTarget() {
        this(new TargetSnapper());
    }

    @Override
    @Nullable
    public List<SceneComponent> newSelection() {
        if (this.hasChangedComponent()) {
            List<NlComponent> selection = this.getComponent().getScene().getSelection();
            if (selection.size() == 1) {
                return ImmutableList.of((Object)this.getComponent());
            }
            Scene scene = this.myComponent.getScene();
            return (List)selection.stream().map(c -> scene.getSceneComponent((NlComponent)c)).collect(ImmutableList.toImmutableList());
        }
        return null;
    }

    @Override
    public boolean layout(@NotNull SceneContext sceneTransform, int l, int t, int r, int b) {
        int d;
        if (sceneTransform == null) {
            DragBaseTarget.$$$reportNull$$$0(1);
        }
        int minWidth = 16;
        int minHeight = 16;
        if (r - l < minWidth) {
            d = (minWidth - (r - l)) / 2;
            l -= d;
            r += d;
        }
        if (b - t < minHeight) {
            d = (minHeight - (b - t)) / 2;
            t -= d;
            b += d;
        }
        this.myLeft = l;
        this.myTop = t;
        this.myRight = r;
        this.myBottom = b;
        return false;
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        if (list == null) {
            DragBaseTarget.$$$reportNull$$$0(2);
        }
        if (sceneContext == null) {
            DragBaseTarget.$$$reportNull$$$0(3);
        }
        this.myTargetSnapper.renderSnappedNotches(list, sceneContext, this.myComponent);
    }

    protected abstract void updateAttributes(@NotNull NlAttributesHolder var1, int var2, int var3);

    @Override
    protected boolean isHittable() {
        if (this.myComponent.isSelected()) {
            return this.myComponent.canShowBaseline() || !this.myComponent.isDragging();
        }
        return true;
    }

    @Override
    public int getPreferenceLevel() {
        return 20;
    }

    public void fillComponentModification(ComponentModification modification) {
    }

    public void applyComponentModification(ComponentModification modification) {
        modification.apply();
    }

    public void commitComponentModification(ComponentModification modification) {
        modification.commit();
    }

    @Override
    public void mouseDown(int x, int y) {
        if (this.myComponent.getParent() == null) {
            return;
        }
        this.myFirstMouseX = x;
        this.myFirstMouseY = y;
        this.myOffsetX = x - this.myComponent.getDrawX(System.currentTimeMillis());
        this.myOffsetY = y - this.myComponent.getDrawY(System.currentTimeMillis());
        this.myChangedComponent = false;
        this.getTargetNotchSnapper().reset();
        this.getTargetNotchSnapper().gatherNotches(this.myComponent);
    }

    @Override
    public void mouseDrag(int x, int y, @NotNull List<Target> closestTargets) {
        if (closestTargets == null) {
            DragBaseTarget.$$$reportNull$$$0(4);
        }
        if (this.myComponent.getParent() == null) {
            return;
        }
        this.myComponent.setDragging(true);
        NlComponent component3 = this.myComponent.getAuthoritativeNlComponent();
        int snappedX = this.myTargetSnapper.trySnapHorizontal(x -= this.myOffsetX).orElse(x);
        int snappedY = this.myTargetSnapper.trySnapVertical(y -= this.myOffsetY).orElse(y);
        ComponentModification modification = new ComponentModification(component3, "Drag");
        this.fillComponentModification(modification);
        this.updateAttributes(modification, snappedX, snappedY);
        this.applyComponentModification(modification);
        component3.fireLiveChangeEvent();
        this.myComponent.getScene().markNeedsLayout(1);
        this.myChangedComponent = true;
    }

    @Override
    public void mouseRelease(int x, int y, @NotNull List<Target> closestTargets) {
        if (closestTargets == null) {
            DragBaseTarget.$$$reportNull$$$0(5);
        }
        if (!this.myComponent.isDragging()) {
            return;
        }
        this.myComponent.setDragging(false);
        if (this.myComponent.getParent() != null) {
            boolean commitChanges = true;
            if (Math.abs(x - this.myFirstMouseX) <= 1 && Math.abs(y - this.myFirstMouseY) <= 1) {
                commitChanges = false;
            }
            NlComponent component3 = this.myComponent.getAuthoritativeNlComponent();
            ComponentModification modification = new ComponentModification(component3, "Drag");
            this.fillComponentModification(modification);
            int snappedX = this.myTargetSnapper.trySnapHorizontal(x -= this.myOffsetX).orElse(x);
            int snappedY = this.myTargetSnapper.trySnapVertical(y -= this.myOffsetY).orElse(y);
            if (this.isAutoConnectionEnabled()) {
                this.myTargetSnapper.applyNotches(modification);
            }
            this.updateAttributes(modification, snappedX, snappedY);
            this.applyComponentModification(modification);
            if (commitChanges) {
                this.commitComponentModification(modification);
            }
        }
        if (this.myChangedComponent) {
            this.myComponent.getScene().markNeedsLayout(1);
        }
    }

    protected boolean isAutoConnectionEnabled() {
        return true;
    }

    @Override
    public void mouseCancel() {
        int originalX = this.myFirstMouseX - this.myOffsetX;
        int originalY = this.myFirstMouseY - this.myOffsetY;
        this.myComponent.setPosition(originalX, originalY);
        NlComponent component3 = this.myComponent.getAuthoritativeNlComponent();
        AttributesTransaction transaction = component3.startAttributeTransaction();
        transaction.rollback();
        component3.fireLiveChangeEvent();
        this.myComponent.setDragging(false);
        this.myTargetSnapper.reset();
        this.myChangedComponent = false;
        this.myComponent.getScene().markNeedsLayout(1);
    }

    @Override
    public Cursor getMouseCursor(@JdkConstants.InputEventMask int modifiersEx) {
        return Cursor.getPredefinedCursor(12);
    }

    @NotNull
    public TargetSnapper getTargetNotchSnapper() {
        TargetSnapper targetSnapper = this.myTargetSnapper;
        if (targetSnapper == null) {
            DragBaseTarget.$$$reportNull$$$0(6);
        }
        return targetSnapper;
    }

    private boolean hasChangedComponent() {
        return this.myChangedComponent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetSnapper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneTransform";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneContext";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closestTargets";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/scene/target/DragBaseTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/scene/target/DragBaseTarget";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetNotchSnapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "layout";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "mouseDrag";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "mouseRelease";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

