/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DrawCommand;
import com.android.tools.idea.common.scene.draw.DrawComponentBackground;
import com.android.tools.idea.common.scene.draw.DrawNlComponentFrame;
import com.android.tools.idea.common.scene.draw.DrawNlDraggingComponentFrame;
import com.android.tools.idea.common.scene.draw.DrawTextRegion;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.DrawAnchor;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.DrawConnection;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.DrawConnectionUtils;
import com.android.tools.idea.uibuilder.scene.decorator.ButtonDecorator;
import com.android.tools.idea.uibuilder.scene.decorator.CheckBoxDecorator;
import com.android.tools.idea.uibuilder.scene.decorator.ImageViewDecorator;
import com.android.tools.idea.uibuilder.scene.decorator.LinearLayoutDecorator;
import com.android.tools.idea.uibuilder.scene.decorator.ProgressBarDecorator;
import com.android.tools.idea.uibuilder.scene.decorator.RadioButtonDecorator;
import com.android.tools.idea.uibuilder.scene.decorator.SeekBarDecorator;
import com.android.tools.idea.uibuilder.scene.decorator.SwitchDecorator;
import com.android.tools.idea.uibuilder.scene.decorator.UnknownViewDecorator;
import com.android.tools.idea.uibuilder.scene.draw.DrawResize;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Stack;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisplayList {
    private static final boolean DEBUG = false;
    private ArrayList<DrawCommand> myCommands = new ArrayList();
    private Stack<UNClip> myUnClipStack = new Stack();
    static HashMap<String, Function<String, ? extends DrawCommand>> ourBuildMap = new HashMap();

    public void clear() {
        this.myCommands.clear();
        this.myUnClipStack.clear();
    }

    public ArrayList<DrawCommand> getCommands() {
        return this.myCommands;
    }

    public void add(DrawCommand cmd) {
        this.myCommands.add(cmd);
    }

    public void pushClip(@NotNull SceneContext context, @Nullable Rectangle r) {
        if (context == null) {
            DisplayList.$$$reportNull$$$0(0);
        }
        if (r == null) {
            this.myUnClipStack.add(new EmptyUNClip());
            return;
        }
        int l = context.getSwingXDip(r.x);
        int t = context.getSwingYDip(r.y);
        int w = context.getSwingDimensionDip(r.width);
        int h = context.getSwingDimensionDip(r.height);
        Clip c = new Clip(l, t, w, h);
        this.myCommands.add(c);
        this.myUnClipStack.add(new UNClip(c));
    }

    public boolean popClip() {
        UNClip c;
        try {
            c = this.myUnClipStack.pop();
        }
        catch (EmptyStackException e) {
            return false;
        }
        if (!(c instanceof EmptyUNClip)) {
            this.myCommands.add(c);
        }
        return true;
    }

    public void addRect(SceneContext context, Rectangle r, Color color) {
        int l = context.getSwingXDip(r.x);
        int t = context.getSwingYDip(r.y);
        int w = context.getSwingDimensionDip(r.width);
        int h = context.getSwingDimensionDip(r.height);
        this.myCommands.add(new Rect(l, t, w, h, color));
    }

    public void addRect(SceneContext context, float left2, float top, float right2, float bottom2, Color color) {
        int l = context.getSwingXDip(left2);
        int t = context.getSwingYDip(top);
        int w = context.getSwingDimensionDip(right2 - left2);
        int h = context.getSwingDimensionDip(bottom2 - top);
        this.add(new Rect(l, t, w, h, color));
    }

    public void addRect(int left2, int top, int right2, int bottom2, @NotNull Color color) {
        if (color == null) {
            DisplayList.$$$reportNull$$$0(1);
        }
        this.add(new Rect(left2, top, right2 - left2, bottom2 - top, color));
    }

    public void addConnection(SceneContext context, float x1, float y1, float x2, float y2, int direction) {
        int sx1 = context.getSwingXDip(x1);
        int sy1 = context.getSwingYDip(y1);
        int sx2 = context.getSwingXDip(x2);
        int sy2 = context.getSwingYDip(y2);
        this.add(new Connection(sx1, sy1, sx2, sy2, direction));
    }

    public void addLine(SceneContext context, float x1, float y1, float x2, float y2, @NotNull Color color) {
        if (color == null) {
            DisplayList.$$$reportNull$$$0(2);
        }
        this.add(new Line(context, x1, y1, x2, y2, color));
    }

    public void addLine(int x1, int y1, int x2, int y2, @NotNull Color color) {
        if (color == null) {
            DisplayList.$$$reportNull$$$0(3);
        }
        this.add(new Line(x1, y1, x2, y2, color));
    }

    public void paint(Graphics2D g2, SceneContext sceneContext) {
        int count;
        if (!this.myUnClipStack.isEmpty()) {
            Logger.getInstance(DisplayList.class).warn("There are still clippings in the clip stack.");
            this.myUnClipStack.clear();
        }
        if ((count = this.myCommands.size()) == 0) {
            return;
        }
        Graphics2D g = (Graphics2D)g2.create();
        DrawCommand[] array = this.myCommands.toArray(new DrawCommand[0]);
        CommandSet set = new CommandSet(array, 0, array.length - 1);
        set.sort();
        set.paint(g, sceneContext);
        g.dispose();
    }

    @VisibleForTesting
    public String generateSortedDisplayList() {
        CommandSet set = (CommandSet)this.getCommand(0);
        set.sort();
        return set.serialize();
    }

    public String serialize() {
        Object str = "";
        int count = this.myCommands.size();
        for (int i2 = 0; i2 < count; ++i2) {
            DrawCommand command = this.myCommands.get(i2);
            str = (String)str + command.serialize() + "\n";
        }
        return str;
    }

    public DrawCommand getCommand(int level) {
        DrawCommand[] array = this.myCommands.toArray(new DrawCommand[0]);
        return new CommandSet(array, 0, array.length - 1, level);
    }

    public static void addListElementConstructor(Class<? extends DrawCommand> c) {
        ourBuildMap.put(c.getSimpleName(), s -> {
            try {
                return (DrawCommand)c.getConstructor(String.class).newInstance(s);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                Logger.getInstance(DisplayList.class).error((Throwable)e);
                return null;
            }
        });
    }

    public static void addListElementProvider(Class<? extends DrawCommand> c, Function<String, ? extends DrawCommand> provider2) {
        ourBuildMap.put(c.getSimpleName(), provider2);
    }

    @Nullable
    private static DrawCommand get(String cmd, String args) {
        return ourBuildMap.get(cmd).apply(args);
    }

    public static DisplayList getDisplayList(String str) {
        DisplayList list = new DisplayList();
        String[] sp = str.split("\n");
        Clip lastClip = null;
        for (int i2 = 0; i2 < sp.length; ++i2) {
            String args;
            String cmd;
            String s = sp[i2];
            if (s.indexOf(44) > 0) {
                cmd = s.substring(0, s.indexOf(44));
                args = s.substring(s.indexOf(44) + 1);
            } else {
                cmd = s;
                args = "";
            }
            DrawCommand drawCommand = DisplayList.get(cmd, args);
            list.add(drawCommand);
            if (drawCommand instanceof Clip) {
                lastClip = (Clip)drawCommand;
            }
            if (!(drawCommand instanceof UNClip)) continue;
            UNClip unclip = (UNClip)drawCommand;
            unclip.setClip(lastClip);
        }
        return list;
    }

    static {
        DisplayList.addListElementConstructor(Connection.class);
        DisplayList.addListElementConstructor(Rect.class);
        DisplayList.addListElementConstructor(Clip.class);
        DisplayList.addListElementConstructor(UNClip.class);
        DisplayList.addListElementConstructor(Line.class);
        DisplayList.addListElementConstructor(DrawConnection.class);
        DisplayList.addListElementConstructor(DrawResize.class);
        DisplayList.addListElementConstructor(DrawAnchor.class);
        DisplayList.addListElementConstructor(DrawComponentBackground.class);
        DisplayList.addListElementConstructor(DrawNlComponentFrame.class);
        DisplayList.addListElementConstructor(DrawNlDraggingComponentFrame.class);
        DisplayList.addListElementConstructor(ProgressBarDecorator.DrawProgressBar.class);
        DisplayList.addListElementConstructor(LinearLayoutDecorator.DrawLinearLayout.class);
        DisplayList.addListElementConstructor(ImageViewDecorator.DrawImageView.class);
        DisplayList.addListElementConstructor(SeekBarDecorator.DrawSeekBar.class);
        DisplayList.addListElementProvider(DrawTextRegion.class, DrawTextRegion::createFromString);
        DisplayList.addListElementProvider(ButtonDecorator.DrawButton.class, ButtonDecorator.DrawButton::createFromString);
        DisplayList.addListElementProvider(SwitchDecorator.DrawSwitch.class, SwitchDecorator.DrawSwitch::createFromString);
        DisplayList.addListElementProvider(RadioButtonDecorator.DrawRadioButton.class, RadioButtonDecorator.DrawRadioButton::createFromString);
        DisplayList.addListElementProvider(ButtonDecorator.DrawButton.class, ButtonDecorator.DrawButton::createFromString);
        DisplayList.addListElementProvider(CheckBoxDecorator.DrawCheckbox.class, CheckBoxDecorator.DrawCheckbox::createFromString);
        DisplayList.addListElementProvider(UnknownViewDecorator.DrawUnknownDecorator.class, UnknownViewDecorator.DrawUnknownDecorator::createFromString);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/common/scene/draw/DisplayList";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "pushClip";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addRect";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addLine";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class CommandSet
    implements DrawCommand {
        private ArrayList<DrawCommand> myCommands = new ArrayList();
        private int myLevel;

        public CommandSet(DrawCommand[] commands2, int start, int end) {
            this(commands2, start, end, 20);
        }

        public CommandSet(DrawCommand[] commands2, int start, int end, int level) {
            this.myLevel = level;
            if (commands2.length == 0) {
                return;
            }
            int first = CommandSet.findFirstClip(commands2, start, end);
            int last = CommandSet.findLastUnClip(commands2, start, end);
            if (first == start && last == end) {
                this.myCommands.add(commands2[start]);
                for (int i2 = start + 1; i2 < end; ++i2) {
                    DrawCommand cmd = commands2[i2];
                    if (cmd instanceof Clip) {
                        int n = CommandSet.findNextUnClip(commands2, i2 + 1, end - 1);
                        cmd = new CommandSet(commands2, i2, n);
                        i2 = Math.max(n, i2);
                    }
                    this.myCommands.add(cmd);
                }
                this.myCommands.add(commands2[end]);
            } else if (first != -1 && last != -1) {
                int i3;
                for (i3 = start; i3 < first; ++i3) {
                    this.myCommands.add(commands2[i3]);
                }
                this.myCommands.add(new CommandSet(commands2, first, last));
                for (i3 = last + 1; i3 <= end; ++i3) {
                    this.myCommands.add(commands2[i3]);
                }
            } else {
                for (int i4 = start; i4 <= end; ++i4) {
                    this.myCommands.add(commands2[i4]);
                }
            }
        }

        private static int findFirstClip(DrawCommand[] commands2, int start, int end) {
            for (int i2 = start; i2 < end; ++i2) {
                if (!(commands2[i2] instanceof Clip)) continue;
                return i2;
            }
            return -1;
        }

        private static int findLastUnClip(DrawCommand[] commands2, int start, int end) {
            for (int i2 = end; i2 > start; --i2) {
                if (!(commands2[i2] instanceof UNClip)) continue;
                return i2;
            }
            return -1;
        }

        private static int findNextUnClip(DrawCommand[] commands2, int start, int end) {
            int count = 0;
            for (int i2 = start; i2 <= end; ++i2) {
                if (commands2[i2] instanceof Clip) {
                    ++count;
                }
                if (!(commands2[i2] instanceof UNClip)) continue;
                if (count == 0) {
                    return i2;
                }
                --count;
            }
            return -1;
        }

        public void sort() {
            this.myCommands.sort(Comparator.comparingInt(DrawCommand::getLevel));
            this.myCommands.forEach(command -> {
                if (command instanceof CommandSet) {
                    ((CommandSet)command).sort();
                }
            });
        }

        @Override
        public int getLevel() {
            return this.myLevel;
        }

        @Override
        public void paint(Graphics2D g2, SceneContext sceneContext) {
            for (int i2 = 0; i2 < this.myCommands.size(); ++i2) {
                this.myCommands.get(i2).paint(g2, sceneContext);
            }
        }

        public void print(String s) {
            this.myCommands.forEach(command -> {
                if (command instanceof CommandSet) {
                    ((CommandSet)command).print(s + ">");
                } else {
                    System.out.println(s + command.serialize());
                }
            });
        }

        @Override
        public String serialize() {
            Object str = "";
            for (DrawCommand command : this.myCommands) {
                str = (String)str + command.serialize() + "\n";
            }
            return str;
        }
    }

    static class Line
    implements DrawCommand {
        Color color;
        int x1;
        int y1;
        int x2;
        int y2;

        @Override
        public String serialize() {
            return "Line," + this.x1 + "," + this.y1 + "," + this.x2 + "," + this.y2 + "," + Integer.toHexString(this.color.getRGB());
        }

        @Override
        public int getLevel() {
            return 50;
        }

        public Line(String s) {
            String[] sp = s.split(",");
            int c = 0;
            this.x1 = Integer.parseInt(sp[c++]);
            this.y1 = Integer.parseInt(sp[c++]);
            this.x2 = Integer.parseInt(sp[c++]);
            this.y2 = Integer.parseInt(sp[c++]);
            this.color = new Color((int)Long.parseLong(sp[c], 16));
        }

        public Line(SceneContext transform, float x1, float y1, float x2, float y2, @NotNull Color c) {
            if (c == null) {
                Line.$$$reportNull$$$0(0);
            }
            this.x1 = transform.getSwingXDip(x1);
            this.y1 = transform.getSwingYDip(y1);
            this.x2 = transform.getSwingXDip(x2);
            this.y2 = transform.getSwingYDip(y2);
            this.color = c;
        }

        public Line(int x1, int y1, int x2, int y2, @NotNull Color c) {
            if (c == null) {
                Line.$$$reportNull$$$0(1);
            }
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.color = c;
        }

        @Override
        public void paint(Graphics2D g, SceneContext sceneContext) {
            g.setColor(this.color);
            g.drawLine(this.x1, this.y1, this.x2, this.y2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/android/tools/idea/common/scene/draw/DisplayList$Line", "<init>"));
        }
    }

    private static class EmptyUNClip
    extends UNClip {
        public EmptyUNClip() {
            super((Clip)null);
        }

        @Override
        public void paint(Graphics2D g, SceneContext sceneContext) {
        }
    }

    private static class UNClip
    implements DrawCommand {
        Clip lastClip;

        @Override
        public String serialize() {
            return "UNClip";
        }

        @Override
        public int getLevel() {
            return 1000;
        }

        public UNClip(String s) {
        }

        public UNClip(Clip s) {
            this.lastClip = s;
        }

        @Override
        public void paint(Graphics2D g, SceneContext sceneContext) {
            g.setClip(this.lastClip.getOriginalShape());
        }

        public void setClip(Clip clip) {
            this.lastClip = clip;
        }
    }

    private static class Clip
    extends Rectangle
    implements DrawCommand {
        Shape myOriginal;

        @Override
        public String serialize() {
            return "Clip," + this.x + "," + this.y + "," + this.width + "," + this.height;
        }

        @Override
        public int getLevel() {
            return 0;
        }

        public Clip(String s) {
            String[] sp = s.split(",");
            int c = 0;
            this.x = Integer.parseInt(sp[c++]);
            this.y = Integer.parseInt(sp[c++]);
            this.width = Integer.parseInt(sp[c++]);
            this.height = Integer.parseInt(sp[c]);
        }

        private Clip(int x, int y, int width, int height) {
            super(x, y, width, height);
        }

        public Shape getOriginalShape() {
            return this.myOriginal;
        }

        @Override
        public void paint(Graphics2D g, SceneContext sceneContext) {
            this.myOriginal = g.getClip();
            g.clipRect(this.x, this.y, this.width, this.height);
        }
    }

    static class Rect
    extends Rectangle
    implements DrawCommand {
        Color color;

        @Override
        public String serialize() {
            return "Rect," + this.x + "," + this.y + "," + this.width + "," + this.height + "," + Integer.toHexString(this.color.getRGB());
        }

        public Rect(String s) {
            String[] sp = s.split(",");
            int c = 0;
            this.x = Integer.parseInt(sp[c++]);
            this.y = Integer.parseInt(sp[c++]);
            this.width = Integer.parseInt(sp[c++]);
            this.height = Integer.parseInt(sp[c++]);
            this.color = new Color((int)Long.parseLong(sp[c], 16));
        }

        public Rect(int x, int y, int width, int height, Color c) {
            super(x, y, width, height);
            this.color = c;
        }

        @Override
        public int getLevel() {
            return 20;
        }

        @Override
        public void paint(Graphics2D g, SceneContext sceneContext) {
            g.setColor(this.color);
            g.drawRect(this.x, this.y, this.width, this.height);
        }
    }

    public static class Connection
    implements DrawCommand {
        int x1;
        int y1;
        int x2;
        int y2;
        int myDirection;
        private static final int DIR_LEFT = 0;
        private static final int DIR_TOP = 1;
        private static final int DIR_RIGHT = 2;
        private static final int DIR_BOTTOM = 3;
        private static final int DIR_BASELINE = 4;

        @Override
        public int getLevel() {
            return 100;
        }

        @Override
        public String serialize() {
            return "Connection," + this.x1 + "," + this.y1 + "," + this.x2 + "," + this.y2 + this.myDirection;
        }

        public Connection(String s) {
            String[] sp = s.split(",");
            int c = 0;
            this.x1 = Integer.parseInt(sp[c++]);
            this.y1 = Integer.parseInt(sp[c++]);
            this.x2 = Integer.parseInt(sp[c++]);
            this.y2 = Integer.parseInt(sp[c++]);
            this.myDirection = Integer.parseInt(sp[c]);
        }

        public Connection(int x1, int y1, int x2, int y2, int direction) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.myDirection = direction;
        }

        @Override
        public void paint(Graphics2D g, SceneContext sceneContext) {
            g.setColor(sceneContext.getColorSet().getSelectedConstraints());
            int start_dx = 0;
            int start_dy = 0;
            int end_dx = 0;
            int end_dy = 0;
            int scale = 20;
            int arrowDirection = 0;
            int arrowX = this.x2;
            int arrowY = this.y2;
            int arrowGap = DrawConnectionUtils.CONNECTION_ARROW_SIZE;
            switch (this.myDirection) {
                case 0: {
                    start_dx = -scale;
                    end_dx = this.x2 > this.x1 ? -scale : scale;
                    arrowDirection = this.x2 > this.x1 ? 0 : 1;
                    arrowX += this.x2 > this.x1 ? -arrowGap : arrowGap;
                    break;
                }
                case 1: {
                    start_dy = -10;
                    end_dy = this.y2 > this.y1 ? -scale : scale;
                    arrowDirection = this.y2 > this.y1 ? 2 : 3;
                    arrowY += this.y2 > this.y1 ? -arrowGap : arrowGap;
                    break;
                }
                case 2: {
                    end_dx = this.x2 > this.x1 ? -scale : scale;
                    start_dx = scale;
                    arrowDirection = this.x2 > this.x1 ? 0 : 1;
                    arrowX += this.x2 > this.x1 ? -arrowGap : arrowGap;
                    break;
                }
                case 3: {
                    start_dy = scale;
                    end_dy = this.y2 > this.y1 ? -scale : scale;
                    arrowDirection = this.y2 > this.y1 ? 2 : 3;
                    arrowY += this.y2 > this.y1 ? -arrowGap : arrowGap;
                    break;
                }
                case 4: {
                    start_dy = -scale;
                    end_dy = this.y2 > this.y1 ? -scale : scale;
                    arrowDirection = this.y2 > this.y1 ? 2 : 3;
                    arrowY += this.y2 > this.y1 ? -arrowGap : arrowGap;
                }
            }
            GeneralPath path2 = new GeneralPath();
            path2.moveTo(this.x1, this.y1);
            path2.curveTo(this.x1 + start_dx, this.y1 + start_dy, this.x2 + end_dx, this.y2 + end_dy, arrowX, arrowY);
            g.draw(path2);
            int[] xPoints = new int[3];
            int[] yPoints = new int[3];
            DrawConnectionUtils.getArrow(arrowDirection, this.x2, this.y2, xPoints, yPoints);
            g.fillPolygon(xPoints, yPoints, 3);
        }
    }
}

