/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene;

import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.DefaultHitProvider;
import com.android.tools.idea.common.scene.HitProvider;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.TemporarySceneComponent;
import com.android.tools.idea.common.scene.decorator.SceneDecoratorFactory;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.rendering.RenderSettings;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SceneManager
implements Disposable {
    public static final boolean SUPPORTS_LOCKING = false;
    @NotNull
    private final NlModel myModel;
    @NotNull
    private final DesignSurface myDesignSurface;
    @NotNull
    private final Scene myScene;
    @Nullable
    private SceneView mySceneView;
    @NotNull
    private final HitProvider myHitProvider;

    public SceneManager(@NotNull NlModel model2, @NotNull DesignSurface surface2, @NotNull Supplier<RenderSettings> renderSettingsProvider) {
        if (model2 == null) {
            SceneManager.$$$reportNull$$$0(0);
        }
        if (surface2 == null) {
            SceneManager.$$$reportNull$$$0(1);
        }
        if (renderSettingsProvider == null) {
            SceneManager.$$$reportNull$$$0(2);
        }
        this.myHitProvider = new DefaultHitProvider();
        this.myModel = model2;
        this.myDesignSurface = surface2;
        Disposer.register((Disposable)model2, (Disposable)this);
        this.myScene = new Scene(this, this.myDesignSurface, renderSettingsProvider.get().getUseLiveRendering());
    }

    protected void createSceneView() {
        if (this.mySceneView != null) {
            Disposer.dispose((Disposable)this.mySceneView);
        }
        this.mySceneView = this.doCreateSceneView();
        Disposer.register((Disposable)this, (Disposable)this.mySceneView);
        this.myDesignSurface.addLayers(this.getLayers());
        this.myDesignSurface.layoutContent();
    }

    @NotNull
    protected abstract SceneView doCreateSceneView();

    public void updateSceneView() {
        this.myDesignSurface.removeLayers(this.getLayers());
        this.createSceneView();
    }

    @NotNull
    public SceneView getSceneView() {
        assert (this.mySceneView != null) : "createSceneView() should have been called during initialization";
        SceneView sceneView = this.mySceneView;
        if (sceneView == null) {
            SceneManager.$$$reportNull$$$0(3);
        }
        return sceneView;
    }

    @NotNull
    public ImmutableList<Layer> getLayers() {
        ImmutableList<Layer> immutableList = this.mySceneView.getLayers();
        if (immutableList == null) {
            SceneManager.$$$reportNull$$$0(4);
        }
        return immutableList;
    }

    public abstract float getSceneScalingFactor();

    public void dispose() {
    }

    public void update() {
        List<SceneComponent> hierarchy;
        ImmutableList<NlComponent> components = this.getModel().getComponents();
        Scene scene = this.getScene();
        if (components.isEmpty()) {
            scene.removeAllComponents();
            scene.setRoot(null);
            return;
        }
        HashSet<SceneComponent> usedComponents = new HashSet<SceneComponent>();
        HashSet<SceneComponent> oldComponents = new HashSet<SceneComponent>(scene.getSceneComponents());
        NlComponent rootComponent = this.getRoot();
        if (this.myScene.getRoot() != null && rootComponent != this.myScene.getRoot().getNlComponent()) {
            scene.removeAllComponents();
            scene.setRoot(null);
        }
        SceneComponent root2 = (hierarchy = this.createHierarchy(rootComponent)).isEmpty() ? null : hierarchy.get(0);
        scene.setRoot(root2);
        if (root2 != null) {
            this.updateFromComponent(root2, usedComponents);
        }
        oldComponents.removeAll(usedComponents);
        oldComponents.removeIf(component3 -> component3 instanceof TemporarySceneComponent);
        oldComponents.forEach(scene::removeComponent);
        scene.needsRebuildList();
    }

    @NotNull
    protected NlComponent getRoot() {
        NlComponent nlComponent = ((NlComponent)this.getModel().getComponents().get(0)).getRoot();
        if (nlComponent == null) {
            SceneManager.$$$reportNull$$$0(5);
        }
        return nlComponent;
    }

    public static boolean isComponentLocked(@NotNull NlComponent component3) {
        if (component3 == null) {
            SceneManager.$$$reportNull$$$0(6);
        }
        return false;
    }

    @NotNull
    protected List<SceneComponent> createHierarchy(@NotNull NlComponent component3) {
        SceneComponent sceneComponent;
        if (component3 == null) {
            SceneManager.$$$reportNull$$$0(7);
        }
        if ((sceneComponent = this.getScene().getSceneComponent(component3)) == null) {
            sceneComponent = new SceneComponent(this.getScene(), component3, this.getHitProvider(component3));
        }
        sceneComponent.setToolLocked(SceneManager.isComponentLocked(component3));
        HashSet<SceneComponent> oldChildren = new HashSet<SceneComponent>(sceneComponent.getChildren());
        for (NlComponent nlChild : component3.getChildren()) {
            List<SceneComponent> children = this.createHierarchy(nlChild);
            oldChildren.removeAll(children);
            for (SceneComponent child : children) {
                child.removeFromParent();
                sceneComponent.addChild(child);
            }
        }
        for (SceneComponent child : oldChildren) {
            if (child instanceof TemporarySceneComponent && child.getParent() == sceneComponent || child.getParent() != sceneComponent) continue;
            child.removeFromParent();
        }
        ImmutableList immutableList = ImmutableList.of((Object)sceneComponent);
        if (immutableList == null) {
            SceneManager.$$$reportNull$$$0(8);
        }
        return immutableList;
    }

    protected final void updateFromComponent(@NotNull SceneComponent component3, @NotNull Set<SceneComponent> seenComponents) {
        if (component3 == null) {
            SceneManager.$$$reportNull$$$0(9);
        }
        if (seenComponents == null) {
            SceneManager.$$$reportNull$$$0(10);
        }
        seenComponents.add(component3);
        this.updateFromComponent(component3);
        for (SceneComponent child : component3.getChildren()) {
            this.updateFromComponent(child, seenComponents);
        }
        this.postUpdateFromComponent(component3);
    }

    protected void postUpdateFromComponent(@NotNull SceneComponent component3) {
        if (component3 == null) {
            SceneManager.$$$reportNull$$$0(11);
        }
    }

    @NotNull
    public abstract TemporarySceneComponent createTemporaryComponent(@NotNull NlComponent var1);

    protected void updateFromComponent(SceneComponent sceneComponent) {
        sceneComponent.setToolLocked(false);
    }

    @NotNull
    protected DesignSurface getDesignSurface() {
        DesignSurface designSurface = this.myDesignSurface;
        if (designSurface == null) {
            SceneManager.$$$reportNull$$$0(12);
        }
        return designSurface;
    }

    @NotNull
    public NlModel getModel() {
        NlModel nlModel = this.myModel;
        if (nlModel == null) {
            SceneManager.$$$reportNull$$$0(13);
        }
        return nlModel;
    }

    @NotNull
    public Scene getScene() {
        Scene scene = this.myScene;
        if (scene == null) {
            SceneManager.$$$reportNull$$$0(14);
        }
        return scene;
    }

    @NotNull
    public abstract CompletableFuture<Void> requestRender();

    @NotNull
    public CompletableFuture<Void> requestLayoutAndRender(boolean animate) {
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        if (completableFuture == null) {
            SceneManager.$$$reportNull$$$0(15);
        }
        return completableFuture;
    }

    @NotNull
    public abstract CompletableFuture<Void> requestLayout(boolean var1);

    public abstract void layout(boolean var1);

    @NotNull
    public abstract SceneDecoratorFactory getSceneDecoratorFactory();

    public abstract Map<Object, Map<ResourceReference, ResourceValue>> getDefaultProperties();

    public abstract Map<Object, String> getDefaultStyles();

    @NotNull
    protected HitProvider getHitProvider(@NotNull NlComponent component3) {
        if (component3 == null) {
            SceneManager.$$$reportNull$$$0(16);
        }
        HitProvider hitProvider = this.myHitProvider;
        if (hitProvider == null) {
            SceneManager.$$$reportNull$$$0(17);
        }
        return hitProvider;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderSettingsProvider";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/scene/SceneManager";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "seenComponents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/scene/SceneManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSceneView";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayers";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createHierarchy";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDesignSurface";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getScene";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "requestLayoutAndRender";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getHitProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isComponentLocked";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createHierarchy";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updateFromComponent";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "postUpdateFromComponent";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getHitProvider";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

