/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene;

import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.common.surface.InteractionInformation;
import com.android.tools.idea.common.surface.SceneView;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SceneInteraction
extends Interaction {
    protected SceneView mySceneView;

    public SceneInteraction(@NotNull SceneView sceneView) {
        if (sceneView == null) {
            SceneInteraction.$$$reportNull$$$0(0);
        }
        this.mySceneView = sceneView;
    }

    @Override
    public void begin(@Nullable EventObject event, @NotNull InteractionInformation interactionInformation) {
        if (interactionInformation == null) {
            SceneInteraction.$$$reportNull$$$0(1);
        }
        if (event instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)event;
            this.begin(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiersEx());
        } else {
            Logger.getInstance(SceneInteraction.class).warn("The Scene Interaction shouldn't be started by event " + event);
        }
    }

    @Override
    public void begin(int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
        super.begin(x, y, modifiersEx);
        int androidX = Coordinates.getAndroidX(this.mySceneView, this.myStartX);
        int androidY = Coordinates.getAndroidY(this.mySceneView, this.myStartY);
        int dpX = Coordinates.pxToDp(this.mySceneView, androidX);
        int dpY = Coordinates.pxToDp(this.mySceneView, androidY);
        Scene scene = this.mySceneView.getScene();
        scene.mouseDown(SceneContext.get(this.mySceneView), dpX, dpY, modifiersEx);
    }

    @Override
    public void update(@NotNull EventObject event, @NotNull InteractionInformation interactionInformation) {
        if (event == null) {
            SceneInteraction.$$$reportNull$$$0(2);
        }
        if (interactionInformation == null) {
            SceneInteraction.$$$reportNull$$$0(3);
        }
        if (event instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)event;
            int mouseX = mouseEvent.getX();
            int mouseY = mouseEvent.getY();
            this.mySceneView.getContext().setMouseLocation(mouseX, mouseY);
            this.update(mouseX, mouseY, mouseEvent.getModifiersEx());
        }
    }

    @Override
    public void update(int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
        super.update(x, y, modifiersEx);
        int androidX = Coordinates.getAndroidX(this.mySceneView, x);
        int androidY = Coordinates.getAndroidY(this.mySceneView, y);
        int dpX = Coordinates.pxToDp(this.mySceneView, androidX);
        int dpY = Coordinates.pxToDp(this.mySceneView, androidY);
        Scene scene = this.mySceneView.getScene();
        scene.mouseDrag(SceneContext.get(this.mySceneView), dpX, dpY, modifiersEx);
        this.mySceneView.getSurface().repaint();
    }

    @Override
    public void commit(@Nullable EventObject event, @NotNull InteractionInformation interactionInformation) {
        if (interactionInformation == null) {
            SceneInteraction.$$$reportNull$$$0(4);
        }
        assert (event instanceof MouseEvent);
        MouseEvent mouseEvent = (MouseEvent)event;
        this.end(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiersEx());
    }

    @Override
    public void end(int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
        int androidX = Coordinates.getAndroidX(this.mySceneView, x);
        int androidY = Coordinates.getAndroidY(this.mySceneView, y);
        int dpX = Coordinates.pxToDp(this.mySceneView, androidX);
        int dpY = Coordinates.pxToDp(this.mySceneView, androidY);
        Scene scene = this.mySceneView.getScene();
        scene.mouseRelease(SceneContext.get(this.mySceneView), dpX, dpY, modifiersEx);
        this.mySceneView.getSurface().repaint();
    }

    @Override
    public void cancel(@Nullable EventObject event, @NotNull InteractionInformation interactionInformation) {
        if (interactionInformation == null) {
            SceneInteraction.$$$reportNull$$$0(5);
        }
        this.cancel(interactionInformation.getX(), interactionInformation.getY(), interactionInformation.getModifiersEx());
    }

    @Override
    public void cancel(int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
        Scene scene = this.mySceneView.getScene();
        scene.mouseCancel();
        this.mySceneView.getSurface().repaint();
    }

    @Override
    @Nullable
    public Cursor getCursor() {
        return this.mySceneView.getScene().getMouseCursor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneView";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interactionInformation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/common/scene/SceneInteraction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "begin";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "commit";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "cancel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

