/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene;

import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.scene.ScenePicker;
import com.android.tools.idea.common.scene.draw.ColorSet;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.handlers.constraint.drawing.BlueprintColorSet;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class SceneContext {
    private final ScenePicker myGraphicsPicker = new ScenePicker();
    private Object myFoundObject;
    private Long myTime;
    private int myMouseX = -1;
    private int myMouseY = -1;
    private boolean myShowOnlySelection = false;
    @NotNull
    protected final Rectangle myRenderableBounds = new Rectangle();
    private static SceneContext lazySingleton;

    public SceneContext() {
        this.myTime = System.currentTimeMillis();
        this.myGraphicsPicker.setSelectListener((over, dist) -> {
            this.myFoundObject = over;
        });
    }

    public void setShowOnlySelection(boolean value2) {
        this.myShowOnlySelection = value2;
    }

    public long getTime() {
        return this.myTime;
    }

    public void setTime(long time2) {
        this.myTime = time2;
    }

    public void setMouseLocation(int x, int y) {
        this.myMouseX = x;
        this.myMouseY = y;
    }

    public int getMouseX() {
        return this.myMouseX;
    }

    public int getMouseY() {
        return this.myMouseY;
    }

    public void repaint() {
    }

    public int getSwingXDip(float x) {
        return (int)x;
    }

    public int getSwingYDip(float y) {
        return (int)y;
    }

    public int getSwingX(int x) {
        return x;
    }

    public int getSwingY(int y) {
        return y;
    }

    public int getSwingDimensionDip(float dim) {
        return (int)dim;
    }

    public int getSwingDimension(int dim) {
        return dim;
    }

    @NotNull
    public abstract ColorSet getColorSet();

    @NotNull
    public ScenePicker getScenePicker() {
        ScenePicker scenePicker = this.myGraphicsPicker;
        if (scenePicker == null) {
            SceneContext.$$$reportNull$$$0(0);
        }
        return scenePicker;
    }

    @Nullable
    public Object findClickedGraphics(int x, int y) {
        this.myFoundObject = null;
        this.myGraphicsPicker.find(x, y);
        return this.myFoundObject;
    }

    public double getScale() {
        return 1.0;
    }

    public final void setRenderableBounds(@NotNull Rectangle bounds) {
        if (bounds == null) {
            SceneContext.$$$reportNull$$$0(1);
        }
        this.myRenderableBounds.setBounds(bounds);
    }

    @NotNull
    public final Rectangle getRenderableBounds() {
        Rectangle rectangle = this.myRenderableBounds;
        if (rectangle == null) {
            SceneContext.$$$reportNull$$$0(2);
        }
        return rectangle;
    }

    @TestOnly
    @NotNull
    public static SceneContext get() {
        if (lazySingleton == null) {
            lazySingleton = new IdentitySceneContext();
        }
        SceneContext sceneContext = lazySingleton;
        if (sceneContext == null) {
            SceneContext.$$$reportNull$$$0(3);
        }
        return sceneContext;
    }

    @Deprecated
    @NotNull
    public static SceneContext get(@NotNull SceneView sceneView) {
        if (sceneView == null) {
            SceneContext.$$$reportNull$$$0(4);
        }
        SceneContext sceneContext = sceneView.getContext();
        if (sceneContext == null) {
            SceneContext.$$$reportNull$$$0(5);
        }
        return sceneContext;
    }

    @Nullable
    public DesignSurface getSurface() {
        return null;
    }

    public float pxToDp(int px) {
        return (float)px * Coordinates.DEFAULT_DENSITY;
    }

    public boolean showOnlySelection() {
        return this.myShowOnlySelection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/scene/SceneContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getScenePicker";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/scene/SceneContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderableBounds";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setRenderableBounds";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @TestOnly
    private static class IdentitySceneContext
    extends SceneContext {
        private ColorSet myColorSet = new BlueprintColorSet();

        private IdentitySceneContext() {
        }

        @Override
        @NotNull
        public ColorSet getColorSet() {
            ColorSet colorSet = this.myColorSet;
            if (colorSet == null) {
                IdentitySceneContext.$$$reportNull$$$0(0);
            }
            return colorSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/common/scene/SceneContext$IdentitySceneContext", "getColorSet"));
        }
    }
}

