/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.error;

import com.android.tools.idea.common.error.Issue;
import com.android.tools.idea.common.error.IssueProvider;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.util.ListenerCollection;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ModalityState;
import com.intellij.ui.GuiUtils;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IssueModel {
    private ImmutableList<Issue> myIssues = ImmutableList.of();
    private final ListenerCollection<IssueModelListener> myListeners = ListenerCollection.createWithExecutor(command -> GuiUtils.invokeLaterIfNeeded((Runnable)command, (ModalityState)ModalityState.defaultModalityState()));
    protected int myWarningCount;
    protected int myErrorCount;
    @VisibleForTesting
    public final Runnable myUpdateCallback = () -> this.updateErrorsList();
    private List<IssueProvider> myIssueProviders = new ArrayList<IssueProvider>();

    @VisibleForTesting
    public void updateErrorsList() {
        this.myWarningCount = 0;
        this.myErrorCount = 0;
        ImmutableList.Builder issueListBuilder = ImmutableList.builder();
        for (IssueProvider provider2 : ImmutableList.copyOf(this.myIssueProviders)) {
            provider2.collectIssues((ImmutableCollection.Builder<Issue>)issueListBuilder);
        }
        this.myIssues = issueListBuilder.build();
        this.myIssues.forEach(issue2 -> this.updateIssuesCounts((Issue)issue2));
        this.myListeners.forEach(IssueModelListener::errorModelChanged);
    }

    private void updateIssuesCounts(@NotNull Issue issue2) {
        if (issue2 == null) {
            IssueModel.$$$reportNull$$$0(0);
        }
        if (issue2.getSeverity().equals((Object)HighlightSeverity.WARNING)) {
            ++this.myWarningCount;
        } else if (issue2.getSeverity().equals((Object)HighlightSeverity.ERROR)) {
            ++this.myErrorCount;
        }
    }

    public void addIssueProvider(@NotNull IssueProvider issueProvider) {
        if (issueProvider == null) {
            IssueModel.$$$reportNull$$$0(1);
        }
        this.myIssueProviders.add(issueProvider);
        issueProvider.addListener(this.myUpdateCallback);
        this.updateErrorsList();
    }

    public void removeIssueProvider(@NotNull IssueProvider issueProvider) {
        if (issueProvider == null) {
            IssueModel.$$$reportNull$$$0(2);
        }
        this.myIssueProviders.remove(issueProvider);
        issueProvider.removeListener(this.myUpdateCallback);
        this.updateErrorsList();
    }

    @NotNull
    public ImmutableList<Issue> getIssues() {
        ImmutableList<Issue> immutableList = this.myIssues;
        if (immutableList == null) {
            IssueModel.$$$reportNull$$$0(3);
        }
        return immutableList;
    }

    public int getIssueCount() {
        return this.myIssues.size();
    }

    public void addErrorModelListener(@NotNull IssueModelListener listener2) {
        if (listener2 == null) {
            IssueModel.$$$reportNull$$$0(4);
        }
        this.myListeners.add(listener2);
    }

    public void removeErrorModelListener(@NotNull IssueModelListener listener2) {
        if (listener2 == null) {
            IssueModel.$$$reportNull$$$0(5);
        }
        this.myListeners.remove(listener2);
    }

    public int getWarningCount() {
        return this.myWarningCount;
    }

    public int getErrorCount() {
        return this.myErrorCount;
    }

    public boolean hasIssues() {
        return !this.myIssues.isEmpty();
    }

    @Nullable
    public Issue findIssue(@NotNull NlComponent component3) {
        if (component3 == null) {
            IssueModel.$$$reportNull$$$0(6);
        }
        for (Issue issue2 : this.myIssues) {
            if (!component3.equals(issue2.getSource())) continue;
            return issue2;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issue";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issueProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/error/IssueModel";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/error/IssueModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIssues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateIssuesCounts";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addIssueProvider";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeIssueProvider";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addErrorModelListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeErrorModelListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findIssue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface IssueModelListener {
        public void errorModelChanged();
    }
}

