/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.ddmlib.IDevice;
import com.android.prefs.AndroidLocation;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.avdmanager.ShowErrorDialogCallback;
import com.android.utils.ILogger;
import com.google.common.util.concurrent.FutureCallback;
import com.intellij.CommonBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AvdManagerLog;
import org.jetbrains.android.sdk.MessageBuildingSdkLog;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AvdManagerUtils {
    public static boolean reloadAvds(@NotNull AvdManager manager, @NotNull Project project) {
        if (manager == null) {
            AvdManagerUtils.$$$reportNull$$$0(0);
        }
        if (project == null) {
            AvdManagerUtils.$$$reportNull$$$0(1);
        }
        try {
            MessageBuildingSdkLog log = new MessageBuildingSdkLog();
            manager.reloadAvds((ILogger)log);
            if (!log.getErrorMessage().isEmpty()) {
                String message2 = AndroidBundle.message("cant.load.avds.error.prefix", new Object[0]) + " " + log.getErrorMessage();
                Messages.showErrorDialog((Project)project, (String)message2, (String)CommonBundle.getErrorTitle());
            }
            return true;
        }
        catch (AndroidLocation.AndroidLocationException e) {
            Messages.showErrorDialog((Project)project, (String)AndroidBundle.message("cant.load.avds.error", new Object[0]), (String)CommonBundle.getErrorTitle());
            return false;
        }
    }

    @Nullable
    public static AvdManager getAvdManagerSilently(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            AvdManagerUtils.$$$reportNull$$$0(2);
        }
        try {
            return AvdManager.getInstance((AndroidSdkHandler)AndroidSdkData.getSdkHolder(facet2), (ILogger)new AvdManagerLog());
        }
        catch (AndroidLocation.AndroidLocationException androidLocationException) {
            return null;
        }
    }

    @NotNull
    static FutureCallback<IDevice> newCallback(@Nullable Project project) {
        return new ShowErrorDialogCallback<IDevice>("AVD Manager", "There was an unspecified error in the AVD Manager. Please consult idea.log for more information.", project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/avdmanager/AvdManagerUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "reloadAvds";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getAvdManagerSilently";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

