/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.debugging;

import com.android.tools.idea.gradle.util.ContentEntries;
import com.intellij.ide.JavaUiBundle;
import com.intellij.ide.util.projectWizard.importSources.JavaModuleSourceRoot;
import com.intellij.ide.util.projectWizard.importSources.JavaSourceRootDetectionUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.progress.util.SmoothProgressAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.SwingWorker;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSourceFolders {
    @NotNull
    private final ModifiableRootModel myModuleModel;

    public ExternalSourceFolders(@NotNull ModifiableRootModel moduleModel) {
        if (moduleModel == null) {
            ExternalSourceFolders.$$$reportNull$$$0(0);
        }
        this.myModuleModel = moduleModel;
    }

    @NotNull
    public List<VirtualFile> addSourceFolders(@NotNull VirtualFile[] files2, @Nullable Runnable runOnFinish) {
        if (files2 == null) {
            ExternalSourceFolders.$$$reportNull$$$0(1);
        }
        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>();
        HashSet<ContentEntry> contentEntries = new HashSet<ContentEntry>();
        for (VirtualFile file : files2) {
            ContentEntry contentEntry = ContentEntries.findParentContentEntry(VfsUtilCore.virtualToIoFile((VirtualFile)file), Arrays.stream(this.myModuleModel.getContentEntries()));
            if (contentEntry == null) {
                contentEntry = this.myModuleModel.addContentEntry(file);
            }
            contentEntries.add(contentEntry);
        }
        if (!contentEntries.isEmpty()) {
            this.addSourceRoots(contentEntries, runOnFinish);
        }
        for (ContentEntry contentEntry : contentEntries) {
            VirtualFile file = contentEntry.getFile();
            if (file == null) continue;
            roots.add(file);
        }
        ArrayList<VirtualFile> arrayList = roots;
        if (arrayList == null) {
            ExternalSourceFolders.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private void addSourceRoots(@NotNull Set<ContentEntry> contentEntries, @Nullable Runnable runOnFinish) {
        EmptyProgressIndicator progressIndicator;
        if (contentEntries == null) {
            ExternalSourceFolders.$$$reportNull$$$0(3);
        }
        HashMap<ContentEntry, Object> entryToRootMap = new HashMap<ContentEntry, Object>();
        HashMap<File, ContentEntry> fileToEntryMap = new HashMap<File, ContentEntry>();
        for (ContentEntry contentEntry : contentEntries) {
            VirtualFile file = contentEntry.getFile();
            if (file == null) continue;
            entryToRootMap.put(contentEntry, null);
            fileToEntryMap.put(VfsUtilCore.virtualToIoFile((VirtualFile)file), contentEntry);
        }
        Project project = this.myModuleModel.getProject();
        Application application = ApplicationManager.getApplication();
        boolean unitTestMode = application.isUnitTestMode();
        if (unitTestMode) {
            progressIndicator = new EmptyProgressIndicator();
        } else {
            ProgressWindow progressWindow = new ProgressWindow(true, project);
            progressWindow.setTitle(JavaUiBundle.message((String)"module.paths.searching.source.roots.title", (Object[])new Object[0]));
            progressIndicator = new SmoothProgressAdapter((ProgressIndicator)progressWindow, project);
        }
        final Runnable searchTask = () -> ExternalSourceFolders.lambda$addSourceRoots$2(fileToEntryMap, (ProgressIndicator)progressIndicator, entryToRootMap, application);
        final Runnable addSourcesTask = () -> {
            for (ContentEntry contentEntry : contentEntries) {
                Collection suggestedRoots = (Collection)entryToRootMap.get(contentEntry);
                if (suggestedRoots == null) continue;
                for (JavaModuleSourceRoot suggestedRoot : suggestedRoots) {
                    VirtualFile sourceRoot = LocalFileSystem.getInstance().findFileByIoFile(suggestedRoot.getDirectory());
                    VirtualFile fileContent = contentEntry.getFile();
                    if (sourceRoot == null || fileContent == null || !VfsUtilCore.isAncestor((VirtualFile)fileContent, (VirtualFile)sourceRoot, (boolean)false)) continue;
                    contentEntry.addSourceFolder(sourceRoot, false, suggestedRoot.getPackagePrefix());
                }
            }
            if (runOnFinish != null) {
                runOnFinish.run();
            }
        };
        if (unitTestMode) {
            searchTask.run();
            addSourcesTask.run();
        } else {
            new SwingWorker(){

                public Object construct() {
                    searchTask.run();
                    return null;
                }

                public void finished() {
                    addSourcesTask.run();
                }
            }.start();
        }
    }

    private static /* synthetic */ void lambda$addSourceRoots$2(Map fileToEntryMap, ProgressIndicator progressIndicator, Map entryToRootMap, Application application) {
        Runnable process2 = () -> {
            for (File file : fileToEntryMap.keySet()) {
                progressIndicator.setText(JavaUiBundle.message((String)"module.paths.searching.source.roots.progress", (Object[])new Object[]{file.getPath()}));
                Collection roots = JavaSourceRootDetectionUtil.suggestRoots((File)file);
                entryToRootMap.put((ContentEntry)fileToEntryMap.get(file), roots);
            }
        };
        if (application.isDispatchThread()) {
            ProgressManager.getInstance().runProcess(process2, progressIndicator);
        } else {
            application.invokeLater(() -> ProgressManager.getInstance().runProcess(process2, progressIndicator));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/apk/debugging/ExternalSourceFolders";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentEntries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/apk/debugging/ExternalSourceFolders";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "addSourceFolders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addSourceFolders";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addSourceRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

