/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk;

import com.android.sdklib.devices.Abi;
import com.android.tools.idea.apk.debugging.DebuggableSharedObjectFile;
import com.android.tools.idea.apk.debugging.NativeLibrary;
import com.android.tools.idea.apk.debugging.SetupIssue;
import com.android.tools.idea.io.FilePaths;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ApkFacetConfiguration
implements FacetConfiguration {
    private static final FacetEditorTab[] EDITOR_TABS = new FacetEditorTab[0];
    @NonNls
    public String APK_PATH;
    @NonNls
    public String APP_PACKAGE;
    @NotNull
    public List<SetupIssue> SETUP_ISSUES = new ArrayList<SetupIssue>();
    @NotNull
    public List<NativeLibrary> NATIVE_LIBRARIES = new ArrayList<NativeLibrary>();
    @NotNull
    public Set<String> JAVA_SOURCE_FOLDER_PATHS = new HashSet<String>();

    public FacetEditorTab[] createEditorTabs(FacetEditorContext editorContext, FacetValidatorsManager validatorsManager) {
        return EDITOR_TABS;
    }

    @NotNull
    public Collection<String> getDebugSymbolFolderPaths(@NotNull List<Abi> abis) {
        if (abis == null) {
            ApkFacetConfiguration.$$$reportNull$$$0(0);
        }
        if (this.NATIVE_LIBRARIES.isEmpty() || abis.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                ApkFacetConfiguration.$$$reportNull$$$0(1);
            }
            return list;
        }
        HashSet<String> paths = new HashSet<String>();
        for (Abi abi : abis) {
            for (NativeLibrary library : this.NATIVE_LIBRARIES) {
                File path2;
                DebuggableSharedObjectFile sharedObjectFile = library.debuggableSharedObjectFilesByAbi.get(abi);
                if (sharedObjectFile == null || !(path2 = FilePaths.toSystemDependentPath((String)sharedObjectFile.path)).exists()) continue;
                paths.add(path2.getParent());
            }
        }
        if (paths.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                ApkFacetConfiguration.$$$reportNull$$$0(2);
            }
            return list;
        }
        HashSet<String> hashSet = paths;
        if (hashSet == null) {
            ApkFacetConfiguration.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    @NotNull
    public Map<File, File> getExplicitModuleSymbolMap(@NotNull Abi abi) {
        if (abi == null) {
            ApkFacetConfiguration.$$$reportNull$$$0(4);
        }
        HashMap<File, File> moduleToSymbols = new HashMap<File, File>();
        for (NativeLibrary library : this.NATIVE_LIBRARIES) {
            VirtualFile lib = library.sharedObjectFilesByAbi.get(abi);
            DebuggableSharedObjectFile sharedObjectFile = library.debuggableSharedObjectFilesByAbi.get(abi);
            if (sharedObjectFile == null || lib == null) continue;
            File libFile = VfsUtilCore.virtualToIoFile((VirtualFile)lib);
            File symFile = FilePaths.toSystemDependentPath((String)sharedObjectFile.path);
            if (!libFile.exists() || !symFile.exists()) continue;
            moduleToSymbols.put(libFile, symFile);
        }
        HashMap<File, File> hashMap = moduleToSymbols;
        if (hashMap == null) {
            ApkFacetConfiguration.$$$reportNull$$$0(5);
        }
        return hashMap;
    }

    @NotNull
    public Map<String, String> getSymbolFolderPathMappings() {
        if (this.NATIVE_LIBRARIES.isEmpty()) {
            Map<String, String> map2 = Collections.emptyMap();
            if (map2 == null) {
                ApkFacetConfiguration.$$$reportNull$$$0(6);
            }
            return map2;
        }
        HashMap<String, String> mappings = new HashMap<String, String>();
        for (NativeLibrary library : this.NATIVE_LIBRARIES) {
            mappings.putAll(library.pathMappings);
        }
        HashMap<String, String> hashMap = mappings;
        if (hashMap == null) {
            ApkFacetConfiguration.$$$reportNull$$$0(7);
        }
        return hashMap;
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            ApkFacetConfiguration.$$$reportNull$$$0(8);
        }
        XmlSerializer.deserializeInto((Object)this, (Element)element);
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            ApkFacetConfiguration.$$$reportNull$$$0(9);
        }
        XmlSerializer.serializeInto((Object)this, (Element)element);
    }

    @NotNull
    public List<NativeLibrary> getLibrariesWithoutDebugSymbols() {
        if (this.NATIVE_LIBRARIES.isEmpty()) {
            List<NativeLibrary> list = Collections.emptyList();
            if (list == null) {
                ApkFacetConfiguration.$$$reportNull$$$0(10);
            }
            return list;
        }
        List<NativeLibrary> list = this.NATIVE_LIBRARIES.stream().filter(library -> !library.hasDebugSymbols).collect(Collectors.toList());
        if (list == null) {
            ApkFacetConfiguration.$$$reportNull$$$0(11);
        }
        return list;
    }

    public void removeIssues(@NotNull String category) {
        if (category == null) {
            ApkFacetConfiguration.$$$reportNull$$$0(12);
        }
        ArrayList<SetupIssue> forRemoval = new ArrayList<SetupIssue>();
        for (SetupIssue issue2 : this.SETUP_ISSUES) {
            if (!category.equals(issue2.category)) continue;
            forRemoval.add(issue2);
        }
        if (!forRemoval.isEmpty()) {
            this.SETUP_ISSUES.removeAll(forRemoval);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "abis";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/apk/ApkFacetConfiguration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "abi";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/apk/ApkFacetConfiguration";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugSymbolFolderPaths";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExplicitModuleSymbolMap";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSymbolFolderPathMappings";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibrariesWithoutDebugSymbols";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDebugSymbolFolderPaths";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getExplicitModuleSymbolMap";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeIssues";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

