/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions.license;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;

public class LicenseTextCollector {
    private final Path myHome;
    private final List<Path> myLicenses;

    public LicenseTextCollector(@NotNull Path ideHome, @NotNull List<Path> licenses) {
        if (ideHome == null) {
            LicenseTextCollector.$$$reportNull$$$0(0);
        }
        if (licenses == null) {
            LicenseTextCollector.$$$reportNull$$$0(1);
        }
        this.myHome = ideHome;
        this.myLicenses = licenses;
    }

    @NotNull
    public CompletableFuture<String> getLicenseText() {
        CompletableFuture<String> completableFuture = CompletableFuture.supplyAsync(this::getLicenseTextSync);
        if (completableFuture == null) {
            LicenseTextCollector.$$$reportNull$$$0(2);
        }
        return completableFuture;
    }

    private String getLicenseTextSync() {
        StringBuilder sb = new StringBuilder(10240);
        for (Path license : this.myLicenses) {
            sb.append("------------ License file: ");
            sb.append(this.myHome.relativize(license).toString());
            sb.append("------------");
            sb.append("<br><br>");
            sb.append(LicenseTextCollector.getLicenseText(license.toFile()));
            sb.append("<br><br>");
        }
        return sb.toString();
    }

    @NotNull
    private static String getLicenseText(@NotNull File f) {
        String string;
        if (f == null) {
            LicenseTextCollector.$$$reportNull$$$0(3);
        }
        try {
            string = Files.toString((File)f, (Charset)Charsets.UTF_8).replaceAll("\\<.*?\\>", "").replace("\n", "<br>");
        }
        catch (IOException e) {
            return "";
        }
        if (string == null) {
            LicenseTextCollector.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideHome";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "licenses";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/actions/license/LicenseTextCollector";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/actions/license/LicenseTextCollector";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLicenseText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLicenseText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

