/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions.annotations;

import com.android.SdkConstants;
import com.android.resources.ResourceType;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.lint.checks.AnnotationDetector;
import com.android.tools.lint.detector.api.ResourceEvaluator;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class InferSupportAnnotations {
    static final boolean CREATE_INFERENCE_REPORT = true;
    static final boolean FILTER_HIDDEN = true;
    public static final String KEEP_ANNOTATION = SdkConstants.SUPPORT_ANNOTATIONS_PREFIX + "Keep";
    private static final int MAX_PASSES = 10;
    private int numAnnotationsAdded;
    private final Map<SmartPsiElementPointer<? extends PsiModifierListOwner>, Constraints> myConstraints = Maps.newHashMapWithExpectedSize((int)400);
    private final boolean myAnnotateLocalVariables;
    private final SmartPointerManager myPointerManager;
    private final Project myProject;

    public InferSupportAnnotations(boolean annotateLocalVariables, Project project) {
        this.myProject = project;
        this.myAnnotateLocalVariables = annotateLocalVariables;
        this.myPointerManager = SmartPointerManager.getInstance((Project)project);
    }

    public static void nothingFoundMessage(final Project project) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                Messages.showInfoMessage((Project)project, (String)"Did not infer any new annotations", (String)"Infer Support Annotation Results");
            }
        });
    }

    @TestOnly
    public void apply(Project project) {
        for (Map.Entry<SmartPsiElementPointer<? extends PsiModifierListOwner>, Constraints> entry : this.myConstraints.entrySet()) {
            SmartPsiElementPointer<? extends PsiModifierListOwner> owner = entry.getKey();
            Constraints value2 = entry.getValue();
            PsiModifierListOwner element = (PsiModifierListOwner)owner.getElement();
            if (element == null) continue;
            InferSupportAnnotations.annotateConstraints(project, value2, element);
        }
        if (this.myConstraints.isEmpty()) {
            throw new RuntimeException("Nothing found to infer");
        }
    }

    public static void apply(Project project, UsageInfo info) {
        if (info instanceof ConstraintUsageInfo) {
            InferSupportAnnotations.annotateConstraints(project, ((ConstraintUsageInfo)info).getConstraints(), (PsiModifierListOwner)info.getElement());
        }
    }

    private static boolean isHidden(@NotNull PsiDocCommentOwner owner) {
        if (owner == null) {
            InferSupportAnnotations.$$$reportNull$$$0(0);
        }
        while (owner != null) {
            PsiDocComment docComment = owner.getDocComment();
            if (docComment != null) {
                String text = docComment.getText();
                return text.contains("@hide");
            }
            owner = (PsiDocCommentOwner)PsiTreeUtil.getParentOfType((PsiElement)owner, PsiDocCommentOwner.class, (boolean)true);
        }
        return false;
    }

    private static void annotateConstraints(Project project, Constraints constraints, PsiModifierListOwner element) {
        if (element == null) {
            return;
        }
        if (constraints.readOnly || ModuleUtilCore.findModuleForPsiElement((PsiElement)element) == null) {
            return;
        }
        PsiDocCommentOwner doc = (PsiDocCommentOwner)PsiTreeUtil.getParentOfType((PsiElement)element, PsiDocCommentOwner.class, (boolean)false);
        if (doc != null && InferSupportAnnotations.isHidden(doc)) {
            return;
        }
        for (String code : constraints.getResourceTypeAnnotations()) {
            InferSupportAnnotations.insertAnnotation(project, element, code);
        }
        for (String code : constraints.getPermissionAnnotations()) {
            InferSupportAnnotations.insertAnnotation(project, element, code);
        }
        if (constraints.keep) {
            InferSupportAnnotations.insertAnnotation(project, element, constraints.getKeepAnnotationsString());
        }
    }

    private static void insertAnnotation(@NotNull Project project, @NotNull PsiModifierListOwner element, @NotNull String code) {
        if (project == null) {
            InferSupportAnnotations.$$$reportNull$$$0(1);
        }
        if (element == null) {
            InferSupportAnnotations.$$$reportNull$$$0(2);
        }
        if (code == null) {
            InferSupportAnnotations.$$$reportNull$$$0(3);
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        PsiAnnotation newAnnotation = elementFactory.createAnnotationFromText(code, (PsiElement)element);
        PsiNameValuePair[] attributes = newAnnotation.getParameterList().getAttributes();
        int end = code.indexOf(40);
        if (end == -1) {
            end = code.length();
        }
        assert (code.startsWith("@")) : code;
        String fqn = code.substring(1, end);
        InferSupportAnnotations.insertAnnotation(project, element, fqn, null, attributes);
    }

    private static void insertAnnotation(final @NotNull Project project, final @NotNull PsiModifierListOwner element, final @NotNull String fqn, final @Nullable String toRemove, final @NotNull PsiNameValuePair[] values) {
        if (project == null) {
            InferSupportAnnotations.$$$reportNull$$$0(4);
        }
        if (element == null) {
            InferSupportAnnotations.$$$reportNull$$$0(5);
        }
        if (fqn == null) {
            InferSupportAnnotations.$$$reportNull$$$0(6);
        }
        if (values == null) {
            InferSupportAnnotations.$$$reportNull$$$0(7);
        }
        WriteCommandAction.runWriteCommandAction((Project)project, (Runnable)new Runnable(){

            @Override
            public void run() {
                String[] stringArray;
                if (toRemove != null) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = toRemove;
                } else {
                    stringArray = ArrayUtil.EMPTY_STRING_ARRAY;
                }
                String[] toRemoveArray = stringArray;
                new AddAnnotationFix(fqn, element, values, toRemoveArray).invoke(project, null, element.getContainingFile());
            }
        });
    }

    public void collect(List<UsageInfo> usages, AnalysisScope scope) {
        for (Map.Entry<SmartPsiElementPointer<? extends PsiModifierListOwner>, Constraints> entry : this.myConstraints.entrySet()) {
            SmartPsiElementPointer<? extends PsiModifierListOwner> pointer = entry.getKey();
            PsiModifierListOwner element = (PsiModifierListOwner)pointer.getElement();
            if (element == null || !scope.contains((PsiElement)element) || this.shouldIgnore(element)) continue;
            Constraints constraints = entry.getValue();
            usages.add(new ConstraintUsageInfo((PsiElement)element, constraints));
        }
    }

    private boolean shouldIgnore(PsiModifierListOwner element) {
        if (!this.myAnnotateLocalVariables) {
            if (element instanceof PsiLocalVariable) {
                return true;
            }
            if (element instanceof PsiParameter && ((PsiParameter)element).getDeclarationScope() instanceof PsiForeachStatement) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    private Constraints registerPermissionRequirement(@NotNull PsiModifierListOwner owner, boolean all, Object ... permissions) {
        SmartPsiElementPointer pointer;
        Constraints constraints;
        if (owner == null) {
            InferSupportAnnotations.$$$reportNull$$$0(8);
        }
        if ((constraints = this.myConstraints.get(pointer = this.myPointerManager.createSmartPsiElementPointer((PsiElement)owner))) == null) {
            constraints = new Constraints();
            constraints.permissionReferences = Sets.newHashSet((Object[])permissions);
            constraints.requireAllPermissions = all;
            this.storeConstraint(owner, (SmartPsiElementPointer<PsiModifierListOwner>)pointer, constraints);
            ++this.numAnnotationsAdded;
        } else if (constraints.permissionReferences == null) {
            constraints.permissionReferences = Sets.newHashSet((Object[])permissions);
            constraints.requireAllPermissions = all;
            ++this.numAnnotationsAdded;
        } else {
            Set<Object> set = constraints.permissionReferences;
            if (Collections.addAll(set, permissions)) {
                if (set.size() > 1) {
                    constraints.requireAllPermissions = all;
                }
                ++this.numAnnotationsAdded;
            } else {
                return null;
            }
        }
        return constraints;
    }

    private void storeConstraint(@NotNull PsiModifierListOwner owner, SmartPsiElementPointer<PsiModifierListOwner> pointer, Constraints constraints) {
        if (owner == null) {
            InferSupportAnnotations.$$$reportNull$$$0(9);
        }
        boolean bl = constraints.readOnly = ModuleUtilCore.findModuleForPsiElement((PsiElement)owner) == null;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            constraints.readOnly = false;
        }
        this.myConstraints.put(pointer, constraints);
    }

    public void collect(@NotNull PsiFile file) {
        int prevNumAnnotationsAdded;
        if (file == null) {
            InferSupportAnnotations.$$$reportNull$$$0(10);
        }
        int pass = 0;
        do {
            InferenceVisitor visitor = new InferenceVisitor();
            prevNumAnnotationsAdded = this.numAnnotationsAdded;
            file.accept((PsiElementVisitor)visitor);
        } while (prevNumAnnotationsAdded < this.numAnnotationsAdded && ++pass < 10);
    }

    @Nullable
    private Constraints getResourceTypeConstraints(PsiModifierListOwner owner, boolean inHierarchy) {
        Constraints constraints = null;
        for (PsiAnnotation annotation : AnnotationUtil.getAllAnnotations((PsiModifierListOwner)owner, (boolean)inHierarchy, null)) {
            String name;
            String qualifiedName = annotation.getQualifiedName();
            if (qualifiedName == null) continue;
            ResourceType type = null;
            if (qualifiedName.startsWith(SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.oldName()) && qualifiedName.endsWith("Res")) {
                name = qualifiedName.substring(SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.oldName().length(), qualifiedName.length() - "Res".length());
                type = ResourceType.fromClassName((String)StringUtil.toLowerCase((String)name));
            } else if (qualifiedName.startsWith(SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.newName()) && qualifiedName.endsWith("Res")) {
                name = qualifiedName.substring(SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.newName().length(), qualifiedName.length() - "Res".length());
                type = ResourceType.fromClassName((String)StringUtil.toLowerCase((String)name));
            } else if (ResourceEvaluator.COLOR_INT_ANNOTATION.isEquals(qualifiedName)) {
                type = ResourceEvaluator.COLOR_INT_MARKER_TYPE;
            } else if (ResourceEvaluator.PX_ANNOTATION.isEquals(qualifiedName)) {
                type = ResourceEvaluator.DIMENSION_MARKER_TYPE;
            }
            if (type == null) continue;
            if (constraints == null) {
                constraints = new Constraints();
            }
            constraints.addResourceType(type);
        }
        SmartPsiElementPointer pointer = this.myPointerManager.createSmartPsiElementPointer((PsiElement)owner);
        Constraints existing2 = this.myConstraints.get(pointer);
        if (existing2 != null) {
            if (constraints != null) {
                constraints.merge(existing2);
                return constraints;
            }
            return existing2;
        }
        return constraints;
    }

    @Nullable
    private PsiModifierListOwner findReflectiveReference(PsiMethodCallExpression call) {
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        if (!"invoke".equals(methodExpression.getReferenceName())) {
            return null;
        }
        PsiElement qualifier = methodExpression.getQualifier();
        PsiMethodCallExpression methodCall = null;
        if (qualifier instanceof PsiMethodCallExpression) {
            methodCall = (PsiMethodCallExpression)qualifier;
        } else if (qualifier instanceof PsiReferenceExpression) {
            PsiLocalVariable var;
            PsiExpression initializer;
            PsiElement methodVar = ((PsiReferenceExpression)qualifier).resolve();
            if (methodVar == null) {
                return null;
            }
            if (methodVar instanceof PsiLocalVariable && (initializer = (var = (PsiLocalVariable)methodVar).getInitializer()) instanceof PsiMethodCallExpression) {
                methodCall = (PsiMethodCallExpression)initializer;
            }
        } else {
            return null;
        }
        if (methodCall != null) {
            PsiReferenceExpression methodCallMethodExpression = methodCall.getMethodExpression();
            String declarationName = methodCallMethodExpression.getReferenceName();
            if (!"getDeclaredMethod".equals(declarationName) && !"getMethod".equals(declarationName)) {
                return null;
            }
            PsiExpression[] arguments = methodCall.getArgumentList().getExpressions();
            if (arguments.length < 1) {
                return null;
            }
            Object o = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)arguments[0], (boolean)false);
            if (!(o instanceof String)) {
                return null;
            }
            String methodName = (String)o;
            String className = null;
            qualifier = methodCallMethodExpression.getQualifier();
            if (qualifier instanceof PsiReferenceExpression) {
                PsiElement clsVar = ((PsiReferenceExpression)qualifier).resolve();
                if (clsVar == null) {
                    return null;
                }
                if (clsVar instanceof PsiLocalVariable) {
                    PsiLocalVariable var = (PsiLocalVariable)clsVar;
                    qualifier = var.getInitializer();
                }
            }
            if (qualifier instanceof PsiMethodCallExpression) {
                methodCall = (PsiMethodCallExpression)qualifier;
                methodCallMethodExpression = methodCall.getMethodExpression();
                declarationName = methodCallMethodExpression.getReferenceName();
                if (!"loadClass".equals(declarationName) && !"forName".equals(declarationName)) {
                    return null;
                }
                PsiExpression[] arguments2 = methodCall.getArgumentList().getExpressions();
                if (arguments2.length < 1) {
                    return null;
                }
                o = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)arguments2[0], (boolean)false);
                if (!(o instanceof String)) {
                    return null;
                }
                className = (String)o;
            } else if (qualifier instanceof PsiClassObjectAccessExpression) {
                PsiClassObjectAccessExpression accessExpression = (PsiClassObjectAccessExpression)qualifier;
                PsiTypeElement operand = accessExpression.getOperand();
                if (operand != null) {
                    className = operand.getType().getCanonicalText();
                }
            } else {
                return null;
            }
            if (className != null) {
                PsiClass psiClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(className, GlobalSearchScope.allScope((Project)this.myProject));
                if (psiClass == null) {
                    return null;
                }
                PsiMethod[] methods = psiClass.findMethodsByName(methodName, true);
                if (methods.length == 1) {
                    return methods[0];
                }
                if (methods.length == 0) {
                    return null;
                }
                for (PsiMethod method : methods) {
                    PsiParameter[] parameters2 = method.getParameterList().getParameters();
                    if (arguments.length != parameters2.length + 1) continue;
                    boolean allMatch = true;
                    for (int i2 = 0; i2 < parameters2.length; ++i2) {
                        PsiParameter parameter = parameters2[i2];
                        PsiExpression argument = arguments[i2 + 1];
                        PsiType parameterType = parameter.getType();
                        PsiType argumentType = argument.getType();
                        if (InferSupportAnnotations.typesMatch(argumentType, parameterType)) continue;
                        allMatch = false;
                        break;
                    }
                    if (!allMatch) continue;
                    return method;
                }
                return null;
            }
        }
        return null;
    }

    private static boolean typesMatch(PsiType argumentType, PsiType parameterType) {
        if (argumentType instanceof PsiClassType) {
            PsiClassType type = (PsiClassType)argumentType;
            PsiType[] typeParameters = type.getParameters();
            if (typeParameters.length != 1) {
                return false;
            }
            PsiPrimitiveType unboxed = PsiPrimitiveType.getUnboxedType((PsiType)parameterType);
            if (unboxed != null) {
                parameterType = unboxed;
            }
            if ((unboxed = PsiPrimitiveType.getUnboxedType((PsiType)(argumentType = typeParameters[0]))) != null) {
                argumentType = unboxed;
            }
            return parameterType.equals(argumentType);
        }
        return false;
    }

    @Nullable
    private Constraints computeRequiredPermissions(PsiModifierListOwner owner) {
        Constraints constraints = null;
        for (PsiAnnotation annotation : AnnotationUtil.getAllAnnotations((PsiModifierListOwner)owner, (boolean)true, null)) {
            String qualifiedName = annotation.getQualifiedName();
            if (qualifiedName == null) continue;
            if (AnnotationDetector.PERMISSION_ANNOTATION.isPrefix(qualifiedName)) {
                if (constraints == null) {
                    constraints = new Constraints();
                }
                ArrayList<Object> permissions = new ArrayList<Object>();
                PsiAnnotationMemberValue value2 = annotation.findAttributeValue(null);
                InferSupportAnnotations.addPermissions(value2, permissions);
                if (!permissions.isEmpty()) {
                    constraints.permissionReferences = Sets.newHashSet(permissions);
                    continue;
                }
                PsiAnnotationMemberValue anyOf = annotation.findAttributeValue("anyOf");
                InferSupportAnnotations.addPermissions(anyOf, permissions);
                if (!permissions.isEmpty()) {
                    constraints.permissionReferences = Sets.newHashSet(permissions);
                    continue;
                }
                PsiAnnotationMemberValue allOf = annotation.findAttributeValue("allOf");
                InferSupportAnnotations.addPermissions(allOf, permissions);
                if (permissions.isEmpty()) continue;
                constraints.permissionReferences = Sets.newHashSet(permissions);
                constraints.requireAllPermissions = true;
                continue;
            }
            if (!AnnotationDetector.UI_THREAD_ANNOTATION.isEquals(qualifiedName) && !AnnotationDetector.MAIN_THREAD_ANNOTATION.isEquals(qualifiedName) && !AnnotationDetector.BINDER_THREAD_ANNOTATION.isEquals(qualifiedName) && !AnnotationDetector.WORKER_THREAD_ANNOTATION.isEquals(qualifiedName)) continue;
        }
        SmartPsiElementPointer pointer = this.myPointerManager.createSmartPsiElementPointer((PsiElement)owner);
        Constraints existing2 = this.myConstraints.get(pointer);
        if (existing2 != null) {
            if (constraints != null) {
                constraints.merge(existing2);
                return constraints;
            }
            return existing2;
        }
        return constraints;
    }

    private static void addPermissions(@Nullable PsiAnnotationMemberValue value2, @NotNull List<Object> names) {
        if (names == null) {
            InferSupportAnnotations.$$$reportNull$$$0(11);
        }
        if (value2 == null) {
            return;
        }
        if (value2 instanceof PsiLiteral) {
            String name = (String)((PsiLiteral)value2).getValue();
            if (name != null && !name.isEmpty()) {
                names.add(name);
            }
        } else if (value2 instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)value2;
            PsiElement resolved = referenceExpression.resolve();
            if (resolved instanceof PsiField) {
                names.add(resolved);
            }
        } else if (value2 instanceof PsiArrayInitializerMemberValue) {
            PsiArrayInitializerMemberValue array = (PsiArrayInitializerMemberValue)value2;
            for (PsiAnnotationMemberValue memberValue : array.getInitializers()) {
                InferSupportAnnotations.addPermissions(memberValue, names);
            }
        }
    }

    @Nullable
    private Constraints storeConstraints(@NotNull PsiModifierListOwner owner, @NotNull Constraints constraints) {
        SmartPsiElementPointer pointer;
        Constraints existing2;
        if (owner == null) {
            InferSupportAnnotations.$$$reportNull$$$0(12);
        }
        if (constraints == null) {
            InferSupportAnnotations.$$$reportNull$$$0(13);
        }
        if ((existing2 = this.myConstraints.get(pointer = this.myPointerManager.createSmartPsiElementPointer((PsiElement)owner))) == null && (existing2 = this.getResourceTypeConstraints(owner, false)) != null) {
            this.storeConstraint(owner, (SmartPsiElementPointer<PsiModifierListOwner>)pointer, existing2);
        }
        if (existing2 == null) {
            this.storeConstraint(owner, (SmartPsiElementPointer<PsiModifierListOwner>)pointer, constraints);
            ++this.numAnnotationsAdded;
            return constraints;
        }
        int added = existing2.merge(constraints);
        this.numAnnotationsAdded += added;
        return added > 0 ? existing2 : null;
    }

    @NotNull
    public static String generateReport(@NotNull UsageInfo[] infos) {
        if (infos == null) {
            InferSupportAnnotations.$$$reportNull$$$0(14);
        }
        StringBuilder sb = new StringBuilder(1000);
        sb.append("INFER SUPPORT ANNOTATIONS REPORT\n");
        sb.append("================================\n\n");
        ArrayList<String> list = new ArrayList<String>();
        for (UsageInfo info : infos) {
            ((ConstraintUsageInfo)info).addInferenceExplanations(list);
        }
        Collections.sort(list);
        String lastClass = null;
        String lastMethod = null;
        String lastLine = null;
        for (String s : list) {
            if (s.equals(lastLine)) continue;
            lastLine = s;
            String cls = null;
            String method = null;
            String field2 = null;
            String parameter = null;
            int index = s.indexOf("Class{");
            if (index != -1) {
                cls = s.substring(index + "Class{".length(), s.indexOf(125, index));
            }
            if ((index = s.indexOf("Method{")) != -1) {
                method = s.substring(index + "Method{".length(), s.indexOf(125, index));
                index = s.indexOf("Parameter{");
                if (index != -1) {
                    parameter = s.substring(index + "Parameter{".length(), s.indexOf(125, index));
                }
            } else {
                index = s.indexOf("Field{");
                if (index != -1) {
                    field2 = s.substring(index + "Field{".length(), s.indexOf(125, index));
                }
            }
            boolean printedMethod = false;
            if (cls != null && !cls.equals(lastClass)) {
                lastClass = cls;
                lastMethod = null;
                sb.append("\n");
                sb.append("Class ").append(cls).append(":\n");
            }
            if (method != null && !method.equals(lastMethod)) {
                lastMethod = method;
                sb.append("  Method ").append(method).append(":\n");
                printedMethod = true;
            } else if (field2 != null) {
                sb.append("  Field ").append(field2).append(":\n");
            }
            if (parameter != null) {
                if (!printedMethod) {
                    sb.append("  Method ").append(method).append(":\n");
                }
                sb.append("    Parameter ");
                sb.append(parameter).append(":\n");
            }
            String message2 = s.substring(s.indexOf(58) + 1);
            sb.append("      ").append(message2).append("\n");
        }
        if (list.isEmpty()) {
            sb.append("Nothing found.");
        }
        String string = sb.toString();
        if (string == null) {
            InferSupportAnnotations.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "code";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraints";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/actions/annotations/InferSupportAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/actions/annotations/InferSupportAnnotations";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "generateReport";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isHidden";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "insertAnnotation";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerPermissionRequirement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "storeConstraint";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collect";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addPermissions";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "storeConstraints";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "generateReport";
                break;
            }
            case 15: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class InferenceVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private InferenceVisitor() {
        }

        public void visitMethod(final @NotNull PsiMethod method) {
            PsiCodeBlock body;
            if (method == null) {
                InferenceVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethod(method);
            Constraints constraints = InferSupportAnnotations.this.getResourceTypeConstraints((PsiModifierListOwner)method, true);
            Collection overridingMethods = OverridingMethodsSearch.search((PsiMethod)method).findAll();
            for (PsiMethod overridingMethod : overridingMethods) {
                Constraints additional = InferSupportAnnotations.this.getResourceTypeConstraints((PsiModifierListOwner)overridingMethod, true);
                if (additional == null) continue;
                if (constraints == null) {
                    constraints = additional;
                    continue;
                }
                constraints.addResourceTypes(additional.types);
            }
            if (constraints != null && (constraints = InferSupportAnnotations.this.storeConstraints((PsiModifierListOwner)method, constraints)) != null && !constraints.readOnly) {
                constraints.addReport((PsiModifierListOwner)method, constraints.getResourceTypeAnnotationsString() + " because it extends or is overridden by an annotated method");
            }
            if ((body = method.getBody()) != null) {
                body.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){
                    private boolean myReturnedFromMethod = false;

                    public void visitClass(PsiClass aClass) {
                    }

                    public void visitThrowStatement(PsiThrowStatement statement) {
                        this.myReturnedFromMethod = true;
                        super.visitThrowStatement(statement);
                    }

                    public void visitLambdaExpression(PsiLambdaExpression expression) {
                    }

                    public void visitReturnStatement(PsiReturnStatement statement) {
                        PsiElement resolved;
                        PsiExpression expression = statement.getReturnValue();
                        if (!(expression instanceof PsiReferenceExpression) || (resolved = ((PsiReferenceExpression)expression).resolve()) instanceof PsiModifierListOwner) {
                            // empty if block
                        }
                        this.myReturnedFromMethod = true;
                        super.visitReturnStatement(statement);
                    }

                    public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                        PsiExpression[] args;
                        String name;
                        PsiModifierListOwner reflectiveReference;
                        String message2;
                        String signature;
                        PsiClass containingClass;
                        Constraints constraints;
                        super.visitMethodCallExpression(expression);
                        PsiMethod calledMethod = expression.resolveMethod();
                        if (calledMethod != null && (constraints = InferSupportAnnotations.this.computeRequiredPermissions((PsiModifierListOwner)calledMethod)) != null && constraints.permissionReferences != null && this.isUnconditionallyReachable(method, (PsiElement)expression)) {
                            Constraints inferred = constraints;
                            if ((constraints = InferSupportAnnotations.this.storeConstraints((PsiModifierListOwner)method, constraints)) != null && !constraints.readOnly) {
                                containingClass = calledMethod.getContainingClass();
                                signature = (String)(containingClass != null ? containingClass.getName() + "#" : "") + calledMethod.getName();
                                message2 = inferred.getPermissionAnnotationsString() + " because it calls " + (String)signature;
                                constraints.addReport((PsiModifierListOwner)method, message2);
                            }
                        }
                        if ((reflectiveReference = InferSupportAnnotations.this.findReflectiveReference(expression)) != null) {
                            Constraints constraints2 = new Constraints();
                            constraints2.keep = true;
                            if ((constraints2 = InferSupportAnnotations.this.storeConstraints(reflectiveReference, constraints2)) != null && !constraints2.readOnly) {
                                containingClass = method.getContainingClass();
                                signature = (String)(containingClass != null ? containingClass.getName() + "#" : "") + method.getName();
                                message2 = constraints2.getKeepAnnotationsString() + " because it is called reflectively from " + signature;
                                constraints2.addReport(reflectiveReference, message2);
                            }
                        }
                        if ((name = expression.getMethodExpression().getReferenceName()) != null && name.startsWith("enforce") && ("enforceCallingOrSelfPermission".equals(name) || "enforceCallingOrSelfUriPermission".equals(name) || "enforceCallingPermission".equals(name) || "enforceCallingUriPermission".equals(name) || "enforcePermission".equals(name) || "enforceUriPermission".equals(name)) && (args = expression.getArgumentList().getExpressions()).length > 0) {
                            String permission;
                            Constraints constraints3;
                            PsiField field2;
                            PsiElement resolved;
                            PsiExpression first = args[0];
                            PsiReference reference2 = first.getReference();
                            if (reference2 != null && (resolved = reference2.resolve()) instanceof PsiField && (field2 = (PsiField)resolved).hasModifierProperty("final") && field2.hasModifierProperty("static")) {
                                Constraints constraints4 = InferSupportAnnotations.this.registerPermissionRequirement((PsiModifierListOwner)method, true, field2);
                                if (constraints4 != null && !constraints4.readOnly) {
                                    constraints4.addReport((PsiModifierListOwner)method, constraints4.getPermissionAnnotationsString() + " because it calls " + name);
                                }
                                return;
                            }
                            Object v = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)first, (boolean)false);
                            if (v instanceof String && (constraints3 = InferSupportAnnotations.this.registerPermissionRequirement((PsiModifierListOwner)method, true, permission = (String)v)) != null && !constraints3.readOnly) {
                                constraints3.addReport((PsiModifierListOwner)method, constraints3.getPermissionAnnotationsString() + " because it calls " + name);
                            }
                        }
                    }

                    private boolean isUnconditionallyReachable(PsiMethod method2, PsiElement expression) {
                        PsiElement curr;
                        if (this.myReturnedFromMethod) {
                            return false;
                        }
                        PsiElement prev = curr = expression.getParent();
                        while (curr != null) {
                            PsiBinaryExpression binaryExpression;
                            if (curr == method2) {
                                return true;
                            }
                            if (curr instanceof PsiIfStatement || curr instanceof PsiConditionalExpression || curr instanceof PsiSwitchStatement) {
                                return false;
                            }
                            if (curr instanceof PsiBinaryExpression && prev != (binaryExpression = (PsiBinaryExpression)curr).getLOperand() && binaryExpression.getOperationTokenType() == JavaTokenType.ANDAND) {
                                return false;
                            }
                            prev = curr;
                            curr = curr.getParent();
                        }
                        return true;
                    }
                });
            }
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            PsiMethod method = expression.resolveMethod();
            if (method != null) {
                PsiParameter[] parameters2 = method.getParameterList().getParameters();
                PsiExpression[] arguments = expression.getArgumentList().getExpressions();
                if (parameters2.length > 0 && arguments.length >= parameters2.length) {
                    for (int i2 = 0; i2 < arguments.length; ++i2) {
                        PsiParameter parameter;
                        PsiExpression argument = arguments[i2];
                        ResourceType resourceType = AndroidPsiUtils.getResourceType((PsiElement)argument);
                        if (resourceType == null || !PsiType.INT.equals((Object)(parameter = parameters2[i2]).getType()) || i2 == 1 && parameters2.length == 2 && method.getName().startsWith("put")) continue;
                        Constraints newConstraint = new Constraints();
                        newConstraint.addResourceType(resourceType);
                        Constraints constraints = InferSupportAnnotations.this.storeConstraints((PsiModifierListOwner)parameter, newConstraint);
                        if (constraints == null || constraints.readOnly) continue;
                        constraints.addReport((PsiModifierListOwner)parameter, newConstraint.getResourceTypeAnnotationsString() + " because it's passed " + argument.getText() + " in a call");
                    }
                }
            }
        }

        public void visitReturnStatement(PsiReturnStatement statement) {
            PsiMethod method;
            Constraints constraints;
            PsiModifierListOwner owner;
            Constraints newConstraint;
            PsiElement resolved;
            super.visitReturnStatement(statement);
            PsiExpression returnValue = statement.getReturnValue();
            if (returnValue == null) {
                return;
            }
            ResourceType resourceType = AndroidPsiUtils.getResourceType((PsiElement)returnValue);
            if (resourceType != null) {
                Constraints newConstraint2 = new Constraints();
                newConstraint2.addResourceType(resourceType);
                PsiMethod method2 = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiMethod.class);
                Constraints constraints2 = InferSupportAnnotations.this.storeConstraints((PsiModifierListOwner)method2, newConstraint2);
                if (constraints2 != null && !constraints2.readOnly) {
                    constraints2.addReport((PsiModifierListOwner)method2, newConstraint2.getResourceTypeAnnotationsString() + " because it returns " + returnValue.getText());
                }
            } else if (returnValue instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)returnValue).resolve()) instanceof PsiModifierListOwner && (newConstraint = InferSupportAnnotations.this.getResourceTypeConstraints(owner = (PsiModifierListOwner)resolved, true)) != null && (constraints = InferSupportAnnotations.this.storeConstraints((PsiModifierListOwner)(method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiMethod.class)), newConstraint)) != null && !constraints.readOnly) {
                constraints.addReport((PsiModifierListOwner)method, newConstraint.getResourceTypeAnnotationsString() + " because it returns " + returnValue.getText());
            }
        }

        public void visitParameter(@NotNull PsiParameter parameter) {
            PsiMethod method;
            PsiElement grandParent;
            Constraints constraints;
            if (parameter == null) {
                InferenceVisitor.$$$reportNull$$$0(1);
            }
            super.visitParameter(parameter);
            Constraints resourceTypeConstraints = InferSupportAnnotations.this.getResourceTypeConstraints((PsiModifierListOwner)parameter, true);
            if (resourceTypeConstraints != null && resourceTypeConstraints.types != null && !resourceTypeConstraints.types.isEmpty() && (constraints = InferSupportAnnotations.this.storeConstraints((PsiModifierListOwner)parameter, resourceTypeConstraints)) != null && !constraints.readOnly) {
                constraints.addReport((PsiModifierListOwner)parameter, constraints.getResourceTypeAnnotationsString() + " because it extends a method with that parameter annotated or inferred");
            }
            if ((grandParent = parameter.getDeclarationScope()) instanceof PsiMethod && (method = (PsiMethod)grandParent).getBody() != null) {
                for (PsiReference reference2 : ReferencesSearch.search((PsiElement)parameter, (SearchScope)new LocalSearchScope((PsiElement)method))) {
                    PsiElement parent;
                    PsiReferenceExpression expr;
                    PsiElement place = reference2.getElement();
                    if (!(place instanceof PsiReferenceExpression) || !this.processParameter(parameter, expr = (PsiReferenceExpression)place, parent = PsiTreeUtil.skipParentsOfType((PsiElement)expr, (Class[])new Class[]{PsiParenthesizedExpression.class, PsiTypeCastExpression.class}))) continue;
                    return;
                }
            }
        }

        private boolean processParameter(PsiParameter parameter, PsiReferenceExpression expr, PsiElement parent) {
            PsiParameter resolvedToParam;
            Constraints constraints;
            PsiParameter[] parameters2;
            PsiMethod resolvedMethod;
            Object[] args;
            int idx;
            PsiExpressionList argumentList;
            if (PsiUtil.isAccessedForWriting((PsiExpression)expr)) {
                return true;
            }
            PsiCall call = (PsiCall)PsiTreeUtil.getParentOfType((PsiElement)expr, PsiCall.class);
            if (call != null && (argumentList = call.getArgumentList()) != null && (idx = ArrayUtil.find((Object[])(args = argumentList.getExpressions()), (Object)expr)) >= 0 && (resolvedMethod = call.resolveMethod()) != null && idx < (parameters2 = resolvedMethod.getParameterList().getParameters()).length && (constraints = InferSupportAnnotations.this.getResourceTypeConstraints((PsiModifierListOwner)(resolvedToParam = parameters2[idx]), true)) != null && constraints.types != null && !constraints.types.isEmpty() && !resolvedToParam.isVarArgs()) {
                if ((constraints = InferSupportAnnotations.this.storeConstraints((PsiModifierListOwner)parameter, constraints)) != null && !constraints.readOnly) {
                    constraints.addReport((PsiModifierListOwner)parameter, constraints.getResourceTypeAnnotationsString() + " because it calls " + (String)(resolvedMethod.getContainingClass() != null ? resolvedMethod.getContainingClass().getName() + "#" : "") + resolvedMethod.getName());
                }
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/actions/annotations/InferSupportAnnotations$InferenceVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethod";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitParameter";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ConstraintUsageInfo
    extends UsageInfo {
        private final Constraints myConstraints;

        private ConstraintUsageInfo(@NotNull PsiElement element, @NotNull Constraints constraints) {
            if (element == null) {
                ConstraintUsageInfo.$$$reportNull$$$0(0);
            }
            if (constraints == null) {
                ConstraintUsageInfo.$$$reportNull$$$0(1);
            }
            super(element);
            this.myConstraints = constraints;
        }

        public Constraints getConstraints() {
            return this.myConstraints;
        }

        public void addInferenceExplanations(List<String> list) {
            if (this.myConstraints.inferences != null) {
                list.addAll(this.myConstraints.inferences);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "constraints";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/actions/annotations/InferSupportAnnotations$ConstraintUsageInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Constraints {
        public List<String> inferences;
        public boolean readOnly;
        @Nullable
        public EnumSet<ResourceType> types;
        @Nullable
        public Set<Object> permissionReferences;
        public boolean requireAllPermissions;
        public boolean keep;

        private Constraints() {
        }

        public void addResourceType(@Nullable ResourceType type) {
            if (type != null) {
                if (this.types == null) {
                    this.types = EnumSet.of(type);
                } else {
                    this.types.add(type);
                }
            }
        }

        public void addResourceTypes(@Nullable EnumSet<ResourceType> types) {
            if (types != null) {
                if (this.types == null) {
                    this.types = EnumSet.copyOf(types);
                } else {
                    this.types.addAll(types);
                }
            }
        }

        public void addReport(PsiModifierListOwner annotated, String message2) {
            PsiMethod method;
            PsiClass cls = null;
            PsiMember member = null;
            PsiParameter parameter = null;
            if (annotated instanceof PsiClass) {
                cls = (PsiClass)annotated;
            } else if (annotated instanceof PsiMethod || annotated instanceof PsiField) {
                member = (PsiMember)annotated;
                cls = member.getContainingClass();
            } else if (annotated instanceof PsiParameter && (method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)(parameter = (PsiParameter)annotated), PsiMethod.class, (boolean)true)) != null) {
                member = method;
                cls = method.getContainingClass();
            }
            StringBuilder sb = new StringBuilder();
            if (cls != null) {
                sb.append("Class{").append(cls.getName());
                if (InferSupportAnnotations.isHidden((PsiDocCommentOwner)cls)) {
                    sb.append(" (Hidden)");
                }
                sb.append('}');
            }
            if (member instanceof PsiMethod) {
                sb.append(" Method{").append(member.getName());
                if (InferSupportAnnotations.isHidden((PsiDocCommentOwner)((PsiMethod)member))) {
                    sb.append(" (Hidden)");
                }
                sb.append('}');
            }
            if (member instanceof PsiField) {
                sb.append("Field{").append(member.getName());
                if (InferSupportAnnotations.isHidden((PsiDocCommentOwner)((PsiField)member))) {
                    sb.append(" (Hidden)");
                }
                sb.append('}');
            }
            if (parameter != null) {
                sb.append("Parameter");
                sb.append("{");
                sb.append(parameter.getType().getCanonicalText()).append(" ").append(parameter.getName());
                sb.append("}");
            }
            sb.append(":");
            sb.append(message2);
            if (this.inferences == null) {
                this.inferences = Lists.newArrayListWithCapacity((int)4);
            }
            this.inferences.add(sb.toString());
        }

        public int merge(Constraints other) {
            int added = 0;
            if (other.types != null) {
                if (this.types == null) {
                    this.types = other.types;
                    ++added;
                } else if (this.types.addAll(other.types)) {
                    ++added;
                }
            }
            if (other.permissionReferences != null) {
                if (this.permissionReferences == null) {
                    this.permissionReferences = other.permissionReferences;
                    ++added;
                } else if (this.permissionReferences.addAll(other.permissionReferences)) {
                    ++added;
                }
                if (other.permissionReferences.size() > 1) {
                    this.requireAllPermissions = other.requireAllPermissions;
                }
            }
            if (!this.keep && other.keep) {
                this.keep = true;
                ++added;
            }
            if (other.inferences != null) {
                if (this.inferences == null) {
                    this.inferences = other.inferences;
                } else {
                    for (String inference : other.inferences) {
                        if (this.inferences.contains(inference)) continue;
                        this.inferences.add(inference);
                    }
                }
            }
            return added;
        }

        @NotNull
        public List<String> getResourceTypeAnnotations() {
            if (this.types != null && !this.types.isEmpty()) {
                ArrayList<String> annotations = new ArrayList<String>();
                for (ResourceType type : this.types) {
                    StringBuilder oldAnnotation = new StringBuilder();
                    StringBuilder newAnnotation = new StringBuilder();
                    oldAnnotation.append('@');
                    newAnnotation.append('@');
                    if (type == ResourceEvaluator.COLOR_INT_MARKER_TYPE) {
                        oldAnnotation.append(ResourceEvaluator.COLOR_INT_ANNOTATION.oldName());
                        newAnnotation.append(ResourceEvaluator.COLOR_INT_ANNOTATION.newName());
                    } else if (type == ResourceEvaluator.DIMENSION_MARKER_TYPE) {
                        oldAnnotation.append(ResourceEvaluator.PX_ANNOTATION.oldName());
                        newAnnotation.append(ResourceEvaluator.PX_ANNOTATION.newName());
                    } else {
                        if (type == ResourceType.MIPMAP) {
                            type = ResourceType.DRAWABLE;
                        } else if (type == ResourceType.STYLEABLE) continue;
                        oldAnnotation.append(SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.oldName());
                        oldAnnotation.append(StringUtil.capitalize((String)type.getName()));
                        oldAnnotation.append("Res");
                        newAnnotation.append(SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.newName());
                        newAnnotation.append(StringUtil.capitalize((String)type.getName()));
                        newAnnotation.append("Res");
                    }
                    annotations.add(oldAnnotation.toString());
                    annotations.add(newAnnotation.toString());
                }
                ArrayList<String> arrayList = annotations;
                if (arrayList == null) {
                    Constraints.$$$reportNull$$$0(0);
                }
                return arrayList;
            }
            List<String> list = Collections.emptyList();
            if (list == null) {
                Constraints.$$$reportNull$$$0(1);
            }
            return list;
        }

        @NotNull
        public List<String> getPermissionAnnotations() {
            if (this.permissionReferences != null && !this.permissionReferences.isEmpty()) {
                if (this.permissionReferences.size() == 1) {
                    Object permission = this.permissionReferences.iterator().next();
                    StringBuilder sb = new StringBuilder();
                    sb.append('@').append(AnnotationDetector.PERMISSION_ANNOTATION.oldName()).append('(');
                    if (permission instanceof String) {
                        sb.append('\"');
                        sb.append(permission);
                        sb.append('\"');
                    } else if (permission instanceof PsiField) {
                        String qualifiedName;
                        PsiField field2 = (PsiField)permission;
                        PsiClass containingClass = field2.getContainingClass();
                        if (containingClass != null && (qualifiedName = containingClass.getQualifiedName()) != null) {
                            sb.append(qualifiedName);
                            sb.append('.');
                        }
                        sb.append(field2.getName());
                    }
                    sb.append(')');
                    List<String> list = Collections.singletonList(sb.toString());
                    if (list == null) {
                        Constraints.$$$reportNull$$$0(2);
                    }
                    return list;
                }
                StringBuilder sb = new StringBuilder();
                sb.append('@').append(AnnotationDetector.PERMISSION_ANNOTATION.oldName()).append('(');
                if (this.requireAllPermissions) {
                    sb.append("allOf");
                } else {
                    sb.append("anyOf");
                }
                sb.append("={");
                boolean first = true;
                for (Object permission : this.permissionReferences) {
                    String qualifiedName;
                    if (first) {
                        first = false;
                    } else {
                        sb.append(',');
                    }
                    if (permission instanceof String) {
                        sb.append('\"');
                        sb.append(permission);
                        sb.append('\"');
                        continue;
                    }
                    if (!(permission instanceof PsiField)) continue;
                    PsiField field3 = (PsiField)permission;
                    PsiClass containingClass = field3.getContainingClass();
                    if (containingClass != null && (qualifiedName = containingClass.getQualifiedName()) != null) {
                        sb.append(qualifiedName);
                        sb.append('.');
                    }
                    sb.append(field3.getName());
                }
                sb.append("}");
                sb.append(')');
                String annotation = sb.toString();
                ImmutableList immutableList = ImmutableList.of((Object)annotation, (Object)StringUtil.replace((String)annotation, (String)AnnotationDetector.PERMISSION_ANNOTATION.oldName(), (String)AnnotationDetector.PERMISSION_ANNOTATION.newName()));
                if (immutableList == null) {
                    Constraints.$$$reportNull$$$0(3);
                }
                return immutableList;
            }
            List<String> list = Collections.emptyList();
            if (list == null) {
                Constraints.$$$reportNull$$$0(4);
            }
            return list;
        }

        @NotNull
        public String getResourceTypeAnnotationsString() {
            List<String> annotations = this.getResourceTypeAnnotations();
            if (!annotations.isEmpty()) {
                String string = Joiner.on((char)'\n').join(annotations).replace(SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.oldName(), "").replace(SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.newName(), "");
                if (string == null) {
                    Constraints.$$$reportNull$$$0(5);
                }
                return string;
            }
            return "";
        }

        @NotNull
        public String getPermissionAnnotationsString() {
            List<String> annotations = this.getPermissionAnnotations();
            if (!annotations.isEmpty()) {
                String string = Joiner.on((char)'\n').join(annotations).replace(SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.oldName(), "").replace(SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.newName(), "").replace("android.Manifest", "Manifest");
                if (string == null) {
                    Constraints.$$$reportNull$$$0(6);
                }
                return string;
            }
            return "";
        }

        @NotNull
        public String getKeepAnnotationsString() {
            if (this.keep) {
                String string = "@" + KEEP_ANNOTATION;
                if (string == null) {
                    Constraints.$$$reportNull$$$0(7);
                }
                return string;
            }
            return "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/android/tools/idea/actions/annotations/InferSupportAnnotations$Constraints";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResourceTypeAnnotations";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPermissionAnnotations";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResourceTypeAnnotationsString";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPermissionAnnotationsString";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKeepAnnotationsString";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

