/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

enum Kind {
    ANNOTATION("Annotation", PlatformIcons.ANNOTATION_TYPE_ICON, "AnnotationType"),
    CLASS("Class", PlatformIcons.CLASS_ICON),
    ENUM("Enum", PlatformIcons.ENUM_ICON),
    INTERFACE("Interface", PlatformIcons.INTERFACE_ICON);

    private final String myName;
    private final Icon myIcon;
    private final String myTemplateName;

    private Kind(String name, Icon icon2) {
        this(name, icon2, name);
    }

    private Kind(String name, Icon icon2, String templateName) {
        this.myName = name;
        this.myIcon = icon2;
        this.myTemplateName = templateName;
    }

    String getName() {
        return this.myName;
    }

    Icon getIcon() {
        return this.myIcon;
    }

    String getTemplateName() {
        return this.myTemplateName;
    }

    @Nullable
    static Kind valueOfText(String text) {
        for (Kind kind : Kind.values()) {
            if (!kind.getTemplateName().equals(text)) continue;
            return kind;
        }
        return null;
    }
}

