/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.actions.CreateFileFromTemplateDialog;
import com.android.tools.idea.projectsystem.SourceProviders;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateFromTemplateAction;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.SourceProviderManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public final class CreateClassAction
extends AnAction {
    private final JavaDirectoryService myJavaDirectoryService = JavaDirectoryService.getInstance();

    public CreateClassAction() {
        super("Java Class");
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        DataContext context;
        IdeView view;
        if (event == null) {
            CreateClassAction.$$$reportNull$$$0(0);
        }
        if ((view = (IdeView)LangDataKeys.IDE_VIEW.getData(context = event.getDataContext())) == null) {
            return;
        }
        Module module = (Module)LangDataKeys.MODULE.getData(context);
        if (module == null) {
            return;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        if (project == null) {
            return;
        }
        final PsiDirectory directory = CreateClassAction.getDestinationDirectory(view, module);
        if (directory == null) {
            return;
        }
        CreateFileFromTemplateDialog dialog2 = new CreateFileFromTemplateDialog(project, directory);
        try {
            PsiClass createdElement = dialog2.show(new CreateFileFromTemplateDialog.FileCreator(){

                @Override
                public PsiClass createFile(@NotNull String name, @NotNull Map<String, String> creationOptions, @NotNull String templateName) {
                    if (name == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (creationOptions == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (templateName == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    String enteredPackageName = creationOptions.get("PACKAGE_NAME");
                    PsiDirectory packageSubdirectory = (PsiDirectory)ApplicationManager.getApplication().runWriteAction(() -> CreateClassAction.createPackageSubdirectory(directory, enteredPackageName));
                    return CreateClassAction.this.checkOrCreate(name, packageSubdirectory, templateName, creationOptions);
                }

                @Override
                @NotNull
                public String getActionName(@NotNull String name, @NotNull String templateName) {
                    if (name == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    if (templateName == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    PsiPackage p = CreateClassAction.this.myJavaDirectoryService.getPackage(directory);
                    assert (p != null);
                    String packageDirectoryQualifiedName = p.getQualifiedName();
                    String string = JavaBundle.message((String)"progress.creating.class", (Object[])new Object[]{StringUtil.getQualifiedName((String)packageDirectoryQualifiedName, (String)name)});
                    if (string == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 5: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 5: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "name";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "creationOptions";
                            break;
                        }
                        case 2: 
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "templateName";
                            break;
                        }
                        case 5: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/android/tools/idea/actions/CreateClassAction$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/android/tools/idea/actions/CreateClassAction$1";
                            break;
                        }
                        case 5: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getActionName";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "createFile";
                            break;
                        }
                        case 3: 
                        case 4: {
                            objectArray = objectArray;
                            objectArray[2] = "getActionName";
                            break;
                        }
                        case 5: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 5: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            });
            view.selectElement((PsiElement)createdElement);
            CreateFromTemplateAction.moveCaretAfterNameIdentifier((PsiNameIdentifierOwner)createdElement);
            if (dialog2.isShowSelectOverridesDialogCheckBoxSelected()) {
                CreateClassAction.showOverridesDialog(event);
            }
        }
        catch (CreateFileFromTemplateDialog.FailedToCreateFileException failedToCreateFileException) {
            // empty catch block
        }
    }

    @Nullable
    @VisibleForTesting
    static PsiDirectory getDestinationDirectory(@NotNull IdeView ide, @NotNull Module module) {
        PsiDirectory[] directories;
        if (ide == null) {
            CreateClassAction.$$$reportNull$$$0(1);
        }
        if (module == null) {
            CreateClassAction.$$$reportNull$$$0(2);
        }
        if ((directories = ide.getDirectories()).length == 1) {
            return directories[0];
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module);
        if (facet2 == null) {
            return ide.getOrChooseDirectory();
        }
        SourceProviders sourceProviderManager = SourceProviderManager.getInstance(facet2);
        Collection files2 = Stream.of(sourceProviderManager.getSources(), sourceProviderManager.getUnitTestSources(), sourceProviderManager.getAndroidTestSources()).flatMap(it -> it.getJavaDirectories().stream()).collect(Collectors.toList());
        if (files2.size() != 1) {
            return ide.getOrChooseDirectory();
        }
        VirtualFile file = (VirtualFile)files2.iterator().next();
        if (file == null) {
            return ide.getOrChooseDirectory();
        }
        return PsiManager.getInstance((Project)module.getProject()).findDirectory(file);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            CreateClassAction.$$$reportNull$$$0(3);
        }
        boolean enabled = CreateClassAction.isAvailable(e.getDataContext());
        Presentation presentation = e.getPresentation();
        presentation.setEnabledAndVisible(enabled);
    }

    private static boolean isAvailable(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            CreateClassAction.$$$reportNull$$$0(4);
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (project == null || view == null || view.getDirectories().length == 0) {
            return false;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        for (PsiDirectory dir : view.getDirectories()) {
            if (!projectFileIndex.isUnderSourceRootOfType(dir.getVirtualFile(), JavaModuleSourceRootTypes.SOURCES) || !CreateClassAction.checkPackageExists(dir)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkPackageExists(PsiDirectory directory) {
        PsiPackage psiPackage = JavaDirectoryService.getInstance().getPackage(directory);
        if (psiPackage == null) {
            return false;
        }
        String name = psiPackage.getQualifiedName();
        return StringUtil.isEmpty((String)name) || PsiNameHelper.getInstance((Project)directory.getProject()).isQualifiedName(name);
    }

    @NotNull
    private static PsiDirectory createPackageSubdirectory(@NotNull PsiDirectory directory, @NotNull String packageName) {
        PsiPackage psiPackage;
        String startPackagePath;
        if (directory == null) {
            CreateClassAction.$$$reportNull$$$0(5);
        }
        if (packageName == null) {
            CreateClassAction.$$$reportNull$$$0(6);
        }
        String string = startPackagePath = (psiPackage = JavaDirectoryService.getInstance().getPackage(directory)) != null ? psiPackage.getQualifiedName() : null;
        if (startPackagePath == null || startPackagePath.equals(packageName)) {
            PsiDirectory psiDirectory = directory;
            if (psiDirectory == null) {
                CreateClassAction.$$$reportNull$$$0(7);
            }
            return psiDirectory;
        }
        PsiPackage baseName = JavaDirectoryService.getInstance().getPackage(directory);
        assert (baseName != null);
        PsiDirectory dir = directory;
        if (!packageName.startsWith(baseName.getQualifiedName())) {
            while (baseName.getParentPackage() != null) {
                if (packageName.equals(baseName.getQualifiedName())) {
                    assert (dir != null);
                    PsiDirectory psiDirectory = dir;
                    if (psiDirectory == null) {
                        CreateClassAction.$$$reportNull$$$0(8);
                    }
                    return psiDirectory;
                }
                if (packageName.startsWith(baseName.getQualifiedName())) break;
                baseName = baseName.getParentPackage();
                assert (baseName != null);
                assert (dir != null);
                dir = dir.getParentDirectory();
            }
        }
        String newPackageName = baseName.getQualifiedName().isEmpty() ? packageName : packageName.substring(baseName.getQualifiedName().length() + 1);
        for (String component3 : Splitter.on((char)'.').split((CharSequence)newPackageName)) {
            assert (dir != null);
            PsiDirectory d = dir.findSubdirectory(component3);
            dir = d == null ? dir.createSubdirectory(component3) : d;
        }
        assert (dir != null);
        PsiDirectory psiDirectory = dir;
        if (psiDirectory == null) {
            CreateClassAction.$$$reportNull$$$0(9);
        }
        return psiDirectory;
    }

    private static void showOverridesDialog(@NotNull AnActionEvent event) {
        if (event == null) {
            CreateClassAction.$$$reportNull$$$0(10);
        }
        Project project = event.getProject();
        assert (project != null);
        Editor editor2 = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (editor2 instanceof EditorEx) {
            EditorEx editorEx = (EditorEx)editor2;
            AnActionEvent newEvent = new AnActionEvent(event.getInputEvent(), editorEx.getDataContext(), "unknown", event.getPresentation(), event.getActionManager(), 0);
            ActionManager.getInstance().getAction("OverrideMethods").actionPerformed(newEvent);
        }
    }

    @Nullable
    private PsiClass checkOrCreate(String newName2, PsiDirectory directory, String templateName, Map<String, String> creationOptions) throws IncorrectOperationException {
        PsiDirectory dir = directory;
        if ((newName2 = StringUtil.trimEnd((String)newName2, (String)".java")).contains(".")) {
            List names = Splitter.on((String)".").splitToList((CharSequence)newName2);
            for (String name : names.subList(0, names.size() - 1)) {
                PsiDirectory subDir = dir.findSubdirectory(name);
                if (subDir == null) {
                    subDir = dir.createSubdirectory(name);
                }
                dir = subDir;
            }
            newName2 = (String)names.get(names.size() - 1);
        }
        return this.myJavaDirectoryService.createClass(dir, newName2, templateName, true, creationOptions);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ide";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/actions/CreateClassAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/actions/CreateClassAction";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createPackageSubdirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDestinationDirectory";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createPackageSubdirectory";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "showOverridesDialog";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

