/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.tree;

import com.android.build.attribution.ui.BuildAttributionUIUtilKt;
import com.android.build.attribution.ui.DescriptionWithHelpLinkLabel;
import com.android.build.attribution.ui.data.CriticalPathTasksUiData;
import com.android.build.attribution.ui.data.TaskIssueUiData;
import com.android.build.attribution.ui.data.TaskUiData;
import com.android.build.attribution.ui.panels.AbstractBuildAttributionInfoPanel;
import com.android.build.attribution.ui.panels.BuildAttributionPanelsKt;
import com.android.build.attribution.ui.panels.ChartBuildAttributionInfoPanel;
import com.android.build.attribution.ui.panels.CriticalPathChartLegend;
import com.android.build.attribution.ui.panels.TimeDistributionChart;
import com.android.build.attribution.ui.panels.TreeLinkListener;
import com.android.build.attribution.ui.tree.AbstractBuildAttributionNode;
import com.android.build.attribution.ui.tree.ChartDataItemsKt;
import com.android.build.attribution.ui.tree.ControllersAwareBuildAttributionNode;
import com.android.build.attribution.ui.tree.TaskNode;
import com.android.utils.HtmlBuilder;
import com.google.wireless.android.sdk.stats.BuildAttributionUiEvent;
import com.intellij.ui.treeStructure.SimpleNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0014\u00a2\u0006\u0002\u0010\u001fJ\b\u0010 \u001a\u00020!H\u0016R\u001a\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0011\u00a8\u0006\""}, d2={"Lcom/android/build/attribution/ui/tree/CriticalPathTasksRoot;", "Lcom/android/build/attribution/ui/tree/AbstractBuildAttributionNode;", "data", "Lcom/android/build/attribution/ui/data/CriticalPathTasksUiData;", "parent", "Lcom/android/build/attribution/ui/tree/ControllersAwareBuildAttributionNode;", "taskIssueLinkListener", "Lcom/android/build/attribution/ui/panels/TreeLinkListener;", "Lcom/android/build/attribution/ui/data/TaskIssueUiData;", "(Lcom/android/build/attribution/ui/data/CriticalPathTasksUiData;Lcom/android/build/attribution/ui/tree/ControllersAwareBuildAttributionNode;Lcom/android/build/attribution/ui/panels/TreeLinkListener;)V", "chartItems", "", "Lcom/android/build/attribution/ui/panels/TimeDistributionChart$ChartDataItem;", "Lcom/android/build/attribution/ui/data/TaskUiData;", "issuesCountsSuffix", "", "getIssuesCountsSuffix", "()Ljava/lang/String;", "pageType", "Lcom/google/wireless/android/sdk/stats/BuildAttributionUiEvent$Page$PageType;", "getPageType", "()Lcom/google/wireless/android/sdk/stats/BuildAttributionUiEvent$Page$PageType;", "presentationIcon", "Ljavax/swing/Icon;", "getPresentationIcon", "()Ljavax/swing/Icon;", "timeSuffix", "getTimeSuffix", "buildChildren", "", "Lcom/intellij/ui/treeStructure/SimpleNode;", "()[Lcom/intellij/ui/treeStructure/SimpleNode;", "createComponent", "Lcom/android/build/attribution/ui/panels/AbstractBuildAttributionInfoPanel;", "intellij.android.build-attribution"})
public final class CriticalPathTasksRoot
extends AbstractBuildAttributionNode {
    private final List<TimeDistributionChart.ChartDataItem<TaskUiData>> chartItems;
    @Nullable
    private final Icon presentationIcon;
    @Nullable
    private final String issuesCountsSuffix;
    @Nullable
    private final String timeSuffix;
    @NotNull
    private final BuildAttributionUiEvent.Page.PageType pageType;
    private final CriticalPathTasksUiData data;
    private final TreeLinkListener<TaskIssueUiData> taskIssueLinkListener;

    @Override
    @Nullable
    public Icon getPresentationIcon() {
        return this.presentationIcon;
    }

    @Override
    @Nullable
    public String getIssuesCountsSuffix() {
        return this.issuesCountsSuffix;
    }

    @Override
    @Nullable
    public String getTimeSuffix() {
        return this.timeSuffix;
    }

    @Override
    @NotNull
    public BuildAttributionUiEvent.Page.PageType getPageType() {
        return this.pageType;
    }

    @NotNull
    protected SimpleNode[] buildChildren() {
        boolean bl = false;
        List nodes = new ArrayList();
        for (TimeDistributionChart.ChartDataItem<TaskUiData> item : this.chartItems) {
            TimeDistributionChart.ChartDataItem<TaskUiData> chartDataItem = item;
            if (chartDataItem instanceof TimeDistributionChart.SingularChartDataItem) {
                Object t = ((TimeDistributionChart.SingularChartDataItem)item).getUnderlyingData();
                Intrinsics.checkNotNullExpressionValue(t, (String)"item.underlyingData");
                nodes.add(new TaskNode((TaskUiData)t, this.chartItems, item, this, this.taskIssueLinkListener));
                continue;
            }
            if (!(chartDataItem instanceof TimeDistributionChart.AggregatedChartDataItem)) continue;
            List list = ((TimeDistributionChart.AggregatedChartDataItem)item).getUnderlyingData();
            Intrinsics.checkNotNullExpressionValue(list, (String)"item.underlyingData");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TaskUiData taskData = (TaskUiData)element$iv;
                boolean bl2 = false;
                TaskUiData taskUiData = taskData;
                Intrinsics.checkNotNullExpressionValue((Object)taskUiData, (String)"taskData");
                nodes.add(new TaskNode(taskUiData, this.chartItems, item, this, this.taskIssueLinkListener));
            }
        }
        Collection $this$toTypedArray$iv = nodes;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        SimpleNode[] simpleNodeArray = thisCollection$iv.toArray(new SimpleNode[0]);
        if (simpleNodeArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return simpleNodeArray;
    }

    @Override
    @NotNull
    public AbstractBuildAttributionInfoPanel createComponent() {
        return new ChartBuildAttributionInfoPanel(this){
            final /* synthetic */ CriticalPathTasksRoot this$0;

            @NotNull
            public JComponent createHeader() {
                return BuildAttributionPanelsKt.criticalPathHeader("Tasks", BuildAttributionUIUtilKt.durationString(CriticalPathTasksRoot.access$getData$p(this.this$0).getCriticalPathDuration()));
            }

            @NotNull
            public JComponent createChart() {
                return new TimeDistributionChart<T>(CriticalPathTasksRoot.access$getChartItems$p(this.this$0), null, true);
            }

            @NotNull
            public JComponent createLegend() {
                JPanel jPanel = CriticalPathChartLegend.createTasksLegendPanel();
                Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"CriticalPathChartLegend.createTasksLegendPanel()");
                return jPanel;
            }

            @NotNull
            public JComponent createDescription() {
                HtmlBuilder text;
                HtmlBuilder htmlBuilder = text = new HtmlBuilder().openHtmlBody().add("These tasks belong to a group of sequentially executed tasks that has the largest impact on this build's duration.").newline().add("Addressing this group provides the greatest likelihood of reducing the overall build duration.").closeHtmlBody();
                Intrinsics.checkNotNullExpressionValue((Object)htmlBuilder, (String)"text");
                String string = htmlBuilder.getHtml();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text.html");
                return (JComponent)((Object)new DescriptionWithHelpLinkLabel(string, "https://developer.android.com/r/tools/build-attribution/critical-path", this.this$0.getAnalytics()));
            }

            @Nullable
            public JComponent createRightInfoPanel() {
                return null;
            }
            {
                this.this$0 = this$0;
            }
        };
    }

    public CriticalPathTasksRoot(@NotNull CriticalPathTasksUiData data, @NotNull ControllersAwareBuildAttributionNode parent, @NotNull TreeLinkListener<TaskIssueUiData> taskIssueLinkListener2) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter(taskIssueLinkListener2, (String)"taskIssueLinkListener");
        super(parent, "Tasks determining this build's duration");
        this.data = data;
        this.taskIssueLinkListener = taskIssueLinkListener2;
        this.chartItems = ChartDataItemsKt.createTaskChartItems(this.data);
        this.issuesCountsSuffix = BuildAttributionUIUtilKt.issuesCountString(this.data.getWarningCount(), this.data.getInfoCount());
        this.timeSuffix = BuildAttributionUIUtilKt.durationString(this.data.getCriticalPathDuration());
        this.pageType = BuildAttributionUiEvent.Page.PageType.CRITICAL_PATH_TASKS_ROOT;
    }

    public static final /* synthetic */ CriticalPathTasksUiData access$getData$p(CriticalPathTasksRoot $this) {
        return $this.data;
    }

    public static final /* synthetic */ List access$getChartItems$p(CriticalPathTasksRoot $this) {
        return $this.chartItems;
    }
}

