/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.tree;

import com.android.build.attribution.ui.tree.AbstractBuildAttributionNode;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.render.RenderingHelper;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Shape;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;

public class BuildAttributionNodeRenderer
extends NodeRenderer {
    private String myDurationText;
    private Color myDurationColor;
    private int myDurationWidth;
    private int myDurationOffset;

    public BuildAttributionNodeRenderer() {
        this.putClientProperty(RenderingHelper.SHRINK_LONG_RENDERER, true);
    }

    public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (tree == null) {
            BuildAttributionNodeRenderer.$$$reportNull$$$0(0);
        }
        super.customizeCellRenderer(tree, value2, selected, expanded, leaf, row, hasFocus);
        this.myDurationText = null;
        this.myDurationColor = null;
        this.myDurationWidth = 0;
        this.myDurationOffset = 0;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value2;
        Object userObj = node.getUserObject();
        if (userObj instanceof AbstractBuildAttributionNode) {
            this.myDurationText = ((AbstractBuildAttributionNode)userObj).getTimeSuffix();
            if (this.myDurationText != null) {
                FontMetrics metrics = this.getFontMetrics(RelativeFont.SMALL.derive(this.getFont()));
                this.myDurationWidth = metrics.stringWidth(this.myDurationText);
                this.myDurationOffset = metrics.getHeight() / 2;
                this.myDurationColor = selected ? UIUtil.getTreeSelectionForeground((boolean)hasFocus) : SimpleTextAttributes.GRAYED_ATTRIBUTES.getFgColor();
            }
        }
    }

    protected void paintComponent(Graphics g) {
        UISettings.setupAntialiasing((Graphics)g);
        Shape clip = null;
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, width, height);
        }
        if (this.myDurationWidth > 0 && (width -= this.myDurationWidth + this.myDurationOffset) > 0 && height > 0) {
            g.setColor(this.myDurationColor);
            g.setFont(RelativeFont.SMALL.derive(this.getFont()));
            g.drawString(this.myDurationText, width + this.myDurationOffset / 2, BuildAttributionNodeRenderer.getTextBaseLine((FontMetrics)g.getFontMetrics(), (int)height));
            clip = g.getClip();
            g.clipRect(0, 0, width, height);
        }
        super.paintComponent(g);
        if (clip != null) {
            g.setClip(clip);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/build/attribution/ui/tree/BuildAttributionNodeRenderer", "customizeCellRenderer"));
    }
}

